/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.utils.io.core;

import io.ktor.utils.io.core.BufferKt;
import io.ktor.utils.io.core.ExperimentalIoApi;
import io.ktor.utils.io.core.InsufficientSpaceException;
import io.ktor.utils.io.core.IoBuffer;
import io.ktor.utils.io.core.internal.DangerousInternalIoApi;
import java.io.EOFException;
import java.nio.ByteBuffer;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@DangerousInternalIoApi
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0015\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u0005\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0017\u0018\u0000 E2\u00020\u0001:\u0001EB\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\rH\u0007J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\rH\u0001J\u0010\u0010(\u001a\u00020\r2\u0006\u0010$\u001a\u00020\rH\u0007J\u0010\u0010(\u001a\u00020)2\u0006\u0010$\u001a\u00020)H\u0007J\u0010\u0010*\u001a\u00020#2\b\b\u0002\u0010$\u001a\u00020\rJ\u0015\u0010+\u001a\u00020#2\u0006\u0010'\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b,J\b\u0010-\u001a\u00020\u0000H\u0016J\u0010\u0010.\u001a\u00020#2\u0006\u0010/\u001a\u00020\u0000H\u0014J\u0006\u00100\u001a\u000201J\r\u00102\u001a\u00020#H\u0000\u00a2\u0006\u0002\b3J\r\u00104\u001a\u00020#H\u0000\u00a2\u0006\u0002\b5J\u0015\u00106\u001a\u00020#2\u0006\u00107\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b8J\u000e\u00109\u001a\u00020#2\u0006\u0010\u0010\u001a\u00020\rJ\u000e\u0010:\u001a\u00020#2\u0006\u0010\u001c\u001a\u00020\rJ\b\u0010;\u001a\u00020#H\u0016J\u0006\u0010<\u001a\u00020#J\u0006\u0010=\u001a\u00020#J\u000e\u0010=\u001a\u00020#2\u0006\u0010\u0013\u001a\u00020\rJ\u0010\u0010>\u001a\u00020#2\b\b\u0002\u0010$\u001a\u00020\rJ\b\u0010?\u001a\u00020@H\u0016J\u0006\u0010A\u001a\u00020\rJ\u0006\u0010B\u001a\u00020\rJ\u000e\u0010C\u001a\u00020#2\u0006\u0010D\u001a\u000201R&\u0010\u0005\u001a\u0004\u0018\u00010\u00018\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u00020\r8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u001e\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000fR\u0019\u0010\u0002\u001a\u00020\u0003\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\u0017\u001a\u0004\b\u0015\u0010\u0016R\u001e\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000fR\u0012\u0010\u001a\u001a\u00020\r8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u000fR\u001e\u0010\u001c\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u000fR\u001e\u0010\u001e\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u000fR\u0012\u0010 \u001a\u00020\r8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u000f\u0082\u0002\b\n\u0002\b\u0019\n\u0002\b!\u00a8\u0006F"}, d2={"Lio/ktor/utils/io/core/Buffer;", "", "memory", "Lio/ktor/utils/io/bits/Memory;", "(Ljava/nio/ByteBuffer;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "attachment", "getAttachment$annotations", "()V", "getAttachment", "()Ljava/lang/Object;", "setAttachment", "(Ljava/lang/Object;)V", "capacity", "", "getCapacity", "()I", "endGap", "getEndGap", "<set-?>", "limit", "getLimit", "getMemory-SK3TCg8", "()Ljava/nio/ByteBuffer;", "Ljava/nio/ByteBuffer;", "readPosition", "getReadPosition", "readRemaining", "getReadRemaining", "startGap", "getStartGap", "writePosition", "getWritePosition", "writeRemaining", "getWriteRemaining", "commitWritten", "", "count", "commitWrittenUntilIndex", "", "position", "discard", "", "discardExact", "discardUntilIndex", "discardUntilIndex$ktor_io", "duplicate", "duplicateTo", "copy", "readByte", "", "releaseEndGap", "releaseEndGap$ktor_io", "releaseGaps", "releaseGaps$ktor_io", "releaseStartGap", "newReadPosition", "releaseStartGap$ktor_io", "reserveEndGap", "reserveStartGap", "reset", "resetForRead", "resetForWrite", "rewind", "toString", "", "tryPeekByte", "tryReadByte", "writeByte", "value", "Companion", "ktor-io"})
public class Buffer {
    private int readPosition;
    private int writePosition;
    private int startGap;
    private int limit;
    private final int capacity;
    @Nullable
    private Object attachment;
    @NotNull
    private final ByteBuffer memory;
    public static final int ReservedSize = 8;
    public static final Companion Companion = new Companion(null);

    public final int getReadPosition() {
        return this.readPosition;
    }

    public final int getWritePosition() {
        return this.writePosition;
    }

    public final int getStartGap() {
        return this.startGap;
    }

    public final int getLimit() {
        return this.limit;
    }

    public final int getEndGap() {
        int $i$f$getEndGap = 0;
        return this.getCapacity() - this.getLimit();
    }

    public final int getCapacity() {
        return this.capacity;
    }

    public final int getReadRemaining() {
        int $i$f$getReadRemaining = 0;
        return this.getWritePosition() - this.getReadPosition();
    }

    public final int getWriteRemaining() {
        int $i$f$getWriteRemaining = 0;
        return this.getLimit() - this.getWritePosition();
    }

    @Deprecated(message="Will be removed. Inherit Buffer and add required fields instead.")
    @ExperimentalIoApi
    public static /* synthetic */ void getAttachment$annotations() {
    }

    @Nullable
    public final Object getAttachment() {
        return this.attachment;
    }

    public final void setAttachment(@Nullable Object object) {
        this.attachment = object;
    }

    public final void discardExact(int count) {
        if (count == 0) {
            return;
        }
        int newReadPosition = this.readPosition + count;
        if (count < 0 || newReadPosition > this.writePosition) {
            Buffer this_$iv = this;
            boolean $i$f$getReadRemaining = false;
            Void void_ = BufferKt.discardFailed(count, this_$iv.getWritePosition() - this_$iv.getReadPosition());
            throw new KotlinNothingValueException();
        }
        this.readPosition = newReadPosition;
    }

    public static /* synthetic */ void discardExact$default(Buffer buffer, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: discardExact");
        }
        if ((n2 & 1) != 0) {
            Buffer this_$iv = buffer;
            boolean $i$f$getReadRemaining = false;
            n = this_$iv.getWritePosition() - this_$iv.getReadPosition();
        }
        buffer.discardExact(n);
    }

    @Deprecated(message="Use discardExact instead.", level=DeprecationLevel.ERROR)
    public final int discard(int count) {
        Buffer this_$iv = this;
        boolean $i$f$getReadRemaining = false;
        int n = this_$iv.getWritePosition() - this_$iv.getReadPosition();
        boolean bl = false;
        int size = Math.min(count, n);
        this.discardExact(size);
        return size;
    }

    @Deprecated(message="Use discardExact instead.", level=DeprecationLevel.ERROR)
    public final long discard(long count) {
        Buffer this_$iv = this;
        boolean $i$f$getReadRemaining = false;
        long l = this_$iv.getWritePosition() - this_$iv.getReadPosition();
        boolean bl = false;
        int size = (int)Math.min(count, l);
        this.discardExact(size);
        return size;
    }

    @DangerousInternalIoApi
    public final void commitWritten(int count) {
        int newWritePosition = this.writePosition + count;
        if (count < 0 || newWritePosition > this.limit) {
            Buffer this_$iv = this;
            boolean $i$f$getWriteRemaining = false;
            Void void_ = BufferKt.commitWrittenFailed(count, this_$iv.getLimit() - this_$iv.getWritePosition());
            throw new KotlinNothingValueException();
        }
        this.writePosition = newWritePosition;
    }

    @PublishedApi
    public final boolean commitWrittenUntilIndex(int position) {
        int limit = this.limit;
        if (position < this.writePosition) {
            Buffer this_$iv = this;
            boolean $i$f$getWriteRemaining = false;
            Void void_ = BufferKt.commitWrittenFailed(position - this.writePosition, this_$iv.getLimit() - this_$iv.getWritePosition());
            throw new KotlinNothingValueException();
        }
        if (position >= limit) {
            if (position == limit) {
                this.writePosition = position;
                return false;
            }
            Buffer this_$iv = this;
            boolean $i$f$getWriteRemaining = false;
            Void void_ = BufferKt.commitWrittenFailed(position - this.writePosition, this_$iv.getLimit() - this_$iv.getWritePosition());
            throw new KotlinNothingValueException();
        }
        this.writePosition = position;
        return true;
    }

    public final void discardUntilIndex$ktor_io(int position) {
        if (position < 0 || position > this.writePosition) {
            Buffer this_$iv = this;
            boolean $i$f$getReadRemaining = false;
            Void void_ = BufferKt.discardFailed(position - this.readPosition, this_$iv.getWritePosition() - this_$iv.getReadPosition());
            throw new KotlinNothingValueException();
        }
        if (this.readPosition != position) {
            this.readPosition = position;
        }
    }

    public final void rewind(int count) {
        int newReadPosition = this.readPosition - count;
        if (newReadPosition < this.startGap) {
            Void void_ = BufferKt.rewindFailed(count, this.readPosition - this.startGap);
            throw new KotlinNothingValueException();
        }
        this.readPosition = newReadPosition;
    }

    public static /* synthetic */ void rewind$default(Buffer buffer, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: rewind");
        }
        if ((n2 & 1) != 0) {
            n = buffer.readPosition - buffer.startGap;
        }
        buffer.rewind(n);
    }

    public final void reserveStartGap(int startGap) {
        boolean bl = startGap >= 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "startGap shouldn't be negative: " + startGap;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (this.readPosition >= startGap) {
            this.startGap = startGap;
            return;
        }
        if (this.readPosition == this.writePosition) {
            if (startGap > this.limit) {
                Void void_ = BufferKt.startGapReservationFailedDueToLimit(this, startGap);
                throw new KotlinNothingValueException();
            }
            this.writePosition = startGap;
            this.readPosition = startGap;
            this.startGap = startGap;
            return;
        }
        Void void_ = BufferKt.startGapReservationFailed(this, startGap);
        throw new KotlinNothingValueException();
    }

    public final void reserveEndGap(int endGap) {
        boolean bl = endGap >= 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "endGap shouldn't be negative: " + endGap;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int newLimit = this.capacity - endGap;
        if (newLimit >= this.writePosition) {
            this.limit = newLimit;
            return;
        }
        if (newLimit < 0) {
            BufferKt.endGapReservationFailedDueToCapacity(this, endGap);
        }
        if (newLimit < this.startGap) {
            BufferKt.endGapReservationFailedDueToStartGap(this, endGap);
        }
        if (this.readPosition == this.writePosition) {
            this.limit = newLimit;
            this.readPosition = newLimit;
            this.writePosition = newLimit;
            return;
        }
        BufferKt.endGapReservationFailedDueToContent(this, endGap);
    }

    public final void resetForRead() {
        int capacity;
        this.startGap = 0;
        this.readPosition = 0;
        this.writePosition = capacity = this.capacity;
    }

    public final void resetForWrite() {
        this.resetForWrite(this.capacity - this.startGap);
    }

    public final void resetForWrite(int limit) {
        int startGap;
        this.readPosition = startGap = this.startGap;
        this.writePosition = startGap;
        this.limit = limit;
    }

    public final void releaseGaps$ktor_io() {
        this.releaseStartGap$ktor_io(0);
        this.releaseEndGap$ktor_io();
    }

    public final void releaseEndGap$ktor_io() {
        this.limit = this.capacity;
    }

    public final void releaseStartGap$ktor_io(int newReadPosition) {
        boolean bl = newReadPosition >= 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "newReadPosition shouldn't be negative: " + newReadPosition;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = newReadPosition <= this.readPosition;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "newReadPosition shouldn't be ahead of the read position: " + newReadPosition + " > " + this.readPosition;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.readPosition = newReadPosition;
        if (this.startGap > newReadPosition) {
            this.startGap = newReadPosition;
        }
    }

    protected void duplicateTo(@NotNull Buffer copy2) {
        Intrinsics.checkNotNullParameter((Object)copy2, (String)"copy");
        copy2.limit = this.limit;
        copy2.startGap = this.startGap;
        copy2.readPosition = this.readPosition;
        copy2.writePosition = this.writePosition;
    }

    @NotNull
    public Buffer duplicate() {
        Buffer buffer = new Buffer(this.memory, null);
        boolean bl = false;
        boolean bl2 = false;
        Buffer $this$apply = buffer;
        boolean bl3 = false;
        $this$apply.duplicateTo($this$apply);
        return buffer;
    }

    public final int tryPeekByte() {
        int readPosition = this.readPosition;
        if (readPosition == this.writePosition) {
            return -1;
        }
        ByteBuffer $this$get$iv = this.memory;
        boolean bl = false;
        ByteBuffer $this$iv$iv = $this$get$iv;
        boolean $i$f$loadAt = false;
        return $this$iv$iv.get(readPosition) & 0xFF;
    }

    public final int tryReadByte() {
        int readPosition = this.readPosition;
        if (readPosition == this.writePosition) {
            return -1;
        }
        this.readPosition = readPosition + 1;
        ByteBuffer $this$get$iv = this.memory;
        boolean bl = false;
        ByteBuffer $this$iv$iv = $this$get$iv;
        boolean $i$f$loadAt = false;
        return $this$iv$iv.get(readPosition) & 0xFF;
    }

    public final byte readByte() {
        int readPosition = this.readPosition;
        if (readPosition == this.writePosition) {
            throw (Throwable)new EOFException("No readable bytes available.");
        }
        this.readPosition = readPosition + 1;
        ByteBuffer $this$get$iv = this.memory;
        boolean bl = false;
        ByteBuffer $this$iv$iv = $this$get$iv;
        boolean $i$f$loadAt = false;
        return $this$iv$iv.get(readPosition);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeByte(byte value) {
        void $this$set$iv;
        int writePosition = this.writePosition;
        if (writePosition == this.limit) {
            throw (Throwable)new InsufficientSpaceException("No free space in the buffer to write a byte");
        }
        ByteBuffer byteBuffer = this.memory;
        byte value$iv = value;
        boolean bl = false;
        void $this$iv$iv = $this$set$iv;
        boolean $i$f$storeAt = false;
        $this$iv$iv.put(writePosition, value$iv);
        this.writePosition = writePosition + 1;
    }

    public void reset() {
        this.releaseGaps$ktor_io();
        this.resetForWrite();
    }

    @NotNull
    public String toString() {
        Buffer this_$iv = this;
        boolean $i$f$getReadRemaining = false;
        StringBuilder stringBuilder = new StringBuilder().append("Buffer(").append(this_$iv.getWritePosition() - this_$iv.getReadPosition()).append(" used, ");
        this_$iv = this;
        boolean $i$f$getWriteRemaining = false;
        StringBuilder stringBuilder2 = stringBuilder.append(this_$iv.getLimit() - this_$iv.getWritePosition()).append(" free, ");
        this_$iv = this;
        boolean $i$f$getEndGap = false;
        return stringBuilder2.append(this.startGap + (this_$iv.getCapacity() - this_$iv.getLimit())).append(" reserved of ").append(this.capacity).append(')').toString();
    }

    @NotNull
    public final ByteBuffer getMemory-SK3TCg8() {
        return this.memory;
    }

    private Buffer(ByteBuffer memory) {
        ByteBuffer $this$iv = this.memory = memory;
        boolean $i$f$getSize32 = false;
        this.limit = $this$iv.limit();
        $this$iv = this.memory;
        $i$f$getSize32 = false;
        this.capacity = $this$iv.limit();
    }

    public static final /* synthetic */ int access$getLimit$p(Buffer $this) {
        return $this.limit;
    }

    public static final /* synthetic */ void access$setLimit$p(Buffer $this, int n) {
        $this.limit = n;
    }

    public static final /* synthetic */ int access$getWritePosition$p(Buffer $this) {
        return $this.writePosition;
    }

    public static final /* synthetic */ void access$setWritePosition$p(Buffer $this, int n) {
        $this.writePosition = n;
    }

    public static final /* synthetic */ int access$getReadPosition$p(Buffer $this) {
        return $this.readPosition;
    }

    public static final /* synthetic */ void access$setReadPosition$p(Buffer $this, int n) {
        $this.readPosition = n;
    }

    public /* synthetic */ Buffer(ByteBuffer memory, DefaultConstructorMarker $constructor_marker) {
        this(memory);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\f\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u00020\t8\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\n\u0010\u0002\u00a8\u0006\u000b"}, d2={"Lio/ktor/utils/io/core/Buffer$Companion;", "", "()V", "Empty", "Lio/ktor/utils/io/core/Buffer;", "getEmpty$annotations", "getEmpty", "()Lio/ktor/utils/io/core/Buffer;", "ReservedSize", "", "getReservedSize$annotations", "ktor-io"})
    public static final class Companion {
        @DangerousInternalIoApi
        public static /* synthetic */ void getReservedSize$annotations() {
        }

        public static /* synthetic */ void getEmpty$annotations() {
        }

        @NotNull
        public final Buffer getEmpty() {
            return IoBuffer.Companion.getEmpty();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

