/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.utils.io.core;

import io.ktor.utils.io.core.BufferKt;
import io.ktor.utils.io.core.BufferSharedState;
import io.ktor.utils.io.core.ExperimentalIoApi;
import io.ktor.utils.io.core.InsufficientSpaceException;
import io.ktor.utils.io.core.IoBuffer;
import io.ktor.utils.io.core.internal.DangerousInternalIoApi;
import io.ktor.utils.io.core.internal.RequireFailureCapture;
import java.io.EOFException;
import java.nio.ByteBuffer;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@DangerousInternalIoApi
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0019\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u0005\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0017\u0018\u0000 K2\u00020\u0001:\u0001KB\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u0010H\u0007J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0010H\u0001J\u0010\u0010/\u001a\u00020\u00102\u0006\u0010+\u001a\u00020\u0010H\u0007J\u0010\u0010/\u001a\u0002002\u0006\u0010+\u001a\u000200H\u0007J\u0010\u00101\u001a\u00020*2\b\b\u0002\u0010+\u001a\u00020\u0010J\u0015\u00102\u001a\u00020*2\u0006\u0010.\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b3J\b\u00104\u001a\u00020\u0000H\u0016J\u0010\u00105\u001a\u00020*2\u0006\u00106\u001a\u00020\u0000H\u0014J\u0006\u00107\u001a\u000208J\r\u00109\u001a\u00020*H\u0000\u00a2\u0006\u0002\b:J\r\u0010;\u001a\u00020*H\u0000\u00a2\u0006\u0002\b<J\u0015\u0010=\u001a\u00020*2\u0006\u0010>\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b?J\u000e\u0010@\u001a\u00020*2\u0006\u0010\u0013\u001a\u00020\u0010J\u000e\u0010A\u001a\u00020*2\u0006\u0010!\u001a\u00020\u0010J\b\u0010B\u001a\u00020*H\u0016J\u0006\u0010C\u001a\u00020*J\u0006\u0010D\u001a\u00020*J\u000e\u0010D\u001a\u00020*2\u0006\u0010\u0015\u001a\u00020\u0010J\u0010\u0010E\u001a\u00020*2\b\b\u0002\u0010+\u001a\u00020\u0010J\b\u0010F\u001a\u00020GH\u0016J\u0006\u0010H\u001a\u00020\u0010J\u0006\u0010I\u001a\u00020\u0010J\u000e\u0010J\u001a\u00020*2\u0006\u0010\u0005\u001a\u000208R.\u0010\u0006\u001a\u0004\u0018\u00010\u00012\b\u0010\u0005\u001a\u0004\u0018\u00010\u00018F@FX\u0087\u000e\u00a2\u0006\u0012\u0012\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0012\u0010\u0013\u001a\u00020\u00108\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R$\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00108F@BX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0018R\u0019\u0010\u0002\u001a\u00020\u0003\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\u001b\u001a\u0004\b\u0019\u0010\u001aR$\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00108F@BX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001d\u0010\u0012\"\u0004\b\u001e\u0010\u0018R\u0012\u0010\u001f\u001a\u00020\u00108\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0012R$\u0010!\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00108F@BX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\"\u0010\u0012\"\u0004\b#\u0010\u0018R$\u0010$\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00108F@BX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b%\u0010\u0012\"\u0004\b&\u0010\u0018R\u0012\u0010'\u001a\u00020\u00108\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u0012\u0082\u0002\b\n\u0002\b\u0019\n\u0002\b!\u00a8\u0006L"}, d2={"Lio/ktor/utils/io/core/Buffer;", "", "memory", "Lio/ktor/utils/io/bits/Memory;", "(Ljava/nio/ByteBuffer;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "value", "attachment", "getAttachment$annotations", "()V", "getAttachment", "()Ljava/lang/Object;", "setAttachment", "(Ljava/lang/Object;)V", "bufferState", "Lio/ktor/utils/io/core/BufferSharedState;", "capacity", "", "getCapacity", "()I", "endGap", "getEndGap", "limit", "getLimit", "setLimit", "(I)V", "getMemory-SK3TCg8", "()Ljava/nio/ByteBuffer;", "Ljava/nio/ByteBuffer;", "readPosition", "getReadPosition", "setReadPosition", "readRemaining", "getReadRemaining", "startGap", "getStartGap", "setStartGap", "writePosition", "getWritePosition", "setWritePosition", "writeRemaining", "getWriteRemaining", "commitWritten", "", "count", "commitWrittenUntilIndex", "", "position", "discard", "", "discardExact", "discardUntilIndex", "discardUntilIndex$ktor_io", "duplicate", "duplicateTo", "copy", "readByte", "", "releaseEndGap", "releaseEndGap$ktor_io", "releaseGaps", "releaseGaps$ktor_io", "releaseStartGap", "newReadPosition", "releaseStartGap$ktor_io", "reserveEndGap", "reserveStartGap", "reset", "resetForRead", "resetForWrite", "rewind", "toString", "", "tryPeekByte", "tryReadByte", "writeByte", "Companion", "ktor-io"})
public class Buffer {
    private final BufferSharedState bufferState;
    private final int capacity;
    @NotNull
    private final ByteBuffer memory;
    public static final int ReservedSize = 8;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final int getReadPosition() {
        return this.bufferState.getReadPosition();
    }

    private final void setReadPosition(int value) {
        this.bufferState.setReadPosition(value);
    }

    public final int getWritePosition() {
        return this.bufferState.getWritePosition();
    }

    private final void setWritePosition(int value) {
        this.bufferState.setWritePosition(value);
    }

    public final int getStartGap() {
        return this.bufferState.getStartGap();
    }

    private final void setStartGap(int value) {
        this.bufferState.setStartGap(value);
    }

    public final int getLimit() {
        return this.bufferState.getLimit();
    }

    private final void setLimit(int value) {
        this.bufferState.setLimit(value);
    }

    public final int getEndGap() {
        int $i$f$getEndGap = 0;
        return this.getCapacity() - this.getLimit();
    }

    public final int getCapacity() {
        return this.capacity;
    }

    public final int getReadRemaining() {
        int $i$f$getReadRemaining = 0;
        return this.getWritePosition() - this.getReadPosition();
    }

    public final int getWriteRemaining() {
        int $i$f$getWriteRemaining = 0;
        return this.getLimit() - this.getWritePosition();
    }

    @Deprecated(message="Will be removed. Inherit Buffer and add required fields instead.")
    @ExperimentalIoApi
    public static /* synthetic */ void getAttachment$annotations() {
    }

    @Nullable
    public final Object getAttachment() {
        return this.bufferState.getAttachment();
    }

    public final void setAttachment(@Nullable Object value) {
        this.bufferState.setAttachment(value);
    }

    public final void discardExact(int count) {
        if (count == 0) {
            return;
        }
        int newReadPosition = this.getReadPosition() + count;
        if (count < 0 || newReadPosition > this.getWritePosition()) {
            Buffer this_$iv = this;
            boolean $i$f$getReadRemaining = false;
            Void void_ = BufferKt.discardFailed(count, this_$iv.getWritePosition() - this_$iv.getReadPosition());
            throw new KotlinNothingValueException();
        }
        this.setReadPosition(newReadPosition);
    }

    public static /* synthetic */ void discardExact$default(Buffer buffer, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: discardExact");
        }
        if ((n2 & 1) != 0) {
            Buffer this_$iv = buffer;
            boolean $i$f$getReadRemaining = false;
            n = this_$iv.getWritePosition() - this_$iv.getReadPosition();
        }
        buffer.discardExact(n);
    }

    @Deprecated(message="Use discardExact instead.", level=DeprecationLevel.ERROR)
    public final int discard(int count) {
        Buffer this_$iv = this;
        boolean $i$f$getReadRemaining = false;
        int n = this_$iv.getWritePosition() - this_$iv.getReadPosition();
        boolean bl = false;
        int size = Math.min(count, n);
        this.discardExact(size);
        return size;
    }

    @Deprecated(message="Use discardExact instead.", level=DeprecationLevel.ERROR)
    public final long discard(long count) {
        Buffer this_$iv = this;
        boolean $i$f$getReadRemaining = false;
        long l = this_$iv.getWritePosition() - this_$iv.getReadPosition();
        boolean bl = false;
        int size = (int)Math.min(count, l);
        this.discardExact(size);
        return size;
    }

    @DangerousInternalIoApi
    public final void commitWritten(int count) {
        int newWritePosition = this.getWritePosition() + count;
        if (count < 0 || newWritePosition > this.getLimit()) {
            Buffer this_$iv = this;
            boolean $i$f$getWriteRemaining = false;
            Void void_ = BufferKt.commitWrittenFailed(count, this_$iv.getLimit() - this_$iv.getWritePosition());
            throw new KotlinNothingValueException();
        }
        this.setWritePosition(newWritePosition);
    }

    @PublishedApi
    public final boolean commitWrittenUntilIndex(int position) {
        int limit = this.getLimit();
        if (position < this.getWritePosition()) {
            Buffer this_$iv = this;
            boolean $i$f$getWriteRemaining = false;
            Void void_ = BufferKt.commitWrittenFailed(position - this.getWritePosition(), this_$iv.getLimit() - this_$iv.getWritePosition());
            throw new KotlinNothingValueException();
        }
        if (position >= limit) {
            if (position == limit) {
                this.setWritePosition(position);
                return false;
            }
            Buffer this_$iv = this;
            boolean $i$f$getWriteRemaining = false;
            Void void_ = BufferKt.commitWrittenFailed(position - this.getWritePosition(), this_$iv.getLimit() - this_$iv.getWritePosition());
            throw new KotlinNothingValueException();
        }
        this.setWritePosition(position);
        return true;
    }

    public final void discardUntilIndex$ktor_io(int position) {
        if (position < 0 || position > this.getWritePosition()) {
            Buffer this_$iv = this;
            boolean $i$f$getReadRemaining = false;
            Void void_ = BufferKt.discardFailed(position - this.getReadPosition(), this_$iv.getWritePosition() - this_$iv.getReadPosition());
            throw new KotlinNothingValueException();
        }
        if (this.getReadPosition() != position) {
            this.setReadPosition(position);
        }
    }

    public final void rewind(int count) {
        int newReadPosition = this.getReadPosition() - count;
        if (newReadPosition < this.getStartGap()) {
            Void void_ = BufferKt.rewindFailed(count, this.getReadPosition() - this.getStartGap());
            throw new KotlinNothingValueException();
        }
        this.setReadPosition(newReadPosition);
    }

    public static /* synthetic */ void rewind$default(Buffer buffer, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: rewind");
        }
        if ((n2 & 1) != 0) {
            n = buffer.getReadPosition() - buffer.getStartGap();
        }
        buffer.rewind(n);
    }

    public final void reserveStartGap(int startGap) {
        boolean condition$iv = startGap >= 0;
        boolean $i$f$require = false;
        boolean bl = false;
        if (!condition$iv) {
            RequireFailureCapture m$iv = new RequireFailureCapture(startGap){
                final /* synthetic */ int $startGap$inlined;
                {
                    this.$startGap$inlined = n;
                }

                @NotNull
                public Void doFail() {
                    String string;
                    boolean bl = false;
                    String string2 = string = "startGap shouldn't be negative: " + this.$startGap$inlined;
                    throw (Throwable)new IllegalArgumentException(string2);
                }
            };
            Void void_ = m$iv.doFail();
            throw new KotlinNothingValueException();
        }
        if (this.getReadPosition() >= startGap) {
            this.setStartGap(startGap);
            return;
        }
        if (this.getReadPosition() == this.getWritePosition()) {
            if (startGap > this.getLimit()) {
                Void void_ = BufferKt.startGapReservationFailedDueToLimit(this, startGap);
                throw new KotlinNothingValueException();
            }
            this.setWritePosition(startGap);
            this.setReadPosition(startGap);
            this.setStartGap(startGap);
            return;
        }
        Void void_ = BufferKt.startGapReservationFailed(this, startGap);
        throw new KotlinNothingValueException();
    }

    public final void reserveEndGap(int endGap) {
        boolean condition$iv = endGap >= 0;
        boolean $i$f$require = false;
        boolean bl = false;
        if (!condition$iv) {
            RequireFailureCapture m$iv = new RequireFailureCapture(endGap){
                final /* synthetic */ int $endGap$inlined;
                {
                    this.$endGap$inlined = n;
                }

                @NotNull
                public Void doFail() {
                    String string;
                    boolean bl = false;
                    String string2 = string = "endGap shouldn't be negative: " + this.$endGap$inlined;
                    throw (Throwable)new IllegalArgumentException(string2);
                }
            };
            Void void_ = m$iv.doFail();
            throw new KotlinNothingValueException();
        }
        int newLimit = this.capacity - endGap;
        if (newLimit >= this.getWritePosition()) {
            this.setLimit(newLimit);
            return;
        }
        if (newLimit < 0) {
            BufferKt.endGapReservationFailedDueToCapacity(this, endGap);
        }
        if (newLimit < this.getStartGap()) {
            BufferKt.endGapReservationFailedDueToStartGap(this, endGap);
        }
        if (this.getReadPosition() == this.getWritePosition()) {
            this.setLimit(newLimit);
            this.setReadPosition(newLimit);
            this.setWritePosition(newLimit);
            return;
        }
        BufferKt.endGapReservationFailedDueToContent(this, endGap);
    }

    public final void resetForRead() {
        this.setStartGap(0);
        this.setReadPosition(0);
        int capacity = this.capacity;
        this.setWritePosition(capacity);
    }

    public final void resetForWrite() {
        this.resetForWrite(this.capacity - this.getStartGap());
    }

    public final void resetForWrite(int limit) {
        int startGap = this.getStartGap();
        this.setReadPosition(startGap);
        this.setWritePosition(startGap);
        this.setLimit(limit);
    }

    public final void releaseGaps$ktor_io() {
        this.releaseStartGap$ktor_io(0);
        this.releaseEndGap$ktor_io();
    }

    public final void releaseEndGap$ktor_io() {
        this.setLimit(this.capacity);
    }

    public final void releaseStartGap$ktor_io(int newReadPosition) {
        boolean condition$iv = newReadPosition >= 0;
        boolean $i$f$require = false;
        boolean bl = false;
        if (!condition$iv) {
            RequireFailureCapture m$iv = new RequireFailureCapture(newReadPosition){
                final /* synthetic */ int $newReadPosition$inlined;
                {
                    this.$newReadPosition$inlined = n;
                }

                @NotNull
                public Void doFail() {
                    String string;
                    boolean bl = false;
                    String string2 = string = "newReadPosition shouldn't be negative: " + this.$newReadPosition$inlined;
                    throw (Throwable)new IllegalArgumentException(string2);
                }
            };
            Void void_ = m$iv.doFail();
            throw new KotlinNothingValueException();
        }
        condition$iv = newReadPosition <= this.getReadPosition();
        $i$f$require = false;
        boolean m$iv = false;
        if (!condition$iv) {
            RequireFailureCapture m$iv2 = new RequireFailureCapture(this, newReadPosition){
                final /* synthetic */ Buffer this$0;
                final /* synthetic */ int $newReadPosition$inlined;
                {
                    this.this$0 = buffer;
                    this.$newReadPosition$inlined = n;
                }

                @NotNull
                public Void doFail() {
                    String string;
                    boolean bl = false;
                    String string2 = string = "newReadPosition shouldn't be ahead of the read position: " + this.$newReadPosition$inlined + " > " + this.this$0.getReadPosition();
                    throw (Throwable)new IllegalArgumentException(string2);
                }
            };
            Void void_ = m$iv2.doFail();
            throw new KotlinNothingValueException();
        }
        this.setReadPosition(newReadPosition);
        if (this.getStartGap() > newReadPosition) {
            this.setStartGap(newReadPosition);
        }
    }

    protected void duplicateTo(@NotNull Buffer copy2) {
        Intrinsics.checkNotNullParameter((Object)copy2, (String)"copy");
        copy2.setLimit(this.getLimit());
        copy2.setStartGap(this.getStartGap());
        copy2.setReadPosition(this.getReadPosition());
        copy2.setWritePosition(this.getWritePosition());
    }

    @NotNull
    public Buffer duplicate() {
        Buffer buffer = new Buffer(this.memory, null);
        boolean bl = false;
        boolean bl2 = false;
        Buffer $this$apply = buffer;
        boolean bl3 = false;
        $this$apply.duplicateTo($this$apply);
        return buffer;
    }

    public final int tryPeekByte() {
        int readPosition = this.getReadPosition();
        if (readPosition == this.getWritePosition()) {
            return -1;
        }
        ByteBuffer $this$get$iv = this.memory;
        boolean bl = false;
        ByteBuffer $this$iv$iv = $this$get$iv;
        boolean $i$f$loadAt = false;
        return $this$iv$iv.get(readPosition) & 0xFF;
    }

    public final int tryReadByte() {
        int readPosition = this.getReadPosition();
        if (readPosition == this.getWritePosition()) {
            return -1;
        }
        this.setReadPosition(readPosition + 1);
        ByteBuffer $this$get$iv = this.memory;
        boolean bl = false;
        ByteBuffer $this$iv$iv = $this$get$iv;
        boolean $i$f$loadAt = false;
        return $this$iv$iv.get(readPosition) & 0xFF;
    }

    public final byte readByte() {
        int readPosition = this.getReadPosition();
        if (readPosition == this.getWritePosition()) {
            throw (Throwable)new EOFException("No readable bytes available.");
        }
        this.setReadPosition(readPosition + 1);
        ByteBuffer $this$get$iv = this.memory;
        boolean bl = false;
        ByteBuffer $this$iv$iv = $this$get$iv;
        boolean $i$f$loadAt = false;
        return $this$iv$iv.get(readPosition);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeByte(byte value) {
        void $this$set$iv;
        int writePosition = this.getWritePosition();
        if (writePosition == this.getLimit()) {
            throw (Throwable)new InsufficientSpaceException("No free space in the buffer to write a byte");
        }
        ByteBuffer byteBuffer = this.memory;
        byte value$iv = value;
        boolean bl = false;
        void $this$iv$iv = $this$set$iv;
        boolean $i$f$storeAt = false;
        $this$iv$iv.put(writePosition, value$iv);
        this.setWritePosition(writePosition + 1);
    }

    public void reset() {
        this.releaseGaps$ktor_io();
        this.resetForWrite();
    }

    @NotNull
    public String toString() {
        Buffer this_$iv = this;
        boolean $i$f$getReadRemaining = false;
        StringBuilder stringBuilder = new StringBuilder().append("Buffer(").append(this_$iv.getWritePosition() - this_$iv.getReadPosition()).append(" used, ");
        this_$iv = this;
        boolean $i$f$getWriteRemaining = false;
        StringBuilder stringBuilder2 = stringBuilder.append(this_$iv.getLimit() - this_$iv.getWritePosition()).append(" free, ");
        this_$iv = this;
        boolean $i$f$getEndGap = false;
        return stringBuilder2.append(this.getStartGap() + (this_$iv.getCapacity() - this_$iv.getLimit())).append(" reserved of ").append(this.capacity).append(')').toString();
    }

    @NotNull
    public final ByteBuffer getMemory-SK3TCg8() {
        return this.memory;
    }

    private Buffer(ByteBuffer memory) {
        ByteBuffer $this$iv = this.memory = memory;
        boolean $i$f$getSize32 = false;
        this.bufferState = new BufferSharedState($this$iv.limit());
        $this$iv = this.memory;
        $i$f$getSize32 = false;
        this.capacity = $this$iv.limit();
    }

    public static final /* synthetic */ int access$getLimit$p(Buffer $this) {
        return $this.getLimit();
    }

    public static final /* synthetic */ void access$setLimit$p(Buffer $this, int n) {
        $this.setLimit(n);
    }

    public static final /* synthetic */ int access$getWritePosition$p(Buffer $this) {
        return $this.getWritePosition();
    }

    public static final /* synthetic */ void access$setWritePosition$p(Buffer $this, int n) {
        $this.setWritePosition(n);
    }

    public static final /* synthetic */ int access$getReadPosition$p(Buffer $this) {
        return $this.getReadPosition();
    }

    public static final /* synthetic */ void access$setReadPosition$p(Buffer $this, int n) {
        $this.setReadPosition(n);
    }

    public /* synthetic */ Buffer(ByteBuffer memory, DefaultConstructorMarker $constructor_marker) {
        this(memory);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\f\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u00020\t8\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\n\u0010\u0002\u00a8\u0006\u000b"}, d2={"Lio/ktor/utils/io/core/Buffer$Companion;", "", "()V", "Empty", "Lio/ktor/utils/io/core/Buffer;", "getEmpty$annotations", "getEmpty", "()Lio/ktor/utils/io/core/Buffer;", "ReservedSize", "", "getReservedSize$annotations", "ktor-io"})
    public static final class Companion {
        @DangerousInternalIoApi
        public static /* synthetic */ void getReservedSize$annotations() {
        }

        public static /* synthetic */ void getEmpty$annotations() {
        }

        @NotNull
        public final Buffer getEmpty() {
            return IoBuffer.Companion.getEmpty();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

