/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.utils.io.core.internal;

import io.ktor.utils.io.bits.DefaultAllocator;
import io.ktor.utils.io.core.Buffer;
import io.ktor.utils.io.core.BufferFactoryKt;
import io.ktor.utils.io.core.IoBuffer;
import io.ktor.utils.io.core.internal.RequireFailureCapture;
import io.ktor.utils.io.pool.NoPoolImpl;
import io.ktor.utils.io.pool.ObjectPool;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0016\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\b\u0016\u0018\u0000 -2\u00020/:\u0001-B,\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0000\u0012\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0000\u0018\u00010\u0004\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\u000b\u001a\u00020\bH\u0000\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\r\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0000H\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0011\u001a\u00020\u0000H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0010J\u000f\u0010\u0015\u001a\u00020\u0012H\u0000\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001d\u0010\u0015\u001a\u00020\b2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00000\u0004H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0017J\r\u0010\u0018\u001a\u00020\b\u00a2\u0006\u0004\b\u0018\u0010\nJ\u000f\u0010\u001a\u001a\u00020\bH\u0000\u00a2\u0006\u0004\b\u0019\u0010\nJ\u000f\u0010\u001c\u001a\u00020\bH\u0000\u00a2\u0006\u0004\b\u001b\u0010\nR(\u0010 \u001a\u0004\u0018\u00010\u00002\b\u0010\u001d\u001a\u0004\u0018\u00010\u00008F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001e\u0010\u0010\"\u0004\b\u001f\u0010\u000eR/\u0010\u0003\u001a\u0004\u0018\u00010\u00002\b\u0010!\u001a\u0004\u0018\u00010\u00008F@BX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010\u0010\"\u0004\b%\u0010\u000eR$\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0000\u0018\u00010\u00048\u0000@\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010&\u001a\u0004\b'\u0010(R\u0013\u0010,\u001a\u00020)8F@\u0006\u00a2\u0006\u0006\u001a\u0004\b*\u0010+\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006."}, d2={"Lio/ktor/utils/io/core/internal/ChunkBuffer;", "Lio/ktor/utils/io/bits/Memory;", "memory", "origin", "Lio/ktor/utils/io/pool/ObjectPool;", "parentPool", "<init>", "(Ljava/nio/ByteBuffer;Lio/ktor/utils/io/core/internal/ChunkBuffer;Lio/ktor/utils/io/pool/ObjectPool;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "", "acquire$ktor_io", "()V", "acquire", "chunk", "appendNext", "(Lio/ktor/utils/io/core/internal/ChunkBuffer;)V", "cleanNext", "()Lio/ktor/utils/io/core/internal/ChunkBuffer;", "duplicate", "", "release$ktor_io", "()Z", "release", "pool", "(Lio/ktor/utils/io/pool/ObjectPool;)V", "reset", "unlink$ktor_io", "unlink", "unpark$ktor_io", "unpark", "newValue", "getNext", "setNext", "next", "<set-?>", "origin$delegate", "Lkotlin/properties/ReadWriteProperty;", "getOrigin", "setOrigin", "Lio/ktor/utils/io/pool/ObjectPool;", "getParentPool$ktor_io", "()Lio/ktor/utils/io/pool/ObjectPool;", "", "getReferenceCount", "()I", "referenceCount", "Companion", "ktor-io", "Lio/ktor/utils/io/core/Buffer;"})
public class ChunkBuffer
extends Buffer {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @Nullable
    private final ObjectPool<ChunkBuffer> parentPool;
    @NotNull
    private volatile /* synthetic */ Object nextRef;
    private static final /* synthetic */ AtomicReferenceFieldUpdater nextRef$FU;
    @NotNull
    private volatile /* synthetic */ int refCount;
    private static final /* synthetic */ AtomicIntegerFieldUpdater refCount$FU;
    @NotNull
    private final ReadWriteProperty origin$delegate;
    @NotNull
    private static final ObjectPool<ChunkBuffer> Pool;
    @NotNull
    private static final ObjectPool<ChunkBuffer> EmptyPool;
    @NotNull
    private static final ObjectPool<ChunkBuffer> NoPool;
    @NotNull
    private static final ObjectPool<ChunkBuffer> NoPoolManuallyManaged;

    private ChunkBuffer(ByteBuffer memory, ChunkBuffer origin, ObjectPool<ChunkBuffer> parentPool) {
        super(memory, null);
        this.parentPool = parentPool;
        boolean condition$iv = origin != this;
        boolean $i$f$require = false;
        boolean bl = false;
        if (!condition$iv) {
            RequireFailureCapture m$iv = new RequireFailureCapture(){

                @NotNull
                public Void doFail() {
                    String string;
                    boolean bl = false;
                    String string2 = string = "A chunk couldn't be a view of itself.";
                    throw new IllegalArgumentException(string2);
                }
            };
            m$iv.doFail();
            throw new KotlinNothingValueException();
        }
        this.nextRef = null;
        this.refCount = 1;
        boolean $i$f$shared = false;
        this.origin$delegate = new ReadWriteProperty<Object, T>(origin){
            private T value;
            final /* synthetic */ T $value;
            {
                this.$value = $value;
                this.value = this.$value;
            }

            public T getValue(@NotNull Object thisRef, @NotNull KProperty<?> property) {
                Intrinsics.checkNotNullParameter((Object)thisRef, (String)"thisRef");
                Intrinsics.checkNotNullParameter(property, (String)"property");
                return this.value;
            }

            public void setValue(@NotNull Object thisRef, @NotNull KProperty<?> property, T value) {
                Intrinsics.checkNotNullParameter((Object)thisRef, (String)"thisRef");
                Intrinsics.checkNotNullParameter(property, (String)"property");
                this.value = value;
            }
        };
    }

    @Nullable
    public final ObjectPool<ChunkBuffer> getParentPool$ktor_io() {
        return this.parentPool;
    }

    @Nullable
    public final ChunkBuffer getOrigin() {
        return (ChunkBuffer)this.origin$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    private final void setOrigin(ChunkBuffer chunkBuffer) {
        this.origin$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)chunkBuffer);
    }

    @Nullable
    public final ChunkBuffer getNext() {
        return (ChunkBuffer)this.nextRef;
    }

    public final void setNext(@Nullable ChunkBuffer newValue) {
        if (newValue == null) {
            this.cleanNext();
        } else {
            this.appendNext(newValue);
        }
    }

    public final int getReferenceCount() {
        return this.refCount;
    }

    private final void appendNext(ChunkBuffer chunk) {
        if (!nextRef$FU.compareAndSet(this, null, chunk)) {
            throw new IllegalStateException("This chunk has already a next chunk.");
        }
    }

    @Nullable
    public final ChunkBuffer cleanNext() {
        return nextRef$FU.getAndSet(this, null);
    }

    @Override
    @NotNull
    public ChunkBuffer duplicate() {
        ChunkBuffer chunkBuffer = this.getOrigin();
        chunkBuffer = chunkBuffer == null ? this : chunkBuffer;
        boolean bl = false;
        boolean bl2 = false;
        ChunkBuffer newOrigin = chunkBuffer;
        boolean bl3 = false;
        newOrigin.acquire$ktor_io();
        ChunkBuffer chunkBuffer2 = new ChunkBuffer(this.getMemory-SK3TCg8(), newOrigin, this.getParentPool$ktor_io(), null);
        boolean bl4 = false;
        boolean bl5 = false;
        ChunkBuffer copy2 = chunkBuffer2;
        boolean bl6 = false;
        this.duplicateTo(copy2);
        return chunkBuffer2;
    }

    public void release(@NotNull ObjectPool<ChunkBuffer> pool) {
        Intrinsics.checkNotNullParameter(pool, (String)"pool");
        if (this.release$ktor_io()) {
            ChunkBuffer origin = this.getOrigin();
            if (origin != null) {
                this.unlink$ktor_io();
                origin.release(pool);
            } else {
                ObjectPool<ChunkBuffer> objectPool = this.parentPool;
                ObjectPool<ChunkBuffer> poolToUse = objectPool == null ? pool : objectPool;
                poolToUse.recycle(this);
            }
        }
    }

    public final void unlink$ktor_io() {
        if (!refCount$FU.compareAndSet(this, 0, -1)) {
            throw new IllegalStateException("Unable to unlink: buffer is in use.");
        }
        this.cleanNext();
        this.setOrigin(null);
    }

    public final void acquire$ktor_io() {
        int old;
        int upd$iv;
        int cur$iv;
        ChunkBuffer $this$update$iv = this;
        boolean $i$f$update = false;
        do {
            old = cur$iv = $this$update$iv.refCount;
            boolean bl = false;
            if (old > 0) continue;
            throw new IllegalStateException("Unable to acquire chunk: it is already released.");
        } while (!refCount$FU.compareAndSet($this$update$iv, cur$iv, upd$iv = old + 1));
    }

    public final void unpark$ktor_io() {
        int upd$iv;
        int cur$iv;
        ChunkBuffer $this$update$iv = this;
        boolean $i$f$update = false;
        do {
            int old = cur$iv = $this$update$iv.refCount;
            boolean bl = false;
            if (old < 0) {
                throw new IllegalStateException("This instance is already disposed and couldn't be borrowed.");
            }
            if (old <= 0) continue;
            throw new IllegalStateException("This instance is already in use but somehow appeared in the pool.");
        } while (!refCount$FU.compareAndSet($this$update$iv, cur$iv, upd$iv = 1));
    }

    public final boolean release$ktor_io() {
        int old;
        int upd$iv;
        int cur$iv;
        ChunkBuffer $this$updateAndGet$iv = this;
        boolean $i$f$updateAndGet = false;
        do {
            old = cur$iv = $this$updateAndGet$iv.refCount;
            boolean bl = false;
            if (old > 0) continue;
            throw new IllegalStateException("Unable to release: it is already released.");
        } while (!refCount$FU.compareAndSet($this$updateAndGet$iv, cur$iv, upd$iv = old - 1));
        return upd$iv == 0;
    }

    @Override
    public final void reset() {
        boolean condition$iv = this.getOrigin() == null;
        boolean $i$f$require = false;
        boolean bl = false;
        if (!condition$iv) {
            RequireFailureCapture m$iv = new RequireFailureCapture(){

                @NotNull
                public Void doFail() {
                    String string;
                    boolean bl = false;
                    String string2 = string = "Unable to reset buffer with origin";
                    throw new IllegalArgumentException(string2);
                }
            };
            m$iv.doFail();
            throw new KotlinNothingValueException();
        }
        super.reset();
        this.setAttachment(null);
        this.nextRef = null;
    }

    public /* synthetic */ ChunkBuffer(ByteBuffer memory, ChunkBuffer origin, ObjectPool parentPool, DefaultConstructorMarker $constructor_marker) {
        this(memory, origin, parentPool);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ChunkBuffer.class), "origin", "getOrigin()Lio/ktor/utils/io/core/internal/ChunkBuffer;")))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
        Pool = new ObjectPool<ChunkBuffer>(){

            public int getCapacity() {
                return BufferFactoryKt.getDefaultChunkedBufferPool().getCapacity();
            }

            @NotNull
            public ChunkBuffer borrow() {
                return BufferFactoryKt.getDefaultChunkedBufferPool().borrow();
            }

            public void recycle(@NotNull ChunkBuffer instance) {
                Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
                if (!(instance instanceof IoBuffer)) {
                    throw new IllegalArgumentException("Only IoBuffer instances can be recycled.");
                }
                BufferFactoryKt.getDefaultChunkedBufferPool().recycle((IoBuffer)instance);
            }

            public void dispose() {
                BufferFactoryKt.getDefaultChunkedBufferPool().dispose();
            }

            public void close() {
                ObjectPool.DefaultImpls.close(this);
            }
        };
        EmptyPool = new ObjectPool<ChunkBuffer>(){

            public int getCapacity() {
                return 1;
            }

            @NotNull
            public ChunkBuffer borrow() {
                return ChunkBuffer.Companion.getEmpty();
            }

            public void recycle(@NotNull ChunkBuffer instance) {
                Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
                boolean condition$iv = instance == ChunkBuffer.Companion.getEmpty();
                boolean $i$f$require = false;
                boolean bl = false;
                if (!condition$iv) {
                    RequireFailureCapture m$iv = new RequireFailureCapture(){

                        @NotNull
                        public Void doFail() {
                            String string;
                            boolean bl = false;
                            String string2 = string = "Only ChunkBuffer.Empty instance could be recycled.";
                            throw new IllegalArgumentException(string2);
                        }
                    };
                    m$iv.doFail();
                    throw new KotlinNothingValueException();
                }
            }

            public void dispose() {
            }

            public void close() {
                ObjectPool.DefaultImpls.close(this);
            }
        };
        NoPool = new NoPoolImpl<ChunkBuffer>(){

            @NotNull
            public ChunkBuffer borrow() {
                return new IoBuffer(DefaultAllocator.INSTANCE.alloc-SK3TCg8(4096), null, this, null);
            }

            public void recycle(@NotNull ChunkBuffer instance) {
                Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
                if (!(instance instanceof IoBuffer)) {
                    throw new IllegalArgumentException("Only IoBuffer instances can be recycled.");
                }
                DefaultAllocator.INSTANCE.free-3GNKZMM(instance.getMemory-SK3TCg8());
            }
        };
        NoPoolManuallyManaged = new NoPoolImpl<ChunkBuffer>(){

            @NotNull
            public ChunkBuffer borrow() {
                throw new UnsupportedOperationException("This pool doesn't support borrow");
            }

            public void recycle(@NotNull ChunkBuffer instance) {
                Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
            }
        };
        nextRef$FU = AtomicReferenceFieldUpdater.newUpdater(ChunkBuffer.class, Object.class, "nextRef");
        refCount$FU = AtomicIntegerFieldUpdater.newUpdater(ChunkBuffer.class, "refCount");
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\f\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR \u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\tX\u0080\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\r\u0010\u0002\u001a\u0004\b\u000e\u0010\u000bR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000bR\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lio/ktor/utils/io/core/internal/ChunkBuffer$Companion;", "", "()V", "Empty", "Lio/ktor/utils/io/core/internal/ChunkBuffer;", "getEmpty$annotations", "getEmpty", "()Lio/ktor/utils/io/core/internal/ChunkBuffer;", "EmptyPool", "Lio/ktor/utils/io/pool/ObjectPool;", "getEmptyPool", "()Lio/ktor/utils/io/pool/ObjectPool;", "NoPool", "getNoPool$ktor_io$annotations", "getNoPool$ktor_io", "NoPoolManuallyManaged", "getNoPoolManuallyManaged$ktor_io", "Pool", "getPool", "ktor-io"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ObjectPool<ChunkBuffer> getPool() {
            return Pool;
        }

        @NotNull
        public final ChunkBuffer getEmpty() {
            return IoBuffer.Companion.getEmpty();
        }

        public static /* synthetic */ void getEmpty$annotations() {
        }

        @NotNull
        public final ObjectPool<ChunkBuffer> getEmptyPool() {
            return EmptyPool;
        }

        @NotNull
        public final ObjectPool<ChunkBuffer> getNoPool$ktor_io() {
            return NoPool;
        }

        public static /* synthetic */ void getNoPool$ktor_io$annotations() {
        }

        @NotNull
        public final ObjectPool<ChunkBuffer> getNoPoolManuallyManaged$ktor_io() {
            return NoPoolManuallyManaged;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

