/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.utils.io.internal;

import io.ktor.utils.io.internal.ReadWriteBufferStateKt;
import io.ktor.utils.io.internal.RingBufferCapacity;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001:\u0007\u0018\u0019\u001a\u001b\u001c\u001d\u001eB\u0017\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\r\u0010\u0010\u001a\u00020\u0000H\u0010\u00a2\u0006\u0002\b\u0011J\r\u0010\u0012\u001a\u00020\u0000H\u0010\u00a2\u0006\u0002\b\u0013J\r\u0010\u0014\u001a\u00020\u0000H\u0010\u00a2\u0006\u0002\b\u0015J\r\u0010\u0016\u001a\u00020\u0000H\u0010\u00a2\u0006\u0002\b\u0017R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\r\u0082\u0001\u0007\u001f !\"#$%\u00a8\u0006&"}, d2={"Lio/ktor/utils/io/internal/ReadWriteBufferState;", "", "backingBuffer", "Ljava/nio/ByteBuffer;", "capacity", "Lio/ktor/utils/io/internal/RingBufferCapacity;", "(Ljava/nio/ByteBuffer;Lio/ktor/utils/io/internal/RingBufferCapacity;)V", "idle", "", "getIdle", "()Z", "readBuffer", "getReadBuffer", "()Ljava/nio/ByteBuffer;", "writeBuffer", "getWriteBuffer", "startReading", "startReading$ktor_io", "startWriting", "startWriting$ktor_io", "stopReading", "stopReading$ktor_io", "stopWriting", "stopWriting$ktor_io", "IdleEmpty", "IdleNonEmpty", "Initial", "Reading", "ReadingWriting", "Terminated", "Writing", "Lio/ktor/utils/io/internal/ReadWriteBufferState$IdleEmpty;", "Lio/ktor/utils/io/internal/ReadWriteBufferState$Initial;", "Lio/ktor/utils/io/internal/ReadWriteBufferState$IdleNonEmpty;", "Lio/ktor/utils/io/internal/ReadWriteBufferState$Reading;", "Lio/ktor/utils/io/internal/ReadWriteBufferState$Writing;", "Lio/ktor/utils/io/internal/ReadWriteBufferState$ReadingWriting;", "Lio/ktor/utils/io/internal/ReadWriteBufferState$Terminated;", "ktor-io"})
public abstract class ReadWriteBufferState {
    @JvmField
    @NotNull
    public final ByteBuffer backingBuffer;
    @JvmField
    @NotNull
    public final RingBufferCapacity capacity;

    private ReadWriteBufferState(ByteBuffer backingBuffer, RingBufferCapacity capacity) {
        this.backingBuffer = backingBuffer;
        this.capacity = capacity;
    }

    public boolean getIdle() {
        return false;
    }

    @NotNull
    public ByteBuffer getReadBuffer() {
        String string = Intrinsics.stringPlus((String)"read buffer is not available in state ", (Object)this);
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string.toString());
    }

    @NotNull
    public ByteBuffer getWriteBuffer() {
        String string = Intrinsics.stringPlus((String)"write buffer is not available in state ", (Object)this);
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string.toString());
    }

    @NotNull
    public ReadWriteBufferState startReading$ktor_io() {
        String string = Intrinsics.stringPlus((String)"Reading is not available in state ", (Object)this);
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string.toString());
    }

    @NotNull
    public ReadWriteBufferState startWriting$ktor_io() {
        String string = Intrinsics.stringPlus((String)"Writing is not available in state ", (Object)this);
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string.toString());
    }

    @NotNull
    public ReadWriteBufferState stopReading$ktor_io() {
        String string = Intrinsics.stringPlus((String)"Unable to stop reading in state ", (Object)this);
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string.toString());
    }

    @NotNull
    public ReadWriteBufferState stopWriting$ktor_io() {
        String string = Intrinsics.stringPlus((String)"Unable to stop writing in state ", (Object)this);
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string.toString());
    }

    public /* synthetic */ ReadWriteBufferState(ByteBuffer backingBuffer, RingBufferCapacity capacity, DefaultConstructorMarker $constructor_marker) {
        this(backingBuffer, capacity);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lio/ktor/utils/io/internal/ReadWriteBufferState$IdleEmpty;", "Lio/ktor/utils/io/internal/ReadWriteBufferState;", "()V", "idle", "", "getIdle", "()Z", "toString", "", "ktor-io"})
    public static final class IdleEmpty
    extends ReadWriteBufferState {
        @NotNull
        public static final IdleEmpty INSTANCE = new IdleEmpty();

        private IdleEmpty() {
            super(ReadWriteBufferStateKt.getEmptyByteBuffer(), ReadWriteBufferStateKt.getEmptyCapacity(), null);
        }

        @Override
        public boolean getIdle() {
            return true;
        }

        @NotNull
        public String toString() {
            return "IDLE(empty)";
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\r\u0010 \u001a\u00020\u0013H\u0010\u00a2\u0006\u0002\b!J\r\u0010\"\u001a\u00020\u001dH\u0010\u00a2\u0006\u0002\b#J\b\u0010$\u001a\u00020%H\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0017X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0011R\u0014\u0010\u001c\u001a\u00020\u001dX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006&"}, d2={"Lio/ktor/utils/io/internal/ReadWriteBufferState$Initial;", "Lio/ktor/utils/io/internal/ReadWriteBufferState;", "backingBuffer", "Ljava/nio/ByteBuffer;", "reservedSize", "", "(Ljava/nio/ByteBuffer;I)V", "idle", "", "getIdle", "()Z", "idleState", "Lio/ktor/utils/io/internal/ReadWriteBufferState$IdleNonEmpty;", "getIdleState$ktor_io", "()Lio/ktor/utils/io/internal/ReadWriteBufferState$IdleNonEmpty;", "readBuffer", "getReadBuffer", "()Ljava/nio/ByteBuffer;", "readingState", "Lio/ktor/utils/io/internal/ReadWriteBufferState$Reading;", "getReadingState$ktor_io", "()Lio/ktor/utils/io/internal/ReadWriteBufferState$Reading;", "readingWritingState", "Lio/ktor/utils/io/internal/ReadWriteBufferState$ReadingWriting;", "getReadingWritingState$ktor_io", "()Lio/ktor/utils/io/internal/ReadWriteBufferState$ReadingWriting;", "writeBuffer", "getWriteBuffer", "writingState", "Lio/ktor/utils/io/internal/ReadWriteBufferState$Writing;", "getWritingState$ktor_io", "()Lio/ktor/utils/io/internal/ReadWriteBufferState$Writing;", "startReading", "startReading$ktor_io", "startWriting", "startWriting$ktor_io", "toString", "", "ktor-io"})
    public static final class Initial
    extends ReadWriteBufferState {
        @NotNull
        private final ByteBuffer writeBuffer;
        @NotNull
        private final ByteBuffer readBuffer;
        @NotNull
        private final IdleNonEmpty idleState;
        @NotNull
        private final Reading readingState;
        @NotNull
        private final Writing writingState;
        @NotNull
        private final ReadingWriting readingWritingState;

        public Initial(@NotNull ByteBuffer backingBuffer, int reservedSize) {
            Intrinsics.checkNotNullParameter((Object)backingBuffer, (String)"backingBuffer");
            super(backingBuffer, new RingBufferCapacity(backingBuffer.capacity() - reservedSize), null);
            boolean bl = backingBuffer.position() == 0;
            boolean bl2 = false;
            boolean bl3 = false;
            bl3 = false;
            boolean bl4 = false;
            if (!bl) {
                boolean bl5 = false;
                String string = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            bl = backingBuffer.limit() == backingBuffer.capacity();
            bl2 = false;
            bl3 = false;
            bl3 = false;
            bl4 = false;
            if (!bl) {
                boolean bl6 = false;
                String string = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            ByteBuffer byteBuffer = backingBuffer.duplicate();
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"backingBuffer.duplicate()");
            this.writeBuffer = byteBuffer;
            byteBuffer = backingBuffer.duplicate();
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"backingBuffer.duplicate()");
            this.readBuffer = byteBuffer;
            this.idleState = new IdleNonEmpty(this);
            this.readingState = new Reading(this);
            this.writingState = new Writing(this);
            this.readingWritingState = new ReadingWriting(this);
        }

        public /* synthetic */ Initial(ByteBuffer byteBuffer, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                n = 8;
            }
            this(byteBuffer, n);
        }

        @Override
        @NotNull
        public ByteBuffer getWriteBuffer() {
            return this.writeBuffer;
        }

        @Override
        @NotNull
        public ByteBuffer getReadBuffer() {
            return this.readBuffer;
        }

        @NotNull
        public final IdleNonEmpty getIdleState$ktor_io() {
            return this.idleState;
        }

        @NotNull
        public final Reading getReadingState$ktor_io() {
            return this.readingState;
        }

        @NotNull
        public final Writing getWritingState$ktor_io() {
            return this.writingState;
        }

        @NotNull
        public final ReadingWriting getReadingWritingState$ktor_io() {
            return this.readingWritingState;
        }

        @Override
        @NotNull
        public Reading startReading$ktor_io() {
            return this.readingState;
        }

        @Override
        @NotNull
        public Writing startWriting$ktor_io() {
            return this.writingState;
        }

        @Override
        public boolean getIdle() {
            String string = "Not available for initial state";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }

        @NotNull
        public String toString() {
            return "Initial";
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\r\u0010\u000b\u001a\u00020\fH\u0010\u00a2\u0006\u0002\b\rJ\r\u0010\u000e\u001a\u00020\u000fH\u0010\u00a2\u0006\u0002\b\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lio/ktor/utils/io/internal/ReadWriteBufferState$IdleNonEmpty;", "Lio/ktor/utils/io/internal/ReadWriteBufferState;", "initial", "Lio/ktor/utils/io/internal/ReadWriteBufferState$Initial;", "(Lio/ktor/utils/io/internal/ReadWriteBufferState$Initial;)V", "idle", "", "getIdle", "()Z", "getInitial", "()Lio/ktor/utils/io/internal/ReadWriteBufferState$Initial;", "startReading", "Lio/ktor/utils/io/internal/ReadWriteBufferState$Reading;", "startReading$ktor_io", "startWriting", "Lio/ktor/utils/io/internal/ReadWriteBufferState$Writing;", "startWriting$ktor_io", "toString", "", "ktor-io"})
    public static final class IdleNonEmpty
    extends ReadWriteBufferState {
        @NotNull
        private final Initial initial;

        public IdleNonEmpty(@NotNull Initial initial) {
            Intrinsics.checkNotNullParameter((Object)initial, (String)"initial");
            super(initial.backingBuffer, initial.capacity, null);
            this.initial = initial;
        }

        @NotNull
        public final Initial getInitial() {
            return this.initial;
        }

        @Override
        @NotNull
        public Reading startReading$ktor_io() {
            return this.initial.getReadingState$ktor_io();
        }

        @Override
        @NotNull
        public Writing startWriting$ktor_io() {
            return this.initial.getWritingState$ktor_io();
        }

        @Override
        public boolean getIdle() {
            return true;
        }

        @NotNull
        public String toString() {
            return "IDLE(with buffer)";
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\r\u0010\t\u001a\u00020\nH\u0010\u00a2\u0006\u0002\b\u000bJ\r\u0010\f\u001a\u00020\rH\u0010\u00a2\u0006\u0002\b\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lio/ktor/utils/io/internal/ReadWriteBufferState$Reading;", "Lio/ktor/utils/io/internal/ReadWriteBufferState;", "initial", "Lio/ktor/utils/io/internal/ReadWriteBufferState$Initial;", "(Lio/ktor/utils/io/internal/ReadWriteBufferState$Initial;)V", "readBuffer", "Ljava/nio/ByteBuffer;", "getReadBuffer", "()Ljava/nio/ByteBuffer;", "startWriting", "Lio/ktor/utils/io/internal/ReadWriteBufferState$ReadingWriting;", "startWriting$ktor_io", "stopReading", "Lio/ktor/utils/io/internal/ReadWriteBufferState$IdleNonEmpty;", "stopReading$ktor_io", "toString", "", "ktor-io"})
    public static final class Reading
    extends ReadWriteBufferState {
        @NotNull
        private final Initial initial;

        public Reading(@NotNull Initial initial) {
            Intrinsics.checkNotNullParameter((Object)initial, (String)"initial");
            super(initial.backingBuffer, initial.capacity, null);
            this.initial = initial;
        }

        @Override
        @NotNull
        public ByteBuffer getReadBuffer() {
            return this.initial.getReadBuffer();
        }

        @Override
        @NotNull
        public ReadingWriting startWriting$ktor_io() {
            return this.initial.getReadingWritingState$ktor_io();
        }

        @Override
        @NotNull
        public IdleNonEmpty stopReading$ktor_io() {
            return this.initial.getIdleState$ktor_io();
        }

        @NotNull
        public String toString() {
            return "Reading";
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\r\u0010\t\u001a\u00020\nH\u0010\u00a2\u0006\u0002\b\u000bJ\r\u0010\f\u001a\u00020\rH\u0010\u00a2\u0006\u0002\b\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lio/ktor/utils/io/internal/ReadWriteBufferState$Writing;", "Lio/ktor/utils/io/internal/ReadWriteBufferState;", "initial", "Lio/ktor/utils/io/internal/ReadWriteBufferState$Initial;", "(Lio/ktor/utils/io/internal/ReadWriteBufferState$Initial;)V", "writeBuffer", "Ljava/nio/ByteBuffer;", "getWriteBuffer", "()Ljava/nio/ByteBuffer;", "startReading", "Lio/ktor/utils/io/internal/ReadWriteBufferState$ReadingWriting;", "startReading$ktor_io", "stopWriting", "Lio/ktor/utils/io/internal/ReadWriteBufferState$IdleNonEmpty;", "stopWriting$ktor_io", "toString", "", "ktor-io"})
    public static final class Writing
    extends ReadWriteBufferState {
        @NotNull
        private final Initial initial;

        public Writing(@NotNull Initial initial) {
            Intrinsics.checkNotNullParameter((Object)initial, (String)"initial");
            super(initial.backingBuffer, initial.capacity, null);
            this.initial = initial;
        }

        @Override
        @NotNull
        public ByteBuffer getWriteBuffer() {
            return this.initial.getWriteBuffer();
        }

        @Override
        @NotNull
        public ReadingWriting startReading$ktor_io() {
            return this.initial.getReadingWritingState$ktor_io();
        }

        @Override
        @NotNull
        public IdleNonEmpty stopWriting$ktor_io() {
            return this.initial.getIdleState$ktor_io();
        }

        @NotNull
        public String toString() {
            return "Writing";
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\r\u0010\u000b\u001a\u00020\fH\u0010\u00a2\u0006\u0002\b\rJ\r\u0010\u000e\u001a\u00020\u000fH\u0010\u00a2\u0006\u0002\b\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0013"}, d2={"Lio/ktor/utils/io/internal/ReadWriteBufferState$ReadingWriting;", "Lio/ktor/utils/io/internal/ReadWriteBufferState;", "initial", "Lio/ktor/utils/io/internal/ReadWriteBufferState$Initial;", "(Lio/ktor/utils/io/internal/ReadWriteBufferState$Initial;)V", "readBuffer", "Ljava/nio/ByteBuffer;", "getReadBuffer", "()Ljava/nio/ByteBuffer;", "writeBuffer", "getWriteBuffer", "stopReading", "Lio/ktor/utils/io/internal/ReadWriteBufferState$Writing;", "stopReading$ktor_io", "stopWriting", "Lio/ktor/utils/io/internal/ReadWriteBufferState$Reading;", "stopWriting$ktor_io", "toString", "", "ktor-io"})
    public static final class ReadingWriting
    extends ReadWriteBufferState {
        @NotNull
        private final Initial initial;

        public ReadingWriting(@NotNull Initial initial) {
            Intrinsics.checkNotNullParameter((Object)initial, (String)"initial");
            super(initial.backingBuffer, initial.capacity, null);
            this.initial = initial;
        }

        @Override
        @NotNull
        public ByteBuffer getReadBuffer() {
            return this.initial.getReadBuffer();
        }

        @Override
        @NotNull
        public ByteBuffer getWriteBuffer() {
            return this.initial.getWriteBuffer();
        }

        @Override
        @NotNull
        public Writing stopReading$ktor_io() {
            return this.initial.getWritingState$ktor_io();
        }

        @Override
        @NotNull
        public Reading stopWriting$ktor_io() {
            return this.initial.getReadingState$ktor_io();
        }

        @NotNull
        public String toString() {
            return "Reading+Writing";
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lio/ktor/utils/io/internal/ReadWriteBufferState$Terminated;", "Lio/ktor/utils/io/internal/ReadWriteBufferState;", "()V", "toString", "", "ktor-io"})
    public static final class Terminated
    extends ReadWriteBufferState {
        @NotNull
        public static final Terminated INSTANCE = new Terminated();

        private Terminated() {
            super(ReadWriteBufferStateKt.getEmptyByteBuffer(), ReadWriteBufferStateKt.getEmptyCapacity(), null);
        }

        @NotNull
        public String toString() {
            return "Terminated";
        }
    }
}

