/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.utils.io.core;

import io.ktor.utils.io.core.BufferUtilsJvmKt;
import io.ktor.utils.io.core.internal.ChunkBuffer;
import io.ktor.utils.io.pool.SingleInstancePool;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\b\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u0002H\u0014J\b\u0010\u000e\u001a\u00020\u0002H\u0014R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"Lio/ktor/utils/io/core/SingleByteBufferPool;", "Lio/ktor/utils/io/pool/SingleInstancePool;", "Lio/ktor/utils/io/core/internal/ChunkBuffer;", "instance", "Ljava/nio/ByteBuffer;", "release", "Lkotlin/Function1;", "", "(Ljava/nio/ByteBuffer;Lkotlin/jvm/functions/Function1;)V", "getInstance", "()Ljava/nio/ByteBuffer;", "getRelease", "()Lkotlin/jvm/functions/Function1;", "disposeInstance", "produceInstance", "ktor-io"})
final class SingleByteBufferPool
extends SingleInstancePool<ChunkBuffer> {
    @NotNull
    private final ByteBuffer instance;
    @NotNull
    private final Function1<ByteBuffer, Unit> release;

    public SingleByteBufferPool(@NotNull ByteBuffer instance, @NotNull Function1<? super ByteBuffer, Unit> release) {
        Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
        Intrinsics.checkNotNullParameter(release, (String)"release");
        this.instance = instance;
        this.release = release;
    }

    @NotNull
    public final ByteBuffer getInstance() {
        return this.instance;
    }

    @NotNull
    public final Function1<ByteBuffer, Unit> getRelease() {
        return this.release;
    }

    @Override
    @NotNull
    protected ChunkBuffer produceInstance() {
        return BufferUtilsJvmKt.ChunkBuffer(this.instance, this);
    }

    @Override
    protected void disposeInstance(@NotNull ChunkBuffer instance) {
        Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
        this.release.invoke((Object)this.instance);
    }
}

