/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.utils.io.internal;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlinx.atomicfu.AtomicFU;
import kotlinx.atomicfu.AtomicInt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0003J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003H\u0002J\u000e\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0003J\u0018\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003H\u0002J\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020\u0015J\u0006\u0010!\u001a\u00020\u001fJ\u0006\u0010\"\u001a\u00020\u001fJ\u0006\u0010#\u001a\u00020\u0015J\u0006\u0010$\u001a\u00020\u0015J\b\u0010%\u001a\u00020&H\u0016J\u0006\u0010'\u001a\u00020\u001fJ\u000e\u0010(\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003J\u000e\u0010)\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003J\u000e\u0010*\u001a\u00020\u001f2\u0006\u0010\u0016\u001a\u00020\u0003J\u000e\u0010+\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003J\u000e\u0010,\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003J\u000e\u0010-\u001a\u00020\u001f2\u0006\u0010\u0016\u001a\u00020\u0003R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\n\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00038\u00c6\u0002@\u00c2\u0002X\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u0004R&\u0010\u000e\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00038\u00c6\u0002@\u00c2\u0002X\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\f\"\u0004\b\u0010\u0010\u0004R&\u0010\u0011\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00038\u00c6\u0002@\u00c6\u0002X\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\f\"\u0004\b\u0013\u0010\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lio/ktor/utils/io/internal/RingBufferCapacity;", "", "totalCapacity", "", "(I)V", "_availableForRead", "Lkotlinx/atomicfu/AtomicInt;", "_availableForWrite", "_pendingToFlush", "value", "availableForRead", "getAvailableForRead", "()I", "setAvailableForRead", "availableForWrite", "getAvailableForWrite", "setAvailableForWrite", "pendingToFlush", "getPendingToFlush", "setPendingToFlush", "completeRead", "", "n", "completeReadOverflow", "", "remaining", "update", "completeWrite", "completeWriteOverflow", "pending", "flush", "", "forceLockForRelease", "isEmpty", "isFull", "resetForRead", "resetForWrite", "toString", "", "tryLockForRelease", "tryReadAtLeast", "tryReadAtMost", "tryReadExact", "tryWriteAtLeast", "tryWriteAtMost", "tryWriteExact", "ktor-io"})
public final class RingBufferCapacity {
    private final int totalCapacity;
    @NotNull
    private final AtomicInt _availableForRead;
    @NotNull
    private final AtomicInt _availableForWrite;
    @NotNull
    private final AtomicInt _pendingToFlush;

    public RingBufferCapacity(int totalCapacity) {
        this.totalCapacity = totalCapacity;
        this._availableForRead = AtomicFU.atomic((int)0);
        this._availableForWrite = AtomicFU.atomic((int)this.totalCapacity);
        this._pendingToFlush = AtomicFU.atomic((int)0);
    }

    public final int getAvailableForRead() {
        boolean $i$f$getAvailableForRead = false;
        return this._availableForRead.getValue();
    }

    private final void setAvailableForRead(int value) {
        boolean $i$f$setAvailableForRead = false;
        this._availableForRead.setValue(value);
    }

    public final int getAvailableForWrite() {
        boolean $i$f$getAvailableForWrite = false;
        return this._availableForWrite.getValue();
    }

    private final void setAvailableForWrite(int value) {
        boolean $i$f$setAvailableForWrite = false;
        this._availableForWrite.setValue(value);
    }

    public final int getPendingToFlush() {
        boolean $i$f$getPendingToFlush = false;
        return this._pendingToFlush.getValue();
    }

    public final void setPendingToFlush(int value) {
        boolean $i$f$setPendingToFlush = false;
        this._pendingToFlush.setValue(value);
    }

    public final void resetForWrite() {
        this._availableForRead.setValue(0);
        this._pendingToFlush.setValue(0);
        this._availableForWrite.setValue(this.totalCapacity);
    }

    public final void resetForRead() {
        this._availableForRead.setValue(this.totalCapacity);
        this._availableForWrite.setValue(0);
        this._pendingToFlush.setValue(0);
    }

    public final int tryReadAtLeast(int n) {
        int upd$iv;
        int cur$iv;
        AtomicInt $this$getAndUpdate$iv = this._availableForRead;
        boolean $i$f$getAndUpdate = false;
        do {
            int remaining = cur$iv = $this$getAndUpdate$iv.getValue();
            boolean bl = false;
            if (remaining >= n) continue;
            return 0;
        } while (!$this$getAndUpdate$iv.compareAndSet(cur$iv, upd$iv = 0));
        int available = cur$iv;
        return available;
    }

    public final boolean tryReadExact(int n) {
        int remaining;
        int upd$iv;
        int cur$iv;
        AtomicInt $this$update$iv = this._availableForRead;
        boolean $i$f$update = false;
        do {
            remaining = cur$iv = $this$update$iv.getValue();
            boolean bl = false;
            if (remaining >= n) continue;
            return false;
        } while (!$this$update$iv.compareAndSet(cur$iv, upd$iv = remaining - n));
        return true;
    }

    public final int tryReadAtMost(int n) {
        int delta;
        int remaining;
        int upd$iv;
        int cur$iv;
        AtomicInt $this$getAndUpdate$iv = this._availableForRead;
        boolean $i$f$getAndUpdate = false;
        do {
            remaining = cur$iv = $this$getAndUpdate$iv.getValue();
            boolean bl = false;
            delta = Math.min(n, remaining);
            if (delta != 0) continue;
            return 0;
        } while (!$this$getAndUpdate$iv.compareAndSet(cur$iv, upd$iv = remaining - delta));
        int available = cur$iv;
        return Math.min(n, available);
    }

    public final int tryWriteAtLeast(int n) {
        int upd$iv;
        int cur$iv;
        AtomicInt $this$getAndUpdate$iv = this._availableForWrite;
        boolean $i$f$getAndUpdate = false;
        do {
            int remaining = cur$iv = $this$getAndUpdate$iv.getValue();
            boolean bl = false;
            if (remaining >= n) continue;
            return 0;
        } while (!$this$getAndUpdate$iv.compareAndSet(cur$iv, upd$iv = 0));
        int available = cur$iv;
        return available;
    }

    public final boolean tryWriteExact(int n) {
        int remaining;
        int upd$iv;
        int cur$iv;
        AtomicInt $this$update$iv = this._availableForWrite;
        boolean $i$f$update = false;
        do {
            remaining = cur$iv = $this$update$iv.getValue();
            boolean bl = false;
            if (remaining >= n) continue;
            return false;
        } while (!$this$update$iv.compareAndSet(cur$iv, upd$iv = remaining - n));
        return true;
    }

    public final int tryWriteAtMost(int n) {
        int delta;
        int remaining;
        int upd$iv;
        int cur$iv;
        AtomicInt $this$getAndUpdate$iv = this._availableForWrite;
        boolean $i$f$getAndUpdate = false;
        do {
            remaining = cur$iv = $this$getAndUpdate$iv.getValue();
            boolean bl = false;
            delta = Math.min(n, remaining);
            if (delta != 0) continue;
            return 0;
        } while (!$this$getAndUpdate$iv.compareAndSet(cur$iv, upd$iv = remaining - delta));
        int available = cur$iv;
        return Math.min(n, available);
    }

    public final void completeRead(int n) {
        int update;
        int upd$iv;
        int cur$iv;
        AtomicInt $this$update$iv = this._availableForWrite;
        boolean $i$f$update = false;
        do {
            int remaining = cur$iv = $this$update$iv.getValue();
            boolean bl = false;
            update = remaining + n;
            if (update <= this.totalCapacity) continue;
            this.completeReadOverflow(remaining, update, n);
            throw new KotlinNothingValueException();
        } while (!$this$update$iv.compareAndSet(cur$iv, upd$iv = update));
    }

    private final Void completeReadOverflow(int remaining, int update, int n) {
        throw new IllegalArgumentException("Completed read overflow: " + remaining + " + " + n + " = " + update + " > " + this.totalCapacity);
    }

    public final void completeWrite(int n) {
        int update;
        int upd$iv;
        int cur$iv;
        AtomicInt $this$update$iv = this._pendingToFlush;
        boolean $i$f$update = false;
        do {
            int pending = cur$iv = $this$update$iv.getValue();
            boolean bl = false;
            update = pending + n;
            if (update <= this.totalCapacity) continue;
            this.completeWriteOverflow(pending, n);
            throw new KotlinNothingValueException();
        } while (!$this$update$iv.compareAndSet(cur$iv, upd$iv = update));
    }

    private final Void completeWriteOverflow(int pending, int n) {
        throw new IllegalArgumentException("Complete write overflow: " + pending + " + " + n + " > " + this.totalCapacity);
    }

    public final boolean flush() {
        int pending = this._pendingToFlush.getAndSet(0);
        if (pending == 0) {
        } else {
            return this._availableForRead.addAndGet(pending) > 0;
        }
        return this._availableForRead.getValue() > 0;
    }

    public final boolean tryLockForRelease() {
        int upd$iv;
        int cur$iv;
        AtomicInt $this$update$iv = this._availableForWrite;
        boolean $i$f$update = false;
        do {
            int remaining = cur$iv = $this$update$iv.getValue();
            boolean bl = false;
            RingBufferCapacity this_$iv = this;
            boolean $i$f$getPendingToFlush = false;
            if (this_$iv._pendingToFlush.getValue() <= 0) {
                this_$iv = this;
                boolean $i$f$getAvailableForRead = false;
                if (this_$iv._availableForRead.getValue() <= 0 && remaining == this.totalCapacity) continue;
            }
            return false;
        } while (!$this$update$iv.compareAndSet(cur$iv, upd$iv = 0));
        return true;
    }

    public final void forceLockForRelease() {
        this._availableForWrite.getAndSet(0);
    }

    public final boolean isEmpty() {
        return this._availableForWrite.getValue() == this.totalCapacity;
    }

    public final boolean isFull() {
        return this._availableForWrite.getValue() == 0;
    }

    @NotNull
    public String toString() {
        RingBufferCapacity this_$iv = this;
        boolean $i$f$getAvailableForRead = false;
        StringBuilder stringBuilder = new StringBuilder().append("RingBufferCapacity[read: ").append(this_$iv._availableForRead.getValue()).append(", write: ");
        this_$iv = this;
        boolean $i$f$getAvailableForWrite = false;
        StringBuilder stringBuilder2 = stringBuilder.append(this_$iv._availableForWrite.getValue()).append(", flush: ");
        this_$iv = this;
        boolean $i$f$getPendingToFlush = false;
        return stringBuilder2.append(this_$iv._pendingToFlush.getValue()).append(", capacity: ").append(this.totalCapacity).append(']').toString();
    }
}

