/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.utils.io.pool;

import io.ktor.utils.io.pool.ObjectPool;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.atomicfu.AtomicBoolean;
import kotlinx.atomicfu.AtomicFU;
import kotlinx.atomicfu.AtomicInt;
import kotlinx.atomicfu.AtomicRef;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u000b\u0010\u000f\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0010J\u0006\u0010\u0011\u001a\u00020\u0012J\u0015\u0010\u0013\u001a\u00020\u00122\u0006\u0010\r\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0014J\r\u0010\u0015\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0010J\u0013\u0010\u0016\u001a\u00020\u00122\u0006\u0010\r\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/ktor/utils/io/pool/SingleInstancePool;", "T", "", "Lio/ktor/utils/io/pool/ObjectPool;", "()V", "borrowed", "Lkotlinx/atomicfu/AtomicInt;", "capacity", "", "getCapacity", "()I", "disposed", "Lkotlinx/atomicfu/AtomicBoolean;", "instance", "Lkotlinx/atomicfu/AtomicRef;", "borrow", "()Ljava/lang/Object;", "dispose", "", "disposeInstance", "(Ljava/lang/Object;)V", "produceInstance", "recycle", "ktor-io"})
public abstract class SingleInstancePool<T>
implements ObjectPool<T> {
    @NotNull
    private final AtomicInt borrowed = AtomicFU.atomic((int)0);
    @NotNull
    private final AtomicBoolean disposed = AtomicFU.atomic((boolean)false);
    @NotNull
    private final AtomicRef<T> instance = AtomicFU.atomic(null);

    @NotNull
    protected abstract T produceInstance();

    protected abstract void disposeInstance(@NotNull T var1);

    @Override
    public final int getCapacity() {
        return 1;
    }

    @Override
    @NotNull
    public final T borrow() {
        int upd$iv;
        int cur$iv;
        AtomicInt $this$update$iv = this.borrowed;
        boolean $i$f$update = false;
        do {
            int it = cur$iv = $this$update$iv.getValue();
            boolean bl = false;
            if (it == 0) continue;
            throw new IllegalStateException("Instance is already consumed");
        } while (!$this$update$iv.compareAndSet(cur$iv, upd$iv = 1));
        T instance = this.produceInstance();
        this.instance.setValue(instance);
        return instance;
    }

    @Override
    public final void recycle(@NotNull T instance) {
        Intrinsics.checkNotNullParameter(instance, (String)"instance");
        if (this.instance.getValue() != instance) {
            if (this.instance.getValue() == null && this.borrowed.getValue() != 0) {
                throw new IllegalStateException("Already recycled or an irrelevant instance tried to be recycled");
            }
            throw new IllegalStateException("Unable to recycle irrelevant instance");
        }
        this.instance.setValue(null);
        if (!this.disposed.compareAndSet(false, true)) {
            throw new IllegalStateException("An instance is already disposed");
        }
        this.disposeInstance(instance);
    }

    @Override
    public final void dispose() {
        if (this.disposed.compareAndSet(false, true)) {
            Object object = this.instance.getValue();
            if (object == null) {
                return;
            }
            Object value = object;
            this.instance.setValue(null);
            this.disposeInstance(value);
        }
    }

    @Override
    public void close() {
        ObjectPool.DefaultImpls.close(this);
    }
}

