/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.utils.io.charsets;

import io.ktor.utils.io.bits.Memory;
import io.ktor.utils.io.charsets.MalformedInputException;
import io.ktor.utils.io.core.Buffer;
import io.ktor.utils.io.core.ByteReadPacket;
import io.ktor.utils.io.core.Input;
import io.ktor.utils.io.core.Output;
import io.ktor.utils.io.core.internal.ChunkBuffer;
import io.ktor.utils.io.core.internal.UTF8Kt;
import io.ktor.utils.io.core.internal.UnsafeKt;
import io.ktor.utils.io.internal.jvm.ErrorsKt;
import java.io.EOFException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u008c\u0001\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a*\u0010\u0015\u001a\u00020\u0001*\u00060\nj\u0002`\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\n\u0010\u0018\u001a\u00060\u0019j\u0002`\u001a2\u0006\u0010\u001b\u001a\u00020\u0001\u001a6\u0010\u001c\u001a\u00020\u0001*\u00060\nj\u0002`\u000b2\u0006\u0010\u0016\u001a\u00020\u001d2\n\u0010\u001e\u001a\u00060\u0019j\u0002`\u001a2\u0006\u0010\u001f\u001a\u00020 2\b\b\u0002\u0010\u001b\u001a\u00020\u0001H\u0000\u001a\u001e\u0010!\u001a\u00020\u0012*\u00060\nj\u0002`\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u0001\u001a \u0010#\u001a\u00020\u0012*\u00060\nj\u0002`\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u0001H\u0002\u001a \u0010$\u001a\u00020\u0012*\u00060\nj\u0002`\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u0001H\u0002\u001a\u0018\u0010%\u001a\u00020 *\u00060\u000ej\u0002`\u000f2\u0006\u0010\u0018\u001a\u00020\u001dH\u0000\u001a0\u0010&\u001a\u00020\u0001*\u00060\u000ej\u0002`\u000f2\u0006\u0010\u0016\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00012\u0006\u0010)\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u001dH\u0000\u001a*\u0010*\u001a\u00020+*\u00060\u000ej\u0002`\u000f2\u0006\u0010\u0016\u001a\u00020'2\b\b\u0002\u0010(\u001a\u00020\u00012\b\b\u0002\u0010)\u001a\u00020\u0001\u001a(\u0010,\u001a\u00020+*\u00060\u000ej\u0002`\u000f2\u0006\u0010\u0016\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00012\u0006\u0010)\u001a\u00020\u0001H\u0002\u001a\u001e\u0010-\u001a\u00020.*\u00060\u000ej\u0002`\u000f2\u0006\u0010\u0016\u001a\u00020/2\u0006\u0010\u0018\u001a\u000200\u001a\f\u00101\u001a\u00020.*\u000202H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001d\u0010\u0007\u001a\u00060\bj\u0002`\t*\u00060\nj\u0002`\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\"\u001d\u0010\u0007\u001a\u00060\bj\u0002`\t*\u00060\u000ej\u0002`\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0010\"\u0019\u0010\u0011\u001a\u00020\u0012*\u00060\bj\u0002`\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014*\n\u00103\"\u00020\b2\u00020\b*\n\u00104\"\u00020\n2\u00020\n*\n\u00105\"\u00020\u000e2\u00020\u000e*\n\u00106\"\u0002072\u000207\u00a8\u00068"}, d2={"DECODE_CHAR_BUFFER_SIZE", "", "EmptyByteBuffer", "Ljava/nio/ByteBuffer;", "EmptyCharBuffer", "Ljava/nio/CharBuffer;", "kotlin.jvm.PlatformType", "charset", "Ljava/nio/charset/Charset;", "Lio/ktor/utils/io/charsets/Charset;", "Ljava/nio/charset/CharsetDecoder;", "Lio/ktor/utils/io/charsets/CharsetDecoder;", "getCharset", "(Ljava/nio/charset/CharsetDecoder;)Ljava/nio/charset/Charset;", "Ljava/nio/charset/CharsetEncoder;", "Lio/ktor/utils/io/charsets/CharsetEncoder;", "(Ljava/nio/charset/CharsetEncoder;)Ljava/nio/charset/Charset;", "name", "", "getName", "(Ljava/nio/charset/Charset;)Ljava/lang/String;", "decode", "input", "Lio/ktor/utils/io/core/Input;", "dst", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "max", "decodeBuffer", "Lio/ktor/utils/io/core/Buffer;", "out", "lastBuffer", "", "decodeExactBytes", "inputLength", "decodeImplByteBuffer", "decodeImplSlow", "encodeComplete", "encodeImpl", "", "fromIndex", "toIndex", "encodeToByteArray", "", "encodeToByteArraySlow", "encodeUTF8", "", "Lio/ktor/utils/io/core/ByteReadPacket;", "Lio/ktor/utils/io/core/Output;", "throwExceptionWrapped", "Ljava/nio/charset/CoderResult;", "Charset", "CharsetDecoder", "CharsetEncoder", "Charsets", "Lkotlin/text/Charsets;", "ktor-io"})
@SourceDebugExtension(value={"SMAP\nCharsetJVM.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CharsetJVM.kt\nio/ktor/utils/io/charsets/CharsetJVMKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 BufferUtilsJvm.kt\nio/ktor/utils/io/core/BufferUtilsJvmKt\n+ 4 Buffer.kt\nio/ktor/utils/io/core/BufferKt\n+ 5 Buffer.kt\nio/ktor/utils/io/core/Buffer\n+ 6 UTF8.kt\nio/ktor/utils/io/core/internal/UTF8Kt\n+ 7 Memory.kt\nio/ktor/utils/io/bits/MemoryKt\n+ 8 MemoryJvm.kt\nio/ktor/utils/io/bits/Memory\n+ 9 Output.kt\nio/ktor/utils/io/core/OutputKt\n+ 10 Input.kt\nio/ktor/utils/io/core/InputKt\n+ 11 Input.kt\nio/ktor/utils/io/core/Input\n+ 12 StringsJVM.kt\nio/ktor/utils/io/core/StringsJVMKt\n*L\n1#1,348:1\n1#2:349\n1#2:363\n1#2:370\n1#2:476\n1#2:507\n1#2:537\n1#2:554\n1#2:583\n1#2:641\n104#3,5:350\n109#3,3:360\n113#3:364\n41#3:367\n42#3:369\n43#3,7:371\n104#3,5:463\n109#3,3:473\n113#3:477\n104#3,5:494\n109#3,3:504\n113#3:508\n51#3,6:518\n104#3,5:524\n109#3,3:534\n113#3:538\n88#3,5:541\n93#3,3:551\n97#3:555\n88#3,5:570\n93#3,3:580\n97#3:584\n88#3,5:628\n93#3,3:638\n97#3:642\n382#4,5:355\n387#4,2:365\n365#4,5:383\n370#4,2:453\n382#4,5:468\n387#4,2:478\n382#4,5:499\n387#4,2:509\n382#4,5:529\n387#4,2:539\n365#4,5:546\n370#4,2:556\n365#4,5:575\n370#4,2:585\n365#4,5:633\n370#4,2:643\n71#5:368\n66#5:566\n56#5:598\n66#5:624\n56#5:656\n121#6,5:378\n126#6,2:388\n128#6,61:392\n191#6:455\n81#7:390\n26#8:391\n491#9,7:456\n498#9,7:480\n491#9,7:487\n498#9,7:511\n845#10,8:558\n855#10,3:567\n859#10,11:587\n870#10,15:599\n845#10,8:616\n855#10,3:625\n859#10,11:645\n870#10,15:657\n74#11:614\n11#12:615\n*S KotlinDebug\n*F\n+ 1 CharsetJVM.kt\nio/ktor/utils/io/charsets/CharsetJVMKt\n*L\n47#1:363\n65#1:370\n93#1:476\n115#1:507\n134#1:537\n152#1:554\n193#1:583\n282#1:641\n47#1:350,5\n47#1:360,3\n47#1:364\n65#1:367\n65#1:369\n65#1:371,7\n93#1:463,5\n93#1:473,3\n93#1:477\n115#1:494,5\n115#1:504,3\n115#1:508\n65#1:518,6\n134#1:524,5\n134#1:534,3\n134#1:538\n152#1:541,5\n152#1:551,3\n152#1:555\n193#1:570,5\n193#1:580,3\n193#1:584\n282#1:628,5\n282#1:638,3\n282#1:642\n47#1:355,5\n47#1:365,2\n77#1:383,5\n77#1:453,2\n93#1:468,5\n93#1:478,2\n115#1:499,5\n115#1:509,2\n134#1:529,5\n134#1:539,2\n152#1:546,5\n152#1:556,2\n193#1:575,5\n193#1:585,2\n282#1:633,5\n282#1:643,2\n65#1:368\n189#1:566\n189#1:598\n279#1:624\n279#1:656\n77#1:378,5\n77#1:388,2\n77#1:392,61\n77#1:455\n77#1:390\n77#1:391\n92#1:456,7\n92#1:480,7\n114#1:487,7\n114#1:511,7\n189#1:558,8\n189#1:567,3\n189#1:587,11\n189#1:599,15\n279#1:616,8\n279#1:625,3\n279#1:645,11\n279#1:657,15\n235#1:614\n243#1:615\n*E\n"})
public final class CharsetJVMKt {
    private static final int DECODE_CHAR_BUFFER_SIZE = 8192;
    private static final CharBuffer EmptyCharBuffer = CharBuffer.allocate(0);
    @NotNull
    private static final ByteBuffer EmptyByteBuffer;

    @NotNull
    public static final String getName(@NotNull Charset $this$name) {
        Intrinsics.checkNotNullParameter((Object)$this$name, (String)"<this>");
        String string = $this$name.name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name()");
        return string;
    }

    @NotNull
    public static final Charset getCharset(@NotNull CharsetEncoder $this$charset) {
        Intrinsics.checkNotNullParameter((Object)$this$charset, (String)"<this>");
        Charset charset = $this$charset.charset();
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"charset()");
        return charset;
    }

    @NotNull
    public static final byte[] encodeToByteArray(@NotNull CharsetEncoder $this$encodeToByteArray, @NotNull CharSequence input, int fromIndex, int toIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$encodeToByteArray, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (input instanceof String) {
            if (fromIndex == 0 && toIndex == input.length()) {
                byte[] byArray = ((String)input).getBytes($this$encodeToByteArray.charset());
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"input as java.lang.String).getBytes(charset())");
                return byArray;
            }
            String string = ((String)input).substring(fromIndex, toIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            Intrinsics.checkNotNull((Object)string, (String)"null cannot be cast to non-null type java.lang.String");
            byte[] byArray = string.getBytes($this$encodeToByteArray.charset());
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"input.substring(fromInde\u2026ring).getBytes(charset())");
            return byArray;
        }
        return CharsetJVMKt.encodeToByteArraySlow($this$encodeToByteArray, input, fromIndex, toIndex);
    }

    public static /* synthetic */ byte[] encodeToByteArray$default(CharsetEncoder charsetEncoder, CharSequence charSequence, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = charSequence.length();
        }
        return CharsetJVMKt.encodeToByteArray(charsetEncoder, charSequence, n, n2);
    }

    private static final byte[] encodeToByteArraySlow(CharsetEncoder $this$encodeToByteArraySlow, CharSequence input, int fromIndex, int toIndex) {
        byte[] existingArray;
        Object object;
        byte[] it;
        byte[] byArray;
        ByteBuffer result = $this$encodeToByteArraySlow.encode(CharBuffer.wrap(input, fromIndex, toIndex));
        if (result.hasArray() && result.arrayOffset() == 0) {
            it = byArray = result.array();
            boolean bl = false;
            object = it.length == result.remaining() ? byArray : null;
        } else {
            object = null;
        }
        byte[] byArray2 = existingArray = object;
        if (existingArray == null) {
            it = byArray = new byte[result.remaining()];
            boolean bl = false;
            result.get(it);
            byArray2 = byArray;
        }
        return byArray2;
    }

    /*
     * WARNING - void declaration
     */
    public static final int encodeImpl(@NotNull CharsetEncoder $this$encodeImpl, @NotNull CharSequence input, int fromIndex, int toIndex, @NotNull Buffer dst) {
        void endExclusive$iv;
        void start$iv;
        ByteBuffer nioBuffer$iv;
        void $this$writeDirect$iv;
        Intrinsics.checkNotNullParameter((Object)$this$encodeImpl, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        CharBuffer cb = CharBuffer.wrap(input, fromIndex, toIndex);
        int before = cb.remaining();
        Buffer buffer = dst;
        boolean size$iv = false;
        boolean $i$f$writeDirect = false;
        void $this$write$iv$iv = $this$writeDirect$iv;
        boolean $i$f$write = false;
        int n = $this$write$iv$iv.getLimit();
        int n2 = $this$write$iv$iv.getWritePosition();
        ByteBuffer memory$iv = $this$write$iv$iv.getMemory-SK3TCg8();
        boolean bl = false;
        ByteBuffer bb = nioBuffer$iv = Memory.slice-87lwejk(memory$iv, (int)start$iv, (int)(endExclusive$iv - start$iv));
        boolean bl2 = false;
        CoderResult result = $this$encodeImpl.encode(cb, bb, false);
        if (result.isMalformed() || result.isUnmappable()) {
            Intrinsics.checkNotNullExpressionValue((Object)result, (String)"result");
            CharsetJVMKt.throwExceptionWrapped(result);
        }
        if (!(nioBuffer$iv.limit() == endExclusive$iv - start$iv)) {
            boolean bl3 = false;
            String string = "Buffer's limit change is not allowed";
            throw new IllegalStateException(string.toString());
        }
        int rc$iv$iv = nioBuffer$iv.position();
        $this$write$iv$iv.commitWritten(rc$iv$iv);
        return before - cb.remaining();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final void encodeUTF8(@NotNull CharsetEncoder $this$encodeUTF8, @NotNull ByteReadPacket input, @NotNull Output dst) {
        Intrinsics.checkNotNullParameter((Object)$this$encodeUTF8, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        if (CharsetJVMKt.getCharset($this$encodeUTF8) == Charsets.UTF_8) {
            dst.writePacket(input);
            return;
        }
        ChunkBuffer tmp = ChunkBuffer.Companion.getPool().borrow();
        int readSize = 0;
        readSize = 1;
        try {
            void $this$writeDirect$iv;
            ChunkBuffer chunkBuffer = tmp;
            int size$iv = 0;
            boolean $i$f$writeDirect = false;
            Buffer this_$iv$iv = (Buffer)$this$writeDirect$iv;
            boolean $i$f$getWriteRemaining = false;
            int rem$iv = this_$iv$iv.getLimit() - this_$iv$iv.getWritePosition();
            if (!(size$iv <= rem$iv)) {
                boolean $i$a$-require-BufferUtilsJvmKt$writeDirect$1$iv22 = false;
                String $i$a$-require-BufferUtilsJvmKt$writeDirect$1$iv22 = "size " + size$iv + " is greater than buffer's remaining capacity " + rem$iv;
                throw new IllegalArgumentException($i$a$-require-BufferUtilsJvmKt$writeDirect$1$iv22.toString());
            }
            ByteBuffer byteBuffer = $this$writeDirect$iv.getMemory-SK3TCg8().duplicate();
            Intrinsics.checkNotNull((Object)byteBuffer);
            ByteBuffer buffer$iv = byteBuffer;
            int writePosition$iv = $this$writeDirect$iv.getWritePosition();
            int limit$iv = $this$writeDirect$iv.getLimit();
            buffer$iv.limit(limit$iv);
            buffer$iv.position(writePosition$iv);
            ByteBuffer tmpBb = buffer$iv;
            boolean bl = false;
            CharBuffer cb = tmpBb.asCharBuffer();
            while (input.getRemaining() > 0L) {
                int i$iv;
                int n;
                int n2;
                ChunkBuffer chunk;
                block41: {
                    void start$iv2;
                    void endExclusive$iv;
                    cb.clear();
                    chunk = input.prepareReadHead$ktor_io(readSize);
                    if (chunk == null) {
                        break;
                    }
                    Buffer $this$decodeUTF8$iv = chunk;
                    boolean $i$f$decodeUTF8 = false;
                    int byteCount$iv = 0;
                    int value$iv = 0;
                    int lastByteCount$iv = 0;
                    Buffer $this$read$iv$iv = $this$decodeUTF8$iv;
                    boolean $i$f$read = false;
                    int n3 = $this$read$iv$iv.getWritePosition();
                    int n4 = $this$read$iv$iv.getReadPosition();
                    ByteBuffer memory$iv = $this$read$iv$iv.getMemory-SK3TCg8();
                    boolean bl2 = false;
                    for (void index$iv = start$iv2; index$iv < endExclusive$iv; ++index$iv) {
                        block46: {
                            block47: {
                                boolean bl3;
                                boolean bl4;
                                boolean bl5;
                                char ch;
                                block45: {
                                    boolean bl6;
                                    ByteBuffer $this$get_u2deY85DW0$iv$iv = memory$iv;
                                    boolean bl7 = false;
                                    n2 = 0;
                                    int v$iv = $this$get_u2deY85DW0$iv$iv.get((int)index$iv) & 0xFF;
                                    if ((v$iv & 0x80) == 0) {
                                        boolean bl8;
                                        if (byteCount$iv != 0) {
                                            UTF8Kt.malformedByteCount(byteCount$iv);
                                            throw new KotlinNothingValueException();
                                        }
                                        ch = (char)v$iv;
                                        bl5 = false;
                                        if (cb.hasRemaining()) {
                                            cb.put(ch);
                                            bl8 = true;
                                        } else {
                                            bl8 = false;
                                        }
                                        if (bl8) continue;
                                        $this$decodeUTF8$iv.discardExact((int)(index$iv - start$iv2));
                                        n = -1;
                                        break block41;
                                    }
                                    if (byteCount$iv == 0) {
                                        int mask$iv = 128;
                                        value$iv = v$iv;
                                        for (i$iv = 1; i$iv < 7 && (value$iv & mask$iv) != 0; ++i$iv) {
                                            value$iv &= ~mask$iv;
                                            mask$iv >>= 1;
                                            ++byteCount$iv;
                                        }
                                        lastByteCount$iv = byteCount$iv;
                                        byteCount$iv += -1;
                                        if (lastByteCount$iv <= endExclusive$iv - index$iv) continue;
                                        $this$decodeUTF8$iv.discardExact((int)(index$iv - start$iv2));
                                        n = lastByteCount$iv;
                                        break block41;
                                    }
                                    value$iv = value$iv << 6 | v$iv & 0x7F;
                                    if ((byteCount$iv += -1) != 0) continue;
                                    if (!UTF8Kt.isBmpCodePoint(value$iv)) break block45;
                                    ch = (char)value$iv;
                                    bl5 = false;
                                    if (cb.hasRemaining()) {
                                        cb.put(ch);
                                        bl6 = true;
                                    } else {
                                        bl6 = false;
                                    }
                                    if (!bl6) {
                                        $this$decodeUTF8$iv.discardExact((int)(index$iv - start$iv2 - lastByteCount$iv + true));
                                        n = -1;
                                        break block41;
                                    }
                                    break block46;
                                }
                                if (!UTF8Kt.isValidCodePoint(value$iv)) {
                                    UTF8Kt.malformedCodePoint(value$iv);
                                    throw new KotlinNothingValueException();
                                }
                                ch = (char)UTF8Kt.highSurrogate(value$iv);
                                bl5 = false;
                                if (cb.hasRemaining()) {
                                    cb.put(ch);
                                    bl4 = true;
                                } else {
                                    bl4 = false;
                                }
                                if (!bl4) break block47;
                                ch = (char)UTF8Kt.lowSurrogate(value$iv);
                                bl5 = false;
                                if (cb.hasRemaining()) {
                                    cb.put(ch);
                                    bl3 = true;
                                } else {
                                    bl3 = false;
                                }
                                if (bl3) break block46;
                            }
                            $this$decodeUTF8$iv.discardExact((int)(index$iv - start$iv2 - lastByteCount$iv + true));
                            n = -1;
                            break block41;
                        }
                        value$iv = 0;
                    }
                    void rc$iv$iv = endExclusive$iv - start$iv2;
                    $this$read$iv$iv.discardExact((int)rc$iv$iv);
                    n = 0;
                }
                int rc = n;
                input.setHeadPosition(chunk.getReadPosition());
                cb.flip();
                int writeSize = 0;
                writeSize = 1;
                if (cb.hasRemaining()) {
                    Output $this$writeWhileSize_u24default$iv = dst;
                    int initialSize$iv = 1;
                    boolean $i$f$writeWhileSize = false;
                    ChunkBuffer tail$iv = UnsafeKt.prepareWriteHead($this$writeWhileSize_u24default$iv, initialSize$iv, null);
                    try {
                        int size$iv2 = 0;
                        while (true) {
                            void endExclusive$iv;
                            void start$iv;
                            ByteBuffer nioBuffer$iv;
                            void $this$writeDirect$iv2;
                            Buffer view = tail$iv;
                            boolean bl9 = false;
                            Buffer start$iv2 = view;
                            int size$iv3 = writeSize;
                            boolean $i$f$writeDirect2 = false;
                            void $this$write$iv$iv2 = $this$writeDirect$iv2;
                            boolean $i$f$write2 = false;
                            i$iv = $this$write$iv$iv2.getLimit();
                            n2 = $this$write$iv$iv2.getWritePosition();
                            ByteBuffer memory$iv = $this$write$iv$iv2.getMemory-SK3TCg8();
                            boolean bl10 = false;
                            ByteBuffer to = nioBuffer$iv = Memory.slice-87lwejk(memory$iv, (int)start$iv, (int)(endExclusive$iv - start$iv));
                            boolean bl11 = false;
                            CoderResult cr = $this$encodeUTF8.encode(cb, to, false);
                            if (cr.isUnmappable() || cr.isMalformed()) {
                                Intrinsics.checkNotNullExpressionValue((Object)cr, (String)"cr");
                                CharsetJVMKt.throwExceptionWrapped(cr);
                            }
                            writeSize = cr.isOverflow() && to.hasRemaining() ? ++writeSize : 1;
                            if (!(nioBuffer$iv.limit() == endExclusive$iv - start$iv)) {
                                boolean bl12 = false;
                                String string = "Buffer's limit change is not allowed";
                                throw new IllegalStateException(string.toString());
                            }
                            int rc$iv$iv = nioBuffer$iv.position();
                            $this$write$iv$iv2.commitWritten(rc$iv$iv);
                            int n5 = size$iv2 = cb.hasRemaining() ? writeSize : 0;
                            if (size$iv2 > 0) {
                                tail$iv = UnsafeKt.prepareWriteHead($this$writeWhileSize_u24default$iv, size$iv2, tail$iv);
                                continue;
                            }
                            break;
                        }
                    }
                    finally {
                        $this$writeWhileSize_u24default$iv.afterHeadWrite();
                    }
                }
                if (rc <= 0) continue;
                readSize = rc;
                break;
            }
            cb.clear();
            cb.flip();
            int completeSize = 0;
            completeSize = 1;
            Output $this$writeWhileSize_u24default$iv = dst;
            int initialSize$iv = 1;
            boolean $i$f$writeWhileSize = false;
            ChunkBuffer tail$iv = UnsafeKt.prepareWriteHead($this$writeWhileSize_u24default$iv, initialSize$iv, null);
            try {
                int size$iv4 = 0;
                while (true) {
                    void endExclusive$iv;
                    void start$iv;
                    ByteBuffer nioBuffer$iv;
                    void $this$writeDirect$iv3;
                    Buffer chunk = tail$iv;
                    boolean bl13 = false;
                    Buffer view = chunk;
                    int size$iv5 = completeSize;
                    boolean $i$f$writeDirect3 = false;
                    void $this$write$iv$iv = $this$writeDirect$iv3;
                    boolean $i$f$write = false;
                    int $this$write$iv$iv2 = $this$write$iv$iv.getLimit();
                    int $i$f$write2 = $this$write$iv$iv.getWritePosition();
                    ByteBuffer memory$iv = $this$write$iv$iv.getMemory-SK3TCg8();
                    boolean bl14 = false;
                    ByteBuffer to = nioBuffer$iv = Memory.slice-87lwejk(memory$iv, (int)start$iv, (int)(endExclusive$iv - start$iv));
                    boolean bl15 = false;
                    CoderResult cr = $this$encodeUTF8.encode(cb, to, true);
                    if (cr.isMalformed() || cr.isUnmappable()) {
                        Intrinsics.checkNotNullExpressionValue((Object)cr, (String)"cr");
                        CharsetJVMKt.throwExceptionWrapped(cr);
                    }
                    completeSize = cr.isOverflow() ? ++completeSize : 0;
                    if (!(nioBuffer$iv.limit() == endExclusive$iv - start$iv)) {
                        boolean bl16 = false;
                        String string = "Buffer's limit change is not allowed";
                        throw new IllegalStateException(string.toString());
                    }
                    int rc$iv$iv = nioBuffer$iv.position();
                    $this$write$iv$iv.commitWritten(rc$iv$iv);
                    size$iv4 = completeSize;
                    if (size$iv4 > 0) {
                        tail$iv = UnsafeKt.prepareWriteHead($this$writeWhileSize_u24default$iv, size$iv4, tail$iv);
                        continue;
                    }
                    break;
                }
            }
            finally {
                $this$writeWhileSize_u24default$iv.afterHeadWrite();
            }
            int delta$iv = buffer$iv.position() - writePosition$iv;
            if (delta$iv < 0 || delta$iv > rem$iv) {
                ErrorsKt.wrongBufferPositionChangeError(delta$iv, size$iv);
                throw new KotlinNothingValueException();
            }
            $this$writeDirect$iv.commitWritten(delta$iv);
        }
        finally {
            tmp.release(ChunkBuffer.Companion.getPool());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean encodeComplete(@NotNull CharsetEncoder $this$encodeComplete, @NotNull Buffer dst) {
        void endExclusive$iv;
        void start$iv;
        ByteBuffer nioBuffer$iv;
        void $this$writeDirect$iv;
        Intrinsics.checkNotNullParameter((Object)$this$encodeComplete, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        boolean completed = false;
        Buffer buffer = dst;
        boolean size$iv = false;
        boolean $i$f$writeDirect = false;
        void $this$write$iv$iv = $this$writeDirect$iv;
        boolean $i$f$write = false;
        int n = $this$write$iv$iv.getLimit();
        int n2 = $this$write$iv$iv.getWritePosition();
        ByteBuffer memory$iv = $this$write$iv$iv.getMemory-SK3TCg8();
        boolean bl = false;
        ByteBuffer bb = nioBuffer$iv = Memory.slice-87lwejk(memory$iv, (int)start$iv, (int)(endExclusive$iv - start$iv));
        boolean bl2 = false;
        CoderResult result = $this$encodeComplete.encode(EmptyCharBuffer, bb, true);
        if (result.isMalformed() || result.isUnmappable()) {
            Intrinsics.checkNotNullExpressionValue((Object)result, (String)"result");
            CharsetJVMKt.throwExceptionWrapped(result);
        }
        if (result.isUnderflow()) {
            completed = true;
        }
        if (!(nioBuffer$iv.limit() == endExclusive$iv - start$iv)) {
            boolean bl3 = false;
            String string = "Buffer's limit change is not allowed";
            throw new IllegalStateException(string.toString());
        }
        int rc$iv$iv = nioBuffer$iv.position();
        $this$write$iv$iv.commitWritten(rc$iv$iv);
        return completed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final int decodeBuffer(@NotNull CharsetDecoder $this$decodeBuffer, @NotNull Buffer input, @NotNull Appendable out2, boolean lastBuffer, int max) {
        int charactersCopied;
        void endExclusive$iv;
        void start$iv;
        ByteBuffer nioBuffer$iv;
        Intrinsics.checkNotNullParameter((Object)$this$decodeBuffer, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)out2, (String)"out");
        Buffer $this$readDirect$iv = input;
        boolean $i$f$readDirect = false;
        Buffer $this$read$iv$iv = $this$readDirect$iv;
        boolean $i$f$read = false;
        int n = $this$read$iv$iv.getWritePosition();
        int n2 = $this$read$iv$iv.getReadPosition();
        ByteBuffer memory$iv = $this$read$iv$iv.getMemory-SK3TCg8();
        boolean bl = false;
        ByteBuffer bb = nioBuffer$iv = Memory.slice-87lwejk(memory$iv, (int)start$iv, (int)(endExclusive$iv - start$iv));
        boolean bl2 = false;
        ChunkBuffer tmpBuffer = ChunkBuffer.Companion.getPool().borrow();
        CharBuffer cb = tmpBuffer.getMemory-SK3TCg8().asCharBuffer();
        try {
            int partSize;
            for (charactersCopied = 0; bb.hasRemaining() && charactersCopied < max; charactersCopied += partSize) {
                partSize = Math.min(cb.capacity(), max - charactersCopied);
                cb.clear();
                cb.limit(partSize);
                CoderResult result = $this$decodeBuffer.decode(bb, cb, lastBuffer);
                if (!result.isMalformed() && !result.isUnmappable()) continue;
                Intrinsics.checkNotNullExpressionValue((Object)result, (String)"result");
                CharsetJVMKt.throwExceptionWrapped(result);
            }
        }
        finally {
            tmpBuffer.release(ChunkBuffer.Companion.getPool());
        }
        if (!(nioBuffer$iv.limit() == endExclusive$iv - start$iv)) {
            boolean bl3 = false;
            String string = "Buffer's limit change is not allowed";
            throw new IllegalStateException(string.toString());
        }
        int rc$iv$iv = nioBuffer$iv.position();
        $this$read$iv$iv.discardExact(rc$iv$iv);
        return charactersCopied;
    }

    public static /* synthetic */ int decodeBuffer$default(CharsetDecoder charsetDecoder, Buffer buffer, Appendable appendable, boolean bl, int n, int n2, Object object) {
        if ((n2 & 8) != 0) {
            n = Integer.MAX_VALUE;
        }
        return CharsetJVMKt.decodeBuffer(charsetDecoder, buffer, appendable, bl, n);
    }

    @NotNull
    public static final Charset getCharset(@NotNull CharsetDecoder $this$charset) {
        Intrinsics.checkNotNullParameter((Object)$this$charset, (String)"<this>");
        Charset charset = $this$charset.charset();
        Intrinsics.checkNotNull((Object)charset);
        return charset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static final int decode(@NotNull CharsetDecoder $this$decode, @NotNull Input input, @NotNull Appendable dst, int max) {
        block20: {
            Intrinsics.checkNotNullParameter((Object)$this$decode, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
            copied = 0;
            cb = CharBuffer.allocate(8192);
            readSize = 0;
            readSize = 1;
            $this$takeWhileSize_u24default$iv = input;
            initialSize$iv = 1;
            $i$f$takeWhileSize = false;
            release$iv = true;
            v0 = UnsafeKt.prepareReadFirstHead($this$takeWhileSize_u24default$iv, initialSize$iv);
            if (v0 == null) break block20;
            current$iv = v0;
            size$iv = initialSize$iv;
            try {
                do {
                    block23: {
                        block22: {
                            this_$iv$iv = current$iv;
                            $i$f$getReadRemaining = false;
                            before$iv = this_$iv$iv.getWritePosition() - this_$iv$iv.getReadPosition();
                            after$iv = 0;
                            if (before$iv >= size$iv) {
                                try {
                                    buffer = current$iv;
                                    $i$a$-takeWhileSize$default-CharsetJVMKt$decode$1 = false;
                                    rem = max - copied;
                                    if (rem == 0) {
                                        v1 = 0;
                                    } else {
                                        $this$readDirect$iv = buffer;
                                        $i$f$readDirect = false;
                                        $this$read$iv$iv = $this$readDirect$iv;
                                        $i$f$read = false;
                                        var23_30 = $this$read$iv$iv.getWritePosition();
                                        var24_31 = $this$read$iv$iv.getReadPosition();
                                        memory$iv = $this$read$iv$iv.getMemory-SK3TCg8();
                                        $i$a$-read-BufferUtilsJvmKt$readDirect$2$iv = false;
                                        bb = nioBuffer$iv = Memory.slice-87lwejk(memory$iv, (int)start$iv, (int)(endExclusive$iv - start$iv));
                                        $i$a$-readDirect-CharsetJVMKt$decode$1$1 = false;
                                        cb.clear();
                                        if (rem < 8192) {
                                            cb.limit(rem);
                                        }
                                        rc = $this$decode.decode(bb, cb, false);
                                        cb.flip();
                                        copied += cb.remaining();
                                        dst.append(cb);
                                        if (rc.isMalformed() || rc.isUnmappable()) {
                                            Intrinsics.checkNotNullExpressionValue((Object)rc, (String)"rc");
                                            CharsetJVMKt.throwExceptionWrapped(rc);
                                        }
                                        readSize = rc.isUnderflow() && bb.hasRemaining() ? ++readSize : 1;
                                        if (!(nioBuffer$iv.limit() == endExclusive$iv - start$iv)) {
                                            $i$a$-check-BufferUtilsJvmKt$readDirect$2$1$iv = false;
                                            var31_45 = "Buffer's limit change is not allowed";
                                            throw new IllegalStateException(var31_45.toString());
                                        }
                                        rc$iv$iv = nioBuffer$iv.position();
                                        $this$read$iv$iv.discardExact(rc$iv$iv);
                                        v1 = readSize;
                                    }
                                    size$iv = v1;
                                }
                                finally {
                                    this_$iv$iv = current$iv;
                                    $i$f$getReadRemaining = false;
                                    after$iv = this_$iv$iv.getWritePosition() - this_$iv$iv.getReadPosition();
                                }
                            } else {
                                after$iv = before$iv;
                            }
                            release$iv = false;
                            if (after$iv != 0) break block22;
                            v2 = UnsafeKt.prepareReadNextHead($this$takeWhileSize_u24default$iv, current$iv);
                            break block23;
                        }
                        if (after$iv < size$iv) ** GOTO lbl-1000
                        this_$iv$iv = current$iv;
                        $i$f$getEndGap = false;
                        if (this_$iv$iv.getCapacity() - this_$iv$iv.getLimit() < 8) lbl-1000:
                        // 2 sources

                        {
                            UnsafeKt.completeReadHead($this$takeWhileSize_u24default$iv, current$iv);
                            v2 = UnsafeKt.prepareReadFirstHead($this$takeWhileSize_u24default$iv, size$iv);
                        } else {
                            v2 = current$iv;
                        }
                    }
                    if (v2 == null) {
                        break;
                    }
                    current$iv = next$iv = v2;
                    release$iv = true;
                } while (size$iv > 0);
            }
            finally {
                if (release$iv) {
                    UnsafeKt.completeReadHead($this$takeWhileSize_u24default$iv, current$iv);
                }
            }
        }
        do {
            cb.clear();
            rem = max - copied;
            if (rem == 0) break;
            if (rem < 8192) {
                cb.limit(rem);
            }
            cr = $this$decode.decode(CharsetJVMKt.EmptyByteBuffer, cb, true);
            cb.flip();
            copied += cb.remaining();
            dst.append(cb);
            if (!cr.isUnmappable() && !cr.isMalformed()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)cr, (String)"cr");
            CharsetJVMKt.throwExceptionWrapped(cr);
        } while (cr.isOverflow());
        return copied;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String decodeExactBytes(@NotNull CharsetDecoder $this$decodeExactBytes, @NotNull Input input, int inputLength) {
        Intrinsics.checkNotNullParameter((Object)$this$decodeExactBytes, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (inputLength == 0) {
            return "";
        }
        Input this_$iv = input;
        boolean $i$f$getHeadRemaining = false;
        if (this_$iv.getHeadEndExclusive() - this_$iv.getHeadPosition() >= inputLength) {
            if (input.getHeadMemory-SK3TCg8().hasArray()) {
                void charset$iv;
                void offset$iv;
                void bytes$iv;
                ByteBuffer bb = input.getHeadMemory-SK3TCg8();
                byte[] byArray = bb.array();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"bb.array()");
                byte[] byArray2 = byArray;
                int n = bb.arrayOffset() + bb.position() + input.getHead().getReadPosition();
                Charset charset = $this$decodeExactBytes.charset();
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"charset()");
                Charset charset2 = charset;
                boolean $i$f$String = false;
                String text = new String((byte[])bytes$iv, (int)offset$iv, inputLength, (Charset)charset$iv);
                input.discardExact(inputLength);
                return text;
            }
            return CharsetJVMKt.decodeImplByteBuffer($this$decodeExactBytes, input, inputLength);
        }
        return CharsetJVMKt.decodeImplSlow($this$decodeExactBytes, input, inputLength);
    }

    private static final String decodeImplByteBuffer(CharsetDecoder $this$decodeImplByteBuffer, Input input, int inputLength) {
        CharBuffer cb = CharBuffer.allocate(inputLength);
        ByteBuffer bb = Memory.slice-87lwejk(input.getHeadMemory-SK3TCg8(), input.getHead().getReadPosition(), inputLength);
        CoderResult rc = $this$decodeImplByteBuffer.decode(bb, cb, true);
        if (rc.isMalformed() || rc.isUnmappable()) {
            Intrinsics.checkNotNullExpressionValue((Object)rc, (String)"rc");
            CharsetJVMKt.throwExceptionWrapped(rc);
        }
        cb.flip();
        input.discardExact(bb.position());
        String string = cb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"cb.toString()");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static final String decodeImplSlow(CharsetDecoder $this$decodeImplSlow, Input input, int inputLength) {
        block21: {
            cb = CharBuffer.allocate(inputLength);
            remainingInputBytes = 0;
            remainingInputBytes = inputLength;
            lastChunk = false;
            readSize = 0;
            readSize = 1;
            $this$takeWhileSize_u24default$iv = input;
            initialSize$iv = 1;
            $i$f$takeWhileSize = false;
            release$iv = true;
            v0 = UnsafeKt.prepareReadFirstHead($this$takeWhileSize_u24default$iv, initialSize$iv);
            if (v0 == null) break block21;
            current$iv = v0;
            size$iv = initialSize$iv;
            try {
                do {
                    block23: {
                        block22: {
                            this_$iv$iv = current$iv;
                            $i$f$getReadRemaining = false;
                            before$iv = this_$iv$iv.getWritePosition() - this_$iv$iv.getReadPosition();
                            after$iv = 0;
                            if (before$iv >= size$iv) {
                                try {
                                    buffer = current$iv;
                                    $i$a$-takeWhileSize$default-CharsetJVMKt$decodeImplSlow$1 = false;
                                    if (!cb.hasRemaining() || remainingInputBytes == 0) {
                                        v1 = 0;
                                    } else {
                                        $this$readDirect$iv = buffer;
                                        $i$f$readDirect = false;
                                        $this$read$iv$iv = $this$readDirect$iv;
                                        $i$f$read = false;
                                        var22_27 = $this$read$iv$iv.getWritePosition();
                                        var23_28 = $this$read$iv$iv.getReadPosition();
                                        memory$iv = $this$read$iv$iv.getMemory-SK3TCg8();
                                        $i$a$-read-BufferUtilsJvmKt$readDirect$2$iv = false;
                                        bb = nioBuffer$iv = Memory.slice-87lwejk(memory$iv, (int)start$iv, (int)(endExclusive$iv - start$iv));
                                        $i$a$-readDirect-CharsetJVMKt$decodeImplSlow$1$1 = false;
                                        limitBefore = bb.limit();
                                        v2 = lastChunk = limitBefore - (positionBefore = bb.position()) >= remainingInputBytes;
                                        if (lastChunk) {
                                            bb.limit(positionBefore + remainingInputBytes);
                                        }
                                        if ((rc = $this$decodeImplSlow.decode(bb, cb, lastChunk)).isMalformed() || rc.isUnmappable()) {
                                            Intrinsics.checkNotNullExpressionValue((Object)rc, (String)"rc");
                                            CharsetJVMKt.throwExceptionWrapped(rc);
                                        }
                                        readSize = rc.isUnderflow() && bb.hasRemaining() ? ++readSize : 1;
                                        bb.limit(limitBefore);
                                        remainingInputBytes -= bb.position() - positionBefore;
                                        if (!(nioBuffer$iv.limit() == endExclusive$iv - start$iv)) {
                                            $i$a$-check-BufferUtilsJvmKt$readDirect$2$1$iv = false;
                                            var32_44 = "Buffer's limit change is not allowed";
                                            throw new IllegalStateException(var32_44.toString());
                                        }
                                        rc$iv$iv = nioBuffer$iv.position();
                                        $this$read$iv$iv.discardExact(rc$iv$iv);
                                        v1 = readSize;
                                    }
                                    size$iv = v1;
                                }
                                finally {
                                    this_$iv$iv = current$iv;
                                    $i$f$getReadRemaining = false;
                                    after$iv = this_$iv$iv.getWritePosition() - this_$iv$iv.getReadPosition();
                                }
                            } else {
                                after$iv = before$iv;
                            }
                            release$iv = false;
                            if (after$iv != 0) break block22;
                            v3 = UnsafeKt.prepareReadNextHead($this$takeWhileSize_u24default$iv, current$iv);
                            break block23;
                        }
                        if (after$iv < size$iv) ** GOTO lbl-1000
                        this_$iv$iv = current$iv;
                        $i$f$getEndGap = false;
                        if (this_$iv$iv.getCapacity() - this_$iv$iv.getLimit() < 8) lbl-1000:
                        // 2 sources

                        {
                            UnsafeKt.completeReadHead($this$takeWhileSize_u24default$iv, current$iv);
                            v3 = UnsafeKt.prepareReadFirstHead($this$takeWhileSize_u24default$iv, size$iv);
                        } else {
                            v3 = current$iv;
                        }
                    }
                    if (v3 == null) {
                        break;
                    }
                    current$iv = next$iv = v3;
                    release$iv = true;
                } while (size$iv > 0);
            }
            finally {
                if (release$iv) {
                    UnsafeKt.completeReadHead($this$takeWhileSize_u24default$iv, current$iv);
                }
            }
        }
        if (cb.hasRemaining() && !lastChunk && ((rc = $this$decodeImplSlow.decode(CharsetJVMKt.EmptyByteBuffer, cb, true)).isMalformed() || rc.isUnmappable())) {
            Intrinsics.checkNotNullExpressionValue((Object)rc, (String)"rc");
            CharsetJVMKt.throwExceptionWrapped(rc);
        }
        if (remainingInputBytes > 0) {
            throw new EOFException("Not enough bytes available: had only " + (inputLength - remainingInputBytes) + " instead of " + inputLength);
        }
        if (remainingInputBytes < 0) {
            throw new AssertionError((Object)"remainingInputBytes < 0");
        }
        cb.flip();
        v4 = cb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"cb.toString()");
        return v4;
    }

    private static final void throwExceptionWrapped(CoderResult $this$throwExceptionWrapped) {
        try {
            $this$throwExceptionWrapped.throwException();
        }
        catch (java.nio.charset.MalformedInputException original) {
            String string = original.getMessage();
            if (string == null) {
                string = "Failed to decode bytes";
            }
            throw new MalformedInputException(string);
        }
    }

    public static /* synthetic */ void Charset$annotations() {
    }

    static {
        ByteBuffer byteBuffer = ByteBuffer.allocate(0);
        Intrinsics.checkNotNull((Object)byteBuffer);
        EmptyByteBuffer = byteBuffer;
    }
}

