/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.utils.io.core;

import io.ktor.utils.io.core.ByteBuffersKt;
import io.ktor.utils.io.core.ByteReadPacket;
import io.ktor.utils.io.utils.AtomicKt;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00012\b\b\u0002\u0010\b\u001a\u00020\t\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003*\n\u0010\n\"\u00020\u000b2\u00020\u000b\u00a8\u0006\f"}, d2={"PACKET_MAX_COPY_SIZE", "", "getPACKET_MAX_COPY_SIZE", "()I", "readByteBuffer", "Ljava/nio/ByteBuffer;", "Lio/ktor/utils/io/core/ByteReadPacket;", "n", "direct", "", "EOFException", "Ljava/io/EOFException;", "ktor-io"})
@SourceDebugExtension(value={"SMAP\nPacketJVM.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PacketJVM.kt\nio/ktor/utils/io/core/PacketJVMKt\n+ 2 Buffers.kt\nio/ktor/utils/io/core/BuffersKt\n*L\n1#1,23:1\n98#2,2:24\n*S KotlinDebug\n*F\n+ 1 PacketJVM.kt\nio/ktor/utils/io/core/PacketJVMKt\n*L\n15#1:24,2\n*E\n"})
public final class PacketJVMKt {
    private static final int PACKET_MAX_COPY_SIZE = AtomicKt.getIOIntProperty("max.copy.size", 500);

    public static final int getPACKET_MAX_COPY_SIZE() {
        return PACKET_MAX_COPY_SIZE;
    }

    @NotNull
    public static final ByteBuffer readByteBuffer(@NotNull ByteReadPacket $this$readByteBuffer, int n, boolean direct) {
        ByteBuffer byteBuffer;
        Intrinsics.checkNotNullParameter((Object)$this$readByteBuffer, (String)"<this>");
        if (direct) {
            ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(n);
            byteBuffer = byteBuffer2;
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer2, (String)"allocateDirect(...)");
        } else {
            ByteBuffer byteBuffer3 = ByteBuffer.allocate(n);
            byteBuffer = byteBuffer3;
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer3, (String)"allocate(...)");
        }
        ByteBuffer bb = byteBuffer;
        ByteBuffersKt.readFully($this$readByteBuffer, bb);
        bb.clear();
        return bb;
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ ByteBuffer readByteBuffer$default(ByteReadPacket byteReadPacket, int n, boolean bl, int n2, Object object) {
        if ((n2 & 1) != 0) {
            void $this$coerceAtMostMaxIntOrFail$iv;
            long l = byteReadPacket.getRemaining();
            String message$iv = "Unable to make a ByteBuffer: packet is too big";
            boolean $i$f$coerceAtMostMaxIntOrFail = false;
            if ($this$coerceAtMostMaxIntOrFail$iv > Integer.MAX_VALUE) {
                throw new IllegalArgumentException(message$iv);
            }
            n = (int)$this$coerceAtMostMaxIntOrFail$iv;
        }
        if ((n2 & 2) != 0) {
            bl = false;
        }
        return PacketJVMKt.readByteBuffer(byteReadPacket, n, bl);
    }
}

