/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.utils.io.core.internal;

import io.ktor.utils.io.bits.DefaultAllocator;
import io.ktor.utils.io.bits.MemoryJvmKt;
import io.ktor.utils.io.core.Buffer;
import io.ktor.utils.io.core.BufferFactoryKt;
import io.ktor.utils.io.pool.NoPoolImpl;
import io.ktor.utils.io.pool.ObjectPool;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated(message="\n    We're migrating to the new kotlinx-io library.\n    This declaration is deprecated and will be removed in Ktor 4.0.0\n    If you have any problems with migration, please contact us in \n    https://youtrack.jetbrains.com/issue/KTOR-6030/Migrate-to-new-kotlinx.io-library\n    ")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u0000 -2\u00020\u0001:\u0001-B-\u0012\n\u0010*\u001a\u00060(j\u0002`)\u0012\b\u0010\u001d\u001a\u0004\u0018\u00010\u0000\u0012\u000e\u0010 \u001a\n\u0012\u0004\u0012\u00020\u0000\u0018\u00010\u0010\u00a2\u0006\u0004\b+\u0010,J\u000f\u0010\u0005\u001a\u00020\u0002H\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0017\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u000b\u001a\u00020\u0000H\u0016\u00a2\u0006\u0004\b\u000b\u0010\nJ\u000f\u0010\u000f\u001a\u00020\fH\u0000\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001d\u0010\u000f\u001a\u00020\u00022\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00000\u0010H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0012J\r\u0010\u0013\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0004J\u000f\u0010\u0015\u001a\u00020\u0002H\u0000\u00a2\u0006\u0004\b\u0014\u0010\u0004J\u000f\u0010\u0017\u001a\u00020\u0002H\u0000\u00a2\u0006\u0004\b\u0016\u0010\u0004R(\u0010\u001b\u001a\u0004\u0018\u00010\u00002\b\u0010\u0018\u001a\u0004\u0018\u00010\u00008F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0019\u0010\n\"\u0004\b\u001a\u0010\bR(\u0010\u001d\u001a\u0004\u0018\u00010\u00002\b\u0010\u001c\u001a\u0004\u0018\u00010\u00008\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010\nR\"\u0010 \u001a\n\u0012\u0004\u0012\u00020\u0000\u0018\u00010\u00108\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\"\u0010#R\u0011\u0010'\u001a\u00020$8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\u00a8\u0006."}, d2={"Lio/ktor/utils/io/core/internal/ChunkBuffer;", "Lio/ktor/utils/io/core/Buffer;", "", "acquire$ktor_io", "()V", "acquire", "chunk", "appendNext", "(Lio/ktor/utils/io/core/internal/ChunkBuffer;)V", "cleanNext", "()Lio/ktor/utils/io/core/internal/ChunkBuffer;", "duplicate", "", "release$ktor_io", "()Z", "release", "Lio/ktor/utils/io/pool/ObjectPool;", "pool", "(Lio/ktor/utils/io/pool/ObjectPool;)V", "reset", "unlink$ktor_io", "unlink", "unpark$ktor_io", "unpark", "newValue", "getNext", "setNext", "next", "<set-?>", "origin", "Lio/ktor/utils/io/core/internal/ChunkBuffer;", "getOrigin", "parentPool", "Lio/ktor/utils/io/pool/ObjectPool;", "getParentPool$ktor_io", "()Lio/ktor/utils/io/pool/ObjectPool;", "", "getReferenceCount", "()I", "referenceCount", "Ljava/nio/ByteBuffer;", "Lio/ktor/utils/io/bits/Memory;", "memory", "<init>", "(Ljava/nio/ByteBuffer;Lio/ktor/utils/io/core/internal/ChunkBuffer;Lio/ktor/utils/io/pool/ObjectPool;)V", "Companion", "ktor-io"})
@SourceDebugExtension(value={"SMAP\nChunkBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChunkBuffer.kt\nio/ktor/utils/io/core/internal/ChunkBuffer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 AtomicFU.common.kt\nkotlinx/atomicfu/AtomicFU_commonKt\n*L\n1#1,180:1\n1#2:181\n360#3,4:182\n360#3,4:186\n382#3,4:190\n*S KotlinDebug\n*F\n+ 1 ChunkBuffer.kt\nio/ktor/utils/io/core/internal/ChunkBuffer\n*L\n89#1:182,4\n99#1:186,4\n116#1:190,4\n*E\n"})
public class ChunkBuffer
extends Buffer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final ObjectPool<ChunkBuffer> parentPool;
    @NotNull
    private volatile /* synthetic */ Object nextRef;
    private static final /* synthetic */ AtomicReferenceFieldUpdater nextRef$FU;
    @NotNull
    private volatile /* synthetic */ int refCount;
    private static final /* synthetic */ AtomicIntegerFieldUpdater refCount$FU;
    @Nullable
    private ChunkBuffer origin;
    @NotNull
    private static final ObjectPool<ChunkBuffer> EmptyPool = new ObjectPool<ChunkBuffer>(){

        public int getCapacity() {
            return 1;
        }

        @NotNull
        public ChunkBuffer borrow() {
            return ChunkBuffer.Companion.getEmpty();
        }

        public void recycle(@NotNull ChunkBuffer instance) {
            Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
            if (!(instance == ChunkBuffer.Companion.getEmpty())) {
                boolean bl = false;
                String string = "Only ChunkBuffer.Empty instance could be recycled.";
                throw new IllegalArgumentException(string.toString());
            }
        }

        public void dispose() {
        }

        public void close() {
            ObjectPool.DefaultImpls.close(this);
        }
    };
    @NotNull
    private static final ChunkBuffer Empty = new ChunkBuffer(MemoryJvmKt.getMEMORY_EMPTY(), null, EmptyPool);
    @NotNull
    private static final ObjectPool<ChunkBuffer> NoPool = new NoPoolImpl<ChunkBuffer>(){

        @NotNull
        public ChunkBuffer borrow() {
            return new ChunkBuffer(DefaultAllocator.INSTANCE.alloc(4096), null, this);
        }

        public void recycle(@NotNull ChunkBuffer instance) {
            Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
            DefaultAllocator.INSTANCE.free(instance.getMemory());
        }
    };
    @NotNull
    private static final ObjectPool<ChunkBuffer> NoPoolManuallyManaged = new NoPoolImpl<ChunkBuffer>(){

        @NotNull
        public ChunkBuffer borrow() {
            throw new UnsupportedOperationException("This pool doesn't support borrow");
        }

        public void recycle(@NotNull ChunkBuffer instance) {
            Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
        }
    };

    public ChunkBuffer(@NotNull ByteBuffer memory, @Nullable ChunkBuffer origin, @Nullable ObjectPool<ChunkBuffer> parentPool) {
        Intrinsics.checkNotNullParameter((Object)memory, (String)"memory");
        super(memory);
        this.parentPool = parentPool;
        if (!(origin != this)) {
            boolean bl = false;
            String string = "A chunk couldn't be a view of itself.";
            throw new IllegalArgumentException(string.toString());
        }
        this.nextRef = null;
        this.refCount = 1;
        this.origin = origin;
    }

    @Nullable
    public final ObjectPool<ChunkBuffer> getParentPool$ktor_io() {
        return this.parentPool;
    }

    @Nullable
    public final ChunkBuffer getOrigin() {
        return this.origin;
    }

    @Nullable
    public final ChunkBuffer getNext() {
        return (ChunkBuffer)this.nextRef;
    }

    public final void setNext(@Nullable ChunkBuffer newValue) {
        if (newValue == null) {
            this.cleanNext();
        } else {
            this.appendNext(newValue);
        }
    }

    public final int getReferenceCount() {
        return this.refCount;
    }

    private final void appendNext(ChunkBuffer chunk) {
        if (!nextRef$FU.compareAndSet(this, null, chunk)) {
            throw new IllegalStateException("This chunk has already a next chunk.");
        }
    }

    @Nullable
    public final ChunkBuffer cleanNext() {
        return nextRef$FU.getAndSet(this, null);
    }

    @Override
    @NotNull
    public ChunkBuffer duplicate() {
        ChunkBuffer chunkBuffer;
        ChunkBuffer chunkBuffer2 = this.origin;
        if (chunkBuffer2 == null) {
            chunkBuffer2 = this;
        }
        ChunkBuffer newOrigin = chunkBuffer2;
        boolean bl = false;
        newOrigin.acquire$ktor_io();
        ChunkBuffer copy2 = chunkBuffer = new ChunkBuffer(this.getMemory(), newOrigin, this.parentPool);
        boolean bl2 = false;
        this.duplicateTo(copy2);
        return chunkBuffer;
    }

    public void release(@NotNull ObjectPool<ChunkBuffer> pool) {
        Intrinsics.checkNotNullParameter(pool, (String)"pool");
        if (this.release$ktor_io()) {
            ChunkBuffer origin = this.origin;
            if (origin != null) {
                this.unlink$ktor_io();
                origin.release(pool);
            } else {
                ObjectPool<ChunkBuffer> objectPool = this.parentPool;
                if (objectPool == null) {
                    objectPool = pool;
                }
                ObjectPool<ChunkBuffer> poolToUse = objectPool;
                poolToUse.recycle(this);
            }
        }
    }

    public final void unlink$ktor_io() {
        if (!refCount$FU.compareAndSet(this, 0, -1)) {
            throw new IllegalStateException("Unable to unlink: buffer is in use.");
        }
        this.cleanNext();
        this.origin = null;
    }

    public final void acquire$ktor_io() {
        int old;
        int upd$iv;
        int cur$iv;
        ChunkBuffer $this$update$iv = this;
        boolean $i$f$update = false;
        do {
            old = cur$iv = $this$update$iv.refCount;
            boolean bl = false;
            if (old > 0) continue;
            throw new IllegalStateException("Unable to acquire chunk: it is already released.");
        } while (!refCount$FU.compareAndSet($this$update$iv, cur$iv, upd$iv = old + 1));
    }

    public final void unpark$ktor_io() {
        int upd$iv;
        int cur$iv;
        ChunkBuffer $this$update$iv = this;
        boolean $i$f$update = false;
        do {
            int old = cur$iv = $this$update$iv.refCount;
            boolean bl = false;
            if (old < 0) {
                throw new IllegalStateException("This instance is already disposed and couldn't be borrowed.");
            }
            if (old <= 0) continue;
            throw new IllegalStateException("This instance is already in use but somehow appeared in the pool.");
        } while (!refCount$FU.compareAndSet($this$update$iv, cur$iv, upd$iv = 1));
    }

    public final boolean release$ktor_io() {
        int old;
        int upd$iv;
        int cur$iv;
        ChunkBuffer $this$updateAndGet$iv = this;
        boolean $i$f$updateAndGet = false;
        do {
            old = cur$iv = $this$updateAndGet$iv.refCount;
            boolean bl = false;
            if (old > 0) continue;
            throw new IllegalStateException("Unable to release: it is already released.");
        } while (!refCount$FU.compareAndSet($this$updateAndGet$iv, cur$iv, upd$iv = old - 1));
        return upd$iv == 0;
    }

    @Override
    public final void reset() {
        if (!(this.origin == null)) {
            boolean bl = false;
            String string = "Unable to reset buffer with origin";
            throw new IllegalArgumentException(string.toString());
        }
        super.reset();
        this.nextRef = null;
    }

    static {
        nextRef$FU = AtomicReferenceFieldUpdater.newUpdater(ChunkBuffer.class, Object.class, "nextRef");
        refCount$FU = AtomicIntegerFieldUpdater.newUpdater(ChunkBuffer.class, "refCount");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\n\u00a8\u0006\u0011"}, d2={"Lio/ktor/utils/io/core/internal/ChunkBuffer$Companion;", "", "()V", "Empty", "Lio/ktor/utils/io/core/internal/ChunkBuffer;", "getEmpty", "()Lio/ktor/utils/io/core/internal/ChunkBuffer;", "EmptyPool", "Lio/ktor/utils/io/pool/ObjectPool;", "getEmptyPool", "()Lio/ktor/utils/io/pool/ObjectPool;", "NoPool", "getNoPool$ktor_io", "NoPoolManuallyManaged", "getNoPoolManuallyManaged$ktor_io", "Pool", "getPool", "ktor-io"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ObjectPool<ChunkBuffer> getPool() {
            return BufferFactoryKt.getDefaultChunkedBufferPool();
        }

        @NotNull
        public final ObjectPool<ChunkBuffer> getEmptyPool() {
            return EmptyPool;
        }

        @NotNull
        public final ChunkBuffer getEmpty() {
            return Empty;
        }

        @NotNull
        public final ObjectPool<ChunkBuffer> getNoPool$ktor_io() {
            return NoPool;
        }

        @NotNull
        public final ObjectPool<ChunkBuffer> getNoPoolManuallyManaged$ktor_io() {
            return NoPoolManuallyManaged;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

