/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.metrics.dropwizard;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import io.ktor.application.Application;
import io.ktor.application.ApplicationCall;
import io.ktor.application.ApplicationCallPipeline;
import io.ktor.application.ApplicationFeature;
import io.ktor.http.HttpStatusCode;
import io.ktor.metrics.dropwizard.DropwizardMetrics;
import io.ktor.routing.Routing;
import io.ktor.routing.RoutingApplicationCall;
import io.ktor.util.AttributeKey;
import io.ktor.util.Attributes;
import io.ktor.util.pipeline.PipelineContext;
import io.ktor.util.pipeline.PipelinePhase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0004\u0018\u0000 \"2\u00020\u0001:\u0003 !\"B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\n \t*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \t*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000f0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006#"}, d2={"Lio/ktor/metrics/dropwizard/DropwizardMetrics;", "", "registry", "Lcom/codahale/metrics/MetricRegistry;", "baseName", "", "(Lcom/codahale/metrics/MetricRegistry;Ljava/lang/String;)V", "active", "Lcom/codahale/metrics/Counter;", "kotlin.jvm.PlatformType", "getBaseName", "()Ljava/lang/String;", "duration", "Lcom/codahale/metrics/Timer;", "exceptions", "Lcom/codahale/metrics/Meter;", "httpStatus", "Ljava/util/concurrent/ConcurrentHashMap;", "", "measureKey", "Lio/ktor/util/AttributeKey;", "Lio/ktor/metrics/dropwizard/DropwizardMetrics$CallMeasure;", "getRegistry", "()Lcom/codahale/metrics/MetricRegistry;", "after", "", "call", "Lio/ktor/application/ApplicationCall;", "before", "exception", "e", "", "CallMeasure", "Configuration", "Feature", "ktor-metrics"})
public final class DropwizardMetrics {
    @NotNull
    public static final Feature Feature = new Feature(null);
    @NotNull
    private final MetricRegistry registry;
    @NotNull
    private final String baseName;
    private final Timer duration;
    private final Counter active;
    private final Meter exceptions;
    @NotNull
    private final ConcurrentHashMap<Integer, Meter> httpStatus;
    @NotNull
    private final AttributeKey<CallMeasure> measureKey;
    @NotNull
    private static final AttributeKey<DropwizardMetrics> key = new AttributeKey("metrics");
    @NotNull
    private static final AttributeKey<Feature.RoutingMetrics> routingMetricsKey = new AttributeKey("metrics");

    public DropwizardMetrics(@NotNull MetricRegistry registry, @NotNull String baseName) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter((Object)baseName, (String)"baseName");
        this.registry = registry;
        this.baseName = baseName;
        String[] stringArray = new String[]{"duration"};
        this.duration = this.registry.timer(MetricRegistry.name((String)this.baseName, (String[])stringArray));
        stringArray = new String[]{"active"};
        this.active = this.registry.counter(MetricRegistry.name((String)this.baseName, (String[])stringArray));
        stringArray = new String[]{"exceptions"};
        this.exceptions = this.registry.meter(MetricRegistry.name((String)this.baseName, (String[])stringArray));
        this.httpStatus = new ConcurrentHashMap();
        this.measureKey = new AttributeKey("metrics");
    }

    public /* synthetic */ DropwizardMetrics(MetricRegistry metricRegistry, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            String string2 = MetricRegistry.name((String)"ktor.calls", (String[])new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name(\"ktor.calls\")");
            string = string2;
        }
        this(metricRegistry, string);
    }

    @NotNull
    public final MetricRegistry getRegistry() {
        return this.registry;
    }

    @NotNull
    public final String getBaseName() {
        return this.baseName;
    }

    private final void before(ApplicationCall call) {
        this.active.inc();
        Attributes attributes = call.getAttributes();
        Timer.Context context = this.duration.time();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"duration.time()");
        attributes.put(this.measureKey, (Object)new CallMeasure(context));
    }

    private final void after(ApplicationCall call) {
        int n;
        this.active.dec();
        HttpStatusCode httpStatusCode = call.getResponse().status();
        Meter meter = this.httpStatus.computeIfAbsent(httpStatusCode == null ? 0 : (n = httpStatusCode.getValue()), arg_0 -> DropwizardMetrics.after$lambda-0(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)meter, (String)"httpStatus.computeIfAbse\u2026it.toString()))\n        }");
        Meter meter2 = meter;
        meter2.mark();
        CallMeasure callMeasure = (CallMeasure)call.getAttributes().getOrNull(this.measureKey);
        if (callMeasure != null) {
            CallMeasure callMeasure2;
            CallMeasure $this$after_u24lambda_u2d1 = callMeasure2 = callMeasure;
            boolean bl = false;
            $this$after_u24lambda_u2d1.getTimer().stop();
        }
    }

    private final void exception(ApplicationCall call, Throwable e) {
        this.exceptions.mark();
    }

    private static final Meter after$lambda-0(DropwizardMetrics this$0, Integer it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String[] stringArray = new String[]{"status", String.valueOf(it)};
        return this$0.registry.meter(MetricRegistry.name((String)this$0.baseName, (String[])stringArray));
    }

    public static final /* synthetic */ void access$before(DropwizardMetrics $this, ApplicationCall call) {
        $this.before(call);
    }

    public static final /* synthetic */ void access$exception(DropwizardMetrics $this, ApplicationCall call, Throwable e) {
        $this.exception(call, e);
    }

    public static final /* synthetic */ void access$after(DropwizardMetrics $this, ApplicationCall call) {
        $this.after(call);
    }

    public static final /* synthetic */ AttributeKey access$getRoutingMetricsKey$cp() {
        return routingMetricsKey;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lio/ktor/metrics/dropwizard/DropwizardMetrics$Configuration;", "", "()V", "baseName", "", "getBaseName", "()Ljava/lang/String;", "setBaseName", "(Ljava/lang/String;)V", "registerJvmMetricSets", "", "getRegisterJvmMetricSets", "()Z", "setRegisterJvmMetricSets", "(Z)V", "registry", "Lcom/codahale/metrics/MetricRegistry;", "getRegistry", "()Lcom/codahale/metrics/MetricRegistry;", "setRegistry", "(Lcom/codahale/metrics/MetricRegistry;)V", "ktor-metrics"})
    public static final class Configuration {
        @NotNull
        private String baseName;
        @NotNull
        private MetricRegistry registry;
        private boolean registerJvmMetricSets;

        public Configuration() {
            String string = MetricRegistry.name((String)"ktor.calls", (String[])new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(\"ktor.calls\")");
            this.baseName = string;
            this.registry = new MetricRegistry();
            this.registerJvmMetricSets = true;
        }

        @NotNull
        public final String getBaseName() {
            return this.baseName;
        }

        public final void setBaseName(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.baseName = string;
        }

        @NotNull
        public final MetricRegistry getRegistry() {
            return this.registry;
        }

        public final void setRegistry(@NotNull MetricRegistry metricRegistry) {
            Intrinsics.checkNotNullParameter((Object)metricRegistry, (String)"<set-?>");
            this.registry = metricRegistry;
        }

        public final boolean getRegisterJvmMetricSets() {
            return this.registerJvmMetricSets;
        }

        public final void setRegisterJvmMetricSets(boolean bl) {
            this.registerJvmMetricSets = bl;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0001\u0012B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0005J)\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00022\u0017\u0010\u000e\u001a\u0013\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0002\b\u0011H\u0016R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/ktor/metrics/dropwizard/DropwizardMetrics$Feature;", "Lio/ktor/application/ApplicationFeature;", "Lio/ktor/application/Application;", "Lio/ktor/metrics/dropwizard/DropwizardMetrics$Configuration;", "Lio/ktor/metrics/dropwizard/DropwizardMetrics;", "()V", "key", "Lio/ktor/util/AttributeKey;", "getKey", "()Lio/ktor/util/AttributeKey;", "routingMetricsKey", "Lio/ktor/metrics/dropwizard/DropwizardMetrics$Feature$RoutingMetrics;", "install", "pipeline", "configure", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "RoutingMetrics", "ktor-metrics"})
    public static final class Feature
    implements ApplicationFeature<Application, Configuration, DropwizardMetrics> {
        private Feature() {
        }

        @NotNull
        public AttributeKey<DropwizardMetrics> getKey() {
            return key;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public DropwizardMetrics install(@NotNull Application pipeline, @NotNull Function1<? super Configuration, Unit> configure) {
            Intrinsics.checkNotNullParameter((Object)pipeline, (String)"pipeline");
            Intrinsics.checkNotNullParameter(configure, (String)"configure");
            Configuration configuration = new Configuration();
            configure.invoke((Object)configuration);
            Configuration configuration2 = configuration;
            DropwizardMetrics feature = new DropwizardMetrics(configuration2.getRegistry(), configuration2.getBaseName());
            if (configuration2.getRegisterJvmMetricSets()) {
                void $this$forEach$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                Object object = new Pair[]{TuplesKt.to((Object)"jvm.memory", (Object)((Object)install.1.INSTANCE)), TuplesKt.to((Object)"jvm.garbage", (Object)((Object)install.2.INSTANCE)), TuplesKt.to((Object)"jvm.threads", (Object)((Object)install.3.INSTANCE)), TuplesKt.to((Object)"jvm.files", (Object)((Object)install.4.INSTANCE)), TuplesKt.to((Object)"jvm.attributes", (Object)((Object)install.5.INSTANCE))};
                object = CollectionsKt.listOf((Object[])object);
                boolean $i$f$filter = false;
                Iterator iterator = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    boolean bl;
                    block6: {
                        Pair $dstr$name$_u24__u24 = (Pair)element$iv$iv;
                        boolean bl2 = false;
                        String name = (String)$dstr$name$_u24__u24.component1();
                        SortedSet sortedSet = configuration2.getRegistry().getNames();
                        Intrinsics.checkNotNullExpressionValue((Object)sortedSet, (String)"configuration.registry.names");
                        Iterable $this$any$iv = sortedSet;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                String existingName = (String)element$iv;
                                boolean bl3 = false;
                                Intrinsics.checkNotNullExpressionValue((Object)existingName, (String)"existingName");
                                if (!StringsKt.startsWith$default((String)existingName, (String)name, (boolean)false, (int)2, null)) continue;
                                bl = true;
                                break block6;
                            }
                            bl = false;
                        }
                    }
                    boolean bl4 = !bl;
                    if (!bl4) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Pair $dstr$name$metric = (Pair)element$iv;
                    boolean bl = false;
                    String name = (String)$dstr$name$metric.component1();
                    Function0 metric = (Function0)$dstr$name$metric.component2();
                    configuration2.getRegistry().register(name, (Metric)metric.invoke());
                }
            }
            PipelinePhase phase = new PipelinePhase("DropwizardMetrics");
            pipeline.insertPhaseBefore(ApplicationCallPipeline.ApplicationPhase.getMonitoring(), phase);
            pipeline.intercept(phase, (Function3)new Function3<PipelineContext<Unit, ApplicationCall>, Unit, Continuation<? super Unit>, Object>(feature, null){
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ DropwizardMetrics $feature;
                {
                    this.$feature = $feature;
                    super(3, $completion);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            PipelineContext $this$intercept;
                            ResultKt.throwOnFailure((Object)object);
                            PipelineContext $this$call$iv = $this$intercept = (PipelineContext)this.L$0;
                            boolean $i$f$getCall = false;
                            DropwizardMetrics.access$before(this.$feature, (ApplicationCall)$this$call$iv.getContext());
                            this.L$0 = $this$intercept;
                            this.label = 1;
                            Object object3 = $this$intercept.proceed((Continuation)this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            Object object3;
                            PipelineContext $this$intercept = (PipelineContext)this.L$0;
                            try {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                object3 = $result;
                                return Unit.INSTANCE;
                            }
                            catch (Exception e) {
                                PipelineContext $this$call$iv = $this$intercept;
                                boolean $i$f$getCall = false;
                                DropwizardMetrics.access$exception(this.$feature, (ApplicationCall)$this$call$iv.getContext(), e);
                                throw e;
                            }
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        {
                            PipelineContext $this$intercept;
                            finally {
                                PipelineContext $this$call$iv = $this$intercept;
                                boolean $i$f$getCall = false;
                                DropwizardMetrics.access$after(this.$feature, (ApplicationCall)$this$call$iv.getContext());
                            }
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @Nullable
                public final Object invoke(@NotNull PipelineContext<Unit, ApplicationCall> p1, @NotNull Unit p2, @Nullable Continuation<? super Unit> p3) {
                    Function3<PipelineContext<Unit, ApplicationCall>, Unit, Continuation<? super Unit>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                    function3.L$0 = p1;
                    return function3.invokeSuspend((Object)Unit.INSTANCE);
                }
            });
            pipeline.getEnvironment().getMonitor().subscribe(Routing.Feature.getRoutingCallStarted(), (Function1)new Function1<RoutingApplicationCall, Unit>(feature){
                final /* synthetic */ DropwizardMetrics $feature;
                {
                    this.$feature = $feature;
                    super(1);
                }

                public final void invoke(@NotNull RoutingApplicationCall call) {
                    Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                    String name = call.getRoute().toString();
                    String[] stringArray = new String[]{name, "meter"};
                    Meter meter = this.$feature.getRegistry().meter(MetricRegistry.name((String)this.$feature.getBaseName(), (String[])stringArray));
                    String[] stringArray2 = new String[]{name, "timer"};
                    Timer timer = this.$feature.getRegistry().timer(MetricRegistry.name((String)this.$feature.getBaseName(), (String[])stringArray2));
                    meter.mark();
                    Timer.Context context = timer.time();
                    Attributes attributes = call.getAttributes();
                    AttributeKey attributeKey = DropwizardMetrics.access$getRoutingMetricsKey$cp();
                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                    attributes.put(attributeKey, (Object)new RoutingMetrics(name, context));
                }
            });
            pipeline.getEnvironment().getMonitor().subscribe(Routing.Feature.getRoutingCallFinished(), (Function1)new Function1<RoutingApplicationCall, Unit>(feature){
                final /* synthetic */ DropwizardMetrics $feature;
                {
                    this.$feature = $feature;
                    super(1);
                }

                public final void invoke(@NotNull RoutingApplicationCall call) {
                    int n;
                    Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                    RoutingMetrics routingMetrics = (RoutingMetrics)call.getAttributes().take(DropwizardMetrics.access$getRoutingMetricsKey$cp());
                    HttpStatusCode httpStatusCode = call.getResponse().status();
                    int status = httpStatusCode == null ? 0 : (n = httpStatusCode.getValue());
                    String[] stringArray = new String[]{routingMetrics.getName(), String.valueOf(status)};
                    Meter statusMeter = this.$feature.getRegistry().meter(MetricRegistry.name((String)this.$feature.getBaseName(), (String[])stringArray));
                    statusMeter.mark();
                    routingMetrics.getContext().stop();
                }
            });
            return feature;
        }

        public /* synthetic */ Feature(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lio/ktor/metrics/dropwizard/DropwizardMetrics$Feature$RoutingMetrics;", "", "name", "", "context", "Lcom/codahale/metrics/Timer$Context;", "(Ljava/lang/String;Lcom/codahale/metrics/Timer$Context;)V", "getContext", "()Lcom/codahale/metrics/Timer$Context;", "getName", "()Ljava/lang/String;", "ktor-metrics"})
        private static final class RoutingMetrics {
            @NotNull
            private final String name;
            @NotNull
            private final Timer.Context context;

            public RoutingMetrics(@NotNull String name, @NotNull Timer.Context context) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                this.name = name;
                this.context = context;
            }

            @NotNull
            public final String getName() {
                return this.name;
            }

            @NotNull
            public final Timer.Context getContext() {
                return this.context;
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lio/ktor/metrics/dropwizard/DropwizardMetrics$CallMeasure;", "", "timer", "Lcom/codahale/metrics/Timer$Context;", "(Lcom/codahale/metrics/Timer$Context;)V", "getTimer", "()Lcom/codahale/metrics/Timer$Context;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "ktor-metrics"})
    private static final class CallMeasure {
        @NotNull
        private final Timer.Context timer;

        public CallMeasure(@NotNull Timer.Context timer) {
            Intrinsics.checkNotNullParameter((Object)timer, (String)"timer");
            this.timer = timer;
        }

        @NotNull
        public final Timer.Context getTimer() {
            return this.timer;
        }

        @NotNull
        public final Timer.Context component1() {
            return this.timer;
        }

        @NotNull
        public final CallMeasure copy(@NotNull Timer.Context timer) {
            Intrinsics.checkNotNullParameter((Object)timer, (String)"timer");
            return new CallMeasure(timer);
        }

        public static /* synthetic */ CallMeasure copy$default(CallMeasure callMeasure, Timer.Context context, int n, Object object) {
            if ((n & 1) != 0) {
                context = callMeasure.timer;
            }
            return callMeasure.copy(context);
        }

        @NotNull
        public String toString() {
            return "CallMeasure(timer=" + this.timer + ')';
        }

        public int hashCode() {
            return this.timer.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CallMeasure)) {
                return false;
            }
            CallMeasure callMeasure = (CallMeasure)other;
            return Intrinsics.areEqual((Object)this.timer, (Object)callMeasure.timer);
        }
    }
}

