/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.resources.serialization;

import io.ktor.http.Parameters;
import io.ktor.resources.ResourceSerializationException;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.AbstractDecoder;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u0018H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\nH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u000fH\u0016J\n\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\u0007H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006&"}, d2={"Lio/ktor/resources/serialization/ListLikeDecoder;", "Lkotlinx/serialization/encoding/AbstractDecoder;", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "parameters", "Lio/ktor/http/Parameters;", "parameterName", "", "(Lkotlinx/serialization/modules/SerializersModule;Lio/ktor/http/Parameters;Ljava/lang/String;)V", "currentIndex", "", "elementsCount", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "decodeBoolean", "", "decodeByte", "", "decodeChar", "", "decodeDouble", "", "decodeElementIndex", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "decodeEnum", "enumDescriptor", "decodeFloat", "", "decodeInt", "decodeLong", "", "decodeNotNullMark", "decodeNull", "", "decodeShort", "", "decodeString", "ktor-resources"})
final class ListLikeDecoder
extends AbstractDecoder {
    @NotNull
    private final SerializersModule serializersModule;
    @NotNull
    private final Parameters parameters;
    @NotNull
    private final String parameterName;
    private int currentIndex;
    private final int elementsCount;

    public ListLikeDecoder(@NotNull SerializersModule serializersModule, @NotNull Parameters parameters, @NotNull String parameterName) {
        Intrinsics.checkNotNullParameter((Object)serializersModule, (String)"serializersModule");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)parameterName, (String)"parameterName");
        this.serializersModule = serializersModule;
        this.parameters = parameters;
        this.parameterName = parameterName;
        this.currentIndex = -1;
        List list = this.parameters.getAll(this.parameterName);
        this.elementsCount = list != null ? list.size() : 0;
    }

    @NotNull
    public SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    public int decodeElementIndex(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        ++this.currentIndex;
        if (this.currentIndex == this.elementsCount) {
            return -1;
        }
        return this.currentIndex;
    }

    public boolean decodeBoolean() {
        return Boolean.parseBoolean(this.decodeString());
    }

    public byte decodeByte() {
        return Byte.parseByte(this.decodeString());
    }

    public char decodeChar() {
        return this.decodeString().charAt(0);
    }

    public double decodeDouble() {
        return Double.parseDouble(this.decodeString());
    }

    public float decodeFloat() {
        return Float.parseFloat(this.decodeString());
    }

    public int decodeInt() {
        return Integer.parseInt(this.decodeString());
    }

    public long decodeLong() {
        return Long.parseLong(this.decodeString());
    }

    public short decodeShort() {
        return Short.parseShort(this.decodeString());
    }

    @NotNull
    public String decodeString() {
        List list = this.parameters.getAll(this.parameterName);
        Intrinsics.checkNotNull((Object)list);
        return (String)list.get(this.currentIndex);
    }

    public boolean decodeNotNullMark() {
        return this.parameters.contains(this.parameterName);
    }

    @Nullable
    public Void decodeNull() {
        return null;
    }

    public int decodeEnum(@NotNull SerialDescriptor enumDescriptor) {
        Intrinsics.checkNotNullParameter((Object)enumDescriptor, (String)"enumDescriptor");
        String enumName = this.decodeString();
        int index = enumDescriptor.getElementIndex(enumName);
        if (index == -3) {
            throw new ResourceSerializationException(enumDescriptor.getSerialName() + " does not contain element with name '" + enumName + '\'');
        }
        return index;
    }
}

