/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.resources.serialization;

import io.ktor.http.Parameters;
import io.ktor.resources.ResourceSerializationException;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.AbstractDecoder;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0005\n\u0002\u0010\u0001\n\u0002\b\r\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0016\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0019\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u000f\u0010\u001c\u001a\u00020\u001bH\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u000f\u0010\u001e\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u000f\u0010!\u001a\u00020 H\u0016\u00a2\u0006\u0004\b!\u0010\"J\u000f\u0010$\u001a\u00020#H\u0016\u00a2\u0006\u0004\b$\u0010%J\u000f\u0010&\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b&\u0010'J\u000f\u0010(\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b(\u0010\u0011J\u0011\u0010*\u001a\u0004\u0018\u00010)H\u0016\u00a2\u0006\u0004\b*\u0010+J\u0017\u0010-\u001a\u00020\f2\u0006\u0010,\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b-\u0010\u000eR\u001a\u0010\u0003\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010.\u001a\u0004\b/\u00100R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u00101R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u00102R\u0016\u00103\u001a\u00020\f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b3\u00104R\u0014\u00105\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b5\u00104\u00a8\u00066"}, d2={"Lio/ktor/resources/serialization/ListLikeDecoder;", "Lkotlinx/serialization/encoding/AbstractDecoder;", "Lkotlinx/serialization/modules/SerializersModule;", "serializersModule", "Lio/ktor/http/Parameters;", "parameters", "", "parameterName", "<init>", "(Lkotlinx/serialization/modules/SerializersModule;Lio/ktor/http/Parameters;Ljava/lang/String;)V", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "descriptor", "", "decodeElementIndex", "(Lkotlinx/serialization/descriptors/SerialDescriptor;)I", "", "decodeBoolean", "()Z", "", "decodeByte", "()B", "", "decodeChar", "()C", "", "decodeDouble", "()D", "", "decodeFloat", "()F", "decodeInt", "()I", "", "decodeLong", "()J", "", "decodeShort", "()S", "decodeString", "()Ljava/lang/String;", "decodeNotNullMark", "", "decodeNull", "()Ljava/lang/Void;", "enumDescriptor", "decodeEnum", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "Lio/ktor/http/Parameters;", "Ljava/lang/String;", "currentIndex", "I", "elementsCount", "ktor-resources"})
final class ListLikeDecoder
extends AbstractDecoder {
    @NotNull
    private final SerializersModule serializersModule;
    @NotNull
    private final Parameters parameters;
    @NotNull
    private final String parameterName;
    private int currentIndex;
    private final int elementsCount;

    public ListLikeDecoder(@NotNull SerializersModule serializersModule, @NotNull Parameters parameters, @NotNull String parameterName) {
        Intrinsics.checkNotNullParameter((Object)serializersModule, (String)"serializersModule");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)parameterName, (String)"parameterName");
        this.serializersModule = serializersModule;
        this.parameters = parameters;
        this.parameterName = parameterName;
        this.currentIndex = -1;
        List list = this.parameters.getAll(this.parameterName);
        this.elementsCount = list != null ? list.size() : 0;
    }

    @NotNull
    public SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    public int decodeElementIndex(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        ++this.currentIndex;
        if (this.currentIndex == this.elementsCount) {
            return -1;
        }
        return this.currentIndex;
    }

    public boolean decodeBoolean() {
        return Boolean.parseBoolean(this.decodeString());
    }

    public byte decodeByte() {
        return Byte.parseByte(this.decodeString());
    }

    public char decodeChar() {
        return this.decodeString().charAt(0);
    }

    public double decodeDouble() {
        return Double.parseDouble(this.decodeString());
    }

    public float decodeFloat() {
        return Float.parseFloat(this.decodeString());
    }

    public int decodeInt() {
        return Integer.parseInt(this.decodeString());
    }

    public long decodeLong() {
        return Long.parseLong(this.decodeString());
    }

    public short decodeShort() {
        return Short.parseShort(this.decodeString());
    }

    @NotNull
    public String decodeString() {
        List list = this.parameters.getAll(this.parameterName);
        Intrinsics.checkNotNull((Object)list);
        return (String)list.get(this.currentIndex);
    }

    public boolean decodeNotNullMark() {
        return this.parameters.contains(this.parameterName);
    }

    @Nullable
    public Void decodeNull() {
        return null;
    }

    public int decodeEnum(@NotNull SerialDescriptor enumDescriptor) {
        Intrinsics.checkNotNullParameter((Object)enumDescriptor, (String)"enumDescriptor");
        String enumName = this.decodeString();
        int index = enumDescriptor.getElementIndex(enumName);
        if (index == -3) {
            throw new ResourceSerializationException(enumDescriptor.getSerialName() + " does not contain element with name '" + enumName + '\'');
        }
        return index;
    }
}

