/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.auth;

import io.ktor.server.auth.UserIdPrincipal;
import io.ktor.server.auth.UserPasswordCredential;
import java.util.Arrays;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B-\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lio/ktor/server/auth/UserHashedTableAuth;", "", "digester", "Lkotlin/Function1;", "", "", "table", "", "(Lkotlin/jvm/functions/Function1;Ljava/util/Map;)V", "getDigester", "()Lkotlin/jvm/functions/Function1;", "getTable", "()Ljava/util/Map;", "authenticate", "Lio/ktor/server/auth/UserIdPrincipal;", "credential", "Lio/ktor/server/auth/UserPasswordCredential;", "ktor-server-auth"})
public final class UserHashedTableAuth {
    @NotNull
    private final Function1<String, byte[]> digester;
    @NotNull
    private final Map<String, byte[]> table;

    public UserHashedTableAuth(@NotNull Function1<? super String, byte[]> digester, @NotNull Map<String, byte[]> table) {
        Intrinsics.checkNotNullParameter(digester, (String)"digester");
        Intrinsics.checkNotNullParameter(table, (String)"table");
        this.digester = digester;
        this.table = table;
        if (this.table.isEmpty()) {
            // empty if block
        }
    }

    @NotNull
    public final Function1<String, byte[]> getDigester() {
        return this.digester;
    }

    @NotNull
    public final Map<String, byte[]> getTable() {
        return this.table;
    }

    @Nullable
    public final UserIdPrincipal authenticate(@NotNull UserPasswordCredential credential) {
        Intrinsics.checkNotNullParameter((Object)credential, (String)"credential");
        byte[] userPasswordHash = this.table.get(credential.getName());
        if (userPasswordHash != null && Arrays.equals((byte[])this.digester.invoke((Object)credential.getPassword()), userPasswordHash)) {
            return new UserIdPrincipal(credential.getName());
        }
        return null;
    }
}

