/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.auth;

import io.ktor.server.application.ApplicationCall;
import io.ktor.server.auth.AuthenticationFailedCause;
import io.ktor.server.auth.AuthenticationProcedureChallenge;
import io.ktor.server.auth.CombinedPrincipal;
import io.ktor.server.auth.Principal;
import io.ktor.util.AttributeKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 72\u00020\u0001:\u00017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JH\u0010\u0017\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00012\u0006\u0010*\u001a\u00020\u00072(\u0010+\u001a$\b\u0001\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020(0-\u0012\u0006\u0012\u0004\u0018\u00010\u00010,\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010.J\u0016\u0010/\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00012\u0006\u0010*\u001a\u00020\u0007J\u000e\u0010\"\u001a\u00020(2\u0006\u0010\"\u001a\u00020!J(\u0010\"\u001a\u0004\u0018\u0001H0\"\n\b\u0000\u00100\u0018\u0001*\u00020!2\n\b\u0002\u00101\u001a\u0004\u0018\u000102H\u0086\b\u00a2\u0006\u0002\u00103J\u001a\u0010\"\u001a\u00020(2\n\b\u0002\u00101\u001a\u0004\u0018\u0001022\u0006\u0010\"\u001a\u00020!J/\u0010\"\u001a\u0004\u0018\u0001H0\"\b\b\u0000\u00100*\u00020!2\b\u00101\u001a\u0004\u0018\u0001022\f\u00104\u001a\b\u0012\u0004\u0012\u0002H005\u00a2\u0006\u0002\u00106R*\u0010\u0005\u001a\u001e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00070\u0006j\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u001e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR6\u0010\u001b\u001a\u001e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00070\u0006j\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0007`\b8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001fR.\u0010\"\u001a\u0004\u0018\u00010!2\b\u0010 \u001a\u0004\u0018\u00010!8F@FX\u0087\u000e\u00a2\u0006\u0012\u0012\u0004\b#\u0010\u001d\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00068"}, d2={"Lio/ktor/server/auth/AuthenticationContext;", "", "call", "Lio/ktor/server/application/ApplicationCall;", "(Lio/ktor/server/application/ApplicationCall;)V", "_errors", "Ljava/util/HashMap;", "Lio/ktor/server/auth/AuthenticationFailedCause;", "Lkotlin/collections/HashMap;", "_principal", "Lio/ktor/server/auth/CombinedPrincipal;", "get_principal$ktor_server_auth", "()Lio/ktor/server/auth/CombinedPrincipal;", "allErrors", "", "Lio/ktor/server/auth/AuthenticationFailedCause$Error;", "getAllErrors", "()Ljava/util/List;", "allFailures", "getAllFailures", "<set-?>", "getCall", "()Lio/ktor/server/application/ApplicationCall;", "challenge", "Lio/ktor/server/auth/AuthenticationProcedureChallenge;", "getChallenge", "()Lio/ktor/server/auth/AuthenticationProcedureChallenge;", "errors", "getErrors$annotations", "()V", "getErrors", "()Ljava/util/HashMap;", "value", "Lio/ktor/server/auth/Principal;", "principal", "getPrincipal$annotations", "getPrincipal", "()Lio/ktor/server/auth/Principal;", "setPrincipal", "(Lio/ktor/server/auth/Principal;)V", "", "key", "cause", "function", "Lkotlin/Function3;", "Lkotlin/coroutines/Continuation;", "(Ljava/lang/Object;Lio/ktor/server/auth/AuthenticationFailedCause;Lkotlin/jvm/functions/Function3;)V", "error", "T", "provider", "", "(Ljava/lang/String;)Lio/ktor/server/auth/Principal;", "klass", "Lkotlin/reflect/KClass;", "(Ljava/lang/String;Lkotlin/reflect/KClass;)Lio/ktor/server/auth/Principal;", "Companion", "ktor-server-auth"})
public final class AuthenticationContext {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private ApplicationCall call;
    @NotNull
    private final HashMap<Object, AuthenticationFailedCause> _errors;
    @NotNull
    private final CombinedPrincipal _principal;
    @NotNull
    private final AuthenticationProcedureChallenge challenge;
    @NotNull
    private static final AttributeKey<AuthenticationContext> AttributeKey = new AttributeKey("AuthContext");

    public AuthenticationContext(@NotNull ApplicationCall call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        this.call = call;
        this._errors = new HashMap();
        this._principal = new CombinedPrincipal();
        this.challenge = new AuthenticationProcedureChallenge();
    }

    @NotNull
    public final ApplicationCall getCall() {
        return this.call;
    }

    @NotNull
    public final CombinedPrincipal get_principal$ktor_server_auth() {
        return this._principal;
    }

    @Nullable
    public final Principal getPrincipal() {
        Pair pair = (Pair)CollectionsKt.firstOrNull(this._principal.getPrincipals());
        return pair != null ? (Principal)pair.getSecond() : null;
    }

    public final void setPrincipal(@Nullable Principal value) {
        if (!(value != null)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        this._principal.add(null, value);
    }

    @Deprecated(message="Use accessor methods instead", level=DeprecationLevel.WARNING)
    public static /* synthetic */ void getPrincipal$annotations() {
    }

    @NotNull
    public final HashMap<Object, AuthenticationFailedCause> getErrors() {
        return this._errors;
    }

    @Deprecated(message="Use allErrors, allFailures or error() function instead", level=DeprecationLevel.ERROR)
    public static /* synthetic */ void getErrors$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<AuthenticationFailedCause.Error> getAllErrors() {
        void $this$filterIsInstanceTo$iv$iv;
        Collection<AuthenticationFailedCause> collection = this._errors.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"_errors.values");
        Iterable $this$filterIsInstance$iv = collection;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof AuthenticationFailedCause.Error)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final List<AuthenticationFailedCause> getAllFailures() {
        Collection<AuthenticationFailedCause> collection = this._errors.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"_errors.values");
        return CollectionsKt.toList((Iterable)collection);
    }

    public final void error(@NotNull Object key, @NotNull AuthenticationFailedCause cause) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        ((Map)this._errors).put(key, cause);
    }

    @NotNull
    public final AuthenticationProcedureChallenge getChallenge() {
        return this.challenge;
    }

    public final void principal(@NotNull Principal principal2) {
        Intrinsics.checkNotNullParameter((Object)principal2, (String)"principal");
        this._principal.add(null, principal2);
    }

    public final void principal(@Nullable String provider, @NotNull Principal principal2) {
        Intrinsics.checkNotNullParameter((Object)principal2, (String)"principal");
        this._principal.add(provider, principal2);
    }

    public static /* synthetic */ void principal$default(AuthenticationContext authenticationContext, String string, Principal principal2, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        authenticationContext.principal(string, principal2);
    }

    public final /* synthetic */ <T extends Principal> T principal(String provider) {
        boolean $i$f$principal = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return this.principal(provider, Reflection.getOrCreateKotlinClass(Principal.class));
    }

    public static /* synthetic */ Principal principal$default(AuthenticationContext $this, String provider, int n, Object object) {
        if ((n & 1) != 0) {
            provider = null;
        }
        boolean $i$f$principal = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return $this.principal(provider, Reflection.getOrCreateKotlinClass(Principal.class));
    }

    @Nullable
    public final <T extends Principal> T principal(@Nullable String provider, @NotNull KClass<T> klass) {
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        return this._principal.get(provider, klass);
    }

    public final void challenge(@NotNull Object key, @NotNull AuthenticationFailedCause cause, @NotNull Function3<? super AuthenticationProcedureChallenge, ? super ApplicationCall, ? super Continuation<? super Unit>, ? extends Object> function) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        Intrinsics.checkNotNullParameter(function, (String)"function");
        this.error(key, cause);
        this.challenge.getRegister$ktor_server_auth().add((Pair<AuthenticationFailedCause, Function3<AuthenticationProcedureChallenge, ApplicationCall, Continuation<? super Unit>, Object>>)TuplesKt.to((Object)cause, function));
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\tR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lio/ktor/server/auth/AuthenticationContext$Companion;", "", "()V", "AttributeKey", "Lio/ktor/util/AttributeKey;", "Lio/ktor/server/auth/AuthenticationContext;", "from", "call", "Lio/ktor/server/application/ApplicationCall;", "from$ktor_server_auth", "ktor-server-auth"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AuthenticationContext from$ktor_server_auth(@NotNull ApplicationCall call) {
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            AuthenticationContext existingContext = (AuthenticationContext)call.getAttributes().getOrNull(AttributeKey);
            if (existingContext != null) {
                existingContext.call = call;
                return existingContext;
            }
            AuthenticationContext context = new AuthenticationContext(call);
            call.getAttributes().put(AttributeKey, (Object)context);
            return context;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

