/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.auth;

import io.ktor.util.internal.ExceptionUtilsJvmKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CopyableThrowable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00060\u0001j\u0002`\u0002:\u0005\t\n\u000b\f\rB\u0019\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0006R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u0082\u0001\u0005\u000e\u000f\u0010\u0011\u0012\u00a8\u0006\u0013"}, d2={"Lio/ktor/server/auth/OAuth2Exception;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "message", "", "errorCode", "(Ljava/lang/String;Ljava/lang/String;)V", "getErrorCode", "()Ljava/lang/String;", "InvalidGrant", "InvalidNonce", "MissingAccessToken", "UnknownException", "UnsupportedGrantType", "Lio/ktor/server/auth/OAuth2Exception$InvalidGrant;", "Lio/ktor/server/auth/OAuth2Exception$InvalidNonce;", "Lio/ktor/server/auth/OAuth2Exception$MissingAccessToken;", "Lio/ktor/server/auth/OAuth2Exception$UnknownException;", "Lio/ktor/server/auth/OAuth2Exception$UnsupportedGrantType;", "ktor-server-auth"})
public abstract class OAuth2Exception
extends Exception {
    @Nullable
    private final String errorCode;

    private OAuth2Exception(String message, String errorCode) {
        super(message);
        this.errorCode = errorCode;
    }

    @Nullable
    public final String getErrorCode() {
        return this.errorCode;
    }

    public /* synthetic */ OAuth2Exception(String message, String errorCode, DefaultConstructorMarker $constructor_marker) {
        this(message, errorCode);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lio/ktor/server/auth/OAuth2Exception$InvalidGrant;", "Lio/ktor/server/auth/OAuth2Exception;", "message", "", "(Ljava/lang/String;)V", "ktor-server-auth"})
    public static final class InvalidGrant
    extends OAuth2Exception {
        public InvalidGrant(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super(message, "invalid_grant", null);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lio/ktor/server/auth/OAuth2Exception$InvalidNonce;", "Lio/ktor/server/auth/OAuth2Exception;", "()V", "ktor-server-auth"})
    public static final class InvalidNonce
    extends OAuth2Exception {
        public InvalidNonce() {
            super("Nonce verification failed", null, null);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lio/ktor/server/auth/OAuth2Exception$MissingAccessToken;", "Lio/ktor/server/auth/OAuth2Exception;", "()V", "ktor-server-auth"})
    public static final class MissingAccessToken
    extends OAuth2Exception {
        public MissingAccessToken() {
            super("OAuth2 server response is OK neither error nor access token provided", null, null);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\u0000H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"Lio/ktor/server/auth/OAuth2Exception$UnsupportedGrantType;", "Lio/ktor/server/auth/OAuth2Exception;", "Lkotlinx/coroutines/CopyableThrowable;", "grantType", "", "(Ljava/lang/String;)V", "getGrantType", "()Ljava/lang/String;", "createCopy", "ktor-server-auth"})
    public static final class UnsupportedGrantType
    extends OAuth2Exception
    implements CopyableThrowable<UnsupportedGrantType> {
        @NotNull
        private final String grantType;

        public UnsupportedGrantType(@NotNull String grantType) {
            Intrinsics.checkNotNullParameter((Object)grantType, (String)"grantType");
            super("OAuth2 server doesn't support grant type " + grantType, "unsupported_grant_type", null);
            this.grantType = grantType;
        }

        @NotNull
        public final String getGrantType() {
            return this.grantType;
        }

        @NotNull
        public UnsupportedGrantType createCopy() {
            UnsupportedGrantType unsupportedGrantType;
            UnsupportedGrantType it = unsupportedGrantType = new UnsupportedGrantType(this.grantType);
            boolean bl = false;
            ExceptionUtilsJvmKt.initCauseBridge((Throwable)it, (Throwable)this);
            return unsupportedGrantType;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\u0000H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lio/ktor/server/auth/OAuth2Exception$UnknownException;", "Lio/ktor/server/auth/OAuth2Exception;", "Lkotlinx/coroutines/CopyableThrowable;", "details", "", "errorCode", "(Ljava/lang/String;Ljava/lang/String;)V", "createCopy", "ktor-server-auth"})
    public static final class UnknownException
    extends OAuth2Exception
    implements CopyableThrowable<UnknownException> {
        @NotNull
        private final String details;

        public UnknownException(@NotNull String details, @NotNull String errorCode) {
            Intrinsics.checkNotNullParameter((Object)details, (String)"details");
            Intrinsics.checkNotNullParameter((Object)errorCode, (String)"errorCode");
            super(details + " (error code = " + errorCode + ')', errorCode, null);
            this.details = details;
        }

        @NotNull
        public UnknownException createCopy() {
            UnknownException unknownException;
            String string = this.getErrorCode();
            Intrinsics.checkNotNull((Object)string);
            UnknownException it = unknownException = new UnknownException(this.details, string);
            boolean bl = false;
            ExceptionUtilsJvmKt.initCauseBridge((Throwable)it, (Throwable)this);
            return unknownException;
        }
    }
}

