/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.auth;

import io.ktor.server.auth.AuthenticationProvider;
import io.ktor.server.auth.DynamicProviderConfig;
import io.ktor.util.KtorDsl;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KtorDsl
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\u0016\b\u0002\u0010\u0002\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\r\u0010\n\u001a\u00020\u0000H\u0000\u00a2\u0006\u0002\b\u000bJ+\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u00042\u0017\u0010\u000f\u001a\u0013\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\r0\u0010\u00a2\u0006\u0002\b\u0012J\u000e\u0010\u0013\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u0005J\u0012\u0010\u0014\u001a\u00020\r2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0004H\u0002R\"\u0010\u0002\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u00050\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0016"}, d2={"Lio/ktor/server/auth/AuthenticationConfig;", "", "providers", "", "", "Lio/ktor/server/auth/AuthenticationProvider;", "(Ljava/util/Map;)V", "", "getProviders$ktor_server_auth", "()Ljava/util/Map;", "copy", "copy$ktor_server_auth", "provider", "", "name", "configure", "Lkotlin/Function1;", "Lio/ktor/server/auth/DynamicProviderConfig;", "Lkotlin/ExtensionFunctionType;", "register", "requireProviderNotRegistered", "providerName", "ktor-server-auth"})
public final class AuthenticationConfig {
    @NotNull
    private final Map<String, AuthenticationProvider> providers;

    public AuthenticationConfig(@NotNull Map<String, ? extends AuthenticationProvider> providers) {
        Intrinsics.checkNotNullParameter(providers, (String)"providers");
        this.providers = MapsKt.toMutableMap(providers);
    }

    public /* synthetic */ AuthenticationConfig(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            map = MapsKt.emptyMap();
        }
        this(map);
    }

    @NotNull
    public final Map<String, AuthenticationProvider> getProviders$ktor_server_auth() {
        return this.providers;
    }

    public final void provider(@Nullable String name, @NotNull Function1<? super DynamicProviderConfig, Unit> configure) {
        Intrinsics.checkNotNullParameter(configure, (String)"configure");
        this.requireProviderNotRegistered(name);
        DynamicProviderConfig dynamicProviderConfig = new DynamicProviderConfig(name);
        configure.invoke((Object)dynamicProviderConfig);
        DynamicProviderConfig configuration = dynamicProviderConfig;
        AuthenticationProvider provider = configuration.buildProvider$ktor_server_auth();
        this.providers.put(provider.getName(), provider);
    }

    public static /* synthetic */ void provider$default(AuthenticationConfig authenticationConfig, String string, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        authenticationConfig.provider(string, (Function1<? super DynamicProviderConfig, Unit>)function1);
    }

    public final void register(@NotNull AuthenticationProvider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        this.requireProviderNotRegistered(provider.getName());
        this.providers.put(provider.getName(), provider);
    }

    private final void requireProviderNotRegistered(String providerName) {
        if (this.providers.containsKey(providerName)) {
            throw new IllegalArgumentException("Provider with the name " + providerName + " is already registered");
        }
    }

    @NotNull
    public final AuthenticationConfig copy$ktor_server_auth() {
        return new AuthenticationConfig(this.providers);
    }

    public AuthenticationConfig() {
        this(null, 1, null);
    }
}

