/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.auth.jwt;

import com.auth0.jwk.Jwk;
import com.auth0.jwk.JwkException;
import com.auth0.jwk.JwkProvider;
import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.impl.JWTParser;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.auth0.jwt.interfaces.JWTVerifier;
import com.auth0.jwt.interfaces.Payload;
import com.auth0.jwt.interfaces.Verification;
import io.ktor.http.auth.HttpAuthHeader;
import io.ktor.server.application.ApplicationCall;
import io.ktor.server.auth.AuthenticationContext;
import io.ktor.server.auth.AuthenticationFailedCause;
import io.ktor.server.auth.AuthenticationProcedureChallenge;
import io.ktor.server.auth.HeadersKt;
import io.ktor.server.auth.Principal;
import io.ktor.server.auth.jwt.JWTAuthKt;
import io.ktor.server.auth.jwt.JWTAuthSchemes;
import io.ktor.server.auth.jwt.JWTChallengeContext;
import io.ktor.server.auth.jwt.JWTCredential;
import io.ktor.server.request.ApplicationRequest;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u0092\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a?\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u001b\u0010\b\u001a\u0017\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tj\u0002`\f\u00a2\u0006\u0002\b\rH\u0000\u001aE\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0017\u0010\u0010\u001a\u0013\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0002\b\rH\u0000\u001af\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072/\u0010\u0016\u001a+\b\u0001\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0018\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u0017\u00a2\u0006\u0002\b\rH\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001b\u001a\u007f\u0010\u001c\u001a\u00020\u000b*\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072Q\u0010!\u001aM\b\u0001\u0012\u0004\u0012\u00020#\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b(&\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b( \u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\"\u00a2\u0006\u0002\b\rH\u0000\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010'\u001a\u0016\u0010(\u001a\u0004\u0018\u00010\u000f*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\f\u0010)\u001a\u00020**\u00020+H\u0000\u001a\u000e\u0010,\u001a\u0004\u0018\u00010\u0005*\u00020-H\u0000\u001a\f\u0010.\u001a\u00020/*\u000200H\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00061"}, d2={"getVerifier", "Lcom/auth0/jwt/interfaces/JWTVerifier;", "jwkProvider", "Lcom/auth0/jwk/JwkProvider;", "token", "Lio/ktor/http/auth/HttpAuthHeader;", "schemes", "Lio/ktor/server/auth/jwt/JWTAuthSchemes;", "configure", "Lkotlin/Function1;", "Lcom/auth0/jwt/interfaces/Verification;", "", "Lio/ktor/server/auth/jwt/JWTConfigureFunction;", "Lkotlin/ExtensionFunctionType;", "issuer", "", "jwtConfigure", "verifyAndValidate", "Lio/ktor/server/auth/Principal;", "call", "Lio/ktor/server/application/ApplicationCall;", "jwtVerifier", "validate", "Lkotlin/Function3;", "Lio/ktor/server/auth/jwt/JWTCredential;", "Lkotlin/coroutines/Continuation;", "", "(Lio/ktor/server/application/ApplicationCall;Lcom/auth0/jwt/interfaces/JWTVerifier;Lio/ktor/http/auth/HttpAuthHeader;Lio/ktor/server/auth/jwt/JWTAuthSchemes;Lkotlin/jvm/functions/Function3;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "bearerChallenge", "Lio/ktor/server/auth/AuthenticationContext;", "cause", "Lio/ktor/server/auth/AuthenticationFailedCause;", "realm", "challengeFunction", "Lkotlin/Function4;", "Lio/ktor/server/auth/jwt/JWTChallengeContext;", "Lkotlin/ParameterName;", "name", "defaultScheme", "(Lio/ktor/server/auth/AuthenticationContext;Lio/ktor/server/auth/AuthenticationFailedCause;Ljava/lang/String;Lio/ktor/server/auth/jwt/JWTAuthSchemes;Lkotlin/jvm/functions/Function4;)V", "getBlob", "makeAlgorithm", "Lcom/auth0/jwt/algorithms/Algorithm;", "Lcom/auth0/jwk/Jwk;", "parseAuthorizationHeaderOrNull", "Lio/ktor/server/request/ApplicationRequest;", "parsePayload", "Lcom/auth0/jwt/interfaces/Payload;", "Lcom/auth0/jwt/interfaces/DecodedJWT;", "ktor-server-auth-jwt"})
public final class JWTUtilsKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static final Algorithm makeAlgorithm(@NotNull Jwk $this$makeAlgorithm) {
        Algorithm algorithm;
        block20: {
            block24: {
                block21: {
                    block23: {
                        block25: {
                            block22: {
                                String string;
                                Intrinsics.checkNotNullParameter((Object)$this$makeAlgorithm, (String)"<this>");
                                String string2 = string = $this$makeAlgorithm.getAlgorithm();
                                if (string2 == null) break block20;
                                switch (string2.hashCode()) {
                                    case 66246401: {
                                        if (!string.equals("ES384")) {
                                            throw new IllegalArgumentException("Unsupported algorithm " + $this$makeAlgorithm.getAlgorithm());
                                        }
                                        break block21;
                                    }
                                    case 78252174: {
                                        if (!string.equals("RS384")) {
                                            throw new IllegalArgumentException("Unsupported algorithm " + $this$makeAlgorithm.getAlgorithm());
                                        }
                                        break block22;
                                    }
                                    case 66245349: {
                                        if (!string.equals("ES256")) {
                                            throw new IllegalArgumentException("Unsupported algorithm " + $this$makeAlgorithm.getAlgorithm());
                                        }
                                        break block23;
                                    }
                                    case 78251122: {
                                        if (string.equals("RS256")) break;
                                        throw new IllegalArgumentException("Unsupported algorithm " + $this$makeAlgorithm.getAlgorithm());
                                    }
                                    case 66248104: {
                                        if (!string.equals("ES512")) {
                                            throw new IllegalArgumentException("Unsupported algorithm " + $this$makeAlgorithm.getAlgorithm());
                                        }
                                        break block24;
                                    }
                                    case 78253877: {
                                        if (!string.equals("RS512")) {
                                            throw new IllegalArgumentException("Unsupported algorithm " + $this$makeAlgorithm.getAlgorithm());
                                        }
                                        break block25;
                                    }
                                }
                                PublicKey publicKey = $this$makeAlgorithm.getPublicKey();
                                if (publicKey == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type java.security.interfaces.RSAPublicKey");
                                }
                                Algorithm algorithm2 = Algorithm.RSA256((RSAPublicKey)((RSAPublicKey)publicKey), null);
                                algorithm = algorithm2;
                                Intrinsics.checkNotNullExpressionValue((Object)algorithm2, (String)"RSA256(publicKey as RSAPublicKey, null)");
                                return algorithm;
                            }
                            PublicKey publicKey = $this$makeAlgorithm.getPublicKey();
                            if (publicKey == null) {
                                throw new NullPointerException("null cannot be cast to non-null type java.security.interfaces.RSAPublicKey");
                            }
                            Algorithm algorithm3 = Algorithm.RSA384((RSAPublicKey)((RSAPublicKey)publicKey), null);
                            algorithm = algorithm3;
                            Intrinsics.checkNotNullExpressionValue((Object)algorithm3, (String)"RSA384(publicKey as RSAPublicKey, null)");
                            return algorithm;
                        }
                        PublicKey publicKey = $this$makeAlgorithm.getPublicKey();
                        if (publicKey == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.security.interfaces.RSAPublicKey");
                        }
                        Algorithm algorithm4 = Algorithm.RSA512((RSAPublicKey)((RSAPublicKey)publicKey), null);
                        algorithm = algorithm4;
                        Intrinsics.checkNotNullExpressionValue((Object)algorithm4, (String)"RSA512(publicKey as RSAPublicKey, null)");
                        return algorithm;
                    }
                    PublicKey publicKey = $this$makeAlgorithm.getPublicKey();
                    if (publicKey == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.security.interfaces.ECPublicKey");
                    }
                    Algorithm algorithm5 = Algorithm.ECDSA256((ECPublicKey)((ECPublicKey)publicKey), null);
                    algorithm = algorithm5;
                    Intrinsics.checkNotNullExpressionValue((Object)algorithm5, (String)"ECDSA256(publicKey as ECPublicKey, null)");
                    return algorithm;
                }
                PublicKey publicKey = $this$makeAlgorithm.getPublicKey();
                if (publicKey == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.security.interfaces.ECPublicKey");
                }
                Algorithm algorithm6 = Algorithm.ECDSA384((ECPublicKey)((ECPublicKey)publicKey), null);
                algorithm = algorithm6;
                Intrinsics.checkNotNullExpressionValue((Object)algorithm6, (String)"ECDSA384(publicKey as ECPublicKey, null)");
                return algorithm;
            }
            PublicKey publicKey = $this$makeAlgorithm.getPublicKey();
            if (publicKey == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.security.interfaces.ECPublicKey");
            }
            Algorithm algorithm7 = Algorithm.ECDSA512((ECPublicKey)((ECPublicKey)publicKey), null);
            algorithm = algorithm7;
            Intrinsics.checkNotNullExpressionValue((Object)algorithm7, (String)"ECDSA512(publicKey as ECPublicKey, null)");
            return algorithm;
        }
        PublicKey publicKey = $this$makeAlgorithm.getPublicKey();
        if (publicKey == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.security.interfaces.RSAPublicKey");
        }
        Algorithm algorithm8 = Algorithm.RSA256((RSAPublicKey)((RSAPublicKey)publicKey), null);
        algorithm = algorithm8;
        Intrinsics.checkNotNullExpressionValue((Object)algorithm8, (String)"RSA256(publicKey as RSAPublicKey, null)");
        return algorithm;
        throw new IllegalArgumentException("Unsupported algorithm " + $this$makeAlgorithm.getAlgorithm());
    }

    public static final void bearerChallenge(@NotNull AuthenticationContext $this$bearerChallenge, @NotNull AuthenticationFailedCause cause, @NotNull String realm, @NotNull JWTAuthSchemes schemes, @NotNull Function4<? super JWTChallengeContext, ? super String, ? super String, ? super Continuation<? super Unit>, ? extends Object> challengeFunction) {
        Intrinsics.checkNotNullParameter((Object)$this$bearerChallenge, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        Intrinsics.checkNotNullParameter((Object)realm, (String)"realm");
        Intrinsics.checkNotNullParameter((Object)schemes, (String)"schemes");
        Intrinsics.checkNotNullParameter(challengeFunction, (String)"challengeFunction");
        $this$bearerChallenge.challenge(JWTAuthKt.getJWTAuthKey(), cause, (Function3)new Function3<AuthenticationProcedureChallenge, ApplicationCall, Continuation<? super Unit>, Object>(challengeFunction, schemes, realm, null){
            int label;
            /* synthetic */ Object L$0;
            /* synthetic */ Object L$1;
            final /* synthetic */ Function4<JWTChallengeContext, String, String, Continuation<? super Unit>, Object> $challengeFunction;
            final /* synthetic */ JWTAuthSchemes $schemes;
            final /* synthetic */ String $realm;
            {
                this.$challengeFunction = $challengeFunction;
                this.$schemes = $schemes;
                this.$realm = $realm;
                super(3, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        challenge = (AuthenticationProcedureChallenge)this.L$0;
                        call = (ApplicationCall)this.L$1;
                        this.L$0 = challenge;
                        this.L$1 = call;
                        this.label = 1;
                        v0 = this.$challengeFunction.invoke((Object)new JWTChallengeContext(call), (Object)this.$schemes.getDefaultScheme(), (Object)this.$realm, (Object)this);
                        if (v0 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl19
                    }
                    case 1: {
                        call = (ApplicationCall)this.L$1;
                        challenge = (AuthenticationProcedureChallenge)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl19:
                        // 2 sources

                        if (!challenge.getCompleted() && call.getResponse().status() != null) {
                            challenge.complete();
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @Nullable
            public final Object invoke(@NotNull AuthenticationProcedureChallenge p1, @NotNull ApplicationCall p2, @Nullable Continuation<? super Unit> p3) {
                Function3<AuthenticationProcedureChallenge, ApplicationCall, Continuation<? super Unit>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                function3.L$0 = p1;
                function3.L$1 = p2;
                return function3.invokeSuspend((Object)Unit.INSTANCE);
            }
        });
    }

    @Nullable
    public static final JWTVerifier getVerifier(@NotNull JwkProvider jwkProvider, @Nullable String issuer, @NotNull HttpAuthHeader token, @NotNull JWTAuthSchemes schemes, @NotNull Function1<? super Verification, Unit> jwtConfigure) {
        Algorithm algorithm;
        String string;
        block10: {
            block9: {
                Jwk jwk;
                Intrinsics.checkNotNullParameter((Object)jwkProvider, (String)"jwkProvider");
                Intrinsics.checkNotNullParameter((Object)token, (String)"token");
                Intrinsics.checkNotNullParameter((Object)schemes, (String)"schemes");
                Intrinsics.checkNotNullParameter(jwtConfigure, (String)"jwtConfigure");
                string = JWTUtilsKt.getBlob(token, schemes);
                if (string == null) break block9;
                String blob = string;
                boolean bl = false;
                try {
                    jwk = jwkProvider.get(JWT.decode((String)blob).getKeyId());
                }
                catch (JwkException cause) {
                    JWTAuthKt.getJWTLogger().trace("Failed to get JWK", (Throwable)cause);
                    jwk = null;
                }
                catch (JWTDecodeException cause) {
                    JWTAuthKt.getJWTLogger().trace("Illegal JWT", (Throwable)cause);
                    jwk = null;
                }
                Jwk jwk2 = jwk;
                string = jwk2;
                if (jwk2 != null) break block10;
            }
            return null;
        }
        String jwk = string;
        try {
            algorithm = JWTUtilsKt.makeAlgorithm((Jwk)jwk);
        }
        catch (Throwable cause) {
            Logger logger = JWTAuthKt.getJWTLogger();
            String string2 = jwk.getAlgorithm();
            String string3 = cause.getMessage();
            if (string3 == null) {
                string3 = cause.getClass().getSimpleName();
            }
            logger.trace("Failed to create algorithm {}: {}", (Object)string2, (Object)string3);
            return null;
        }
        Algorithm algorithm2 = algorithm;
        algorithm = issuer == null ? JWT.require((Algorithm)algorithm2) : JWT.require((Algorithm)algorithm2).withIssuer(issuer);
        jwtConfigure.invoke((Object)algorithm);
        return (JWTVerifier)algorithm.build();
    }

    @Nullable
    public static final JWTVerifier getVerifier(@NotNull JwkProvider jwkProvider, @NotNull HttpAuthHeader token, @NotNull JWTAuthSchemes schemes, @NotNull Function1<? super Verification, Unit> configure) {
        Intrinsics.checkNotNullParameter((Object)jwkProvider, (String)"jwkProvider");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)schemes, (String)"schemes");
        Intrinsics.checkNotNullParameter(configure, (String)"configure");
        return JWTUtilsKt.getVerifier(jwkProvider, null, token, schemes, configure);
    }

    @Nullable
    public static final Object verifyAndValidate(@NotNull ApplicationCall call, @Nullable JWTVerifier jwtVerifier, @NotNull HttpAuthHeader token, @NotNull JWTAuthSchemes schemes, @NotNull Function3<? super ApplicationCall, ? super JWTCredential, ? super Continuation<? super Principal>, ? extends Object> validate, @NotNull Continuation<? super Principal> $completion) {
        DecodedJWT decodedJWT;
        try {
            Object object;
            String string = JWTUtilsKt.getBlob(token, schemes);
            if (string != null) {
                String it = string;
                boolean bl = false;
                JWTVerifier jWTVerifier = jwtVerifier;
                object = jWTVerifier != null ? jWTVerifier.verify(it) : null;
            } else {
                object = null;
            }
            decodedJWT = object;
        }
        catch (JWTVerificationException cause) {
            JWTAuthKt.getJWTLogger().trace("Token verification failed", (Throwable)cause);
            decodedJWT = null;
        }
        DecodedJWT decodedJWT2 = decodedJWT;
        if (decodedJWT2 == null) {
            return null;
        }
        DecodedJWT jwt = decodedJWT2;
        Payload payload = JWTUtilsKt.parsePayload(jwt);
        JWTCredential credentials = new JWTCredential(payload);
        return validate.invoke((Object)call, (Object)credentials, $completion);
    }

    @Nullable
    public static final String getBlob(@NotNull HttpAuthHeader $this$getBlob, @NotNull JWTAuthSchemes schemes) {
        Intrinsics.checkNotNullParameter((Object)$this$getBlob, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)schemes, (String)"schemes");
        return $this$getBlob instanceof HttpAuthHeader.Single && schemes.contains($this$getBlob.getAuthScheme()) ? ((HttpAuthHeader.Single)$this$getBlob).getBlob() : null;
    }

    @Nullable
    public static final HttpAuthHeader parseAuthorizationHeaderOrNull(@NotNull ApplicationRequest $this$parseAuthorizationHeaderOrNull) {
        HttpAuthHeader httpAuthHeader;
        Intrinsics.checkNotNullParameter((Object)$this$parseAuthorizationHeaderOrNull, (String)"<this>");
        try {
            httpAuthHeader = HeadersKt.parseAuthorizationHeader((ApplicationRequest)$this$parseAuthorizationHeaderOrNull);
        }
        catch (IllegalArgumentException cause) {
            JWTAuthKt.getJWTLogger().trace("Illegal HTTP auth header", (Throwable)cause);
            httpAuthHeader = null;
        }
        return httpAuthHeader;
    }

    @NotNull
    public static final Payload parsePayload(@NotNull DecodedJWT $this$parsePayload) {
        Intrinsics.checkNotNullParameter((Object)$this$parsePayload, (String)"<this>");
        byte[] byArray = Base64.getUrlDecoder().decode($this$parsePayload.getPayload());
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getUrlDecoder().decode(payload)");
        byte[] byArray2 = byArray;
        String payloadString = new String(byArray2, Charsets.UTF_8);
        Payload payload = new JWTParser().parsePayload(payloadString);
        Intrinsics.checkNotNullExpressionValue((Object)payload, (String)"JWTParser().parsePayload(payloadString)");
        return payload;
    }
}

