/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.cio;

import io.ktor.http.HttpMethod;
import io.ktor.http.RequestConnectionPoint;
import io.ktor.http.URLProtocol;
import io.ktor.util.network.NetworkAddressJvmKt;
import java.net.SocketAddress;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b!\b\u0000\u0018\u00002\u00020\u0001BG\u0012\u000e\u0010\u0002\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u0004\u0012\u000e\u0010\u0005\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010.\u001a\u00020\u0007H\u0016R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u00078VX\u0097\u0004\u00a2\u0006\f\u0012\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013R\u0014\u0010\u0016\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0013R\u0016\u0010\u0005\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u000e8VX\u0097\u0004\u00a2\u0006\f\u0012\u0004\b\u001e\u0010\u0011\u001a\u0004\b\u001f\u0010\u001aR\u0014\u0010 \u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0013R\u0014\u0010\"\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0013R\u0016\u0010\u0002\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u001aR\u0014\u0010&\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0013R\u0014\u0010(\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0013R\u0014\u0010*\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u001aR\u0014\u0010\b\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\u0013R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\u0013\u00a8\u0006/"}, d2={"Lio/ktor/server/cio/CIOConnectionPoint;", "Lio/ktor/http/RequestConnectionPoint;", "remoteNetworkAddress", "Ljava/net/SocketAddress;", "Lio/ktor/util/network/NetworkAddress;", "localNetworkAddress", "version", "", "uri", "hostHeaderValue", "method", "Lio/ktor/http/HttpMethod;", "(Ljava/net/SocketAddress;Ljava/net/SocketAddress;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lio/ktor/http/HttpMethod;)V", "defaultPort", "", "host", "getHost$annotations", "()V", "getHost", "()Ljava/lang/String;", "localAddress", "getLocalAddress", "localHost", "getLocalHost", "localPort", "getLocalPort", "()I", "getMethod", "()Lio/ktor/http/HttpMethod;", "port", "getPort$annotations", "getPort", "remoteAddress", "getRemoteAddress", "remoteHost", "getRemoteHost", "remotePort", "getRemotePort", "scheme", "getScheme", "serverHost", "getServerHost", "serverPort", "getServerPort", "getUri", "getVersion", "toString", "ktor-server-cio"})
public final class CIOConnectionPoint
implements RequestConnectionPoint {
    @Nullable
    private final SocketAddress remoteNetworkAddress;
    @Nullable
    private final SocketAddress localNetworkAddress;
    @NotNull
    private final String version;
    @NotNull
    private final String uri;
    @Nullable
    private final String hostHeaderValue;
    @NotNull
    private final HttpMethod method;
    private final int defaultPort;

    public CIOConnectionPoint(@Nullable SocketAddress remoteNetworkAddress, @Nullable SocketAddress localNetworkAddress, @NotNull String version, @NotNull String uri, @Nullable String hostHeaderValue, @NotNull HttpMethod method) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        this.remoteNetworkAddress = remoteNetworkAddress;
        this.localNetworkAddress = localNetworkAddress;
        this.version = version;
        this.uri = uri;
        this.hostHeaderValue = hostHeaderValue;
        this.method = method;
        this.defaultPort = URLProtocol.Companion.createOrDefault(this.getScheme()).getDefaultPort();
    }

    @NotNull
    public String getVersion() {
        return this.version;
    }

    @NotNull
    public String getUri() {
        return this.uri;
    }

    @NotNull
    public HttpMethod getMethod() {
        return this.method;
    }

    @NotNull
    public String getScheme() {
        return "http";
    }

    @NotNull
    public String getHost() {
        Object object = this.localNetworkAddress;
        if (object == null || (object = NetworkAddressJvmKt.getHostname((SocketAddress)object)) == null) {
            String string = this.hostHeaderValue;
            object = string != null ? StringsKt.substringBefore$default((String)string, (String)":", null, (int)2, null) : "localhost";
        }
        return object;
    }

    @Deprecated(message="Use localPort or serverPort instead")
    public static /* synthetic */ void getHost$annotations() {
    }

    public int getPort() {
        String string;
        SocketAddress socketAddress = this.localNetworkAddress;
        return socketAddress != null ? NetworkAddressJvmKt.getPort((SocketAddress)socketAddress) : ((string = this.hostHeaderValue) != null && (string = StringsKt.substringAfter((String)string, (String)":", (String)"80")) != null ? Integer.parseInt(string) : 80);
    }

    @Deprecated(message="Use localPort or serverPort instead")
    public static /* synthetic */ void getPort$annotations() {
    }

    public int getLocalPort() {
        SocketAddress socketAddress = this.localNetworkAddress;
        return socketAddress != null ? NetworkAddressJvmKt.getPort((SocketAddress)socketAddress) : this.defaultPort;
    }

    public int getServerPort() {
        String string;
        String string2 = this.hostHeaderValue;
        return string2 != null && (string = StringsKt.substringAfter((String)string2, (String)":", (String)String.valueOf(this.defaultPort))) != null ? Integer.parseInt(string) : this.getLocalPort();
    }

    @NotNull
    public String getLocalHost() {
        Object object = this.localNetworkAddress;
        if (object == null || (object = NetworkAddressJvmKt.getHostname((SocketAddress)object)) == null) {
            object = "localhost";
        }
        return object;
    }

    @NotNull
    public String getServerHost() {
        String string = this.hostHeaderValue;
        if (string == null || (string = StringsKt.substringBefore$default((String)string, (String)":", null, (int)2, null)) == null) {
            string = this.getLocalHost();
        }
        return string;
    }

    @NotNull
    public String getLocalAddress() {
        Object object = this.localNetworkAddress;
        if (object == null || (object = NetworkAddressJvmKt.getAddress((SocketAddress)object)) == null) {
            object = "localhost";
        }
        return object;
    }

    @NotNull
    public String getRemoteHost() {
        Object object = this.remoteNetworkAddress;
        if (object == null || (object = NetworkAddressJvmKt.getHostname((SocketAddress)object)) == null) {
            object = "unknown";
        }
        return object;
    }

    public int getRemotePort() {
        SocketAddress socketAddress = this.remoteNetworkAddress;
        return socketAddress != null ? NetworkAddressJvmKt.getPort((SocketAddress)socketAddress) : 0;
    }

    @NotNull
    public String getRemoteAddress() {
        Object object = this.remoteNetworkAddress;
        if (object == null || (object = NetworkAddressJvmKt.getAddress((SocketAddress)object)) == null) {
            object = "unknown";
        }
        return object;
    }

    @NotNull
    public String toString() {
        return "CIOConnectionPoint(uri=" + this.getUri() + ", method=" + this.getMethod() + ", version=" + this.getVersion() + ", localAddress=" + this.getLocalAddress() + ", localPort=" + this.getLocalPort() + ", remoteAddress=" + this.getRemoteAddress() + ", remotePort=" + this.getRemotePort() + ')';
    }
}

