/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.plugins.compression;

import io.ktor.http.ContentType;
import io.ktor.http.HttpHeaders;
import io.ktor.http.content.OutgoingContent;
import io.ktor.server.application.ApplicationCall;
import io.ktor.server.plugins.compression.CompressionConfig;
import io.ktor.server.plugins.compression.CompressionEncoderBuilder;
import io.ktor.server.plugins.compression.ConditionsHolderBuilder;
import io.ktor.server.plugins.compression.ConfigKt;
import io.ktor.server.plugins.compression.DeflateEncoder;
import io.ktor.server.plugins.compression.GzipEncoder;
import io.ktor.server.plugins.compression.IdentityEncoder;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0000\u001a)\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u001d\u0010\u0003\u001a\u0019\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0004\u00a2\u0006\u0002\b\b\u001a\f\u0010\t\u001a\u00020\u0001*\u00020\u0002H\u0002\u001a%\u0010\n\u001a\u00020\u0001*\u00020\u000b2\u0019\b\u0002\u0010\f\u001a\u0013\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00010\r\u00a2\u0006\u0002\b\b\u001a#\u0010\u000f\u001a\u00020\u0001*\u00020\u00022\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0011\"\u00020\u0012\u00a2\u0006\u0002\u0010\u0013\u001a%\u0010\u0014\u001a\u00020\u0001*\u00020\u000b2\u0019\b\u0002\u0010\f\u001a\u0013\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00010\r\u00a2\u0006\u0002\b\b\u001a%\u0010\u0015\u001a\u00020\u0001*\u00020\u000b2\u0019\b\u0002\u0010\f\u001a\u0013\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00010\r\u00a2\u0006\u0002\b\b\u001a#\u0010\u0016\u001a\u00020\u0001*\u00020\u00022\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0011\"\u00020\u0012\u00a2\u0006\u0002\u0010\u0013\u001a\u0012\u0010\u0017\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0019\u00a8\u0006\u001a"}, d2={"condition", "", "Lio/ktor/server/plugins/compression/ConditionsHolderBuilder;", "predicate", "Lkotlin/Function2;", "Lio/ktor/server/application/ApplicationCall;", "Lio/ktor/http/content/OutgoingContent;", "", "Lkotlin/ExtensionFunctionType;", "defaultConditions", "deflate", "Lio/ktor/server/plugins/compression/CompressionConfig;", "block", "Lkotlin/Function1;", "Lio/ktor/server/plugins/compression/CompressionEncoderBuilder;", "excludeContentType", "mimeTypes", "", "Lio/ktor/http/ContentType;", "(Lio/ktor/server/plugins/compression/ConditionsHolderBuilder;[Lio/ktor/http/ContentType;)V", "gzip", "identity", "matchContentType", "minimumSize", "minSize", "", "ktor-server-compression"})
public final class ConfigKt {
    public static final void gzip(@NotNull CompressionConfig $this$gzip, @NotNull Function1<? super CompressionEncoderBuilder, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$gzip, (String)"<this>");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        $this$gzip.encoder("gzip", GzipEncoder.INSTANCE, block);
    }

    public static /* synthetic */ void gzip$default(CompressionConfig compressionConfig, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = gzip.1.INSTANCE;
        }
        ConfigKt.gzip(compressionConfig, (Function1<? super CompressionEncoderBuilder, Unit>)function1);
    }

    public static final void deflate(@NotNull CompressionConfig $this$deflate, @NotNull Function1<? super CompressionEncoderBuilder, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$deflate, (String)"<this>");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        $this$deflate.encoder("deflate", DeflateEncoder.INSTANCE, (Function1<? super CompressionEncoderBuilder, Unit>)((Function1)new Function1<CompressionEncoderBuilder, Unit>(block){
            final /* synthetic */ Function1<CompressionEncoderBuilder, Unit> $block;
            {
                this.$block = $block;
                super(1);
            }

            public final void invoke(@NotNull CompressionEncoderBuilder $this$encoder) {
                Intrinsics.checkNotNullParameter((Object)$this$encoder, (String)"$this$encoder");
                $this$encoder.setPriority(0.9);
                this.$block.invoke((Object)$this$encoder);
            }
        }));
    }

    public static /* synthetic */ void deflate$default(CompressionConfig compressionConfig, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = deflate.1.INSTANCE;
        }
        ConfigKt.deflate(compressionConfig, (Function1<? super CompressionEncoderBuilder, Unit>)function1);
    }

    public static final void identity(@NotNull CompressionConfig $this$identity, @NotNull Function1<? super CompressionEncoderBuilder, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$identity, (String)"<this>");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        $this$identity.encoder("identity", IdentityEncoder.INSTANCE, block);
    }

    public static /* synthetic */ void identity$default(CompressionConfig compressionConfig, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = identity.1.INSTANCE;
        }
        ConfigKt.identity(compressionConfig, (Function1<? super CompressionEncoderBuilder, Unit>)function1);
    }

    public static final void condition(@NotNull ConditionsHolderBuilder $this$condition, @NotNull Function2<? super ApplicationCall, ? super OutgoingContent, Boolean> predicate) {
        Intrinsics.checkNotNullParameter((Object)$this$condition, (String)"<this>");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        $this$condition.getConditions().add(predicate);
    }

    public static final void minimumSize(@NotNull ConditionsHolderBuilder $this$minimumSize, long minSize) {
        Intrinsics.checkNotNullParameter((Object)$this$minimumSize, (String)"<this>");
        ConfigKt.condition($this$minimumSize, (Function2<? super ApplicationCall, ? super OutgoingContent, Boolean>)((Function2)new Function2<ApplicationCall, OutgoingContent, Boolean>(minSize){
            final /* synthetic */ long $minSize;
            {
                this.$minSize = $minSize;
                super(2);
            }

            @NotNull
            public final Boolean invoke(@NotNull ApplicationCall $this$condition, @NotNull OutgoingContent content) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)$this$condition, (String)"$this$condition");
                Intrinsics.checkNotNullParameter((Object)content, (String)"content");
                Long l = content.getContentLength();
                if (l != null) {
                    Long l2 = l;
                    long l3 = this.$minSize;
                    long it = ((Number)l2).longValue();
                    boolean bl2 = false;
                    bl = it >= l3;
                } else {
                    bl = true;
                }
                return bl;
            }
        }));
    }

    public static final void matchContentType(@NotNull ConditionsHolderBuilder $this$matchContentType, ContentType ... mimeTypes) {
        Intrinsics.checkNotNullParameter((Object)$this$matchContentType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)mimeTypes, (String)"mimeTypes");
        ConfigKt.condition($this$matchContentType, (Function2<? super ApplicationCall, ? super OutgoingContent, Boolean>)((Function2)new Function2<ApplicationCall, OutgoingContent, Boolean>(mimeTypes){
            final /* synthetic */ ContentType[] $mimeTypes;
            {
                this.$mimeTypes = $mimeTypes;
                super(2);
            }

            @NotNull
            public final Boolean invoke(@NotNull ApplicationCall $this$condition, @NotNull OutgoingContent content) {
                boolean bl;
                block2: {
                    Intrinsics.checkNotNullParameter((Object)$this$condition, (String)"$this$condition");
                    Intrinsics.checkNotNullParameter((Object)content, (String)"content");
                    ContentType contentType = content.getContentType();
                    if (contentType == null) {
                        return false;
                    }
                    ContentType contentType2 = contentType;
                    ContentType[] $this$any$iv = this.$mimeTypes;
                    boolean $i$f$any = false;
                    int n = $this$any$iv.length;
                    for (int i = 0; i < n; ++i) {
                        ContentType element$iv;
                        ContentType it = element$iv = $this$any$iv[i];
                        boolean bl2 = false;
                        if (!contentType2.match(it)) continue;
                        bl = true;
                        break block2;
                    }
                    bl = false;
                }
                return bl;
            }
        }));
    }

    public static final void excludeContentType(@NotNull ConditionsHolderBuilder $this$excludeContentType, ContentType ... mimeTypes) {
        Intrinsics.checkNotNullParameter((Object)$this$excludeContentType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)mimeTypes, (String)"mimeTypes");
        ConfigKt.condition($this$excludeContentType, (Function2<? super ApplicationCall, ? super OutgoingContent, Boolean>)((Function2)new Function2<ApplicationCall, OutgoingContent, Boolean>(mimeTypes){
            final /* synthetic */ ContentType[] $mimeTypes;
            {
                this.$mimeTypes = $mimeTypes;
                super(2);
            }

            @NotNull
            public final Boolean invoke(@NotNull ApplicationCall $this$condition, @NotNull OutgoingContent content) {
                boolean bl;
                block5: {
                    Intrinsics.checkNotNullParameter((Object)$this$condition, (String)"$this$condition");
                    Intrinsics.checkNotNullParameter((Object)content, (String)"content");
                    ContentType contentType = content.getContentType();
                    if (contentType == null) {
                        ContentType contentType2;
                        String string = $this$condition.getResponse().getHeaders().get(HttpHeaders.INSTANCE.getContentType());
                        if (string != null) {
                            String it = string;
                            boolean bl2 = false;
                            contentType2 = ContentType.Companion.parse(it);
                        } else {
                            contentType2 = contentType = null;
                        }
                        if (contentType2 == null) {
                            return true;
                        }
                    }
                    ContentType contentType3 = contentType;
                    ContentType[] $this$none$iv = this.$mimeTypes;
                    boolean $i$f$none = false;
                    int n = $this$none$iv.length;
                    for (int i = 0; i < n; ++i) {
                        ContentType element$iv;
                        ContentType excludePattern = element$iv = $this$none$iv[i];
                        boolean bl3 = false;
                        if (!contentType3.match(excludePattern)) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
                return bl;
            }
        }));
    }

    private static final void defaultConditions(ConditionsHolderBuilder $this$defaultConditions) {
        ContentType[] contentTypeArray = new ContentType[]{ContentType.Video.INSTANCE.getAny(), ContentType.Image.INSTANCE.getJPEG(), ContentType.Image.INSTANCE.getPNG(), ContentType.Audio.INSTANCE.getAny(), ContentType.MultiPart.INSTANCE.getAny(), ContentType.Text.INSTANCE.getEventStream()};
        ConfigKt.excludeContentType($this$defaultConditions, contentTypeArray);
        ConfigKt.minimumSize($this$defaultConditions, 200L);
    }

    public static final /* synthetic */ void access$defaultConditions(ConditionsHolderBuilder $receiver) {
        ConfigKt.defaultConditions($receiver);
    }
}

