/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.engine;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueFactory;
import io.ktor.application.ApplicationEnvironment;
import io.ktor.config.ApplicationConfig;
import io.ktor.config.HoconApplicationConfig;
import io.ktor.config.HoconApplicationConfigKt;
import io.ktor.server.engine.ApplicationEngineEnvironment;
import io.ktor.server.engine.ApplicationEngineEnvironmentBuilder;
import io.ktor.server.engine.ApplicationEngineEnvironmentKt;
import io.ktor.server.engine.BaseApplicationEngine;
import io.ktor.server.engine.EngineConnectorBuilder;
import io.ktor.server.engine.EngineConnectorConfig;
import io.ktor.server.engine.EngineSSLConnectorBuilder;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\u001a\u0019\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005\u001a\u0012\u0010\u0006\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\"\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010\f*\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"commandLineEnvironment", "Lio/ktor/server/engine/ApplicationEngineEnvironment;", "args", "", "", "([Ljava/lang/String;)Lio/ktor/server/engine/ApplicationEngineEnvironment;", "loadCommonConfiguration", "", "Lio/ktor/server/engine/BaseApplicationEngine$Configuration;", "deploymentConfig", "Lio/ktor/config/ApplicationConfig;", "splitPair", "Lkotlin/Pair;", "ch", "", "ktor-server-host-common"})
public final class CommandLineKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ApplicationEngineEnvironment commandLineEnvironment(@NotNull String[] args) {
        File file;
        Config environmentConfig;
        Map commandLineMap;
        File configFile;
        URL jar;
        Map argsMap;
        block13: {
            block12: {
                void $receiver$iv$iv;
                void $receiver$iv;
                File file2;
                URL uRL;
                String it;
                Object it$iv$iv;
                Object object;
                String $receiver$iv$iv2;
                void $receiver$iv$iv$iv;
                String[] $receiver$iv2;
                Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
                String[] stringArray = $receiver$iv2 = args;
                Collection destination$iv$iv = new ArrayList();
                void var6_8 = $receiver$iv$iv$iv = $receiver$iv$iv2;
                int n = ((void)var6_8).length;
                for (int i = 0; i < n; ++i) {
                    void var9_15;
                    void element$iv$iv;
                    void it2 = element$iv$iv = (var9_15 = var6_8[i]);
                    boolean bl = false;
                    if (CommandLineKt.splitPair((String)it2, '=') == null) continue;
                    it$iv$iv = object;
                    destination$iv$iv.add(it$iv$iv);
                }
                argsMap = MapsKt.toMap((Iterable)((List)destination$iv$iv));
                String string = (String)argsMap.get("-jar");
                if (string != null) {
                    it = $receiver$iv$iv2 = string;
                    boolean bl = false;
                    uRL = StringsKt.startsWith$default((String)it, (String)"file:", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)it, (String)"jrt:", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)it, (String)"jar:", (boolean)false, (int)2, null) ? new URI(it).toURL() : new File(it).toURI().toURL();
                } else {
                    uRL = null;
                }
                jar = uRL;
                String string2 = (String)argsMap.get("-config");
                if (string2 != null) {
                    String it3 = it = string2;
                    boolean bl = false;
                    file2 = new File(it3);
                } else {
                    file2 = null;
                }
                configFile = file2;
                Map $receiver$iv22 = argsMap;
                LinkedHashMap result$iv = new LinkedHashMap();
                Map map = $receiver$iv22;
                for (Map.Entry entry : map.entrySet()) {
                    String it4 = (String)entry.getKey();
                    boolean bl = false;
                    if (!StringsKt.startsWith$default((String)it4, (String)"-P:", (boolean)false, (int)2, null)) continue;
                    result$iv.put(entry.getKey(), entry.getValue());
                }
                $receiver$iv22 = result$iv;
                result$iv = $receiver$iv;
                Object destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$receiver$iv.size()));
                Iterable $receiver$iv$iv$iv2 = $receiver$iv$iv.entrySet();
                for (Object element$iv$iv$iv : $receiver$iv$iv$iv2) {
                    void it$iv$iv2;
                    void it5;
                    Map.Entry bl = (Map.Entry)element$iv$iv$iv;
                    Map map2 = destination$iv$iv2;
                    boolean bl2 = false;
                    String string3 = StringsKt.removePrefix((String)((String)it5.getKey()), (CharSequence)"-P:");
                    object = (Map.Entry)element$iv$iv$iv;
                    it$iv$iv = string3;
                    Map $i$a$1$let = map2;
                    Object $i$a$1$forEach = it$iv$iv2.getValue();
                    $i$a$1$let.put(it$iv$iv, $i$a$1$forEach);
                }
                commandLineMap = destination$iv$iv2;
                environmentConfig = ConfigFactory.systemProperties().withOnlyPath("ktor");
                file = configFile;
                if (file == null) break block12;
                Object it6 = destination$iv$iv2 = file;
                boolean bl = false;
                file = ConfigFactory.parseFile((File)it6);
                if (file != null) break block13;
            }
            file = ConfigFactory.load();
        }
        File fileConfig = file;
        Config argConfig = ConfigFactory.parseMap((Map)commandLineMap, (String)"Command-line options");
        Config combinedConfig = argConfig.withFallback((ConfigMergeable)fileConfig).withFallback((ConfigMergeable)environmentConfig).resolve();
        String string = "ktor.application.id";
        String hostConfigPath = "ktor.deployment.host";
        String hostPortPath = "ktor.deployment.port";
        String hostWatchPaths = "ktor.deployment.watch";
        String hostSslPortPath = "ktor.deployment.sslPort";
        String hostSslKeyStore = "ktor.security.ssl.keyStore";
        String hostSslKeyAlias = "ktor.security.ssl.keyAlias";
        String hostSslKeyStorePassword = "ktor.security.ssl.keyStorePassword";
        String hostSslPrivateKeyPassword = "ktor.security.ssl.privateKeyPassword";
        Config config = combinedConfig;
        Intrinsics.checkExpressionValueIsNotNull((Object)config, (String)"combinedConfig");
        String string4 = HoconApplicationConfigKt.tryGetString((Config)config, (String)string);
        if (string4 == null) {
            string4 = "Application";
        }
        String applicationId = string4;
        Logger appLog = LoggerFactory.getLogger((String)applicationId);
        if (configFile != null && !configFile.exists()) {
            appLog.error("Configuration file '" + configFile + "' specified as command line argument was not found");
            appLog.warn("Will attempt to start without loading configuration\u2026");
        }
        ApplicationEngineEnvironment environment2 = ApplicationEngineEnvironmentKt.applicationEngineEnvironment((Function1<? super ApplicationEngineEnvironmentBuilder, Unit>)((Function1)new Function1<ApplicationEngineEnvironmentBuilder, Unit>(appLog, jar, combinedConfig, argsMap, hostConfigPath, hostPortPath, hostSslPortPath, hostSslKeyStore, hostSslKeyStorePassword, hostSslPrivateKeyPassword, hostSslKeyAlias, hostWatchPaths){
            final /* synthetic */ Logger $appLog;
            final /* synthetic */ URL $jar;
            final /* synthetic */ Config $combinedConfig;
            final /* synthetic */ Map $argsMap;
            final /* synthetic */ String $hostConfigPath;
            final /* synthetic */ String $hostPortPath;
            final /* synthetic */ String $hostSslPortPath;
            final /* synthetic */ String $hostSslKeyStore;
            final /* synthetic */ String $hostSslKeyStorePassword;
            final /* synthetic */ String $hostSslPrivateKeyPassword;
            final /* synthetic */ String $hostSslKeyAlias;
            final /* synthetic */ String $hostWatchPaths;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ApplicationEngineEnvironmentBuilder $receiver) {
                block29: {
                    Object object;
                    EngineConnectorBuilder engineConnectorBuilder;
                    Object object2;
                    String sslKeyAlias;
                    String string;
                    String string2;
                    String string3;
                    String sslPort;
                    String string4;
                    String port;
                    String string5;
                    String host;
                    String string6;
                    String string7;
                    ClassLoader classLoader;
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                    Logger logger = this.$appLog;
                    Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"appLog");
                    $receiver.setLog(logger);
                    ApplicationEngineEnvironmentBuilder applicationEngineEnvironmentBuilder = $receiver;
                    URL uRL = this.$jar;
                    if (uRL != null) {
                        URL uRL2 = uRL;
                        ApplicationEngineEnvironmentBuilder applicationEngineEnvironmentBuilder2 = applicationEngineEnvironmentBuilder;
                        URL it = uRL2;
                        boolean bl = false;
                        URLClassLoader uRLClassLoader = new URLClassLoader(new URL[]{this.$jar}, ApplicationEnvironment.class.getClassLoader());
                        applicationEngineEnvironmentBuilder = applicationEngineEnvironmentBuilder2;
                        classLoader = uRLClassLoader;
                    } else {
                        ClassLoader classLoader2 = ApplicationEnvironment.class.getClassLoader();
                        classLoader = classLoader2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)classLoader2, (String)"ApplicationEnvironment::class.java.classLoader");
                    }
                    applicationEngineEnvironmentBuilder.setClassLoader(classLoader);
                    Config config = this.$combinedConfig;
                    Intrinsics.checkExpressionValueIsNotNull((Object)config, (String)"combinedConfig");
                    $receiver.setConfig((ApplicationConfig)new HoconApplicationConfig(config));
                    ConfigValue contentHiddenValue = ConfigValueFactory.fromAnyRef((Object)"***", (String)"Content hidden");
                    if (this.$combinedConfig.hasPath("ktor")) {
                        $receiver.getLog().trace(this.$combinedConfig.getObject("ktor").withoutKey("security").withValue("security", contentHiddenValue).render());
                    } else {
                        $receiver.getLog().trace("No configuration provided: neither application.conf nor system properties nor command line options (-config or -P:ktor...=) provided");
                    }
                    if ((string7 = (String)this.$argsMap.get("-host")) == null) {
                        Config config2 = this.$combinedConfig;
                        Intrinsics.checkExpressionValueIsNotNull((Object)config2, (String)"combinedConfig");
                        string7 = string6 = HoconApplicationConfigKt.tryGetString((Config)config2, (String)this.$hostConfigPath);
                    }
                    if (string7 == null) {
                        string6 = host = "0.0.0.0";
                    }
                    if ((string5 = (String)this.$argsMap.get("-port")) == null) {
                        Config config3 = this.$combinedConfig;
                        Intrinsics.checkExpressionValueIsNotNull((Object)config3, (String)"combinedConfig");
                        string5 = port = HoconApplicationConfigKt.tryGetString((Config)config3, (String)this.$hostPortPath);
                    }
                    if ((string4 = (String)this.$argsMap.get("-sslPort")) == null) {
                        Config config4 = this.$combinedConfig;
                        Intrinsics.checkExpressionValueIsNotNull((Object)config4, (String)"combinedConfig");
                        string4 = sslPort = HoconApplicationConfigKt.tryGetString((Config)config4, (String)this.$hostSslPortPath);
                    }
                    if ((string3 = (String)this.$argsMap.get("-sslKeyStore")) == null) {
                        Config config5 = this.$combinedConfig;
                        Intrinsics.checkExpressionValueIsNotNull((Object)config5, (String)"combinedConfig");
                        string3 = HoconApplicationConfigKt.tryGetString((Config)config5, (String)this.$hostSslKeyStore);
                    }
                    String sslKeyStorePath = string3;
                    Config config6 = this.$combinedConfig;
                    Intrinsics.checkExpressionValueIsNotNull((Object)config6, (String)"combinedConfig");
                    String string8 = HoconApplicationConfigKt.tryGetString((Config)config6, (String)this.$hostSslKeyStorePassword);
                    if (string8 != null) {
                        String string9;
                        String string10 = string9 = string8;
                        if (string10 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                        }
                        string2 = ((Object)StringsKt.trim((CharSequence)string10)).toString();
                    } else {
                        string2 = null;
                    }
                    String sslKeyStorePassword = string2;
                    Config config7 = this.$combinedConfig;
                    Intrinsics.checkExpressionValueIsNotNull((Object)config7, (String)"combinedConfig");
                    String string11 = HoconApplicationConfigKt.tryGetString((Config)config7, (String)this.$hostSslPrivateKeyPassword);
                    if (string11 != null) {
                        String string12;
                        String string13 = string12 = string11;
                        if (string13 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                        }
                        string = ((Object)StringsKt.trim((CharSequence)string13)).toString();
                    } else {
                        string = null;
                    }
                    String sslPrivateKeyPassword = string;
                    Config config8 = this.$combinedConfig;
                    Intrinsics.checkExpressionValueIsNotNull((Object)config8, (String)"combinedConfig");
                    String string14 = HoconApplicationConfigKt.tryGetString((Config)config8, (String)this.$hostSslKeyAlias);
                    if (string14 == null) {
                        string14 = sslKeyAlias = "mykey";
                    }
                    if (port != null) {
                        ApplicationEngineEnvironmentBuilder $receiver$iv = $receiver;
                        boolean $i$f$connector = false;
                        EngineConnectorBuilder engineConnectorBuilder2 = new EngineConnectorBuilder(null, 1, null);
                        List<EngineConnectorConfig> list = $receiver$iv.getConnectors();
                        EngineConnectorBuilder $receiver2 = engineConnectorBuilder2;
                        boolean $i$a$-connector-CommandLineKt$commandLineEnvironment$environment$1$32 = false;
                        $receiver2.setHost(host);
                        object2 = port;
                        engineConnectorBuilder = $receiver2;
                        int n = Integer.parseInt((String)object2);
                        engineConnectorBuilder.setPort(n);
                        $receiver2 = engineConnectorBuilder2;
                        list.add($receiver2);
                    }
                    if (sslPort != null) {
                        void $receiver$iv;
                        void keyStorePassword$iv;
                        void keyStore$iv;
                        Object object3;
                        Object object4;
                        if (sslKeyStorePath == null) {
                            throw (Throwable)new IllegalArgumentException("SSL requires keystore: use -sslKeyStore=path or " + this.$hostSslKeyStore + " config");
                        }
                        if (sslKeyStorePassword == null) {
                            throw (Throwable)new IllegalArgumentException("SSL requires keystore password: use " + this.$hostSslKeyStorePassword + " config");
                        }
                        if (sslPrivateKeyPassword == null) {
                            throw (Throwable)new IllegalArgumentException("SSL requires certificate password: use " + this.$hostSslPrivateKeyPassword + " config");
                        }
                        File $i$f$connector = new File(sslKeyStorePath);
                        Object file = $i$f$connector;
                        boolean bl = false;
                        File keyStoreFile = ((File)file).exists() || ((File)file).isAbsolute() ? file : new File(".", sslKeyStorePath).getAbsoluteFile();
                        Object $receiver3 = file = KeyStore.getInstance("JKS");
                        boolean $i$a$-apply-CommandLineKt$commandLineEnvironment$environment$1$keyStore$22 = false;
                        Object $i$a$-connector-CommandLineKt$commandLineEnvironment$environment$1$32 = new FileInputStream(keyStoreFile);
                        object2 = null;
                        try {
                            FileInputStream it = (FileInputStream)$i$a$-connector-CommandLineKt$commandLineEnvironment$environment$1$32;
                            boolean bl2 = false;
                            String string15 = sslKeyStorePassword;
                            InputStream inputStream = it;
                            object4 = $receiver3;
                            char[] cArray = string15.toCharArray();
                            Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
                            object3 = cArray;
                            ((KeyStore)object4).load(inputStream, (char[])object3);
                            engineConnectorBuilder = Unit.INSTANCE;
                        }
                        catch (Throwable throwable) {
                            object2 = throwable;
                            throw throwable;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)$i$a$-connector-CommandLineKt$commandLineEnvironment$environment$1$32, (Throwable)object2);
                        }
                        $i$a$-connector-CommandLineKt$commandLineEnvironment$environment$1$32 = sslPrivateKeyPassword;
                        String string16 = sslKeyAlias;
                        Object object5 = $receiver3;
                        char[] cArray = ((String)$i$a$-connector-CommandLineKt$commandLineEnvironment$environment$1$32).toCharArray();
                        Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
                        char[] cArray2 = cArray;
                        boolean $i$a$-connector-CommandLineKt$commandLineEnvironment$environment$1$32 = ((KeyStore)object5).getKey(string16, cArray2) == null;
                        Object keyStore = file;
                        file = $receiver;
                        Object object6 = keyStore;
                        Intrinsics.checkExpressionValueIsNotNull((Object)object6, (String)"keyStore");
                        $receiver3 = object6;
                        Function0 $i$a$-apply-CommandLineKt$commandLineEnvironment$environment$1$keyStore$22 = (Function0)new Function0<char[]>(sslKeyStorePassword){
                            final /* synthetic */ String $sslKeyStorePassword;

                            @NotNull
                            public final char[] invoke() {
                                String string;
                                String string2 = string = this.$sslKeyStorePassword;
                                if (string2 == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                                }
                                char[] cArray = string2.toCharArray();
                                Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
                                return cArray;
                            }
                            {
                                this.$sslKeyStorePassword = string;
                                super(0);
                            }
                        };
                        Function0 privateKeyPassword$iv = (Function0)new Function0<char[]>(sslPrivateKeyPassword){
                            final /* synthetic */ String $sslPrivateKeyPassword;

                            @NotNull
                            public final char[] invoke() {
                                String string;
                                String string2 = string = this.$sslPrivateKeyPassword;
                                if (string2 == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                                }
                                char[] cArray = string2.toCharArray();
                                Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
                                return cArray;
                            }
                            {
                                this.$sslPrivateKeyPassword = string;
                                super(0);
                            }
                        };
                        boolean $i$f$sslConnector = false;
                        engineConnectorBuilder = new EngineSSLConnectorBuilder((KeyStore)keyStore$iv, sslKeyAlias, (Function0<char[]>)keyStorePassword$iv, (Function0<char[]>)privateKeyPassword$iv);
                        List<EngineConnectorConfig> list = $receiver$iv.getConnectors();
                        EngineConnectorBuilder $receiver4 = engineConnectorBuilder;
                        boolean bl3 = false;
                        $receiver4.setHost(host);
                        object4 = sslPort;
                        object3 = $receiver4;
                        int n = Integer.parseInt((String)object4);
                        ((EngineConnectorBuilder)object3).setPort(n);
                        ((EngineSSLConnectorBuilder)$receiver4).setKeyStorePath(keyStoreFile);
                        object5 = engineConnectorBuilder;
                        list.add((EngineConnectorConfig)object5);
                    }
                    if (port == null && sslPort == null) {
                        throw (Throwable)new IllegalArgumentException("Neither port nor sslPort specified. Use command line options -port/-sslPort or configure connectors in application.conf");
                    }
                    Object object7 = (String)this.$argsMap.get("-watch");
                    if (object7 == null || (object7 = StringsKt.split$default((CharSequence)((CharSequence)object7), (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null)) == null) {
                        Config config9 = this.$combinedConfig;
                        Intrinsics.checkExpressionValueIsNotNull((Object)config9, (String)"combinedConfig");
                        object7 = HoconApplicationConfigKt.tryGetStringList((Config)config9, (String)this.$hostWatchPaths);
                    }
                    if (object7 == null) break block29;
                    Object it = object = object7;
                    boolean bl = false;
                    $receiver.setWatchPaths((List<String>)it);
                }
            }
            {
                this.$appLog = logger;
                this.$jar = uRL;
                this.$combinedConfig = config;
                this.$argsMap = map;
                this.$hostConfigPath = string;
                this.$hostPortPath = string2;
                this.$hostSslPortPath = string3;
                this.$hostSslKeyStore = string4;
                this.$hostSslKeyStorePassword = string5;
                this.$hostSslPrivateKeyPassword = string6;
                this.$hostSslKeyAlias = string7;
                this.$hostWatchPaths = string8;
                super(1);
            }
        }));
        return environment2;
    }

    private static final Pair<String, String> splitPair(@NotNull String $receiver, char ch) {
        Pair pair;
        int n;
        int idx = n = StringsKt.indexOf$default((CharSequence)$receiver, (char)ch, (int)0, (boolean)false, (int)6, null);
        boolean bl = false;
        switch (idx) {
            case -1: {
                pair = null;
                break;
            }
            default: {
                pair = new Pair((Object)StringsKt.take((String)$receiver, (int)idx), (Object)StringsKt.drop((String)$receiver, (int)(idx + 1)));
            }
        }
        return pair;
    }

    public static final void loadCommonConfiguration(@NotNull BaseApplicationEngine.Configuration $receiver, @NotNull ApplicationConfig deploymentConfig) {
        block2: {
            int n;
            Object object;
            Object object2;
            int it;
            int n2;
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
            Intrinsics.checkParameterIsNotNull((Object)deploymentConfig, (String)"deploymentConfig");
            Object object3 = deploymentConfig.propertyOrNull("callGroupSize");
            if (object3 != null && (object3 = object3.getString()) != null) {
                Object object4 = object3;
                it = n2 = Integer.parseInt((String)object4);
                boolean bl = false;
                $receiver.setCallGroupSize(it);
            }
            if ((object2 = deploymentConfig.propertyOrNull("connectionGroupSize")) != null && (object2 = object2.getString()) != null) {
                Object object5 = object2;
                it = n2 = Integer.parseInt((String)object5);
                boolean bl = false;
                $receiver.setConnectionGroupSize(it);
            }
            if ((object = deploymentConfig.propertyOrNull("workerGroupSize")) == null || (object = object.getString()) == null) break block2;
            Object object6 = object;
            it = n = Integer.parseInt((String)object6);
            boolean bl = false;
            $receiver.setWorkerGroupSize(it);
        }
    }
}

