/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.engine;

import io.ktor.application.Application;
import io.ktor.application.DefaultApplicationEventsKt;
import io.ktor.server.engine.ApplicationEngine;
import io.ktor.server.engine.ApplicationEngineEnvironment;
import io.ktor.server.engine.BaseApplicationResponse;
import io.ktor.server.engine.DefaultEnginePipelineKt;
import io.ktor.server.engine.DefaultTransformKt;
import io.ktor.server.engine.EngineAPI;
import io.ktor.server.engine.EngineConnectorConfig;
import io.ktor.server.engine.EnginePipeline;
import io.ktor.util.pipeline.Pipeline;
import java.util.concurrent.TimeUnit;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@EngineAPI
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b'\u0018\u00002\u00020\u0001:\u0001\u000bB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Lio/ktor/server/engine/BaseApplicationEngine;", "Lio/ktor/server/engine/ApplicationEngine;", "environment", "Lio/ktor/server/engine/ApplicationEngineEnvironment;", "pipeline", "Lio/ktor/server/engine/EnginePipeline;", "(Lio/ktor/server/engine/ApplicationEngineEnvironment;Lio/ktor/server/engine/EnginePipeline;)V", "getEnvironment", "()Lio/ktor/server/engine/ApplicationEngineEnvironment;", "getPipeline", "()Lio/ktor/server/engine/EnginePipeline;", "Configuration", "ktor-server-host-common"})
public abstract class BaseApplicationEngine
implements ApplicationEngine {
    @NotNull
    private final ApplicationEngineEnvironment environment;
    @NotNull
    private final EnginePipeline pipeline;

    @Override
    @NotNull
    public final ApplicationEngineEnvironment getEnvironment() {
        return this.environment;
    }

    @NotNull
    public final EnginePipeline getPipeline() {
        return this.pipeline;
    }

    public BaseApplicationEngine(@NotNull ApplicationEngineEnvironment environment2, @NotNull EnginePipeline pipeline) {
        Intrinsics.checkNotNullParameter((Object)environment2, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)((Object)pipeline), (String)"pipeline");
        this.environment = environment2;
        this.pipeline = pipeline;
        BaseApplicationResponse.Companion.setupSendPipeline(this.pipeline.getSendPipeline());
        this.environment.getMonitor().subscribe(DefaultApplicationEventsKt.getApplicationStarting(), (Function1)new Function1<Application, Unit>(){

            public final void invoke(@NotNull Application it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.getReceivePipeline().merge((Pipeline)this.getPipeline().getReceivePipeline());
                it.getSendPipeline().merge((Pipeline)this.getPipeline().getSendPipeline());
                DefaultTransformKt.installDefaultTransformations(it.getReceivePipeline());
                DefaultTransformKt.installDefaultTransformations(it.getSendPipeline());
            }
        });
        this.environment.getMonitor().subscribe(DefaultApplicationEventsKt.getApplicationStarted(), (Function1)new Function1<Application, Unit>(){

            public final void invoke(@NotNull Application it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Iterable $this$forEach$iv = this.getEnvironment().getConnectors();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    EngineConnectorConfig it2 = (EngineConnectorConfig)element$iv;
                    boolean bl = false;
                    Logger logger = this.getEnvironment().getLog();
                    StringBuilder stringBuilder = new StringBuilder().append("Responding at ");
                    String string = it2.getType().getName();
                    boolean bl2 = false;
                    String string2 = string;
                    if (string2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string3 = string2.toLowerCase();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
                    logger.info(stringBuilder.append(string3).append("://").append(it2.getHost()).append(':').append(it2.getPort()).toString());
                }
            }
        });
    }

    public /* synthetic */ BaseApplicationEngine(ApplicationEngineEnvironment applicationEngineEnvironment, EnginePipeline enginePipeline, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            enginePipeline = DefaultEnginePipelineKt.defaultEnginePipeline(applicationEngineEnvironment);
        }
        this(applicationEngineEnvironment, enginePipeline);
    }

    @Override
    @NotNull
    public Application getApplication() {
        return ApplicationEngine.DefaultImpls.getApplication(this);
    }

    @Override
    @Deprecated(message="Binary compatibility.", level=DeprecationLevel.HIDDEN)
    public /* synthetic */ void stop(long gracePeriod, long timeout, @NotNull TimeUnit timeUnit) {
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
        ApplicationEngine.DefaultImpls.stop(this, gracePeriod, timeout, timeUnit);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lio/ktor/server/engine/BaseApplicationEngine$Configuration;", "Lio/ktor/server/engine/ApplicationEngine$Configuration;", "()V", "ktor-server-host-common"})
    public static class Configuration
    extends ApplicationEngine.Configuration {
    }
}

