/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.jetty.jakarta;

import io.ktor.events.EventDefinition;
import io.ktor.events.Events;
import io.ktor.events.EventsKt;
import io.ktor.server.application.Application;
import io.ktor.server.application.ApplicationEnvironment;
import io.ktor.server.application.DefaultApplicationEventsKt;
import io.ktor.server.engine.ApplicationEngine;
import io.ktor.server.engine.BaseApplicationEngine;
import io.ktor.server.engine.EngineConnectorConfig;
import io.ktor.server.engine.EngineConnectorConfigJvmKt;
import io.ktor.server.engine.EngineContextCancellationHelperKt;
import io.ktor.server.jetty.jakarta.ServerInitializerKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.CompletableJob;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001:\u0001'B5\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0019\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u0017\u0010\t\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u001b\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010\u001eR\u0018\u0010 \u001a\u0004\u0018\u00010\u001f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b \u0010!R\u001a\u0010#\u001a\u00020\"8\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b#\u0010$\u001a\u0004\b%\u0010&\u00a8\u0006("}, d2={"Lio/ktor/server/jetty/jakarta/JettyApplicationEngineBase;", "Lio/ktor/server/engine/BaseApplicationEngine;", "Lio/ktor/server/application/ApplicationEnvironment;", "environment", "Lio/ktor/events/Events;", "monitor", "", "developmentMode", "Lio/ktor/server/jetty/jakarta/JettyApplicationEngineBase$Configuration;", "configuration", "Lkotlin/Function0;", "Lio/ktor/server/application/Application;", "applicationProvider", "<init>", "(Lio/ktor/server/application/ApplicationEnvironment;Lio/ktor/events/Events;ZLio/ktor/server/jetty/jakarta/JettyApplicationEngineBase$Configuration;Lkotlin/jvm/functions/Function0;)V", "wait", "start", "(Z)Lio/ktor/server/jetty/jakarta/JettyApplicationEngineBase;", "", "gracePeriodMillis", "timeoutMillis", "", "stop", "(JJ)V", "", "toString", "()Ljava/lang/String;", "Lio/ktor/server/jetty/jakarta/JettyApplicationEngineBase$Configuration;", "getConfiguration", "()Lio/ktor/server/jetty/jakarta/JettyApplicationEngineBase$Configuration;", "Lkotlin/jvm/functions/Function0;", "Lkotlinx/coroutines/CompletableJob;", "cancellationJob", "Lkotlinx/coroutines/CompletableJob;", "Lorg/eclipse/jetty/server/Server;", "server", "Lorg/eclipse/jetty/server/Server;", "getServer", "()Lorg/eclipse/jetty/server/Server;", "Configuration", "ktor-server-jetty-jakarta"})
@SourceDebugExtension(value={"SMAP\nJettyApplicationEngineBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JettyApplicationEngineBase.kt\nio/ktor/server/jetty/jakarta/JettyApplicationEngineBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,89:1\n1557#2:90\n1628#2,3:91\n*S KotlinDebug\n*F\n+ 1 JettyApplicationEngineBase.kt\nio/ktor/server/jetty/jakarta/JettyApplicationEngineBase\n*L\n65#1:90\n65#1:91,3\n*E\n"})
public class JettyApplicationEngineBase
extends BaseApplicationEngine {
    @NotNull
    private final Configuration configuration;
    @NotNull
    private final Function0<Application> applicationProvider;
    @Nullable
    private CompletableJob cancellationJob;
    @NotNull
    private final Server server;

    /*
     * WARNING - void declaration
     */
    public JettyApplicationEngineBase(@NotNull ApplicationEnvironment environment, @NotNull Events monitor, boolean developmentMode, @NotNull Configuration configuration, @NotNull Function0<Application> applicationProvider) {
        void $this$server_u24lambda_u240;
        Server server;
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)monitor, (String)"monitor");
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        Intrinsics.checkNotNullParameter(applicationProvider, (String)"applicationProvider");
        super(environment, monitor, developmentMode, null, 8, null);
        this.configuration = configuration;
        this.applicationProvider = applicationProvider;
        Server server2 = server = new Server();
        JettyApplicationEngineBase jettyApplicationEngineBase = this;
        boolean bl = false;
        this.configuration.getConfigureServer().invoke((Object)$this$server_u24lambda_u240);
        ServerInitializerKt.initializeServer((Server)$this$server_u24lambda_u240, this.configuration);
        jettyApplicationEngineBase.server = server;
    }

    @NotNull
    public final Configuration getConfiguration() {
        return this.configuration;
    }

    @NotNull
    protected final Server getServer() {
        return this.server;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public JettyApplicationEngineBase start(boolean wait) {
        void $this$mapTo$iv$iv;
        this.server.start();
        this.cancellationJob = EngineContextCancellationHelperKt.stopServerOnCancellation((ApplicationEngine)((ApplicationEngine)this), (Application)((Application)this.applicationProvider.invoke()), (long)this.configuration.getShutdownGracePeriod(), (long)this.configuration.getShutdownTimeout());
        Connector[] connectorArray = this.server.getConnectors();
        Intrinsics.checkNotNullExpressionValue((Object)connectorArray, (String)"getConnectors(...)");
        Iterable $this$map$iv = ArraysKt.zip((Object[])connectorArray, (Iterable)this.configuration.getConnectors());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            EngineConnectorConfig engineConnectorConfig = (EngineConnectorConfig)it.getSecond();
            Object object = it.getFirst();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.eclipse.jetty.server.ServerConnector");
            collection.add(EngineConnectorConfigJvmKt.withPort((EngineConnectorConfig)engineConnectorConfig, (int)((ServerConnector)object).getLocalPort()));
        }
        List connectors = (List)destination$iv$iv;
        this.getResolvedConnectorsDeferred().complete((Object)connectors);
        EventsKt.raiseCatching((Events)this.getMonitor(), (EventDefinition)DefaultApplicationEventsKt.getServerReady(), (Object)this.getEnvironment(), (Logger)this.getEnvironment().getLog());
        if (wait) {
            this.server.join();
            this.stop(this.configuration.getShutdownGracePeriod(), this.configuration.getShutdownTimeout());
        }
        return this;
    }

    public void stop(long gracePeriodMillis, long timeoutMillis) {
        CompletableJob completableJob = this.cancellationJob;
        if (completableJob != null) {
            completableJob.complete();
        }
        this.getMonitor().raise(DefaultApplicationEventsKt.getApplicationStopPreparing(), (Object)this.getEnvironment());
        this.server.setStopTimeout(timeoutMillis);
        this.server.stop();
        this.server.destroy();
    }

    @NotNull
    public String toString() {
        return "Jetty(" + this.getEnvironment() + ")";
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R3\u0010\b\u001a\u0013\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0002\b\u00078\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\"\u0010\u000f\u001a\u00020\u000e8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lio/ktor/server/jetty/jakarta/JettyApplicationEngineBase$Configuration;", "Lio/ktor/server/engine/BaseApplicationEngine$Configuration;", "<init>", "()V", "Lkotlin/Function1;", "Lorg/eclipse/jetty/server/Server;", "", "Lkotlin/ExtensionFunctionType;", "configureServer", "Lkotlin/jvm/functions/Function1;", "getConfigureServer", "()Lkotlin/jvm/functions/Function1;", "setConfigureServer", "(Lkotlin/jvm/functions/Function1;)V", "Lkotlin/time/Duration;", "idleTimeout", "J", "getIdleTimeout-UwyO8pc", "()J", "setIdleTimeout-LRDsOJo", "(J)V", "ktor-server-jetty-jakarta"})
    public static final class Configuration
    extends BaseApplicationEngine.Configuration {
        @NotNull
        private Function1<? super Server, Unit> configureServer = Configuration::configureServer$lambda$0;
        private long idleTimeout = DurationKt.toDuration((int)30, (DurationUnit)DurationUnit.SECONDS);

        @NotNull
        public final Function1<Server, Unit> getConfigureServer() {
            return this.configureServer;
        }

        public final void setConfigureServer(@NotNull Function1<? super Server, Unit> function1) {
            Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
            this.configureServer = function1;
        }

        public final long getIdleTimeout-UwyO8pc() {
            return this.idleTimeout;
        }

        public final void setIdleTimeout-LRDsOJo(long l) {
            this.idleTimeout = l;
        }

        private static final Unit configureServer$lambda$0(Server server) {
            Intrinsics.checkNotNullParameter((Object)server, (String)"<this>");
            return Unit.INSTANCE;
        }
    }
}

