/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.jetty.jakarta;

import io.ktor.server.application.Application;
import io.ktor.server.application.ApplicationEnvironment;
import io.ktor.server.engine.DefaultUncaughtExceptionHandler;
import io.ktor.server.engine.EngineConnectorConfig;
import io.ktor.server.engine.EnginePipeline;
import io.ktor.server.jetty.jakarta.JettyApplicationEngineBase;
import io.ktor.server.jetty.jakarta.JettyKtorHandlerKt;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.MultipartConfigElement;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.ExecutorCoroutineDispatcher;
import kotlinx.coroutines.ExecutorsKt;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.SupervisorKt;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B;\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u0005\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J/\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001b\u0010\u001f\u001a\u00020\u0010*\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001dH\u0002\u00a2\u0006\u0004\b\u001f\u0010 R\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010!\u001a\u0004\b\"\u0010#R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010$R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010%R\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010$R\u0014\u0010&\u001a\u00020\u00138\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010'R\u001e\u0010+\u001a\f\u0012\b\u0012\u00060)j\u0002`*0(8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b+\u0010,R\u0014\u0010.\u001a\u00020-8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b.\u0010/R\u0014\u00101\u001a\u0002008\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b1\u00102R\u0014\u00104\u001a\u0002038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b4\u00105R\u0014\u00107\u001a\u0002068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b7\u00108R\u001a\u0010:\u001a\u0002098\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b:\u0010;\u001a\u0004\b<\u0010=\u00a8\u0006>"}, d2={"Lio/ktor/server/jetty/jakarta/JettyKtorHandler;", "Lorg/eclipse/jetty/server/handler/AbstractHandler;", "Lkotlinx/coroutines/CoroutineScope;", "Lio/ktor/server/application/ApplicationEnvironment;", "environment", "Lkotlin/Function0;", "Lio/ktor/server/engine/EnginePipeline;", "pipeline", "Lkotlinx/coroutines/CoroutineDispatcher;", "engineDispatcher", "Lio/ktor/server/jetty/jakarta/JettyApplicationEngineBase$Configuration;", "configuration", "Lio/ktor/server/application/Application;", "applicationProvider", "<init>", "(Lio/ktor/server/application/ApplicationEnvironment;Lkotlin/jvm/functions/Function0;Lkotlinx/coroutines/CoroutineDispatcher;Lio/ktor/server/jetty/jakarta/JettyApplicationEngineBase$Configuration;Lkotlin/jvm/functions/Function0;)V", "", "destroy", "()V", "", "target", "Lorg/eclipse/jetty/server/Request;", "baseRequest", "Ljakarta/servlet/http/HttpServletRequest;", "request", "Ljakarta/servlet/http/HttpServletResponse;", "response", "handle", "(Ljava/lang/String;Lorg/eclipse/jetty/server/Request;Ljakarta/servlet/http/HttpServletRequest;Ljakarta/servlet/http/HttpServletResponse;)V", "", "status", "sendErrorIfNotCommitted", "(Ljakarta/servlet/http/HttpServletResponse;I)V", "Lio/ktor/server/application/ApplicationEnvironment;", "getEnvironment", "()Lio/ktor/server/application/ApplicationEnvironment;", "Lkotlin/jvm/functions/Function0;", "Lkotlinx/coroutines/CoroutineDispatcher;", "environmentName", "Ljava/lang/String;", "Ljava/util/concurrent/BlockingQueue;", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "queue", "Ljava/util/concurrent/BlockingQueue;", "Ljava/util/concurrent/ThreadPoolExecutor;", "executor", "Ljava/util/concurrent/ThreadPoolExecutor;", "Lkotlinx/coroutines/ExecutorCoroutineDispatcher;", "dispatcher", "Lkotlinx/coroutines/ExecutorCoroutineDispatcher;", "Ljakarta/servlet/MultipartConfigElement;", "multipartConfig", "Ljakarta/servlet/MultipartConfigElement;", "Lkotlinx/coroutines/CompletableJob;", "handlerJob", "Lkotlinx/coroutines/CompletableJob;", "Lkotlin/coroutines/CoroutineContext;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "ktor-server-jetty-jakarta"})
public final class JettyKtorHandler
extends AbstractHandler
implements CoroutineScope {
    @NotNull
    private final ApplicationEnvironment environment;
    @NotNull
    private final Function0<EnginePipeline> pipeline;
    @NotNull
    private final CoroutineDispatcher engineDispatcher;
    @NotNull
    private final Function0<Application> applicationProvider;
    @NotNull
    private final String environmentName;
    @NotNull
    private final BlockingQueue<Runnable> queue;
    @NotNull
    private final ThreadPoolExecutor executor;
    @NotNull
    private final ExecutorCoroutineDispatcher dispatcher;
    @NotNull
    private final MultipartConfigElement multipartConfig;
    @NotNull
    private final CompletableJob handlerJob;
    @NotNull
    private final CoroutineContext coroutineContext;

    public JettyKtorHandler(@NotNull ApplicationEnvironment environment, @NotNull Function0<EnginePipeline> pipeline, @NotNull CoroutineDispatcher engineDispatcher, @NotNull JettyApplicationEngineBase.Configuration configuration, @NotNull Function0<Application> applicationProvider) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter(pipeline, (String)"pipeline");
        Intrinsics.checkNotNullParameter((Object)engineDispatcher, (String)"engineDispatcher");
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        Intrinsics.checkNotNullParameter(applicationProvider, (String)"applicationProvider");
        this.environment = environment;
        this.pipeline = pipeline;
        this.engineDispatcher = engineDispatcher;
        this.applicationProvider = applicationProvider;
        this.environmentName = CollectionsKt.joinToString$default((Iterable)configuration.getConnectors(), (CharSequence)"-", null, null, (int)0, null, JettyKtorHandler::environmentName$lambda$0, (int)30, null);
        this.queue = new LinkedBlockingQueue();
        this.executor = new ThreadPoolExecutor(configuration.getCallGroupSize(), configuration.getCallGroupSize() * 8, 1L, TimeUnit.MINUTES, this.queue, arg_0 -> JettyKtorHandler.executor$lambda$1(this, arg_0));
        this.dispatcher = ExecutorsKt.from((ExecutorService)this.executor);
        this.multipartConfig = new MultipartConfigElement(System.getProperty("java.io.tmpdir"));
        this.handlerJob = SupervisorKt.SupervisorJob((Job)((Job)((Application)this.applicationProvider.invoke()).getParentCoroutineContext().get((CoroutineContext.Key)Job.Key)));
        this.coroutineContext = ((Application)this.applicationProvider.invoke()).getParentCoroutineContext().plus((CoroutineContext)this.handlerJob).plus((CoroutineContext)new DefaultUncaughtExceptionHandler(this.environment.getLog()));
    }

    @NotNull
    public final ApplicationEnvironment getEnvironment() {
        return this.environment;
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.coroutineContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        try {
            super.destroy();
            this.executor.shutdownNow();
        }
        finally {
            Job.DefaultImpls.cancel$default((Job)((Job)this.handlerJob), null, (int)1, null);
        }
    }

    public void handle(@NotNull String target, @NotNull Request baseRequest, @NotNull HttpServletRequest request, @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)baseRequest, (String)"baseRequest");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        try {
            String contentType = request.getContentType();
            if (contentType != null && StringsKt.startsWith((String)contentType, (String)"multipart/", (boolean)true)) {
                baseRequest.setAttribute("org.eclipse.jetty.multipartConfig", (Object)this.multipartConfig);
            }
            AsyncContext asyncContext = request.startAsync();
            if (asyncContext != null) {
                AsyncContext asyncContext2;
                AsyncContext $this$handle_u24lambda_u242 = asyncContext2 = asyncContext;
                boolean bl = false;
                $this$handle_u24lambda_u242.setTimeout(0L);
            }
            baseRequest.setHandled(true);
            BuildersKt.launch$default((CoroutineScope)this, (CoroutineContext)this.dispatcher.plus((CoroutineContext)JettyKtorHandlerKt.access$getJettyCallHandlerCoroutineName$p()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, baseRequest, request, response, null){
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ JettyKtorHandler this$0;
                final /* synthetic */ Request $baseRequest;
                final /* synthetic */ HttpServletRequest $request;
                final /* synthetic */ HttpServletResponse $response;
                {
                    this.this$0 = $receiver;
                    this.$baseRequest = $baseRequest;
                    this.$request = $request;
                    this.$response = $response;
                    super(2, $completion);
                }

                /*
                 * Exception decompiling
                 */
                public final Object invokeSuspend(Object var1_1) {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.dump(Method.java:598)
                     *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperAnonymousInner.dumpWithArgs(ClassFileDumperAnonymousInner.java:87)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner.dumpInner(ConstructorInvokationAnonymousInner.java:82)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:139)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.dumpInner(StaticFunctionInvokation.java:143)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.dump(StructuredExpressionStatement.java:29)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                     *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                     *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredTry.dump(StructuredTry.java:79)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                     *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.dump(AttributeCode.java:135)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.entities.Method.dump(Method.java:627)
                     *     at org.benf.cfr.reader.entities.classfilehelpers.AbstractClassFileDumper.dumpMethods(AbstractClassFileDumper.java:211)
                     *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:70)
                     *     at org.benf.cfr.reader.entities.ClassFile.dump(ClassFile.java:1167)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:952)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
        catch (Throwable ex) {
            this.environment.getLog().error("Application cannot fulfill the request", ex);
            this.sendErrorIfNotCommitted(response, 500);
        }
    }

    private final void sendErrorIfNotCommitted(HttpServletResponse $this$sendErrorIfNotCommitted, int status) {
        if (!$this$sendErrorIfNotCommitted.isCommitted()) {
            $this$sendErrorIfNotCommitted.sendError(status);
        }
    }

    private static final CharSequence environmentName$lambda$0(EngineConnectorConfig it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return String.valueOf(it.getPort());
    }

    private static final Thread executor$lambda$1(JettyKtorHandler this$0, Runnable r) {
        return new Thread(r, "ktor-jetty-" + this$0.environmentName + "-" + JettyKtorHandlerKt.access$getJettyKtorCounter$p().incrementAndGet());
    }

    public static final /* synthetic */ Function0 access$getApplicationProvider$p(JettyKtorHandler $this) {
        return $this.applicationProvider;
    }

    public static final /* synthetic */ CoroutineDispatcher access$getEngineDispatcher$p(JettyKtorHandler $this) {
        return $this.engineDispatcher;
    }

    public static final /* synthetic */ ExecutorCoroutineDispatcher access$getDispatcher$p(JettyKtorHandler $this) {
        return $this.dispatcher;
    }

    public static final /* synthetic */ Function0 access$getPipeline$p(JettyKtorHandler $this) {
        return $this.pipeline;
    }

    public static final /* synthetic */ void access$sendErrorIfNotCommitted(JettyKtorHandler $this, HttpServletResponse $receiver, int status) {
        $this.sendErrorIfNotCommitted($receiver, status);
    }
}

