/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.jetty;

import io.ktor.server.engine.ApplicationEngineEnvironment;
import io.ktor.server.engine.ConnectorType;
import io.ktor.server.engine.EngineConnectorConfig;
import io.ktor.server.engine.EngineSSLConnectorConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.jetty.alpn.server.ALPNServerConnectionFactory;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http2.HTTP2Cipher;
import org.eclipse.jetty.http2.server.HTTP2CServerConnectionFactory;
import org.eclipse.jetty.http2.server.HTTP2ServerConnectionFactory;
import org.eclipse.jetty.server.AbstractConnectionFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u00a8\u0006\u0005"}, d2={"initializeServer", "", "Lorg/eclipse/jetty/server/Server;", "environment", "Lio/ktor/server/engine/ApplicationEngineEnvironment;", "ktor-server-jetty"})
public final class ServerInitializerKt {
    /*
     * WARNING - void declaration
     */
    public static final void initializeServer(@NotNull Server $this$initializeServer, @NotNull ApplicationEngineEnvironment environment) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$initializeServer, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Iterable $this$map$iv = environment.getConnectors();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Object[] objectArray;
            Object[] objectArray22;
            void ktorConnector;
            HttpConfiguration httpConfiguration;
            EngineConnectorConfig engineConnectorConfig = (EngineConnectorConfig)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            HttpConfiguration $this$initializeServer_u24lambda_u2d4_u24lambda_u2d0 = httpConfiguration = new HttpConfiguration();
            boolean bl2 = false;
            $this$initializeServer_u24lambda_u2d4_u24lambda_u2d0.setSendServerVersion(false);
            $this$initializeServer_u24lambda_u2d4_u24lambda_u2d0.setSendDateHeader(false);
            if (Intrinsics.areEqual((Object)ktorConnector.getType(), (Object)ConnectorType.Companion.getHTTPS())) {
                $this$initializeServer_u24lambda_u2d4_u24lambda_u2d0.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            }
            HttpConfiguration httpConfig = httpConfiguration;
            boolean alpnAvailable = false;
            ALPNServerConnectionFactory alpnConnectionFactory = null;
            HTTP2ServerConnectionFactory http2ConnectionFactory = null;
            try {
                ALPNServerConnectionFactory aLPNServerConnectionFactory;
                ALPNServerConnectionFactory $this$initializeServer_u24lambda_u2d4_u24lambda_u2d1 = aLPNServerConnectionFactory = new ALPNServerConnectionFactory(new String[0]);
                boolean objectArray22 = false;
                $this$initializeServer_u24lambda_u2d4_u24lambda_u2d1.setDefaultProtocol(HttpVersion.HTTP_1_1.asString());
                alpnConnectionFactory = aLPNServerConnectionFactory;
                http2ConnectionFactory = new HTTP2ServerConnectionFactory(httpConfig);
                alpnAvailable = true;
            }
            catch (Throwable t) {
                alpnConnectionFactory = null;
                http2ConnectionFactory = null;
            }
            ConnectorType connectorType = ktorConnector.getType();
            if (Intrinsics.areEqual((Object)connectorType, (Object)ConnectorType.Companion.getHTTP())) {
                objectArray22 = new AbstractConnectionFactory[]{(AbstractConnectionFactory)new HttpConnectionFactory(httpConfig), (AbstractConnectionFactory)new HTTP2CServerConnectionFactory(httpConfig)};
                objectArray = objectArray22;
            } else if (Intrinsics.areEqual((Object)connectorType, (Object)ConnectorType.Companion.getHTTPS())) {
                boolean bl3;
                void $this$initializeServer_u24lambda_u2d4_u24lambda_u2d2;
                SslContextFactory.Server server;
                objectArray22 = new AbstractConnectionFactory[4];
                SslContextFactory.Server server2 = server = new SslContextFactory.Server();
                int n = 0;
                Object[] objectArray3 = objectArray22;
                boolean bl4 = false;
                if (alpnAvailable) {
                    $this$initializeServer_u24lambda_u2d4_u24lambda_u2d2.setCipherComparator(HTTP2Cipher.COMPARATOR);
                    $this$initializeServer_u24lambda_u2d4_u24lambda_u2d2.setUseCipherSuitesOrder(true);
                }
                $this$initializeServer_u24lambda_u2d4_u24lambda_u2d2.setKeyStore(((EngineSSLConnectorConfig)ktorConnector).getKeyStore());
                $this$initializeServer_u24lambda_u2d4_u24lambda_u2d2.setKeyManagerPassword(new String((char[])((EngineSSLConnectorConfig)ktorConnector).getPrivateKeyPassword().invoke()));
                $this$initializeServer_u24lambda_u2d4_u24lambda_u2d2.setKeyStorePassword(new String((char[])((EngineSSLConnectorConfig)ktorConnector).getKeyStorePassword().invoke()));
                if (((EngineSSLConnectorConfig)ktorConnector).getTrustStore() != null) {
                    $this$initializeServer_u24lambda_u2d4_u24lambda_u2d2.setTrustStore(((EngineSSLConnectorConfig)ktorConnector).getTrustStore());
                    bl3 = true;
                } else if (((EngineSSLConnectorConfig)ktorConnector).getTrustStorePath() != null) {
                    File file = ((EngineSSLConnectorConfig)ktorConnector).getTrustStorePath();
                    Intrinsics.checkNotNull((Object)file);
                    $this$initializeServer_u24lambda_u2d4_u24lambda_u2d2.setTrustStorePath(file.getAbsolutePath());
                    bl3 = true;
                } else {
                    bl3 = false;
                }
                $this$initializeServer_u24lambda_u2d4_u24lambda_u2d2.setNeedClientAuth(bl3);
                String[] stringArray = new String[]{"SSL_RSA_WITH_DES_CBC_SHA", "SSL_DHE_RSA_WITH_DES_CBC_SHA", "SSL_DHE_DSS_WITH_DES_CBC_SHA", "SSL_RSA_EXPORT_WITH_RC4_40_MD5", "SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA"};
                $this$initializeServer_u24lambda_u2d4_u24lambda_u2d2.addExcludeCipherSuites(stringArray);
                Unit unit = Unit.INSTANCE;
                String string = alpnAvailable ? "alpn" : HttpVersion.HTTP_1_1.asString();
                SslContextFactory sslContextFactory = (SslContextFactory)server;
                objectArray3[n] = (AbstractConnectionFactory)new SslConnectionFactory(sslContextFactory, string);
                objectArray22[1] = (AbstractConnectionFactory)alpnConnectionFactory;
                HTTP2ServerConnectionFactory hTTP2ServerConnectionFactory = http2ConnectionFactory;
                if (hTTP2ServerConnectionFactory == null) {
                    hTTP2ServerConnectionFactory = (HTTP2ServerConnectionFactory)new HTTP2CServerConnectionFactory(httpConfig);
                }
                objectArray22[2] = (AbstractConnectionFactory)hTTP2ServerConnectionFactory;
                objectArray22[3] = (AbstractConnectionFactory)new HttpConnectionFactory(httpConfig);
                Collection $this$toTypedArray$iv = ArraysKt.filterNotNull((Object[])objectArray22);
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                AbstractConnectionFactory[] abstractConnectionFactoryArray = thisCollection$iv.toArray(new AbstractConnectionFactory[0]);
                Intrinsics.checkNotNull((Object)abstractConnectionFactoryArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                objectArray = abstractConnectionFactoryArray;
            } else {
                throw new IllegalArgumentException("Connector type " + ktorConnector.getType() + " is not supported by Jetty engine implementation");
            }
            Object[] connectionFactories = objectArray;
            ConnectorType $this$initializeServer_u24lambda_u2d4_u24lambda_u2d3 = connectorType = new ServerConnector($this$initializeServer, (ConnectionFactory[])Arrays.copyOf(connectionFactories, connectionFactories.length));
            boolean bl5 = false;
            $this$initializeServer_u24lambda_u2d4_u24lambda_u2d3.setHost(ktorConnector.getHost());
            $this$initializeServer_u24lambda_u2d4_u24lambda_u2d3.setPort(ktorConnector.getPort());
            collection.add(connectorType);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ServerConnector it = (ServerConnector)element$iv;
            boolean bl = false;
            $this$initializeServer.addConnector((Connector)it);
        }
    }
}

