/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.locations;

import io.ktor.http.Parameters;
import io.ktor.http.URLBuilder;
import io.ktor.server.application.Application;
import io.ktor.server.application.ApplicationCall;
import io.ktor.server.application.BaseApplicationPlugin;
import io.ktor.server.locations.BackwardCompatibleImpl;
import io.ktor.server.locations.KtorExperimentalLocationsAPI;
import io.ktor.server.locations.LocationAttributeRouteService;
import io.ktor.server.locations.LocationInfo;
import io.ktor.server.locations.LocationPropertyInfo;
import io.ktor.server.locations.LocationRouteService;
import io.ktor.server.locations.LocationsImpl;
import io.ktor.server.routing.OptionalParameterRouteSelector;
import io.ktor.server.routing.ParameterRouteSelector;
import io.ktor.server.routing.Route;
import io.ktor.server.routing.RouteSelector;
import io.ktor.server.routing.RoutingBuilderKt;
import io.ktor.util.AttributeKey;
import io.ktor.util.KtorDsl;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KtorExperimentalLocationsAPI
@KtorDsl
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0017\u0018\u0000 )2\u00020\u0001:\u0002()B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\fH\u0002J\u001a\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0016J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0001J\u001d\u0010\u0017\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b\u001dJ\"\u0010\u001e\u001a\u0002H\u001f\"\n\b\u0000\u0010\u001f\u0018\u0001*\u00020\u00012\u0006\u0010 \u001a\u00020!H\u0087\b\u00a2\u0006\u0002\u0010\"J\"\u0010\u001e\u001a\u0002H\u001f\"\n\b\u0000\u0010\u001f\u0018\u0001*\u00020\u00012\u0006\u0010#\u001a\u00020$H\u0087\b\u00a2\u0006\u0002\u0010%J)\u0010\u001e\u001a\u0002H\u001f\"\b\b\u0000\u0010\u001f*\u00020\u00012\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u00162\u0006\u0010 \u001a\u00020!\u00a2\u0006\u0002\u0010&J)\u0010\u001e\u001a\u0002H\u001f\"\b\b\u0000\u0010\u001f*\u00020\u00012\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u00162\u0006\u0010#\u001a\u00020$\u00a2\u0006\u0002\u0010'R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006*"}, d2={"Lio/ktor/server/locations/Locations;", "", "application", "Lio/ktor/server/application/Application;", "(Lio/ktor/server/application/Application;)V", "routeService", "Lio/ktor/server/locations/LocationRouteService;", "(Lio/ktor/server/application/Application;Lio/ktor/server/locations/LocationRouteService;)V", "implementation", "Lio/ktor/server/locations/LocationsImpl;", "registeredLocations", "", "Lio/ktor/server/locations/LocationInfo;", "getRegisteredLocations$annotations", "()V", "getRegisteredLocations", "()Ljava/util/List;", "createEntry", "Lio/ktor/server/routing/Route;", "parent", "info", "locationClass", "Lkotlin/reflect/KClass;", "href", "", "location", "", "builder", "Lio/ktor/http/URLBuilder;", "href$ktor_server_locations", "resolve", "T", "parameters", "Lio/ktor/http/Parameters;", "(Lio/ktor/http/Parameters;)Ljava/lang/Object;", "call", "Lio/ktor/server/application/ApplicationCall;", "(Lio/ktor/server/application/ApplicationCall;)Ljava/lang/Object;", "(Lkotlin/reflect/KClass;Lio/ktor/http/Parameters;)Ljava/lang/Object;", "(Lkotlin/reflect/KClass;Lio/ktor/server/application/ApplicationCall;)Ljava/lang/Object;", "Configuration", "Plugin", "ktor-server-locations"})
@SourceDebugExtension(value={"SMAP\nLocations.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Locations.kt\nio/ktor/server/locations/Locations\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,172:1\n1#2:173\n1789#3,3:174\n*S KotlinDebug\n*F\n+ 1 Locations.kt\nio/ktor/server/locations/Locations\n*L\n99#1:174,3\n*E\n"})
public class Locations {
    @NotNull
    public static final Plugin Plugin = new Plugin(null);
    @NotNull
    private final LocationsImpl implementation;
    @NotNull
    private static final AttributeKey<Locations> key = new AttributeKey("Locations");

    public Locations(@NotNull Application application, @NotNull LocationRouteService routeService) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)routeService, (String)"routeService");
        this.implementation = new BackwardCompatibleImpl(application, routeService);
    }

    public Locations(@NotNull Application application) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        this(application, new LocationAttributeRouteService());
    }

    @NotNull
    public final List<LocationInfo> getRegisteredLocations() {
        return this.implementation.getRegisteredLocations();
    }

    @KtorExperimentalLocationsAPI
    public static /* synthetic */ void getRegisteredLocations$annotations() {
    }

    @NotNull
    public final <T> T resolve(@NotNull KClass<?> locationClass, @NotNull ApplicationCall call) {
        Intrinsics.checkNotNullParameter(locationClass, (String)"locationClass");
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        return this.resolve(locationClass, call.getParameters());
    }

    @NotNull
    public final <T> T resolve(@NotNull KClass<?> locationClass, @NotNull Parameters parameters) {
        Intrinsics.checkNotNullParameter(locationClass, (String)"locationClass");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        LocationInfo info = this.implementation.getOrCreateInfo(locationClass);
        Object object = this.implementation.instantiate(info, parameters);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type T of io.ktor.server.locations.Locations.resolve");
        return (T)object;
    }

    @KtorExperimentalLocationsAPI
    public final /* synthetic */ <T> T resolve(Parameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        boolean $i$f$resolve = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        T t = this.resolve(Reflection.getOrCreateKotlinClass(Object.class), parameters);
        Intrinsics.reifiedOperationMarker((int)1, (String)"T");
        return t;
    }

    @KtorExperimentalLocationsAPI
    public final /* synthetic */ <T> T resolve(ApplicationCall call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        boolean $i$f$resolve = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return this.resolve(Reflection.getOrCreateKotlinClass(Object.class), call);
    }

    @NotNull
    public final String href(@NotNull Object location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return this.implementation.href(location);
    }

    public final void href$ktor_server_locations(@NotNull Object location, @NotNull URLBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this.implementation.href(location, builder);
    }

    private final Route createEntry(Route parent, LocationInfo info) {
        LocationInfo locationInfo;
        block3: {
            block2: {
                locationInfo = info.getParent();
                if (locationInfo == null) break block2;
                LocationInfo it = locationInfo;
                boolean bl = false;
                Route route = this.createEntry(parent, it);
                locationInfo = route;
                if (route != null) break block3;
            }
            locationInfo = parent;
        }
        LocationInfo hierarchyEntry = locationInfo;
        return RoutingBuilderKt.createRouteFromPath((Route)hierarchyEntry, (String)info.getPath());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Route createEntry(@NotNull Route parent, @NotNull KClass<?> locationClass) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter(locationClass, (String)"locationClass");
        LocationInfo info = this.implementation.getOrCreateInfo(locationClass);
        Route pathRoute = this.createEntry(parent, info);
        Iterable $this$fold$iv = info.getQueryParameters();
        boolean $i$f$fold = false;
        Route accumulator$iv = pathRoute;
        for (Object element$iv : $this$fold$iv) {
            void query;
            LocationPropertyInfo locationPropertyInfo = (LocationPropertyInfo)element$iv;
            Route entry = accumulator$iv;
            boolean bl = false;
            RouteSelector selector = query.isOptional() ? (RouteSelector)new OptionalParameterRouteSelector(query.getName()) : (RouteSelector)new ParameterRouteSelector(query.getName());
            accumulator$iv = entry.createChild(selector);
        }
        return accumulator$iv;
    }

    @KtorDsl
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R&\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lio/ktor/server/locations/Locations$Configuration;", "", "()V", "routeService", "Lio/ktor/server/locations/LocationRouteService;", "getRouteService$annotations", "getRouteService", "()Lio/ktor/server/locations/LocationRouteService;", "setRouteService", "(Lio/ktor/server/locations/LocationRouteService;)V", "ktor-server-locations"})
    public static final class Configuration {
        @Nullable
        private LocationRouteService routeService;

        @Nullable
        public final LocationRouteService getRouteService() {
            return this.routeService;
        }

        public final void setRouteService(@Nullable LocationRouteService locationRouteService) {
            this.routeService = locationRouteService;
        }

        @KtorExperimentalLocationsAPI
        public static /* synthetic */ void getRouteService$annotations() {
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0005J)\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00022\u0017\u0010\f\u001a\u0013\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0002\b\u000fH\u0016R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Lio/ktor/server/locations/Locations$Plugin;", "Lio/ktor/server/application/BaseApplicationPlugin;", "Lio/ktor/server/application/Application;", "Lio/ktor/server/locations/Locations$Configuration;", "Lio/ktor/server/locations/Locations;", "()V", "key", "Lio/ktor/util/AttributeKey;", "getKey", "()Lio/ktor/util/AttributeKey;", "install", "pipeline", "configure", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "ktor-server-locations"})
    public static final class Plugin
    implements BaseApplicationPlugin<Application, Configuration, Locations> {
        private Plugin() {
        }

        @NotNull
        public AttributeKey<Locations> getKey() {
            return key;
        }

        @NotNull
        public Locations install(@NotNull Application pipeline, @NotNull Function1<? super Configuration, Unit> configure) {
            Intrinsics.checkNotNullParameter((Object)pipeline, (String)"pipeline");
            Intrinsics.checkNotNullParameter(configure, (String)"configure");
            Configuration configuration = new Configuration();
            configure.invoke((Object)configuration);
            Configuration configuration2 = configuration;
            LocationRouteService locationRouteService = configuration2.getRouteService();
            if (locationRouteService == null) {
                locationRouteService = new LocationAttributeRouteService();
            }
            LocationRouteService routeService = locationRouteService;
            return new Locations(pipeline, routeService);
        }

        public /* synthetic */ Plugin(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

