/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.locations;

import io.ktor.http.HttpUrlEncodedKt;
import io.ktor.http.Parameters;
import io.ktor.http.URLBuilder;
import io.ktor.http.URLBuilderKt;
import io.ktor.server.application.Application;
import io.ktor.server.application.ApplicationKt;
import io.ktor.server.locations.BackwardCompatibleImpl;
import io.ktor.server.locations.KtorExperimentalLocationsAPI;
import io.ktor.server.locations.LocationInfo;
import io.ktor.server.locations.LocationPropertyInfo;
import io.ktor.server.locations.LocationPropertyInfoImpl;
import io.ktor.server.locations.LocationRouteService;
import io.ktor.server.locations.LocationRoutingException;
import io.ktor.server.locations.LocationsImpl;
import io.ktor.server.plugins.MissingRequestParameterException;
import io.ktor.server.plugins.ParameterConversionException;
import io.ktor.server.routing.PathSegmentSelectorBuilder;
import io.ktor.server.routing.RoutingPath;
import io.ktor.server.routing.RoutingPathSegment;
import io.ktor.server.routing.RoutingPathSegmentKind;
import io.ktor.util.reflect.TypeInfo;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.KProperty1;
import kotlin.reflect.KType;
import kotlin.reflect.full.KClasses;
import kotlin.reflect.full.KClassifiers;
import kotlin.reflect.jvm.ReflectJvmMapping;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u00016B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J*\u0010\u0015\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0012H\u0002J\u0014\u0010\u001d\u001a\u00020\u001e2\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0016J&\u0010\u001d\u001a\u00020\u001e2\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030\u00132\u0010\u0010 \u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00130!H\u0002J\u0010\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u000bH\u0016J\u0018\u0010%\u001a\u00020'2\u0006\u0010(\u001a\u00020\u000b2\u0006\u0010)\u001a\u00020*H\u0016J\u0018\u0010+\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020\u001e2\u0006\u0010-\u001a\u00020\u0017H\u0016J\u0010\u0010.\u001a\u00020\b2\u0006\u0010(\u001a\u00020\u000bH\u0002J6\u0010/\u001a\u00020\b*\u00020\b2\u0006\u00100\u001a\u00020\u00192\u0018\u00101\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001903022\u0006\u00104\u001a\u00020\u0012H\u0002J\u0014\u00105\u001a\u00020\u000b*\u00020\u001e2\u0006\u0010-\u001a\u00020\u0017H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n*\u00020\f8BX\u0083\u0004\u00a2\u0006\f\u0012\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u00020\u0012*\u0006\u0012\u0002\b\u00030\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0014\u00a8\u00067"}, d2={"Lio/ktor/server/locations/BackwardCompatibleImpl;", "Lio/ktor/server/locations/LocationsImpl;", "application", "Lio/ktor/server/application/Application;", "routeService", "Lio/ktor/server/locations/LocationRouteService;", "(Lio/ktor/server/application/Application;Lio/ktor/server/locations/LocationRouteService;)V", "rootUri", "Lio/ktor/server/locations/BackwardCompatibleImpl$ResolvedUriInfo;", "getter", "Lkotlin/Function1;", "", "Lio/ktor/server/locations/LocationPropertyInfo;", "getGetter$annotations", "(Lio/ktor/server/locations/LocationPropertyInfo;)V", "getGetter", "(Lio/ktor/server/locations/LocationPropertyInfo;)Lkotlin/jvm/functions/Function1;", "isKotlinObject", "", "Lkotlin/reflect/KClass;", "(Lkotlin/reflect/KClass;)Z", "createFromParameters", "parameters", "Lio/ktor/http/Parameters;", "name", "", "type", "Lio/ktor/util/reflect/TypeInfo;", "optional", "getOrCreateInfo", "Lio/ktor/server/locations/LocationInfo;", "locationClass", "visited", "", "getParameterNameFromAnnotation", "parameter", "Lkotlin/reflect/KParameter;", "href", "instance", "", "location", "builder", "Lio/ktor/http/URLBuilder;", "instantiate", "info", "allParameters", "pathAndQuery", "combine", "relativePath", "queryValues", "", "Lkotlin/Pair;", "trailingSlash", "create", "ResolvedUriInfo", "ktor-server-locations"})
@SourceDebugExtension(value={"SMAP\nBackwardCompatibleImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackwardCompatibleImpl.kt\nio/ktor/server/locations/BackwardCompatibleImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,289:1\n1360#2:290\n1446#2,5:291\n819#2:296\n847#2,2:297\n1360#2:299\n1446#2,2:300\n1549#2:302\n1620#2,3:303\n1448#2,3:306\n1549#2:309\n1620#2,3:310\n819#2:313\n847#2,2:314\n819#2:316\n847#2,2:317\n1549#2:323\n1620#2,2:324\n661#2,11:326\n1622#2:337\n288#2,2:338\n1747#2,3:340\n766#2:343\n857#2,2:344\n1747#2,3:346\n766#2:349\n857#2,2:350\n766#2:352\n857#2,2:353\n1549#2:355\n1620#2,3:356\n1549#2:359\n1620#2,3:360\n766#2:363\n857#2,2:364\n766#2:366\n857#2,2:367\n819#2:369\n847#2,2:370\n618#2,12:376\n361#3,3:319\n364#3,4:372\n1#4:322\n*S KotlinDebug\n*F\n+ 1 BackwardCompatibleImpl.kt\nio/ktor/server/locations/BackwardCompatibleImpl\n*L\n83#1:290\n83#1:291,5\n98#1:296\n98#1:297,2\n110#1:299\n110#1:300,2\n112#1:302\n112#1:303,3\n110#1:306,3\n124#1:309\n124#1:310,3\n135#1:313\n135#1:314,2\n170#1:316\n170#1:317,2\n212#1:323\n212#1:324,2\n214#1:326,11\n212#1:337\n228#1:338,2\n239#1:340,3\n243#1:343\n243#1:344,2\n246#1:346,3\n250#1:349\n250#1:350,2\n264#1:352\n264#1:353,2\n265#1:355\n265#1:356,3\n267#1:359\n267#1:360,3\n268#1:363\n268#1:364,2\n275#1:366\n275#1:367,2\n277#1:369\n277#1:370,2\n78#1:376,12\n184#1:319,3\n184#1:372,4\n*E\n"})
public final class BackwardCompatibleImpl
extends LocationsImpl {
    @NotNull
    private final ResolvedUriInfo rootUri;

    public BackwardCompatibleImpl(@NotNull Application application, @NotNull LocationRouteService routeService) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)routeService, (String)"routeService");
        super(application, routeService);
        this.rootUri = new ResolvedUriInfo("", CollectionsKt.emptyList());
    }

    @Override
    @NotNull
    public LocationInfo getOrCreateInfo(@NotNull KClass<?> locationClass) {
        Intrinsics.checkNotNullParameter(locationClass, (String)"locationClass");
        LocationInfo locationInfo = this.getInfo().get(locationClass);
        if (locationInfo == null) {
            locationInfo = this.getOrCreateInfo(locationClass, new HashSet());
        }
        return locationInfo;
    }

    @Override
    @NotNull
    public Object instantiate(@NotNull LocationInfo info, @NotNull Parameters allParameters) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter((Object)allParameters, (String)"allParameters");
        return this.create(info, allParameters);
    }

    @Override
    @NotNull
    public String href(@NotNull Object instance) {
        Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
        ResolvedUriInfo info = this.pathAndQuery(instance);
        return info.getPath() + (CollectionsKt.any((Iterable)info.getQuery()) ? '?' + HttpUrlEncodedKt.formUrlEncode(info.getQuery()) : "");
    }

    @Override
    public void href(@NotNull Object location, @NotNull URLBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        ResolvedUriInfo info = this.pathAndQuery(location);
        URLBuilderKt.setEncodedPath((URLBuilder)builder, (String)info.getPath());
        for (Pair<String, String> pair : info.getQuery()) {
            String name = (String)pair.component1();
            String value = (String)pair.component2();
            builder.getParameters().append(name, value);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final ResolvedUriInfo pathAndQuery(Object location) {
        void $this$flatMapTo$iv$iv;
        ResolvedUriInfo resolvedUriInfo;
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        void $this$flatMapTo$iv$iv2;
        LocationInfo info = this.getOrCreateInfo(JvmClassMappingKt.getKotlinClass(location.getClass()));
        Iterable $this$flatMap$iv = RoutingPath.Companion.parse(info.getPath()).getParts();
        boolean $i$f$flatMap22 = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
            List<String> list;
            RoutingPathSegment it = (RoutingPathSegment)element$iv$iv;
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$0[it.getKind().ordinal()]) {
                case 1: {
                    list = CollectionsKt.listOf((Object)it.getValue());
                    break;
                }
                case 2: {
                    if (info.getKlass().getObjectInstance() != null) {
                        throw new IllegalArgumentException("There is no place to bind " + it.getValue() + " in object for '" + info.getKlass() + '\'');
                    }
                    list = BackwardCompatibleImpl.pathAndQuery$propertyValue(info, this, location, PathSegmentSelectorBuilder.INSTANCE.parseName(it.getValue()));
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List substituteParts = (List)destination$iv$iv;
        Iterable $i$f$flatMap22 = substituteParts;
        boolean $i$f$filterNot = false;
        destination$iv$iv = $this$filterNot$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterNotTo22 = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (((CharSequence)it).length() == 0) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        String relativePath2 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv2), (CharSequence)"/", null, null, (int)0, null, (Function1)pathAndQuery.relativePath.2.INSTANCE, (int)30, null);
        if (info.getParent() == null) {
            resolvedUriInfo = this.rootUri;
        } else if (info.getParentParameter() != null) {
            Object object = this.getGetter(info.getParentParameter()).invoke(location);
            Intrinsics.checkNotNull((Object)object);
            Object enclosingLocation = object;
            resolvedUriInfo = this.pathAndQuery(enclosingLocation);
        } else {
            resolvedUriInfo = new ResolvedUriInfo(info.getParent().getPath(), CollectionsKt.emptyList());
        }
        ResolvedUriInfo parentInfo = resolvedUriInfo;
        Iterable $this$flatMap$iv2 = info.getQueryParameters();
        boolean $i$f$flatMap = false;
        Iterable $i$f$filterNotTo22 = $this$flatMap$iv2;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$flatMapTo2 = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            LocationPropertyInfo property = (LocationPropertyInfo)element$iv$iv;
            boolean bl = false;
            Object value = this.getGetter(property).invoke(location);
            Iterable $this$map$iv = this.getConversionService().toValues(value);
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv4;
                boolean bl2 = false;
                collection.add(TuplesKt.to((Object)property.getName(), (Object)it));
            }
            Iterable list$iv$iv = (List)destination$iv$iv4;
            CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
        }
        List queryValues = (List)destination$iv$iv3;
        return this.combine(parentInfo, relativePath2, queryValues, StringsKt.endsWith$default((CharSequence)info.getPath(), (char)'/', (boolean)false, (int)2, null));
    }

    /*
     * WARNING - void declaration
     */
    private final Object create(LocationInfo $this$create, Parameters allParameters) {
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        void $this$mapTo$iv$iv;
        Object objectInstance;
        Object object = objectInstance = $this$create.getKlass().getObjectInstance();
        if (object != null) {
            return object;
        }
        KFunction kFunction = KClasses.getPrimaryConstructor($this$create.getKlass());
        if (kFunction == null) {
            kFunction = (KFunction)CollectionsKt.single((Iterable)$this$create.getKlass().getConstructors());
        }
        KFunction constructor = kFunction;
        List parameters = constructor.getParameters();
        Iterable $this$map$iv = parameters;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void parameter;
            KParameter kParameter = (KParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            KType parameterType = parameter.getType();
            KClassifier kClassifier = parameterType.getClassifier();
            Intrinsics.checkNotNull((Object)kClassifier, (String)"null cannot be cast to non-null type kotlin.reflect.KClass<*>");
            TypeInfo parameterTypeInfo = new TypeInfo((KClass)kClassifier, ReflectJvmMapping.getJavaType((KType)parameterType), parameterType);
            String string = parameter.getName();
            if (string == null) {
                string = this.getParameterNameFromAnnotation((KParameter)parameter);
            }
            String parameterName = string;
            Object value = $this$create.getParent() != null && Intrinsics.areEqual((Object)parameterType, (Object)KClassifiers.getStarProjectedType((KClassifier)((KClassifier)$this$create.getParent().getKlass()))) ? this.create($this$create.getParent(), allParameters) : this.createFromParameters(allParameters, parameterName, parameterTypeInfo, parameter.isOptional());
            collection.add(TuplesKt.to((Object)parameter, (Object)value));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot = false;
        $this$mapTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            Pair it = (Pair)element$iv$iv;
            boolean bl = false;
            if (((KParameter)it.getFirst()).isOptional() && it.getSecond() == null) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Map arguments = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        try {
            return constructor.callBy(arguments);
        }
        catch (InvocationTargetException cause) {
            Throwable throwable = cause.getCause();
            if (throwable == null) {
                throwable = cause;
            }
            throw throwable;
        }
    }

    private final Object createFromParameters(Parameters parameters, String name, TypeInfo type, boolean optional) {
        Object object;
        List values = parameters.getAll(name);
        if (values == null) {
            if (!optional) {
                throw new MissingRequestParameterException(name);
            }
            object = null;
        } else {
            Object object2;
            try {
                Object object3 = this.getConversionService().fromValues(values, type);
                if (object3 == null) {
                    object3 = CollectionsKt.emptyList();
                }
                object2 = object3;
            }
            catch (Throwable cause) {
                throw new ParameterConversionException(name, type.toString(), cause);
            }
            object = object2;
        }
        return object;
    }

    private final String getParameterNameFromAnnotation(KParameter parameter) {
        throw new NotImplementedError(null, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    private final ResolvedUriInfo combine(ResolvedUriInfo $this$combine, String relativePath2, List<Pair<String, String>> queryValues, boolean trailingSlash) {
        void $this$filterNotTo$iv$iv;
        String[] stringArray = new String[]{"/"};
        Collection collection = StringsKt.split$default((CharSequence)$this$combine.getPath(), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        stringArray = new String[]{"/"};
        Iterable $this$filterNot$iv = CollectionsKt.plus((Collection)collection, (Iterable)StringsKt.split$default((CharSequence)relativePath2, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (((CharSequence)it).length() == 0) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List pathElements = (List)destination$iv$iv;
        String combinedPath = !((Collection)pathElements).isEmpty() ? CollectionsKt.joinToString$default((Iterable)pathElements, (CharSequence)"/", (CharSequence)"/", (CharSequence)(trailingSlash ? "/" : ""), (int)0, null, null, (int)56, null) : "/";
        return new ResolvedUriInfo(combinedPath, CollectionsKt.plus((Collection)$this$combine.getQuery(), (Iterable)queryValues));
    }

    /*
     * WARNING - void declaration
     */
    private final LocationInfo getOrCreateInfo(KClass<?> locationClass, Set<KClass<?>> visited) {
        LocationInfo locationInfo;
        Map<KClass<?>, LocationInfo> $this$getOrPut$iv = this.getInfo();
        boolean $i$f$getOrPut = false;
        LocationInfo value$iv = $this$getOrPut$iv.get(locationClass);
        if (value$iv == null) {
            LocationInfo locationInfo2;
            String path;
            String string;
            LocationInfo parentInfo;
            LocationInfo locationInfo3;
            KClass outerClass;
            KClass kClass;
            Class<?> $i$a$-check-BackwardCompatibleImpl$getOrCreateInfo$1$222;
            boolean bl = false;
            if (!visited.add(locationClass)) {
                boolean $i$a$-check-BackwardCompatibleImpl$getOrCreateInfo$1$222 = false;
                String $i$a$-check-BackwardCompatibleImpl$getOrCreateInfo$1$222 = "Cyclic dependencies in locations are not allowed.";
                throw new IllegalStateException($i$a$-check-BackwardCompatibleImpl$getOrCreateInfo$1$222.toString());
            }
            Class<?> clazz = $i$a$-check-BackwardCompatibleImpl$getOrCreateInfo$1$222 = JvmClassMappingKt.getJavaClass(locationClass).getDeclaringClass();
            if (clazz != null) {
                Intrinsics.checkNotNullExpressionValue(clazz, (String)"declaringClass");
                kClass = JvmClassMappingKt.getKotlinClass($i$a$-check-BackwardCompatibleImpl$getOrCreateInfo$1$222);
            } else {
                kClass = null;
            }
            KClass kClass2 = outerClass = kClass;
            if (kClass2 != null) {
                KClass it = kClass2;
                boolean bl2 = false;
                locationInfo3 = this.getRouteService().findRoute(outerClass) != null ? this.getOrCreateInfo(outerClass, visited) : null;
            } else {
                locationInfo3 = parentInfo = null;
            }
            if (parentInfo != null && this.isKotlinObject(locationClass) && this.isKotlinObject(parentInfo.getKlass())) {
                ApplicationKt.getLog((Application)this.getApplication()).warn("Object nesting in Ktor Locations is going to be deprecated. Convert nested object to a class with parameter. See https://github.com/ktorio/ktor/issues/1660 for more details.");
            }
            if ((string = this.getRouteService().findRoute(locationClass)) == null) {
                string = path = "";
            }
            if (locationClass.getObjectInstance() != null) {
                locationInfo2 = new LocationInfo(locationClass, parentInfo, null, path, CollectionsKt.emptyList(), CollectionsKt.emptyList());
            } else {
                void $this$filterNotTo$iv$iv;
                void $this$filterTo$iv$iv;
                void $this$filterTo$iv$iv2;
                void $this$mapTo$iv$iv;
                void $this$mapTo$iv$iv2;
                void $this$map$iv;
                RoutingPathSegment it;
                void $this$filterTo$iv$iv3;
                Iterable $this$filter$iv;
                Object v10;
                LocationPropertyInfo it2;
                List declaredProperties;
                Collection collection;
                Iterator destination$iv$iv;
                block39: {
                    void $this$mapTo$iv$iv3;
                    KFunction kFunction = KClasses.getPrimaryConstructor(locationClass);
                    if (kFunction == null && (kFunction = (KFunction)CollectionsKt.singleOrNull((Iterable)locationClass.getConstructors())) == null) {
                        throw new IllegalArgumentException("Class " + locationClass + " cannot be instantiated because the constructor is missing");
                    }
                    KFunction constructor = kFunction;
                    Iterable $this$map$iv2 = constructor.getParameters();
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv2;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                        KProperty1 property;
                        Object v7;
                        void parameter;
                        block38: {
                            KParameter kParameter = (KParameter)item$iv$iv;
                            collection = destination$iv$iv;
                            boolean bl3 = false;
                            Iterable $this$singleOrNull$iv = KClasses.getDeclaredMemberProperties(locationClass);
                            boolean $i$f$singleOrNull = false;
                            Object single$iv = null;
                            boolean found$iv = false;
                            for (Object element$iv : $this$singleOrNull$iv) {
                                KProperty1 property2 = (KProperty1)element$iv;
                                boolean bl4 = false;
                                if (!Intrinsics.areEqual((Object)property2.getName(), (Object)parameter.getName())) continue;
                                if (found$iv) {
                                    v7 = null;
                                    break block38;
                                }
                                single$iv = element$iv;
                                found$iv = true;
                            }
                            v7 = !found$iv ? null : single$iv;
                        }
                        if ((KProperty1)v7 == null) {
                            throw new LocationRoutingException("Parameter " + parameter.getName() + " of constructor for class " + locationClass.getQualifiedName() + " should have corresponding property");
                        }
                        String string2 = parameter.getName();
                        if (string2 == null) {
                            string2 = "<unnamed>";
                        }
                        Intrinsics.checkNotNull((Object)property, (String)"null cannot be cast to non-null type kotlin.reflect.KProperty1<kotlin.Any, kotlin.Any?>");
                        collection.add(new LocationPropertyInfoImpl(string2, (KProperty1.Getter<Object, ? extends Object>)property.getGetter(), parameter.isOptional()));
                    }
                    declaredProperties = (List)((Object)destination$iv$iv);
                    Iterable $this$firstOrNull$iv = declaredProperties;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        it2 = (LocationPropertyInfoImpl)element$iv;
                        boolean bl5 = false;
                        KClass kClass3 = outerClass;
                        if (!Intrinsics.areEqual((Object)((LocationPropertyInfoImpl)it2).getKGetter().getReturnType(), (Object)(kClass3 != null ? KClassifiers.getStarProjectedType((KClassifier)((KClassifier)kClass3)) : null))) continue;
                        v10 = element$iv;
                        break block39;
                    }
                    v10 = null;
                }
                LocationPropertyInfoImpl parentParameter = v10;
                if (parentInfo != null && parentParameter == null) {
                    boolean bl6;
                    Iterator element$iv$iv;
                    Iterator $this$filterTo$iv$iv4;
                    void $this$filter$iv2;
                    boolean $i$f$filter;
                    Iterable $this$any$iv;
                    block41: {
                        boolean bl7;
                        boolean $i$f$any;
                        block40: {
                            if (parentInfo.getParentParameter() != null) {
                                throw new LocationRoutingException("Nested location '" + locationClass + "' should have parameter for parent location because it is chained to its parent");
                            }
                            $this$any$iv = parentInfo.getPathParameters();
                            $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl7 = false;
                            } else {
                                for (Object element$iv : $this$any$iv) {
                                    it2 = (LocationPropertyInfo)element$iv;
                                    boolean bl8 = false;
                                    if (!(!it2.isOptional())) continue;
                                    bl7 = true;
                                    break block40;
                                }
                                bl7 = false;
                            }
                        }
                        if (bl7) {
                            $this$any$iv = parentInfo.getPathParameters();
                            StringBuilder stringBuilder = new StringBuilder().append("Nested location '").append(locationClass).append("' should have parameter for parent location because of non-optional path parameters ");
                            $i$f$filter = false;
                            destination$iv$iv = $this$filter$iv2;
                            Collection destination$iv$iv2 = new ArrayList();
                            boolean $i$f$filterTo = false;
                            Iterator bl8 = $this$filterTo$iv$iv4.iterator();
                            while (bl8.hasNext()) {
                                element$iv$iv = bl8.next();
                                LocationPropertyInfo it3 = (LocationPropertyInfo)((Object)element$iv$iv);
                                boolean bl9 = false;
                                if (!(!it3.isOptional())) continue;
                                destination$iv$iv2.add(element$iv$iv);
                            }
                            String string3 = stringBuilder.append((List)destination$iv$iv2).toString();
                            throw new LocationRoutingException(string3);
                        }
                        $this$any$iv = parentInfo.getQueryParameters();
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl6 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                it2 = (LocationPropertyInfo)element$iv;
                                boolean bl10 = false;
                                if (!(!it2.isOptional())) continue;
                                bl6 = true;
                                break block41;
                            }
                            bl6 = false;
                        }
                    }
                    if (bl6) {
                        $this$any$iv = parentInfo.getQueryParameters();
                        StringBuilder stringBuilder = new StringBuilder().append("Nested location '").append(locationClass).append("' should have parameter for parent location because of non-optional query parameters ");
                        $i$f$filter = false;
                        $this$filterTo$iv$iv4 = $this$filter$iv2;
                        Collection destination$iv$iv3 = new ArrayList();
                        boolean $i$f$filterTo = false;
                        Iterator bl10 = $this$filterTo$iv$iv4.iterator();
                        while (bl10.hasNext()) {
                            element$iv$iv = bl10.next();
                            LocationPropertyInfo it4 = (LocationPropertyInfo)((Object)element$iv$iv);
                            boolean bl11 = false;
                            if (!(!it4.isOptional())) continue;
                            destination$iv$iv3.add(element$iv$iv);
                        }
                        String string4 = stringBuilder.append((List)destination$iv$iv3).toString();
                        throw new LocationRoutingException(string4);
                    }
                    if (!this.isKotlinObject(parentInfo.getKlass())) {
                        ApplicationKt.getLog((Application)this.getApplication()).warn("A nested location class should have a parameter with the type of the outer location class. See https://github.com/ktorio/ktor/issues/1660 for more details.");
                    }
                }
                Iterable $i$f$filter = RoutingPath.Companion.parse(path).getParts();
                boolean $i$f$filter2 = false;
                void destination$iv$iv3 = $this$filter$iv;
                Iterable destination$iv$iv4 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv3) {
                    it = (RoutingPathSegment)element$iv$iv;
                    boolean bl12 = false;
                    if (!(it.getKind() == RoutingPathSegmentKind.Parameter)) continue;
                    destination$iv$iv4.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv4;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv3 = $this$map$iv;
                destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    it = (RoutingPathSegment)item$iv$iv;
                    collection = destination$iv$iv4;
                    boolean bl13 = false;
                    collection.add(PathSegmentSelectorBuilder.INSTANCE.parseName(it.getValue()));
                }
                List pathParameterNames = (List)destination$iv$iv4;
                Iterable $this$map$iv3 = declaredProperties;
                boolean $i$f$map2 = false;
                destination$iv$iv4 = $this$map$iv3;
                Iterable destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it5;
                    LocationPropertyInfoImpl bl13 = (LocationPropertyInfoImpl)item$iv$iv;
                    collection = destination$iv$iv5;
                    boolean bl14 = false;
                    collection.add(it5.getName());
                }
                Set declaredParameterNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv5));
                Iterable $this$filter$iv3 = pathParameterNames;
                boolean $i$f$filter3 = false;
                destination$iv$iv5 = $this$filter$iv3;
                Iterable destination$iv$iv6 = new ArrayList();
                boolean $i$f$filterTo2 = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                    String it6 = (String)element$iv$iv;
                    boolean bl15 = false;
                    if (!(!declaredParameterNames.contains(it6))) continue;
                    destination$iv$iv6.add(element$iv$iv);
                }
                List invalidParameters = (List)destination$iv$iv6;
                if (CollectionsKt.any((Iterable)invalidParameters)) {
                    throw new LocationRoutingException("Path parameters '" + invalidParameters + "' are not bound to '" + locationClass + "' properties");
                }
                Iterable $this$filter$iv4 = declaredProperties;
                boolean $i$f$filter4 = false;
                destination$iv$iv6 = $this$filter$iv4;
                Iterable destination$iv$iv7 = new ArrayList();
                boolean $i$f$filterTo3 = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    LocationPropertyInfoImpl it7 = (LocationPropertyInfoImpl)element$iv$iv;
                    boolean bl16 = false;
                    if (!pathParameterNames.contains(it7.getName())) continue;
                    destination$iv$iv7.add(element$iv$iv);
                }
                List pathParameters = (List)destination$iv$iv7;
                Iterable $this$filterNot$iv = declaredProperties;
                boolean $i$f$filterNot = false;
                destination$iv$iv7 = $this$filterNot$iv;
                Collection destination$iv$iv8 = new ArrayList();
                boolean $i$f$filterNotTo = false;
                for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                    LocationPropertyInfoImpl it8 = (LocationPropertyInfoImpl)element$iv$iv;
                    boolean bl17 = false;
                    if (pathParameterNames.contains(it8.getName()) || Intrinsics.areEqual((Object)it8, (Object)parentParameter)) continue;
                    destination$iv$iv8.add(element$iv$iv);
                }
                List queryParameters = (List)destination$iv$iv8;
                locationInfo2 = new LocationInfo(locationClass, parentInfo, parentParameter, path, pathParameters, queryParameters);
            }
            LocationInfo answer$iv = locationInfo2;
            $this$getOrPut$iv.put(locationClass, answer$iv);
            locationInfo = answer$iv;
        } else {
            locationInfo = value$iv;
        }
        return locationInfo;
    }

    private final Function1<Object, Object> getGetter(LocationPropertyInfo $this$getter) {
        Intrinsics.checkNotNull((Object)$this$getter, (String)"null cannot be cast to non-null type io.ktor.server.locations.LocationPropertyInfoImpl");
        return (Function1)((LocationPropertyInfoImpl)$this$getter).getKGetter();
    }

    @KtorExperimentalLocationsAPI
    private static /* synthetic */ void getGetter$annotations(LocationPropertyInfo locationPropertyInfo) {
    }

    private final boolean isKotlinObject(KClass<?> $this$isKotlinObject) {
        return $this$isKotlinObject.isFinal() && $this$isKotlinObject.getObjectInstance() != null;
    }

    private static final List<String> pathAndQuery$propertyValue(LocationInfo info, BackwardCompatibleImpl this$0, Object instance, String name) {
        Iterable $this$single$iv = info.getPathParameters();
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            LocationPropertyInfo it = (LocationPropertyInfo)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Collection contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        LocationPropertyInfo property = single$iv;
        Object value = this$0.getGetter(property).invoke(instance);
        return this$0.getConversionService().toValues(value);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u001b\u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00060\u0005H\u00c6\u0003J/\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u001a\b\u0002\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR#\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lio/ktor/server/locations/BackwardCompatibleImpl$ResolvedUriInfo;", "", "path", "", "query", "", "Lkotlin/Pair;", "(Ljava/lang/String;Ljava/util/List;)V", "getPath", "()Ljava/lang/String;", "getQuery", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "ktor-server-locations"})
    private static final class ResolvedUriInfo {
        @NotNull
        private final String path;
        @NotNull
        private final List<Pair<String, String>> query;

        public ResolvedUriInfo(@NotNull String path, @NotNull List<Pair<String, String>> query) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter(query, (String)"query");
            this.path = path;
            this.query = query;
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        @NotNull
        public final List<Pair<String, String>> getQuery() {
            return this.query;
        }

        @NotNull
        public final String component1() {
            return this.path;
        }

        @NotNull
        public final List<Pair<String, String>> component2() {
            return this.query;
        }

        @NotNull
        public final ResolvedUriInfo copy(@NotNull String path, @NotNull List<Pair<String, String>> query) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter(query, (String)"query");
            return new ResolvedUriInfo(path, query);
        }

        public static /* synthetic */ ResolvedUriInfo copy$default(ResolvedUriInfo resolvedUriInfo, String string, List list, int n, Object object) {
            if ((n & 1) != 0) {
                string = resolvedUriInfo.path;
            }
            if ((n & 2) != 0) {
                list = resolvedUriInfo.query;
            }
            return resolvedUriInfo.copy(string, list);
        }

        @NotNull
        public String toString() {
            return "ResolvedUriInfo(path=" + this.path + ", query=" + this.query + ')';
        }

        public int hashCode() {
            int result = this.path.hashCode();
            result = result * 31 + ((Object)this.query).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ResolvedUriInfo)) {
                return false;
            }
            ResolvedUriInfo resolvedUriInfo = (ResolvedUriInfo)other;
            if (!Intrinsics.areEqual((Object)this.path, (Object)resolvedUriInfo.path)) {
                return false;
            }
            return Intrinsics.areEqual(this.query, resolvedUriInfo.query);
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RoutingPathSegmentKind.values().length];
            try {
                nArray[RoutingPathSegmentKind.Constant.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RoutingPathSegmentKind.Parameter.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

