/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.netty.http1;

import io.ktor.server.application.Application;
import io.ktor.server.application.ApplicationKt;
import io.ktor.server.engine.ApplicationEngineEnvironment;
import io.ktor.server.engine.EnginePipeline;
import io.ktor.server.netty.NettyApplicationCallHandler;
import io.ktor.server.netty.cio.NettyHttpResponsePipeline;
import io.ktor.server.netty.cio.RequestBodyHandler;
import io.ktor.server.netty.http1.NettyHttp1ApplicationCall;
import io.ktor.util.cio.ChannelIOException;
import io.ktor.utils.io.ByteReadChannel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.concurrent.EventExecutorGroup;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\b\u0000\u0018\u00002\u00020<2\u00020=B7\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0012J\u0017\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0012J\u001f\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0019\u0010\u0019\u001a\u00020\u00102\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u0016\u00a2\u0006\u0004\b\u0019\u0010\u0012J\u001f\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001aH\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001f\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u001eH\u0002\u00a2\u0006\u0004\b\u001f\u0010 J\u0017\u0010\"\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u000eH\u0000\u00a2\u0006\u0004\b!\u0010\u0012J\u001f\u0010$\u001a\u00020#2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u001eH\u0002\u00a2\u0006\u0004\b$\u0010%J\u001f\u0010'\u001a\u00020&2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u001eH\u0002\u00a2\u0006\u0004\b'\u0010(R\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010)R\u0014\u0010,\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u0014\u0010\b\u001a\u00020\u00078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010-R\u0014\u0010\u0002\u001a\u00020\u00018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0002\u0010.R\u0014\u0010\u0004\u001a\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010/R\u001a\u00102\u001a\b\u0012\u0004\u0012\u000201008\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b2\u00103R\u0016\u00105\u001a\u0002048\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b5\u00106R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u00107R\u0016\u00109\u001a\u0002088\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b9\u0010:R\u0014\u0010\t\u001a\u00020\u00078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010-\u00a8\u0006;"}, d2={"Lio/ktor/server/netty/http1/NettyHttp1Handler;", "Lio/ktor/server/engine/EnginePipeline;", "enginePipeline", "Lio/ktor/server/engine/ApplicationEngineEnvironment;", "environment", "Lio/netty/util/concurrent/EventExecutorGroup;", "callEventGroup", "Lkotlin/coroutines/CoroutineContext;", "engineContext", "userContext", "", "runningLimit", "<init>", "(Lio/ktor/server/engine/EnginePipeline;Lio/ktor/server/engine/ApplicationEngineEnvironment;Lio/netty/util/concurrent/EventExecutorGroup;Lkotlin/coroutines/CoroutineContext;Lkotlin/coroutines/CoroutineContext;I)V", "Lio/netty/channel/ChannelHandlerContext;", "context", "", "callReadIfNeeded", "(Lio/netty/channel/ChannelHandlerContext;)V", "channelActive", "channelInactive", "", "message", "channelRead", "(Lio/netty/channel/ChannelHandlerContext;Ljava/lang/Object;)V", "channelReadComplete", "", "cause", "exceptionCaught", "(Lio/netty/channel/ChannelHandlerContext;Ljava/lang/Throwable;)V", "Lio/netty/handler/codec/http/HttpRequest;", "handleRequest", "(Lio/netty/channel/ChannelHandlerContext;Lio/netty/handler/codec/http/HttpRequest;)V", "onLastResponseMessage$ktor_server_netty", "onLastResponseMessage", "Lio/ktor/server/netty/http1/NettyHttp1ApplicationCall;", "prepareCallFromRequest", "(Lio/netty/channel/ChannelHandlerContext;Lio/netty/handler/codec/http/HttpRequest;)Lio/ktor/server/netty/http1/NettyHttp1ApplicationCall;", "Lio/ktor/utils/io/ByteReadChannel;", "prepareRequestContentChannel", "(Lio/netty/channel/ChannelHandlerContext;Lio/netty/handler/codec/http/HttpRequest;)Lio/ktor/utils/io/ByteReadChannel;", "Lio/netty/util/concurrent/EventExecutorGroup;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "Lio/ktor/server/engine/EnginePipeline;", "Lio/ktor/server/engine/ApplicationEngineEnvironment;", "Lkotlinx/coroutines/CompletableDeferred;", "", "handlerJob", "Lkotlinx/coroutines/CompletableDeferred;", "Lio/ktor/server/netty/cio/NettyHttpResponsePipeline;", "responseWriter", "Lio/ktor/server/netty/cio/NettyHttpResponsePipeline;", "I", "", "skipEmpty", "Z", "ktor-server-netty", "Lio/netty/channel/ChannelInboundHandlerAdapter;", "Lkotlinx/coroutines/CoroutineScope;"})
public final class NettyHttp1Handler
extends ChannelInboundHandlerAdapter
implements CoroutineScope {
    @NotNull
    private final EnginePipeline enginePipeline;
    @NotNull
    private final ApplicationEngineEnvironment environment;
    @NotNull
    private final EventExecutorGroup callEventGroup;
    @NotNull
    private final CoroutineContext engineContext;
    @NotNull
    private final CoroutineContext userContext;
    private final int runningLimit;
    @NotNull
    private final CompletableDeferred handlerJob;
    private boolean skipEmpty;
    @NotNull
    private volatile /* synthetic */ int skippedRead;
    private static final /* synthetic */ AtomicIntegerFieldUpdater skippedRead$FU;
    private NettyHttpResponsePipeline responseWriter;
    @NotNull
    public volatile /* synthetic */ long activeRequests$internal;
    public static final /* synthetic */ AtomicLongFieldUpdater activeRequests$FU$internal;
    @NotNull
    public volatile /* synthetic */ int isCurrentRequestFullyRead$internal;
    public static final /* synthetic */ AtomicIntegerFieldUpdater isCurrentRequestFullyRead$FU$internal;
    @NotNull
    public volatile /* synthetic */ int isChannelReadCompleted$internal;
    public static final /* synthetic */ AtomicIntegerFieldUpdater isChannelReadCompleted$FU$internal;

    public NettyHttp1Handler(@NotNull EnginePipeline enginePipeline, @NotNull ApplicationEngineEnvironment environment, @NotNull EventExecutorGroup callEventGroup2, @NotNull CoroutineContext engineContext, @NotNull CoroutineContext userContext, int runningLimit) {
        Intrinsics.checkNotNullParameter((Object)enginePipeline, (String)"enginePipeline");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)callEventGroup2, (String)"callEventGroup");
        Intrinsics.checkNotNullParameter((Object)engineContext, (String)"engineContext");
        Intrinsics.checkNotNullParameter((Object)userContext, (String)"userContext");
        this.enginePipeline = enginePipeline;
        this.environment = environment;
        this.callEventGroup = callEventGroup2;
        this.engineContext = engineContext;
        this.userContext = userContext;
        this.runningLimit = runningLimit;
        this.handlerJob = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        this.skippedRead = 0;
        this.activeRequests$internal = 0L;
        this.isCurrentRequestFullyRead$internal = 0;
        this.isChannelReadCompleted$internal = 0;
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return (CoroutineContext)this.handlerJob;
    }

    public void channelActive(@NotNull ChannelHandlerContext context) {
        ChannelPipeline channelPipeline;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.responseWriter = new NettyHttpResponsePipeline(context, this, this.getCoroutineContext());
        context.channel().config().setAutoRead(false);
        context.channel().read();
        ChannelPipeline $this$channelActive_u24lambda_u2d0 = channelPipeline = context.pipeline();
        boolean bl = false;
        ChannelHandler[] channelHandlerArray = new ChannelHandler[]{(ChannelHandler)new RequestBodyHandler(context)};
        $this$channelActive_u24lambda_u2d0.addLast(channelHandlerArray);
        channelHandlerArray = new ChannelHandler[]{(ChannelHandler)new NettyApplicationCallHandler(this.userContext, this.enginePipeline)};
        $this$channelActive_u24lambda_u2d0.addLast(this.callEventGroup, channelHandlerArray);
        context.fireChannelActive();
    }

    public void channelRead(@NotNull ChannelHandlerContext context, @NotNull Object message) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (message instanceof LastHttpContent) {
            isCurrentRequestFullyRead$FU$internal.compareAndSet(this, 0, 1);
        }
        if (message instanceof HttpRequest) {
            if (!(message instanceof LastHttpContent)) {
                isCurrentRequestFullyRead$FU$internal.compareAndSet(this, 1, 0);
            }
            isChannelReadCompleted$FU$internal.compareAndSet(this, 1, 0);
            activeRequests$FU$internal.incrementAndGet(this);
            this.handleRequest(context, (HttpRequest)message);
            this.callReadIfNeeded(context);
        } else if (message instanceof LastHttpContent && !((LastHttpContent)message).content().isReadable() && this.skipEmpty) {
            this.skipEmpty = false;
            ((LastHttpContent)message).release();
            this.callReadIfNeeded(context);
        } else {
            context.fireChannelRead(message);
        }
    }

    public void channelInactive(@NotNull ChannelHandlerContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        context.pipeline().remove(NettyApplicationCallHandler.class);
        context.fireChannelInactive();
    }

    public void exceptionCaught(@NotNull ChannelHandlerContext context, @NotNull Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        if (cause instanceof IOException || cause instanceof ChannelIOException) {
            ApplicationKt.getLog((Application)this.environment.getApplication()).debug("I/O operation failed", cause);
            Job.DefaultImpls.cancel$default((Job)((Job)this.handlerJob), null, (int)1, null);
        } else {
            this.handlerJob.completeExceptionally(cause);
        }
        context.close();
    }

    public void channelReadComplete(@Nullable ChannelHandlerContext context) {
        isChannelReadCompleted$FU$internal.compareAndSet(this, 0, 1);
        NettyHttpResponsePipeline nettyHttpResponsePipeline = this.responseWriter;
        if (nettyHttpResponsePipeline == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"responseWriter");
            nettyHttpResponsePipeline = null;
        }
        nettyHttpResponsePipeline.flushIfNeeded$ktor_server_netty();
        super.channelReadComplete(context);
    }

    private final void handleRequest(ChannelHandlerContext context, HttpRequest message) {
        NettyHttp1ApplicationCall call = this.prepareCallFromRequest(context, message);
        context.fireChannelRead((Object)call);
        NettyHttpResponsePipeline nettyHttpResponsePipeline = this.responseWriter;
        if (nettyHttpResponsePipeline == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"responseWriter");
            nettyHttpResponsePipeline = null;
        }
        nettyHttpResponsePipeline.processResponse$ktor_server_netty(call);
    }

    private final NettyHttp1ApplicationCall prepareCallFromRequest(ChannelHandlerContext context, HttpRequest message) {
        ByteReadChannel byteReadChannel;
        if (message instanceof LastHttpContent && !((LastHttpContent)message).content().isReadable()) {
            byteReadChannel = null;
        } else if (message.method() == HttpMethod.GET && !HttpUtil.isContentLengthSet((HttpMessage)((HttpMessage)message)) && !HttpUtil.isTransferEncodingChunked((HttpMessage)((HttpMessage)message))) {
            this.skipEmpty = true;
            byteReadChannel = null;
        } else {
            byteReadChannel = this.prepareRequestContentChannel(context, message);
        }
        ByteReadChannel requestBodyChannel = byteReadChannel;
        return new NettyHttp1ApplicationCall(this.environment.getApplication(), context, message, requestBodyChannel, this.engineContext, this.userContext);
    }

    private final ByteReadChannel prepareRequestContentChannel(ChannelHandlerContext context, HttpRequest message) {
        RequestBodyHandler bodyHandler = (RequestBodyHandler)context.pipeline().get(RequestBodyHandler.class);
        ByteReadChannel result = bodyHandler.newChannel();
        if (message instanceof HttpContent) {
            bodyHandler.channelRead(context, message);
        }
        return result;
    }

    private final void callReadIfNeeded(ChannelHandlerContext context) {
        if (this.activeRequests$internal < (long)this.runningLimit) {
            context.read();
            this.skippedRead = 0;
        } else {
            this.skippedRead = 1;
        }
    }

    public final void onLastResponseMessage$ktor_server_netty(@NotNull ChannelHandlerContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        activeRequests$FU$internal.decrementAndGet(this);
        if (skippedRead$FU.compareAndSet(this, 0, 1) && this.activeRequests$internal < (long)this.runningLimit) {
            context.read();
        }
    }

    static {
        skippedRead$FU = AtomicIntegerFieldUpdater.newUpdater(NettyHttp1Handler.class, "skippedRead");
        activeRequests$FU$internal = AtomicLongFieldUpdater.newUpdater(NettyHttp1Handler.class, "activeRequests$internal");
        isCurrentRequestFullyRead$FU$internal = AtomicIntegerFieldUpdater.newUpdater(NettyHttp1Handler.class, "isCurrentRequestFullyRead$internal");
        isChannelReadCompleted$FU$internal = AtomicIntegerFieldUpdater.newUpdater(NettyHttp1Handler.class, "isChannelReadCompleted$internal");
    }
}

