/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.netty.http2;

import io.ktor.server.application.Application;
import io.ktor.server.application.ApplicationCall;
import io.ktor.server.engine.BaseApplicationCall;
import io.ktor.server.netty.NettyApplicationCall;
import io.ktor.server.netty.http2.NettyHttp2ApplicationRequest;
import io.ktor.server.netty.http2.NettyHttp2ApplicationResponse;
import io.ktor.server.netty.http2.NettyHttp2Handler;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.DefaultHttp2DataFrame;
import io.netty.handler.codec.http2.Http2Headers;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\rJ\r\u0010\u0018\u001a\u00020\u0019H\u0010\u00a2\u0006\u0002\b\u001aJ\u0017\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u0019H\u0010\u00a2\u0006\u0002\b\u001eJ\u001d\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0019H\u0010\u00a2\u0006\u0002\b#J\u0015\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0005H\u0010\u00a2\u0006\u0002\b'R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006("}, d2={"Lio/ktor/server/netty/http2/NettyHttp2ApplicationCall;", "Lio/ktor/server/netty/NettyApplicationCall;", "application", "Lio/ktor/server/application/Application;", "context", "Lio/netty/channel/ChannelHandlerContext;", "headers", "Lio/netty/handler/codec/http2/Http2Headers;", "handler", "Lio/ktor/server/netty/http2/NettyHttp2Handler;", "engineContext", "Lkotlin/coroutines/CoroutineContext;", "userContext", "(Lio/ktor/server/application/Application;Lio/netty/channel/ChannelHandlerContext;Lio/netty/handler/codec/http2/Http2Headers;Lio/ktor/server/netty/http2/NettyHttp2Handler;Lkotlin/coroutines/CoroutineContext;Lkotlin/coroutines/CoroutineContext;)V", "getHeaders", "()Lio/netty/handler/codec/http2/Http2Headers;", "request", "Lio/ktor/server/netty/http2/NettyHttp2ApplicationRequest;", "getRequest", "()Lio/ktor/server/netty/http2/NettyHttp2ApplicationRequest;", "response", "Lio/ktor/server/netty/http2/NettyHttp2ApplicationResponse;", "getResponse", "()Lio/ktor/server/netty/http2/NettyHttp2ApplicationResponse;", "isContextCloseRequired", "", "isContextCloseRequired$ktor_server_netty", "prepareEndOfStreamMessage", "", "lastTransformed", "prepareEndOfStreamMessage$ktor_server_netty", "prepareMessage", "buf", "Lio/netty/buffer/ByteBuf;", "isLastContent", "prepareMessage$ktor_server_netty", "upgrade", "", "dst", "upgrade$ktor_server_netty", "ktor-server-netty"})
public final class NettyHttp2ApplicationCall
extends NettyApplicationCall {
    @NotNull
    private final Http2Headers headers;
    @NotNull
    private final NettyHttp2ApplicationRequest request;
    @NotNull
    private final NettyHttp2ApplicationResponse response;

    public NettyHttp2ApplicationCall(@NotNull Application application, @NotNull ChannelHandlerContext context, @NotNull Http2Headers headers2, @NotNull NettyHttp2Handler handler, @NotNull CoroutineContext engineContext, @NotNull CoroutineContext userContext) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)headers2, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)((Object)handler), (String)"handler");
        Intrinsics.checkNotNullParameter((Object)engineContext, (String)"engineContext");
        Intrinsics.checkNotNullParameter((Object)userContext, (String)"userContext");
        super(application, context, headers2);
        this.headers = headers2;
        this.request = new NettyHttp2ApplicationRequest((ApplicationCall)this, engineContext, context, this.headers, null, 16, null);
        this.response = new NettyHttp2ApplicationResponse(this, handler, context, engineContext, userContext);
        BaseApplicationCall.putResponseAttribute$default((BaseApplicationCall)this, null, (int)1, null);
    }

    @NotNull
    public final Http2Headers getHeaders() {
        return this.headers;
    }

    @Override
    @NotNull
    public NettyHttp2ApplicationRequest getRequest() {
        return this.request;
    }

    @Override
    @NotNull
    public NettyHttp2ApplicationResponse getResponse() {
        return this.response;
    }

    @Override
    @NotNull
    public Object prepareMessage$ktor_server_netty(@NotNull ByteBuf buf, boolean isLastContent) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        if (this.isByteBufferContent$ktor_server_netty()) {
            return super.prepareMessage$ktor_server_netty(buf, isLastContent);
        }
        return new DefaultHttp2DataFrame(buf, isLastContent);
    }

    @Override
    @Nullable
    public Object prepareEndOfStreamMessage$ktor_server_netty(boolean lastTransformed) {
        if (this.isByteBufferContent$ktor_server_netty()) {
            return super.prepareEndOfStreamMessage$ktor_server_netty(lastTransformed);
        }
        return lastTransformed ? null : new DefaultHttp2DataFrame(true);
    }

    @Override
    public void upgrade$ktor_server_netty(@NotNull ChannelHandlerContext dst) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        if (this.isByteBufferContent$ktor_server_netty()) {
            super.upgrade$ktor_server_netty(dst);
            return;
        }
        throw new IllegalStateException("HTTP/2 doesn't support upgrade");
    }

    @Override
    public boolean isContextCloseRequired$ktor_server_netty() {
        return false;
    }
}

