/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.handler.codec.http.HttpContent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\nH\u0014J \u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u0005H\u0014\u00a8\u0006\u000e"}, d2={"Lio/ktor/server/netty/NettyDirectEncoder;", "Lio/netty/handler/codec/MessageToByteEncoder;", "Lio/netty/handler/codec/http/HttpContent;", "()V", "allocateBuffer", "Lio/netty/buffer/ByteBuf;", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "msg", "preferDirect", "", "encode", "", "out", "ktor-server-netty"})
public final class NettyDirectEncoder
extends MessageToByteEncoder<HttpContent> {
    protected void encode(@NotNull ChannelHandlerContext ctx, @NotNull HttpContent msg, @NotNull ByteBuf out) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeBytes(msg.content());
    }

    @NotNull
    protected ByteBuf allocateBuffer(@NotNull ChannelHandlerContext ctx, @Nullable HttpContent msg, boolean preferDirect) {
        ByteBuf byteBuf;
        int size;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        HttpContent httpContent = msg;
        int n = httpContent != null && (httpContent = httpContent.content()) != null ? httpContent.readableBytes() : (size = 0);
        if (size == 0) {
            ByteBuf byteBuf2 = Unpooled.EMPTY_BUFFER;
            Intrinsics.checkNotNull((Object)byteBuf2);
            byteBuf = byteBuf2;
        } else if (preferDirect) {
            ByteBuf byteBuf3 = ctx.alloc().ioBuffer(size);
            Intrinsics.checkNotNull((Object)byteBuf3);
            byteBuf = byteBuf3;
        } else {
            ByteBuf byteBuf4 = ctx.alloc().heapBuffer(size);
            byteBuf = byteBuf4;
            Intrinsics.checkNotNullExpressionValue((Object)byteBuf4, (String)"heapBuffer(...)");
        }
        return byteBuf;
    }
}

