/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.netty;

import io.ktor.server.engine.ApplicationEngineEnvironment;
import io.ktor.server.engine.EngineAPI;
import io.ktor.server.engine.EngineConnectorConfig;
import io.ktor.server.engine.EnginePipeline;
import io.ktor.server.engine.EngineSSLConnectorConfig;
import io.ktor.server.netty.NettyChannelInitializer;
import io.ktor.server.netty.cio.NettyRequestQueue;
import io.ktor.server.netty.http1.NettyHttp1Handler;
import io.ktor.server.netty.http2.NettyHttp2Handler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerExpectContinueHandler;
import io.netty.handler.codec.http2.Http2MultiplexCodecBuilder;
import io.netty.handler.codec.http2.Http2SecurityUtil;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import io.netty.handler.timeout.WriteTimeoutHandler;
import io.netty.util.concurrent.EventExecutorGroup;
import java.nio.channels.ClosedChannelException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@EngineAPI
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0007\u0018\u0000  2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002 !B[\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u0012\u0006\u0010\u0011\u001a\u00020\u000f\u0012\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\u0002\u0010\u0015J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u0002H\u0014R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lio/ktor/server/netty/NettyChannelInitializer;", "Lio/netty/channel/ChannelInitializer;", "Lio/netty/channel/socket/SocketChannel;", "enginePipeline", "Lio/ktor/server/engine/EnginePipeline;", "environment", "Lio/ktor/server/engine/ApplicationEngineEnvironment;", "callEventGroup", "Lio/netty/util/concurrent/EventExecutorGroup;", "engineContext", "Lkotlin/coroutines/CoroutineContext;", "userContext", "connector", "Lio/ktor/server/engine/EngineConnectorConfig;", "requestQueueLimit", "", "runningLimit", "responseWriteTimeout", "httpServerCodec", "Lkotlin/Function0;", "Lio/netty/handler/codec/http/HttpServerCodec;", "(Lio/ktor/server/engine/EnginePipeline;Lio/ktor/server/engine/ApplicationEngineEnvironment;Lio/netty/util/concurrent/EventExecutorGroup;Lkotlin/coroutines/CoroutineContext;Lkotlin/coroutines/CoroutineContext;Lio/ktor/server/engine/EngineConnectorConfig;IIILkotlin/jvm/functions/Function0;)V", "sslContext", "Lio/netty/handler/ssl/SslContext;", "configurePipeline", "", "pipeline", "Lio/netty/channel/ChannelPipeline;", "protocol", "", "initChannel", "ch", "Companion", "NegotiatedPipelineInitializer", "ktor-server-netty"})
public final class NettyChannelInitializer
extends ChannelInitializer<SocketChannel> {
    private SslContext sslContext;
    private final EnginePipeline enginePipeline;
    private final ApplicationEngineEnvironment environment;
    private final EventExecutorGroup callEventGroup;
    private final CoroutineContext engineContext;
    private final CoroutineContext userContext;
    private final EngineConnectorConfig connector;
    private final int requestQueueLimit;
    private final int runningLimit;
    private final int responseWriteTimeout;
    private final Function0<HttpServerCodec> httpServerCodec;
    @Nullable
    private static final Lazy alpnProvider$delegate;
    public static final Companion Companion;

    protected void initChannel(@NotNull SocketChannel ch) {
        ChannelPipeline channelPipeline;
        Intrinsics.checkParameterIsNotNull((Object)ch, (String)"ch");
        ChannelPipeline $receiver = channelPipeline = ch.pipeline();
        boolean bl = false;
        if (this.connector instanceof EngineSSLConnectorConfig) {
            SslContext sslContext = this.sslContext;
            if (sslContext == null) {
                Intrinsics.throwNpe();
            }
            $receiver.addLast("ssl", (ChannelHandler)sslContext.newHandler(ch.alloc()));
            if (Companion.getAlpnProvider$ktor_server_netty() != null) {
                $receiver.addLast(new ChannelHandler[]{(ChannelHandler)new NegotiatedPipelineInitializer()});
            } else {
                ChannelPipeline channelPipeline2 = $receiver;
                Intrinsics.checkExpressionValueIsNotNull((Object)channelPipeline2, (String)"this");
                this.configurePipeline(channelPipeline2, "http/1.1");
            }
        } else {
            ChannelPipeline channelPipeline3 = $receiver;
            Intrinsics.checkExpressionValueIsNotNull((Object)channelPipeline3, (String)"this");
            this.configurePipeline(channelPipeline3, "http/1.1");
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void configurePipeline(ChannelPipeline pipeline, String protocol) {
        block4: {
            var3_3 = protocol;
            switch (var3_3.hashCode()) {
                case -134242387: {
                    if (!var3_3.equals("http/1.1")) ** break;
                    break;
                }
                case 3274: {
                    if (!var3_3.equals("h2")) ** break;
                    handler = new NettyHttp2Handler(this.enginePipeline, this.environment.getApplication(), this.callEventGroup, this.userContext);
                    pipeline.addLast(new ChannelHandler[]{(ChannelHandler)Http2MultiplexCodecBuilder.forServer((ChannelHandler)((ChannelHandler)handler)).build()});
                    break block4;
                }
            }
            requestQueue = new NettyRequestQueue(this.requestQueueLimit, this.runningLimit);
            handler = new NettyHttp1Handler(this.enginePipeline, this.environment, this.callEventGroup, this.engineContext, this.userContext, requestQueue);
            $receiver = pipeline;
            $i$a$-with-NettyChannelInitializer$configurePipeline$1 = false;
            $receiver.addLast("codec", (ChannelHandler)this.httpServerCodec.invoke());
            $receiver.addLast("continue", (ChannelHandler)new HttpServerExpectContinueHandler());
            $receiver.addLast("timeout", (ChannelHandler)new WriteTimeoutHandler(this.responseWriteTimeout));
            $receiver.addLast("http1", (ChannelHandler)handler);
            pipeline.context("codec").fireChannelActive();
            break block4;
            this.environment.getLog().error("Unsupported protocol " + protocol);
            pipeline.close();
        }
    }

    public NettyChannelInitializer(@NotNull EnginePipeline enginePipeline, @NotNull ApplicationEngineEnvironment environment, @NotNull EventExecutorGroup callEventGroup, @NotNull CoroutineContext engineContext, @NotNull CoroutineContext userContext, @NotNull EngineConnectorConfig connector, int requestQueueLimit, int runningLimit, int responseWriteTimeout, @NotNull Function0<HttpServerCodec> httpServerCodec2) {
        Intrinsics.checkParameterIsNotNull((Object)enginePipeline, (String)"enginePipeline");
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        Intrinsics.checkParameterIsNotNull((Object)callEventGroup, (String)"callEventGroup");
        Intrinsics.checkParameterIsNotNull((Object)engineContext, (String)"engineContext");
        Intrinsics.checkParameterIsNotNull((Object)userContext, (String)"userContext");
        Intrinsics.checkParameterIsNotNull((Object)connector, (String)"connector");
        Intrinsics.checkParameterIsNotNull(httpServerCodec2, (String)"httpServerCodec");
        this.enginePipeline = enginePipeline;
        this.environment = environment;
        this.callEventGroup = callEventGroup;
        this.engineContext = engineContext;
        this.userContext = userContext;
        this.connector = connector;
        this.requestQueueLimit = requestQueueLimit;
        this.runningLimit = runningLimit;
        this.responseWriteTimeout = responseWriteTimeout;
        this.httpServerCodec = httpServerCodec2;
        if (this.connector instanceof EngineSSLConnectorConfig) {
            Collection $receiver$iv;
            Object[] objectArray = ((EngineSSLConnectorConfig)this.connector).getKeyStore().getCertificateChain(((EngineSSLConnectorConfig)this.connector).getKeyAlias());
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"connector.keyStore.getCe\u2026Chain(connector.keyAlias)");
            List list = ArraysKt.toList((Object[])objectArray);
            if (list == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<java.security.cert.X509Certificate>");
            }
            List chain1 = list;
            Collection collection = $receiver$iv = (Collection)CollectionsKt.toList((Iterable)chain1);
            if (collection == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            Collection thisCollection$iv = collection;
            X509Certificate[] x509CertificateArray = thisCollection$iv.toArray(new X509Certificate[0]);
            if (x509CertificateArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            X509Certificate[] certs = x509CertificateArray;
            char[] password = (char[])((EngineSSLConnectorConfig)this.connector).getPrivateKeyPassword().invoke();
            Key key = ((EngineSSLConnectorConfig)this.connector).getKeyStore().getKey(((EngineSSLConnectorConfig)this.connector).getKeyAlias(), password);
            if (key == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.security.PrivateKey");
            }
            PrivateKey pk = (PrivateKey)key;
            ArraysKt.fill$default((char[])password, (char)'\u0000', (int)0, (int)0, (int)6, null);
            SslContextBuilder sslContextBuilder = SslContextBuilder.forServer((PrivateKey)pk, (X509Certificate[])Arrays.copyOf(certs, certs.length));
            NettyChannelInitializer nettyChannelInitializer = this;
            SslContextBuilder $receiver = sslContextBuilder;
            boolean bl = false;
            if (Companion.getAlpnProvider$ktor_server_netty() != null) {
                $receiver.sslProvider(Companion.getAlpnProvider$ktor_server_netty());
                $receiver.ciphers((Iterable)Http2SecurityUtil.CIPHERS, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE);
                $receiver.applicationProtocolConfig(new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"h2", "http/1.1"}));
            }
            SslContextBuilder sslContextBuilder2 = sslContextBuilder;
            nettyChannelInitializer.sslContext = sslContextBuilder2.build();
        }
    }

    static {
        Companion = new Companion(null);
        alpnProvider$delegate = LazyKt.lazy((Function0)Companion.alpnProvider.2.INSTANCE);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u001a\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0014\u00a8\u0006\f"}, d2={"Lio/ktor/server/netty/NettyChannelInitializer$NegotiatedPipelineInitializer;", "Lio/netty/handler/ssl/ApplicationProtocolNegotiationHandler;", "(Lio/ktor/server/netty/NettyChannelInitializer;)V", "configurePipeline", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "protocol", "", "handshakeFailure", "cause", "", "ktor-server-netty"})
    private final class NegotiatedPipelineInitializer
    extends ApplicationProtocolNegotiationHandler {
        protected void configurePipeline(@NotNull ChannelHandlerContext ctx, @NotNull String protocol) {
            Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
            Intrinsics.checkParameterIsNotNull((Object)protocol, (String)"protocol");
            ChannelPipeline channelPipeline = ctx.pipeline();
            Intrinsics.checkExpressionValueIsNotNull((Object)channelPipeline, (String)"ctx.pipeline()");
            NettyChannelInitializer.this.configurePipeline(channelPipeline, protocol);
        }

        protected void handshakeFailure(@NotNull ChannelHandlerContext ctx, @Nullable Throwable cause) {
            Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
            if (cause instanceof ClosedChannelException) {
                ctx.close();
            } else {
                super.handshakeFailure(ctx, cause);
            }
        }

        public NegotiatedPipelineInitializer() {
            super("http/1.1");
        }
    }

    @EngineAPI
    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0087\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\n\u0010\t\u001a\u0004\u0018\u00010\u0004H\u0002R\u001d\u0010\u0003\u001a\u0004\u0018\u00010\u00048@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\n"}, d2={"Lio/ktor/server/netty/NettyChannelInitializer$Companion;", "", "()V", "alpnProvider", "Lio/netty/handler/ssl/SslProvider;", "getAlpnProvider$ktor_server_netty", "()Lio/netty/handler/ssl/SslProvider;", "alpnProvider$delegate", "Lkotlin/Lazy;", "findAlpnProvider", "ktor-server-netty"})
    public static final class Companion {
        static final /* synthetic */ KProperty[] $$delegatedProperties;

        static {
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Companion.class), "alpnProvider", "getAlpnProvider$ktor_server_netty()Lio/netty/handler/ssl/SslProvider;"))};
        }

        @Nullable
        public final SslProvider getAlpnProvider$ktor_server_netty() {
            Lazy lazy = alpnProvider$delegate;
            Companion companion = Companion;
            KProperty kProperty = $$delegatedProperties[0];
            return (SslProvider)lazy.getValue();
        }

        private final SslProvider findAlpnProvider() {
            try {
                Class.forName("sun.security.ssl.ALPNExtension", true, null);
                return SslProvider.JDK;
            }
            catch (Throwable throwable) {
                try {
                    if (OpenSsl.isAlpnSupported()) {
                        return SslProvider.OPENSSL;
                    }
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                return null;
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final /* synthetic */ SslProvider access$findAlpnProvider(Companion $this) {
            return $this.findAlpnProvider();
        }
    }
}

