/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.netty.cio;

import io.ktor.server.netty.NettyDirectEncoder;
import io.ktor.util.InternalAPI;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http2.DefaultHttp2DataFrame;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@InternalAPI
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u00002\u00020\u0001:\u0003\u0011\u0012\u0013B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00012\u0006\u0010\b\u001a\u00020\u0004H&J\u0018\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004H&J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H&R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0003\u0014\u0015\u0016\u00a8\u0006\u0017"}, d2={"Lio/ktor/server/netty/cio/WriterEncapsulation;", "", "()V", "requiresContextClose", "", "getRequiresContextClose", "()Z", "endOfStream", "lastTransformed", "transform", "buf", "Lio/netty/buffer/ByteBuf;", "last", "upgrade", "", "dst", "Lio/netty/channel/ChannelHandlerContext;", "Http1", "Http2", "Raw", "Lio/ktor/server/netty/cio/WriterEncapsulation$Http1;", "Lio/ktor/server/netty/cio/WriterEncapsulation$Http2;", "Lio/ktor/server/netty/cio/WriterEncapsulation$Raw;", "ktor-server-netty"})
public abstract class WriterEncapsulation {
    private WriterEncapsulation() {
    }

    public boolean getRequiresContextClose() {
        return true;
    }

    @NotNull
    public abstract Object transform(@NotNull ByteBuf var1, boolean var2);

    @Nullable
    public abstract Object endOfStream(boolean var1);

    public abstract void upgrade(@NotNull ChannelHandlerContext var1);

    public /* synthetic */ WriterEncapsulation(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lio/ktor/server/netty/cio/WriterEncapsulation$Http1;", "Lio/ktor/server/netty/cio/WriterEncapsulation;", "()V", "endOfStream", "", "lastTransformed", "", "transform", "buf", "Lio/netty/buffer/ByteBuf;", "last", "upgrade", "", "dst", "Lio/netty/channel/ChannelHandlerContext;", "ktor-server-netty"})
    public static final class Http1
    extends WriterEncapsulation {
        @NotNull
        public static final Http1 INSTANCE = new Http1();

        private Http1() {
            super(null);
        }

        @Override
        @NotNull
        public Object transform(@NotNull ByteBuf buf, boolean last) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            return new DefaultHttpContent(buf);
        }

        @Override
        @Nullable
        public Object endOfStream(boolean lastTransformed) {
            return LastHttpContent.EMPTY_LAST_CONTENT;
        }

        @Override
        public void upgrade(@NotNull ChannelHandlerContext dst) {
            Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
            ChannelPipeline channelPipeline = dst.pipeline();
            boolean bl = false;
            boolean bl2 = false;
            ChannelPipeline $this$upgrade_u24lambda_u2d0 = channelPipeline;
            boolean bl3 = false;
            $this$upgrade_u24lambda_u2d0.replace(HttpServerCodec.class, "direct-encoder", (ChannelHandler)new NettyDirectEncoder());
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u0004H\u0016J\u0018\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004H\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lio/ktor/server/netty/cio/WriterEncapsulation$Http2;", "Lio/ktor/server/netty/cio/WriterEncapsulation;", "()V", "requiresContextClose", "", "getRequiresContextClose", "()Z", "endOfStream", "", "lastTransformed", "transform", "buf", "Lio/netty/buffer/ByteBuf;", "last", "upgrade", "", "dst", "Lio/netty/channel/ChannelHandlerContext;", "ktor-server-netty"})
    public static final class Http2
    extends WriterEncapsulation {
        @NotNull
        public static final Http2 INSTANCE = new Http2();

        private Http2() {
            super(null);
        }

        @Override
        public boolean getRequiresContextClose() {
            return false;
        }

        @Override
        @NotNull
        public Object transform(@NotNull ByteBuf buf, boolean last) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            return new DefaultHttp2DataFrame(buf, last);
        }

        @Override
        @Nullable
        public Object endOfStream(boolean lastTransformed) {
            return lastTransformed ? null : new DefaultHttp2DataFrame(true);
        }

        @Override
        public void upgrade(@NotNull ChannelHandlerContext dst) {
            Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
            throw new IllegalStateException("HTTP/2 doesn't support upgrade");
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u0004H\u0016J\u0018\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004H\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lio/ktor/server/netty/cio/WriterEncapsulation$Raw;", "Lio/ktor/server/netty/cio/WriterEncapsulation;", "()V", "requiresContextClose", "", "getRequiresContextClose", "()Z", "endOfStream", "", "lastTransformed", "transform", "buf", "Lio/netty/buffer/ByteBuf;", "last", "upgrade", "", "dst", "Lio/netty/channel/ChannelHandlerContext;", "ktor-server-netty"})
    public static final class Raw
    extends WriterEncapsulation {
        @NotNull
        public static final Raw INSTANCE = new Raw();

        private Raw() {
            super(null);
        }

        @Override
        public boolean getRequiresContextClose() {
            return false;
        }

        @Override
        @NotNull
        public Object transform(@NotNull ByteBuf buf, boolean last) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            return buf;
        }

        @Override
        @Nullable
        public Object endOfStream(boolean lastTransformed) {
            return null;
        }

        @Override
        public void upgrade(@NotNull ChannelHandlerContext dst) {
            Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
            throw new IllegalStateException("Already upgraded");
        }
    }
}

