/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.plugins.ratelimit;

import io.ktor.server.plugins.ratelimit.RateLimiter;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\b\u0000\u0018\u00002\u00020\u0018B*\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00f8\u0001\u0000\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\r\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001b\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0001H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0013R\u0016\u0010\u0014\u001a\u00020\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0002\u001a\u00020\u00018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0002\u0010\u0016R\u001d\u0010\u0004\u001a\u00020\u00038\u0002X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u0015\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0017"}, d2={"Lio/ktor/server/plugins/ratelimit/DefaultRateLimiter;", "", "limit", "Lkotlin/time/Duration;", "refillPeriod", "Lkotlin/Function0;", "", "clock", "<init>", "(IJLkotlin/jvm/functions/Function0;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "", "refillIfNeeded", "()V", "timeToWaitMillis", "()J", "tokens", "Lio/ktor/server/plugins/ratelimit/RateLimiter$State;", "tryConsume", "(ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Lkotlin/jvm/functions/Function0;", "lastRefillTimeMillis", "J", "I", "ktor-server-rate-limit", "Lio/ktor/server/plugins/ratelimit/RateLimiter;"})
public final class DefaultRateLimiter
implements RateLimiter {
    private final int limit;
    private final long refillPeriod;
    @NotNull
    private final Function0<Long> clock;
    @NotNull
    private volatile /* synthetic */ int tokens;
    private static final /* synthetic */ AtomicIntegerFieldUpdater tokens$FU;
    private long lastRefillTimeMillis;

    private DefaultRateLimiter(int limit, long refillPeriod, Function0<Long> clock) {
        this.limit = limit;
        this.refillPeriod = refillPeriod;
        this.clock = clock;
        this.tokens = this.limit;
        this.lastRefillTimeMillis = ((Number)this.clock.invoke()).longValue();
    }

    public /* synthetic */ DefaultRateLimiter(int n, long l, Function0 function0, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            function0 = 1.INSTANCE;
        }
        this(n, l, function0, null);
    }

    @Override
    @Nullable
    public Object tryConsume(int tokens, @NotNull Continuation<? super RateLimiter.State> $completion) {
        int n;
        int current;
        do {
            this.refillIfNeeded();
            current = this.tokens;
            n = current - tokens;
            if (n >= 0) continue;
            return new RateLimiter.State.Exhausted(DurationKt.toDuration((long)this.timeToWaitMillis(), (DurationUnit)DurationUnit.MILLISECONDS), null);
        } while (!tokens$FU.compareAndSet(this, current, n));
        return new RateLimiter.State.Available(n, this.limit, this.lastRefillTimeMillis + Duration.getInWholeMilliseconds-impl((long)this.refillPeriod));
    }

    private final void refillIfNeeded() {
        if (this.timeToWaitMillis() > 0L) {
            return;
        }
        this.tokens = this.limit;
        this.lastRefillTimeMillis = ((Number)this.clock.invoke()).longValue();
    }

    private final long timeToWaitMillis() {
        return Duration.getInWholeMilliseconds-impl((long)this.refillPeriod) - (((Number)this.clock.invoke()).longValue() - this.lastRefillTimeMillis);
    }

    public /* synthetic */ DefaultRateLimiter(int limit, long refillPeriod, Function0 clock, DefaultConstructorMarker $constructor_marker) {
        this(limit, refillPeriod, (Function0<Long>)clock);
    }

    static {
        tokens$FU = AtomicIntegerFieldUpdater.newUpdater(DefaultRateLimiter.class, "tokens");
    }
}

