/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.servlet;

import io.ktor.server.application.Application;
import io.ktor.server.application.ApplicationCall;
import io.ktor.server.application.ApplicationKt;
import io.ktor.server.engine.DefaultEnginePipelineKt;
import io.ktor.server.engine.DefaultUncaughtExceptionHandler;
import io.ktor.server.engine.EnginePipeline;
import io.ktor.server.servlet.AsyncServletApplicationCall;
import io.ktor.server.servlet.BlockingServletApplicationCall;
import io.ktor.server.servlet.KtorServletKt;
import io.ktor.server.servlet.ServletUpgrade;
import io.ktor.util.AttributeKey;
import io.ktor.util.Attributes;
import io.ktor.util.cio.ChannelIOException;
import io.ktor.util.debug.ContextUtilsKt;
import io.ktor.util.pipeline.Pipeline;
import java.util.Set;
import java.util.concurrent.CancellationException;
import javax.servlet.AsyncContext;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0004J\u000f\u0010\u0007\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0007\u0010\u0004J\u001f\u0010\f\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0014\u00a2\u0006\u0004\b\f\u0010\rJ\u001b\u0010\u0010\u001a\u00020\u0005*\u00020\n2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0012\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0012\u0010\rJ\u001f\u0010\u0013\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0013\u0010\rR \u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00148\u0014X\u0094\u0004\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u001c\u001a\u00020\u00198$X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010 \u001a\u00020\u001d8$X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010$\u001a\u00020!8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0014\u0010(\u001a\u00020%8$X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u001a\u0010*\u001a\u00020)8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b*\u0010+\u001a\u0004\b,\u0010-\u00a8\u0006."}, d2={"Lio/ktor/server/servlet/KtorServlet;", "Ljavax/servlet/http/HttpServlet;", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "()V", "", "init", "destroy", "Ljavax/servlet/http/HttpServletRequest;", "request", "Ljavax/servlet/http/HttpServletResponse;", "response", "service", "(Ljavax/servlet/http/HttpServletRequest;Ljavax/servlet/http/HttpServletResponse;)V", "", "message", "sendErrorIfNotCommitted", "(Ljavax/servlet/http/HttpServletResponse;Ljava/lang/String;)V", "asyncService", "blockingService", "", "managedByEngineHeaders", "Ljava/util/Set;", "getManagedByEngineHeaders", "()Ljava/util/Set;", "Lio/ktor/server/application/Application;", "getApplication", "()Lio/ktor/server/application/Application;", "application", "Lio/ktor/server/engine/EnginePipeline;", "getEnginePipeline", "()Lio/ktor/server/engine/EnginePipeline;", "enginePipeline", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "logger", "Lio/ktor/server/servlet/ServletUpgrade;", "getUpgrade", "()Lio/ktor/server/servlet/ServletUpgrade;", "upgrade", "Lkotlin/coroutines/CoroutineContext;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "ktor-server-servlet"})
public abstract class KtorServlet
extends HttpServlet
implements CoroutineScope {
    @NotNull
    private final Set<String> managedByEngineHeaders = SetsKt.emptySet();
    @NotNull
    private final CoroutineContext coroutineContext = Dispatchers.getUnconfined().plus((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null)).plus((CoroutineContext)new CoroutineName("servlet")).plus((CoroutineContext)new DefaultUncaughtExceptionHandler(() -> KtorServlet.coroutineContext$lambda$0(this)));

    @NotNull
    protected Set<String> getManagedByEngineHeaders() {
        return this.managedByEngineHeaders;
    }

    @NotNull
    protected abstract Application getApplication();

    @NotNull
    protected abstract EnginePipeline getEnginePipeline();

    @NotNull
    protected Logger getLogger() {
        Logger logger = LoggerFactory.getLogger((String)this.getServletName());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        return logger;
    }

    @NotNull
    protected abstract ServletUpgrade getUpgrade();

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.coroutineContext;
    }

    public void init() {
        super.init();
        Attributes attributes = this.getApplication().getAttributes();
        AttributeKey<ServletContext> attributeKey = KtorServletKt.getServletContextAttribute();
        ServletContext servletContext = this.getServletContext();
        Intrinsics.checkNotNull((Object)servletContext);
        attributes.put(attributeKey, (Object)servletContext);
    }

    public void destroy() {
        JobKt.cancel$default((CoroutineContext)this.getCoroutineContext(), null, (int)1, null);
    }

    protected void service(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        if (response.isCommitted()) {
            return;
        }
        try {
            if (request.isAsyncSupported()) {
                this.asyncService(request, response);
            } else {
                this.blockingService(request, response);
            }
        }
        catch (ChannelIOException ioError) {
            ApplicationKt.getLog((Application)this.getApplication()).debug("I/O error", (Throwable)ioError);
        }
        catch (CancellationException cancelled) {
            ApplicationKt.getLog((Application)this.getApplication()).debug("Request cancelled", (Throwable)cancelled);
            this.sendErrorIfNotCommitted(response, "Cancelled");
        }
        catch (Throwable ex) {
            ApplicationKt.getLog((Application)this.getApplication()).error("ServletApplicationEngine cannot service the request", ex);
            String string = ex.getMessage();
            if (string == null) {
                string = ex.toString();
            }
            this.sendErrorIfNotCommitted(response, string);
        }
    }

    private final void sendErrorIfNotCommitted(HttpServletResponse $this$sendErrorIfNotCommitted, String message) {
        try {
            if (!$this$sendErrorIfNotCommitted.isCommitted()) {
                $this$sendErrorIfNotCommitted.sendError(500, message);
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private final void asyncService(HttpServletRequest request, HttpServletResponse response) {
        AsyncContext asyncContext;
        AsyncContext asyncContext2 = request.startAsync();
        Intrinsics.checkNotNull((Object)asyncContext2);
        AsyncContext $this$asyncService_u24lambda_u241 = asyncContext = asyncContext2;
        boolean bl = false;
        $this$asyncService_u24lambda_u241.setTimeout(0L);
        AsyncContext asyncContext3 = asyncContext;
        BuildersKt.launch$default((CoroutineScope)this, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, request, response, asyncContext3, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ KtorServlet this$0;
            final /* synthetic */ HttpServletRequest $request;
            final /* synthetic */ HttpServletResponse $response;
            final /* synthetic */ AsyncContext $asyncContext;
            {
                this.this$0 = $receiver;
                this.$request = $request;
                this.$response = $response;
                this.$asyncContext = $asyncContext;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$launch = (CoroutineScope)this.L$0;
                        call = new AsyncServletApplicationCall(this.this$0.getApplication(), this.$request, this.$response, (CoroutineContext)Dispatchers.getIO(), (CoroutineContext)Dispatchers.getIO(), this.this$0.getUpgrade(), $this$launch.getCoroutineContext(), this.this$0.getManagedByEngineHeaders(), null, 256, null);
                        $this$execute$iv = (Pipeline)this.this$0.getEnginePipeline();
                        $i$f$execute = false;
                        this.L$0 = call;
                        this.label = 1;
                        v0 = ContextUtilsKt.initContextInDebugMode((Function1)((Function1)new Function1<Continuation<? super Unit>, Object>($this$execute$iv, (Object)call, null){
                            int label;
                            final /* synthetic */ Pipeline $this_execute;
                            final /* synthetic */ Object $context;
                            {
                                this.$this_execute = $receiver;
                                this.$context = $context;
                                super(1, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        this.label = 1;
                                        Object object3 = this.$this_execute.execute(this.$context, (Object)Unit.INSTANCE, (Continuation)this);
                                        Object object4 = object3;
                                        if (object3 != object2) return Unit.INSTANCE;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object4 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(Continuation<? super Unit> p1) {
                                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        ** if (v0 != var6_2) goto lbl16
lbl15:
                        // 1 sources

                        return var6_2;
lbl16:
                        // 1 sources

                        ** GOTO lbl24
                    }
                    case 1: {
                        $i$f$execute = false;
                        call = (AsyncServletApplicationCall)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl24:
                        // 2 sources

                        try {
                            this.$asyncContext.complete();
                        }
                        catch (IllegalStateException alreadyCompleted) {
                            ApplicationKt.getLog((Application)this.this$0.getApplication()).debug("AsyncContext is already completed due to previous I/O error", (Throwable)alreadyCompleted);
                        }
                        ** GOTO lbl56
                        catch (Throwable cause) {
                            this.L$0 = null;
                            this.label = 2;
                            v1 = DefaultEnginePipelineKt.logError((ApplicationCall)((ApplicationCall)call), (Throwable)cause, (Continuation)((Continuation)this));
                            ** if (v1 != var6_2) goto lbl38
lbl37:
                            // 1 sources

                            return var6_2;
lbl38:
                            // 1 sources

                            ** GOTO lbl44
                        }
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl44:
                        // 2 sources

                        KtorServlet.access$sendErrorIfNotCommitted(this.this$0, this.$response, "");
                        ** GOTO lbl56
                        {
                            catch (Throwable var4_9) {
                                throw var4_9;
                            }
                        }
                        finally {
                            try {
                                this.$asyncContext.complete();
                            }
                            catch (IllegalStateException alreadyCompleted) {
                                ApplicationKt.getLog((Application)this.this$0.getApplication()).debug("AsyncContext is already completed due to previous I/O error", (Throwable)alreadyCompleted);
                            }
                        }
lbl56:
                        // 3 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private final void blockingService(HttpServletRequest request, HttpServletResponse response) {
        BuildersKt.runBlocking((CoroutineContext)this.getCoroutineContext(), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, request, response, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ KtorServlet this$0;
            final /* synthetic */ HttpServletRequest $request;
            final /* synthetic */ HttpServletResponse $response;
            {
                this.this$0 = $receiver;
                this.$request = $request;
                this.$response = $response;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        CoroutineScope $this$runBlocking = (CoroutineScope)this.L$0;
                        BlockingServletApplicationCall call = new BlockingServletApplicationCall(this.this$0.getApplication(), this.$request, this.$response, $this$runBlocking.getCoroutineContext(), this.this$0.getManagedByEngineHeaders());
                        Pipeline $this$execute$iv = (Pipeline)this.this$0.getEnginePipeline();
                        boolean $i$f$execute = false;
                        this.label = 1;
                        Object object3 = ContextUtilsKt.initContextInDebugMode((Function1)((Function1)new Function1<Continuation<? super Unit>, Object>($this$execute$iv, (Object)((Object)call), null){
                            int label;
                            final /* synthetic */ Pipeline $this_execute;
                            final /* synthetic */ Object $context;
                            {
                                this.$this_execute = $receiver;
                                this.$context = $context;
                                super(1, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        this.label = 1;
                                        Object object3 = this.$this_execute.execute(this.$context, (Object)Unit.INSTANCE, (Continuation)this);
                                        Object object4 = object3;
                                        if (object3 != object2) return Unit.INSTANCE;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object4 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(Continuation<? super Unit> p1) {
                                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        boolean $i$f$execute = false;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private static final Logger coroutineContext$lambda$0(KtorServlet this$0) {
        return this$0.getLogger();
    }

    public static final /* synthetic */ void access$sendErrorIfNotCommitted(KtorServlet $this, HttpServletResponse $receiver, String message) {
        $this.sendErrorIfNotCommitted($receiver, message);
    }
}

