/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.servlet;

import io.ktor.http.HttpHeaders;
import io.ktor.server.application.Application;
import io.ktor.server.application.ApplicationEnvironment;
import io.ktor.server.application.ApplicationKt;
import io.ktor.server.application.DefaultApplicationEventsKt;
import io.ktor.server.application.ServerConfig;
import io.ktor.server.application.ServerConfigBuilder;
import io.ktor.server.config.ApplicationConfig;
import io.ktor.server.config.ApplicationConfigKt;
import io.ktor.server.config.ConfigLoader;
import io.ktor.server.config.MapApplicationConfig;
import io.ktor.server.config.MergedApplicationConfigKt;
import io.ktor.server.engine.ApplicationEngine;
import io.ktor.server.engine.ApplicationEngineFactory;
import io.ktor.server.engine.ApplicationEnvironmentBuilder;
import io.ktor.server.engine.ApplicationEnvironmentBuilderKt;
import io.ktor.server.engine.BaseApplicationResponse;
import io.ktor.server.engine.DefaultEnginePipelineKt;
import io.ktor.server.engine.DefaultTransformKt;
import io.ktor.server.engine.EmbeddedServer;
import io.ktor.server.engine.EnginePipeline;
import io.ktor.server.request.ApplicationReceivePipeline;
import io.ktor.server.response.ApplicationSendPipeline;
import io.ktor.server.servlet.DefaultServletUpgrade;
import io.ktor.server.servlet.EmptyEngineFactory;
import io.ktor.server.servlet.KtorServlet;
import io.ktor.server.servlet.ServletApplicationEngineKt;
import io.ktor.server.servlet.ServletUpgrade;
import io.ktor.util.TextKt;
import io.ktor.util.pipeline.Pipeline;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.annotation.MultipartConfig;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MultipartConfig
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u0000 /2\u00020\u0001:\u0001/B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u000f\u0010\u0006\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0003R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u00078TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR)\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e\u0018\u00010\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0017\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u001c\u001a\u00020\u00188TX\u0094\u0004\u00a2\u0006\f\u0012\u0004\b\u001b\u0010\u0003\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010 \u001a\u00020\u001d8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u001b\u0010%\u001a\u00020!8TX\u0094\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010\u0010\u001a\u0004\b#\u0010$R\u001b\u0010*\u001a\u00020&8TX\u0094\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010\u0010\u001a\u0004\b(\u0010)R\u0014\u0010.\u001a\u00020+8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-\u00a8\u00060"}, d2={"Lio/ktor/server/servlet/ServletApplicationEngine;", "Lio/ktor/server/servlet/KtorServlet;", "<init>", "()V", "", "init", "destroy", "", "", "getManagedByEngineHeaders", "()Ljava/util/Set;", "managedByEngineHeaders", "Lio/ktor/server/engine/EmbeddedServer;", "Lio/ktor/server/engine/ApplicationEngine;", "Lio/ktor/server/engine/ApplicationEngine$Configuration;", "embeddedServer$delegate", "Lkotlin/Lazy;", "getEmbeddedServer", "()Lio/ktor/server/engine/EmbeddedServer;", "embeddedServer", "Lio/ktor/server/application/ApplicationEnvironment;", "getEnvironment", "()Lio/ktor/server/application/ApplicationEnvironment;", "environment", "Lio/ktor/server/application/Application;", "getApplication", "()Lio/ktor/server/application/Application;", "getApplication$annotations", "application", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "logger", "Lio/ktor/server/engine/EnginePipeline;", "enginePipeline$delegate", "getEnginePipeline", "()Lio/ktor/server/engine/EnginePipeline;", "enginePipeline", "Lio/ktor/server/servlet/ServletUpgrade;", "upgrade$delegate", "getUpgrade", "()Lio/ktor/server/servlet/ServletUpgrade;", "upgrade", "Lkotlin/coroutines/CoroutineContext;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "coroutineContext", "Companion", "ktor-server-servlet"})
@SourceDebugExtension(value={"SMAP\nServletApplicationEngine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServletApplicationEngine.kt\nio/ktor/server/servlet/ServletApplicationEngine\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,179:1\n1#2:180\n774#3:181\n865#3,2:182\n1563#3:184\n1634#3,3:185\n*S KotlinDebug\n*F\n+ 1 ServletApplicationEngine.kt\nio/ktor/server/servlet/ServletApplicationEngine\n*L\n46#1:181\n46#1:182,2\n47#1:184\n47#1:185,3\n*E\n"})
public class ServletApplicationEngine
extends KtorServlet {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy embeddedServer$delegate = LazyKt.lazy(() -> ServletApplicationEngine.embeddedServer_delegate$lambda$7(this));
    @NotNull
    private final Lazy enginePipeline$delegate = LazyKt.lazy(() -> ServletApplicationEngine.enginePipeline_delegate$lambda$12(this));
    @NotNull
    private final Lazy upgrade$delegate = LazyKt.lazy(() -> ServletApplicationEngine.upgrade_delegate$lambda$13(this));
    @NotNull
    public static final String EnvironmentAttributeKey = "_ktor_environment_instance";
    @NotNull
    public static final String ApplicationAttributeKey = "_ktor_application_instance";
    @NotNull
    public static final String ApplicationEnginePipelineAttributeKey = "_ktor_application_engine_pipeline_instance";
    @NotNull
    private static final Lazy<ServletUpgrade> jettyUpgrade$delegate = LazyKt.lazy(ServletApplicationEngine::jettyUpgrade_delegate$lambda$14);

    @Override
    @NotNull
    protected Set<String> getManagedByEngineHeaders() {
        Set set;
        ServletContext servletContext = this.getServletContext();
        Intrinsics.checkNotNullExpressionValue((Object)servletContext, (String)"getServletContext(...)");
        if (ServletApplicationEngineKt.isTomcat(servletContext)) {
            Object[] objectArray = new String[]{HttpHeaders.INSTANCE.getTransferEncoding(), HttpHeaders.INSTANCE.getConnection()};
            set = SetsKt.setOf((Object[])objectArray);
        } else {
            set = SetsKt.emptySet();
        }
        return set;
    }

    private final EmbeddedServer<ApplicationEngine, ApplicationEngine.Configuration> getEmbeddedServer() {
        Lazy lazy = this.embeddedServer$delegate;
        return (EmbeddedServer)lazy.getValue();
    }

    @NotNull
    public final ApplicationEnvironment getEnvironment() {
        ApplicationEnvironment applicationEnvironment;
        Object object = this.getServletContext().getAttribute(EnvironmentAttributeKey);
        if (object != null) {
            Object it = object;
            boolean bl = false;
            applicationEnvironment = (ApplicationEnvironment)it;
        } else {
            EmbeddedServer<ApplicationEngine, ApplicationEngine.Configuration> embeddedServer = this.getEmbeddedServer();
            Intrinsics.checkNotNull(embeddedServer);
            applicationEnvironment = embeddedServer.getEnvironment();
        }
        return applicationEnvironment;
    }

    @Override
    @NotNull
    protected Application getApplication() {
        Object object;
        block3: {
            block2: {
                object = this.getServletContext().getAttribute(ApplicationAttributeKey);
                if (object == null) break block2;
                Object it = object;
                boolean bl = false;
                Function0 function0 = (Function0)TypeIntrinsics.beforeCheckcastToFunctionOfArity((Object)it, (int)0);
                object = function0;
                if (function0 != null && (object = (Application)object.invoke()) != null) break block3;
            }
            EmbeddedServer<ApplicationEngine, ApplicationEngine.Configuration> embeddedServer = this.getEmbeddedServer();
            Intrinsics.checkNotNull(embeddedServer);
            object = embeddedServer.getApplication();
        }
        return object;
    }

    protected static /* synthetic */ void getApplication$annotations() {
    }

    @Override
    @NotNull
    protected Logger getLogger() {
        return this.getEnvironment().getLog();
    }

    @Override
    @NotNull
    protected EnginePipeline getEnginePipeline() {
        Lazy lazy = this.enginePipeline$delegate;
        return (EnginePipeline)lazy.getValue();
    }

    @Override
    @NotNull
    protected ServletUpgrade getUpgrade() {
        Lazy lazy = this.upgrade$delegate;
        return (ServletUpgrade)lazy.getValue();
    }

    @Override
    @NotNull
    public CoroutineContext getCoroutineContext() {
        return super.getCoroutineContext().plus(this.getApplication().getParentCoroutineContext());
    }

    @Override
    public void init() {
        EmbeddedServer<ApplicationEngine, ApplicationEngine.Configuration> embeddedServer = this.getEmbeddedServer();
        if (embeddedServer != null) {
            EmbeddedServer.start$default(embeddedServer, (boolean)false, (int)1, null);
        }
        super.init();
    }

    @Override
    public void destroy() {
        block0: {
            this.getApplication().getMonitor().raise(DefaultApplicationEventsKt.getApplicationStopPreparing(), (Object)this.getEnvironment());
            super.destroy();
            EmbeddedServer<ApplicationEngine, ApplicationEngine.Configuration> embeddedServer = this.getEmbeddedServer();
            if (embeddedServer == null) break block0;
            EmbeddedServer.stop$default(embeddedServer, (long)0L, (long)0L, (int)3, null);
        }
    }

    private static final Unit embeddedServer_delegate$lambda$7$lambda$3(ApplicationConfig $combinedConfig, String $applicationId, ServletContext $servletContext, ApplicationEnvironmentBuilder $this$applicationEnvironment) {
        Intrinsics.checkNotNullParameter((Object)$this$applicationEnvironment, (String)"$this$applicationEnvironment");
        $this$applicationEnvironment.setConfig($combinedConfig);
        Logger logger = LoggerFactory.getLogger((String)$applicationId);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        $this$applicationEnvironment.setLog(logger);
        ClassLoader classLoader = $servletContext.getClassLoader();
        Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"getClassLoader(...)");
        $this$applicationEnvironment.setClassLoader(classLoader);
        return Unit.INSTANCE;
    }

    private static final Unit embeddedServer_delegate$lambda$7$lambda$4(ServletContext $servletContext, ServerConfigBuilder $this$serverConfig) {
        Intrinsics.checkNotNullParameter((Object)$this$serverConfig, (String)"$this$serverConfig");
        String string = $servletContext.getContextPath();
        if (string == null) {
            string = "/";
        }
        $this$serverConfig.setRootPath(string);
        return Unit.INSTANCE;
    }

    private static final Unit embeddedServer_delegate$lambda$7$lambda$6$lambda$5(ServletApplicationEngine this$0, Application it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.getReceivePipeline().merge((Pipeline)this$0.getEnginePipeline().getReceivePipeline());
        it.getSendPipeline().merge((Pipeline)this$0.getEnginePipeline().getSendPipeline());
        DefaultTransformKt.installDefaultTransformations((ApplicationReceivePipeline)it.getReceivePipeline());
        DefaultTransformKt.installDefaultTransformations((ApplicationSendPipeline)it.getSendPipeline());
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final EmbeddedServer embeddedServer_delegate$lambda$7(ServletApplicationEngine this$0) {
        EmbeddedServer server;
        EmbeddedServer embeddedServer;
        void $this$mapTo$iv$iv;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        List list;
        List list2;
        List list3;
        List list4;
        Object object = this$0.getServletContext().getAttribute(ApplicationAttributeKey);
        if (object != null) {
            Object it = object;
            boolean bl = false;
            return null;
        }
        ServletContext servletContext = this$0.getServletContext();
        ServletConfig servletConfig = this$0.getServletConfig();
        Enumeration enumeration = servletContext.getInitParameterNames();
        if (enumeration != null) {
            ArrayList arrayList = Collections.list(enumeration);
            Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(...)");
            list4 = arrayList;
        } else {
            list4 = list3 = null;
        }
        if (list4 == null) {
            list3 = CollectionsKt.emptyList();
        }
        Collection collection = list3;
        Enumeration enumeration2 = servletConfig.getInitParameterNames();
        if (enumeration2 != null) {
            ArrayList arrayList = Collections.list(enumeration2);
            Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(...)");
            list2 = arrayList;
        } else {
            list2 = list = null;
        }
        if (list2 == null) {
            list = CollectionsKt.emptyList();
        }
        Iterable bl = CollectionsKt.plus((Collection)collection, (Iterable)list);
        boolean $i$f$filter = false;
        void var6_9 = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            if (!StringsKt.startsWith$default((String)it, (String)"io.ktor", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List parameterNames = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        Iterable $this$map$iv = parameterNames;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String bl2 = (String)item$iv$iv;
            Collection collection2 = destination$iv$iv2;
            boolean bl3 = false;
            Intrinsics.checkNotNull((Object)it);
            String string = StringsKt.removePrefix((String)it, (CharSequence)"io.ktor.");
            String string2 = servletConfig.getInitParameter((String)it);
            if (string2 == null) {
                string2 = servletContext.getInitParameter((String)it);
            }
            collection2.add(TuplesKt.to((Object)string, (Object)string2));
        }
        List parameters = (List)destination$iv$iv2;
        MapApplicationConfig parametersConfig = new MapApplicationConfig((Collection)parameters);
        String configPath = "ktor.config";
        String applicationIdPath = "ktor.application.id";
        ApplicationConfig combinedConfig = MergedApplicationConfigKt.withFallback((ApplicationConfig)((ApplicationConfig)parametersConfig), (ApplicationConfig)ConfigLoader.Companion.load(ApplicationConfigKt.tryGetString((ApplicationConfig)((ApplicationConfig)parametersConfig), (String)configPath)));
        String string = ApplicationConfigKt.tryGetString((ApplicationConfig)combinedConfig, (String)applicationIdPath);
        if (string == null) {
            string = "Application";
        }
        String applicationId = string;
        ApplicationEnvironment environment = ApplicationEnvironmentBuilderKt.applicationEnvironment(arg_0 -> ServletApplicationEngine.embeddedServer_delegate$lambda$7$lambda$3(combinedConfig, applicationId, servletContext, arg_0));
        ServerConfig applicationProperties = ApplicationKt.serverConfig((ApplicationEnvironment)environment, arg_0 -> ServletApplicationEngine.embeddedServer_delegate$lambda$7$lambda$4(servletContext, arg_0));
        EmbeddedServer $this$embeddedServer_delegate_u24lambda_u247_u24lambda_u246 = embeddedServer = (server = new EmbeddedServer(applicationProperties, (ApplicationEngineFactory)EmptyEngineFactory.INSTANCE, null, 4, null));
        boolean bl4 = false;
        $this$embeddedServer_delegate_u24lambda_u247_u24lambda_u246.getMonitor().subscribe(DefaultApplicationEventsKt.getApplicationStarting(), arg_0 -> ServletApplicationEngine.embeddedServer_delegate$lambda$7$lambda$6$lambda$5(this$0, arg_0));
        return embeddedServer;
    }

    private static final EnginePipeline enginePipeline_delegate$lambda$12(ServletApplicationEngine this$0) {
        EnginePipeline enginePipeline;
        Object object = this$0.getServletContext().getAttribute(ApplicationEnginePipelineAttributeKey);
        if (object != null) {
            Object it = object;
            boolean bl = false;
            return (EnginePipeline)it;
        }
        EnginePipeline it = enginePipeline = DefaultEnginePipelineKt.defaultEnginePipeline((ApplicationConfig)this$0.getEnvironment().getConfig(), (boolean)this$0.getApplication().getDevelopmentMode());
        boolean bl = false;
        BaseApplicationResponse.Companion.setupSendPipeline(it.getSendPipeline());
        return enginePipeline;
    }

    private static final ServletUpgrade upgrade_delegate$lambda$13(ServletApplicationEngine this$0) {
        ServletUpgrade servletUpgrade;
        String string = this$0.getServletContext().getServerInfo();
        if (string == null || (string = TextKt.toLowerCasePreservingASCIIRules((String)string)) == null) {
            string = "";
        }
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"jetty", (boolean)false, (int)2, null)) {
            servletUpgrade = ServletApplicationEngine.Companion.getJettyUpgrade();
            if (servletUpgrade == null) {
                servletUpgrade = DefaultServletUpgrade.INSTANCE;
            }
        } else {
            servletUpgrade = DefaultServletUpgrade.INSTANCE;
        }
        return servletUpgrade;
    }

    private static final ServletUpgrade jettyUpgrade_delegate$lambda$14() {
        ServletUpgrade servletUpgrade;
        try {
            Class<?> clazz = Class.forName("io.ktor.server.jetty.internal.JettyUpgradeImpl");
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"forName(...)");
            Object object = JvmClassMappingKt.getKotlinClass(clazz).getObjectInstance();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type io.ktor.server.servlet.ServletUpgrade");
            servletUpgrade = (ServletUpgrade)object;
        }
        catch (Throwable t) {
            servletUpgrade = null;
        }
        return servletUpgrade;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\b\u0010\u0006R\u001d\u0010\u000e\u001a\u0004\u0018\u00010\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000f"}, d2={"Lio/ktor/server/servlet/ServletApplicationEngine$Companion;", "", "<init>", "()V", "", "EnvironmentAttributeKey", "Ljava/lang/String;", "ApplicationAttributeKey", "ApplicationEnginePipelineAttributeKey", "Lio/ktor/server/servlet/ServletUpgrade;", "jettyUpgrade$delegate", "Lkotlin/Lazy;", "getJettyUpgrade", "()Lio/ktor/server/servlet/ServletUpgrade;", "jettyUpgrade", "ktor-server-servlet"})
    public static final class Companion {
        private Companion() {
        }

        private final ServletUpgrade getJettyUpgrade() {
            Lazy lazy = jettyUpgrade$delegate;
            return (ServletUpgrade)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

