/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.servlet;

import io.ktor.http.Headers;
import io.ktor.http.Parameters;
import io.ktor.http.QueryKt;
import io.ktor.http.RequestConnectionPoint;
import io.ktor.server.application.PipelineCall;
import io.ktor.server.engine.BaseApplicationRequest;
import io.ktor.server.request.ApplicationRequest;
import io.ktor.server.request.PipelineRequest;
import io.ktor.server.request.PipelineRequestKt;
import io.ktor.server.request.RequestCookies;
import io.ktor.server.servlet.ServletApplicationRequestCookies;
import io.ktor.server.servlet.ServletApplicationRequestHeaders;
import io.ktor.server.servlet.ServletApplicationRequestKt;
import io.ktor.server.servlet.ServletConnectionPoint;
import javax.servlet.http.HttpServletRequest;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\b\u001a\u0004\b\t\u0010\nR\u001a\u0010\f\u001a\u00020\u000b8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0015\u001a\u00020\u00108VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\u001b\u0010\u0018\u001a\u00020\u00108VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0012\u001a\u0004\b\u0017\u0010\u0014R\u001a\u0010\u001a\u001a\u00020\u00198\u0014X\u0094\u0004\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u001dR \u0010\u001f\u001a\u00020\u001e8\u0016X\u0096\u0004\u00a2\u0006\u0012\n\u0004\b\u001f\u0010 \u0012\u0004\b#\u0010$\u001a\u0004\b!\u0010\"\u00a8\u0006%"}, d2={"Lio/ktor/server/servlet/ServletApplicationRequest;", "Lio/ktor/server/engine/BaseApplicationRequest;", "Lio/ktor/server/application/PipelineCall;", "call", "Ljavax/servlet/http/HttpServletRequest;", "servletRequest", "<init>", "(Lio/ktor/server/application/PipelineCall;Ljavax/servlet/http/HttpServletRequest;)V", "Ljavax/servlet/http/HttpServletRequest;", "getServletRequest", "()Ljavax/servlet/http/HttpServletRequest;", "Lio/ktor/http/RequestConnectionPoint;", "local", "Lio/ktor/http/RequestConnectionPoint;", "getLocal", "()Lio/ktor/http/RequestConnectionPoint;", "Lio/ktor/http/Parameters;", "queryParameters$delegate", "Lkotlin/Lazy;", "getQueryParameters", "()Lio/ktor/http/Parameters;", "queryParameters", "rawQueryParameters$delegate", "getRawQueryParameters", "rawQueryParameters", "Lio/ktor/http/Headers;", "engineHeaders", "Lio/ktor/http/Headers;", "getEngineHeaders", "()Lio/ktor/http/Headers;", "Lio/ktor/server/request/RequestCookies;", "cookies", "Lio/ktor/server/request/RequestCookies;", "getCookies", "()Lio/ktor/server/request/RequestCookies;", "getCookies$annotations", "()V", "ktor-server-servlet"})
public abstract class ServletApplicationRequest
extends BaseApplicationRequest {
    @NotNull
    private final HttpServletRequest servletRequest;
    @NotNull
    private final RequestConnectionPoint local;
    @NotNull
    private final Lazy queryParameters$delegate;
    @NotNull
    private final Lazy rawQueryParameters$delegate;
    @NotNull
    private final Headers engineHeaders;
    @NotNull
    private final RequestCookies cookies;

    public ServletApplicationRequest(@NotNull PipelineCall call, @NotNull HttpServletRequest servletRequest) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)servletRequest, (String)"servletRequest");
        super(call);
        this.servletRequest = servletRequest;
        this.local = new ServletConnectionPoint(this.servletRequest);
        this.queryParameters$delegate = LazyKt.lazy(() -> ServletApplicationRequest.queryParameters_delegate$lambda$0(this));
        this.rawQueryParameters$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> ServletApplicationRequest.rawQueryParameters_delegate$lambda$1(this));
        this.engineHeaders = new ServletApplicationRequestHeaders(this.servletRequest);
        this.cookies = new ServletApplicationRequestCookies(this.servletRequest, (PipelineRequest)this);
    }

    @NotNull
    public final HttpServletRequest getServletRequest() {
        return this.servletRequest;
    }

    @NotNull
    public RequestConnectionPoint getLocal() {
        return this.local;
    }

    @NotNull
    public Parameters getQueryParameters() {
        Lazy lazy = this.queryParameters$delegate;
        return (Parameters)lazy.getValue();
    }

    @NotNull
    public Parameters getRawQueryParameters() {
        Lazy lazy = this.rawQueryParameters$delegate;
        return (Parameters)lazy.getValue();
    }

    @NotNull
    protected Headers getEngineHeaders() {
        return this.engineHeaders;
    }

    @NotNull
    public RequestCookies getCookies() {
        return this.cookies;
    }

    public static /* synthetic */ void getCookies$annotations() {
    }

    private static final Parameters queryParameters_delegate$lambda$0(ServletApplicationRequest this$0) {
        return ServletApplicationRequestKt.access$toQueryParameters(PipelineRequestKt.encodeParameters((ApplicationRequest)((ApplicationRequest)this$0), (Parameters)this$0.getRawQueryParameters()));
    }

    private static final Parameters rawQueryParameters_delegate$lambda$1(ServletApplicationRequest this$0) {
        String string = this$0.servletRequest.getQueryString();
        if (string == null) {
            return Parameters.Companion.getEmpty();
        }
        String uri = string;
        return QueryKt.parseQueryString$default((String)uri, (int)0, (int)0, (boolean)false, (int)6, null);
    }
}

