/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.servlet;

import io.ktor.http.Headers;
import io.ktor.server.servlet.ServletApplicationRequestHeaders;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010&\n\u0002\b\t\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001f\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u001a\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0096\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0018\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u0006H\u0096\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ/\u0010\u0013\u001a\u00020\u00112\u001e\u0010\u0012\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J'\u0010\u0017\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\b0\u00160\u0015H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000f\u0010\u0019\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0015\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0015H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u0018R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001cR\u0014\u0010\u001e\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001a\u00a8\u0006\u001f"}, d2={"Lio/ktor/server/servlet/ServletApplicationRequestHeaders;", "Lio/ktor/http/Headers;", "Ljavax/servlet/http/HttpServletRequest;", "servletRequest", "<init>", "(Ljavax/servlet/http/HttpServletRequest;)V", "", "name", "", "getAll", "(Ljava/lang/String;)Ljava/util/List;", "get", "(Ljava/lang/String;)Ljava/lang/String;", "", "contains", "(Ljava/lang/String;)Z", "Lkotlin/Function2;", "", "body", "forEach", "(Lkotlin/jvm/functions/Function2;)V", "", "", "entries", "()Ljava/util/Set;", "isEmpty", "()Z", "names", "Ljavax/servlet/http/HttpServletRequest;", "getCaseInsensitiveName", "caseInsensitiveName", "ktor-server-servlet"})
public final class ServletApplicationRequestHeaders
implements Headers {
    @NotNull
    private final HttpServletRequest servletRequest;

    public ServletApplicationRequestHeaders(@NotNull HttpServletRequest servletRequest) {
        Intrinsics.checkNotNullParameter((Object)servletRequest, (String)"servletRequest");
        this.servletRequest = servletRequest;
    }

    @Nullable
    public List<String> getAll(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Enumeration enumeration = this.servletRequest.getHeaders(name);
        if (enumeration == null) {
            return null;
        }
        Enumeration headersEnumeration = enumeration;
        if (!headersEnumeration.hasMoreElements()) {
            return null;
        }
        String first = (String)headersEnumeration.nextElement();
        if (!headersEnumeration.hasMoreElements()) {
            return Collections.singletonList(first);
        }
        ArrayList<String> result = new ArrayList<String>(2);
        result.add(first);
        while (headersEnumeration.hasMoreElements()) {
            result.add((String)headersEnumeration.nextElement());
        }
        return result;
    }

    @Nullable
    public String get(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.servletRequest.getHeader(name);
    }

    public boolean contains(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.servletRequest.getHeader(name) != null;
    }

    public void forEach(@NotNull Function2<? super String, ? super List<String>, Unit> body) {
        Intrinsics.checkNotNullParameter(body, (String)"body");
        Enumeration enumeration = this.servletRequest.getHeaderNames();
        if (enumeration == null) {
            return;
        }
        Enumeration namesEnumeration = enumeration;
        while (namesEnumeration.hasMoreElements()) {
            Enumeration headersEnumeration;
            String name = (String)namesEnumeration.nextElement();
            if (this.servletRequest.getHeaders(name) == null) continue;
            List values = SequencesKt.toList((Sequence)SequencesKt.asSequence((Iterator)CollectionsKt.iterator((Enumeration)headersEnumeration)));
            Intrinsics.checkNotNull((Object)name);
            body.invoke((Object)name, (Object)values);
        }
    }

    @NotNull
    public Set<Map.Entry<String, List<String>>> entries() {
        Enumeration names = this.servletRequest.getHeaderNames();
        LinkedHashSet<entries.entry.1> set = new LinkedHashSet<entries.entry.1>();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Map.Entry<String, List<? extends String>> entry2 = new Map.Entry<String, List<? extends String>>(name, this){
                final /* synthetic */ String $name;
                final /* synthetic */ ServletApplicationRequestHeaders this$0;
                {
                    this.$name = $name;
                    this.this$0 = $receiver;
                }

                public String getKey() {
                    String string = this.$name;
                    Intrinsics.checkNotNull((Object)string);
                    return string;
                }

                public List<String> getValue() {
                    String string = this.$name;
                    Intrinsics.checkNotNull((Object)string);
                    List list = this.this$0.getAll(string);
                    if (list == null) {
                        list = CollectionsKt.emptyList();
                    }
                    return list;
                }

                public List<String> setValue(List<String> newValue) {
                    throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                }
            };
            set.add(entry2);
        }
        return set;
    }

    public boolean isEmpty() {
        return !this.servletRequest.getHeaderNames().hasMoreElements();
    }

    public boolean getCaseInsensitiveName() {
        return true;
    }

    @NotNull
    public Set<String> names() {
        Enumeration enumeration = this.servletRequest.getHeaderNames();
        Intrinsics.checkNotNullExpressionValue((Object)enumeration, (String)"getHeaderNames(...)");
        return SequencesKt.toSet((Sequence)SequencesKt.asSequence((Iterator)CollectionsKt.iterator((Enumeration)enumeration)));
    }

    public boolean contains(@NotNull String name, @NotNull String value) {
        return Headers.DefaultImpls.contains((Headers)this, (String)name, (String)value);
    }
}

