/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.sessions;

import io.ktor.server.sessions.CacheStorage;
import io.ktor.server.sessions.DirectoryStorage;
import io.ktor.server.sessions.SessionStorage;
import java.io.File;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u001a\u0015\u0010\u0006\u001a\u00020\u0007*\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003H\u0082\u0010\u001a\f\u0010\t\u001a\u00020\u0007*\u00020\u0003H\u0002\u00a8\u0006\n"}, d2={"directorySessionStorage", "Lio/ktor/server/sessions/SessionStorage;", "rootDir", "Ljava/io/File;", "cached", "", "deleteParentsWhileEmpty", "", "mostTop", "mkdirsOrFail", "ktor-server-sessions"})
public final class DirectoryStorageKt {
    @NotNull
    public static final SessionStorage directorySessionStorage(@NotNull File rootDir, boolean cached) {
        SessionStorage sessionStorage;
        Intrinsics.checkNotNullParameter((Object)rootDir, (String)"rootDir");
        boolean bl = cached;
        if (bl) {
            sessionStorage = new CacheStorage(new DirectoryStorage(rootDir), 60000L);
        } else if (!bl) {
            sessionStorage = new DirectoryStorage(rootDir);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return sessionStorage;
    }

    public static /* synthetic */ SessionStorage directorySessionStorage$default(File file, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return DirectoryStorageKt.directorySessionStorage(file, bl);
    }

    private static final void mkdirsOrFail(File $this$mkdirsOrFail) {
        if (!$this$mkdirsOrFail.mkdirs() && !$this$mkdirsOrFail.exists()) {
            throw new IOException("Couldn't create directory " + $this$mkdirsOrFail);
        }
        if (!$this$mkdirsOrFail.isDirectory()) {
            throw new IOException("Path is not a directory: " + $this$mkdirsOrFail);
        }
    }

    private static final void deleteParentsWhileEmpty(File $this$deleteParentsWhileEmpty, File mostTop) {
        String[] stringArray;
        File file;
        File file2;
        File file3 = $this$deleteParentsWhileEmpty;
        File file4 = mostTop;
        while (!Intrinsics.areEqual((Object)(file2 = file3), (Object)(file = file4)) && file2.isDirectory() && file2.exists() && ((stringArray = file2.list()) == null || stringArray.length == 0)) {
            if (!file2.delete() && file2.exists()) {
                throw new IOException("Failed to delete dir " + file2);
            }
            Intrinsics.checkNotNullExpressionValue((Object)file2.getParentFile(), (String)"parentFile");
            file4 = file;
        }
    }

    public static final /* synthetic */ void access$mkdirsOrFail(File $receiver) {
        DirectoryStorageKt.mkdirsOrFail($receiver);
    }

    public static final /* synthetic */ void access$deleteParentsWhileEmpty(File $receiver, File mostTop) {
        DirectoryStorageKt.deleteParentsWhileEmpty($receiver, mostTop);
    }
}

