/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.sessions;

import io.ktor.http.HttpHeaders;
import io.ktor.server.application.ApplicationCall;
import io.ktor.server.response.ApplicationResponse;
import io.ktor.server.response.ApplicationResponsePropertiesKt;
import io.ktor.server.sessions.SessionTransport;
import io.ktor.server.sessions.SessionTransportTransformer;
import io.ktor.server.sessions.SessionTransportTransformerKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\b\u0010\u0013\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lio/ktor/server/sessions/SessionTransportHeader;", "Lio/ktor/server/sessions/SessionTransport;", "name", "", "transformers", "", "Lio/ktor/server/sessions/SessionTransportTransformer;", "(Ljava/lang/String;Ljava/util/List;)V", "getName", "()Ljava/lang/String;", "getTransformers", "()Ljava/util/List;", "clear", "", "call", "Lio/ktor/server/application/ApplicationCall;", "receive", "send", "value", "toString", "ktor-server-sessions"})
public final class SessionTransportHeader
implements SessionTransport {
    @NotNull
    private final String name;
    @NotNull
    private final List<SessionTransportTransformer> transformers;

    public SessionTransportHeader(@NotNull String name, @NotNull List<? extends SessionTransportTransformer> transformers) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(transformers, (String)"transformers");
        this.name = name;
        this.transformers = transformers;
        HttpHeaders.INSTANCE.checkHeaderName(this.name);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final List<SessionTransportTransformer> getTransformers() {
        return this.transformers;
    }

    @Override
    @Nullable
    public String receive(@NotNull ApplicationCall call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        return SessionTransportTransformerKt.transformRead(this.transformers, call.getRequest().getHeaders().get(this.name));
    }

    @Override
    public void send(@NotNull ApplicationCall call, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ApplicationResponsePropertiesKt.header((ApplicationResponse)call.getResponse(), (String)this.name, (String)SessionTransportTransformerKt.transformWrite(this.transformers, value));
    }

    @Override
    public void clear(@NotNull ApplicationCall call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
    }

    @NotNull
    public String toString() {
        return "SessionTransportHeader: " + this.name;
    }
}

