/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.sessions;

import io.ktor.server.sessions.BaseTimeoutCache;
import io.ktor.server.sessions.KeyState;
import io.ktor.server.sessions.ListElement;
import io.ktor.server.sessions.PullableLinkedList;
import java.lang.ref.WeakReference;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00060\u0003j\u0002`\u0004B;\u0012\u0010\u0010\u0005\u001a\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0012\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\r0\f\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u0017\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\rH\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001d\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R0\u0010\u0005\u001a$\u0012 \u0012\u001e\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u0003 \u0016*\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u0003\u0018\u00010\u00060\u00060\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lio/ktor/server/sessions/TimeoutWorker;", "K", "", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "owner", "Lio/ktor/server/sessions/BaseTimeoutCache;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "cond", "Ljava/util/concurrent/locks/Condition;", "items", "Lio/ktor/server/sessions/PullableLinkedList;", "Lio/ktor/server/sessions/KeyState;", "(Lio/ktor/server/sessions/BaseTimeoutCache;Ljava/util/concurrent/locks/ReentrantLock;Ljava/util/concurrent/locks/Condition;Lio/ktor/server/sessions/PullableLinkedList;)V", "getCond", "()Ljava/util/concurrent/locks/Condition;", "getItems", "()Lio/ktor/server/sessions/PullableLinkedList;", "getLock", "()Ljava/util/concurrent/locks/ReentrantLock;", "Ljava/lang/ref/WeakReference;", "kotlin.jvm.PlatformType", "head", "run", "", "ktor-server-sessions"})
final class TimeoutWorker<K>
implements Runnable {
    @NotNull
    private final ReentrantLock lock;
    @NotNull
    private final Condition cond;
    @NotNull
    private final PullableLinkedList<KeyState<K>> items;
    @NotNull
    private final WeakReference<BaseTimeoutCache<K, ?>> owner;

    public TimeoutWorker(@NotNull BaseTimeoutCache<? super K, ?> owner, @NotNull ReentrantLock lock, @NotNull Condition cond, @NotNull PullableLinkedList<KeyState<K>> items) {
        Intrinsics.checkNotNullParameter(owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)lock, (String)"lock");
        Intrinsics.checkNotNullParameter((Object)cond, (String)"cond");
        Intrinsics.checkNotNullParameter(items, (String)"items");
        this.lock = lock;
        this.cond = cond;
        this.items = items;
        this.owner = new WeakReference(owner);
    }

    @NotNull
    public final ReentrantLock getLock() {
        return this.lock;
    }

    @NotNull
    public final Condition getCond() {
        return this.cond;
    }

    @NotNull
    public final PullableLinkedList<KeyState<K>> getItems() {
        return this.items;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        do {
            Lock lock = this.lock;
            lock.lock();
            try {
                boolean bl = false;
                KeyState<K> item = this.head();
                if (item != null) {
                    long time = item.timeToWait();
                    if (time == 0L) {
                        this.items.remove((KeyState<K>)((ListElement)item));
                        Object k = item.getKey().get();
                        if (k != null) {
                            BaseTimeoutCache baseTimeoutCache = (BaseTimeoutCache)this.owner.get();
                            if (baseTimeoutCache != null) {
                                baseTimeoutCache.invalidate(k);
                            }
                        }
                    } else {
                        this.cond.await(time, TimeUnit.MILLISECONDS);
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
        } while (!Thread.interrupted() && this.owner.get() != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final KeyState<K> head() {
        KeyState<K> keyState;
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            while (this.items.isEmpty() && this.owner.get() != null) {
                this.cond.await(60L, TimeUnit.SECONDS);
            }
            keyState = this.owner.get() == null ? null : this.items.head();
        }
        finally {
            lock.unlock();
        }
        return keyState;
    }
}

