/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.sessions;

import io.ktor.http.CookieEncoding;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\f\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001f\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R$\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u001a@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001c\u0010 \u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0006\"\u0004\b\"\u0010\bR\u001a\u0010#\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u0016\"\u0004\b%\u0010\u0018\u00a8\u0006&"}, d2={"Lio/ktor/server/sessions/CookieConfiguration;", "", "()V", "domain", "", "getDomain", "()Ljava/lang/String;", "setDomain", "(Ljava/lang/String;)V", "encoding", "Lio/ktor/http/CookieEncoding;", "getEncoding", "()Lio/ktor/http/CookieEncoding;", "setEncoding", "(Lio/ktor/http/CookieEncoding;)V", "extensions", "", "getExtensions", "()Ljava/util/Map;", "httpOnly", "", "getHttpOnly", "()Z", "setHttpOnly", "(Z)V", "newMaxAge", "", "maxAgeInSeconds", "getMaxAgeInSeconds", "()J", "setMaxAgeInSeconds", "(J)V", "path", "getPath", "setPath", "secure", "getSecure", "setSecure", "ktor-server-sessions"})
public final class CookieConfiguration {
    private long maxAgeInSeconds = 604800L;
    @NotNull
    private CookieEncoding encoding = CookieEncoding.URI_ENCODING;
    @Nullable
    private String domain;
    @Nullable
    private String path = "/";
    private boolean secure;
    private boolean httpOnly = true;
    @NotNull
    private final Map<String, String> extensions = new LinkedHashMap();

    public final long getMaxAgeInSeconds() {
        return this.maxAgeInSeconds;
    }

    public final void setMaxAgeInSeconds(long newMaxAge) {
        if (!(newMaxAge >= 0L)) {
            boolean bl = false;
            String string = "maxAgeInSeconds shouldn't be negative: " + newMaxAge;
            throw new IllegalArgumentException(string.toString());
        }
        this.maxAgeInSeconds = newMaxAge;
    }

    @NotNull
    public final CookieEncoding getEncoding() {
        return this.encoding;
    }

    public final void setEncoding(@NotNull CookieEncoding cookieEncoding) {
        Intrinsics.checkNotNullParameter((Object)cookieEncoding, (String)"<set-?>");
        this.encoding = cookieEncoding;
    }

    @Nullable
    public final String getDomain() {
        return this.domain;
    }

    public final void setDomain(@Nullable String string) {
        this.domain = string;
    }

    @Nullable
    public final String getPath() {
        return this.path;
    }

    public final void setPath(@Nullable String string) {
        this.path = string;
    }

    public final boolean getSecure() {
        return this.secure;
    }

    public final void setSecure(boolean bl) {
        this.secure = bl;
    }

    public final boolean getHttpOnly() {
        return this.httpOnly;
    }

    public final void setHttpOnly(boolean bl) {
        this.httpOnly = bl;
    }

    @NotNull
    public final Map<String, String> getExtensions() {
        return this.extensions;
    }
}

