/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.sessions;

import io.ktor.server.sessions.DirectoryStorageKt;
import io.ktor.server.sessions.SessionStorage;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Collection;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0002J\u0019\u0010\u000b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\fJ\u0019\u0010\r\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u00102\u0006\u0010\t\u001a\u00020\nH\u0002J!\u0010\u0011\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\nH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0014"}, d2={"Lio/ktor/server/sessions/DirectoryStorage;", "Lio/ktor/server/sessions/SessionStorage;", "Ljava/io/Closeable;", "dir", "Ljava/io/File;", "(Ljava/io/File;)V", "close", "", "fileOf", "id", "", "invalidate", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "read", "requireId", "split", "Lkotlin/sequences/Sequence;", "write", "value", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "ktor-server-sessions"})
public final class DirectoryStorage
implements SessionStorage,
Closeable {
    @NotNull
    private final File dir;

    public DirectoryStorage(@NotNull File dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        this.dir = dir;
        DirectoryStorageKt.access$mkdirsOrFail(this.dir);
    }

    @Override
    public void close() {
    }

    @Override
    @Nullable
    public Object write(@NotNull String id, @NotNull String value, @NotNull Continuation<? super Unit> $completion) {
        this.requireId(id);
        File file = this.fileOf(id);
        File file2 = file.getParentFile();
        if (file2 != null) {
            DirectoryStorageKt.access$mkdirsOrFail(file2);
        }
        FilesKt.writeText$default((File)file, (String)value, null, (int)2, null);
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object read(@NotNull String id, @NotNull Continuation<? super String> $completion) {
        this.requireId(id);
        try {
            String string;
            File file = this.fileOf(id);
            File file2 = file.getParentFile();
            if (file2 != null) {
                DirectoryStorageKt.access$mkdirsOrFail(file2);
            }
            String it = string = FilesKt.readText$default((File)file, null, (int)1, null);
            boolean bl = false;
            String string2 = ((CharSequence)it).length() > 0 ? string : null;
            if (string2 == null) {
                throw new IllegalStateException("Failed to read stored session from " + file);
            }
            return string2;
        }
        catch (FileNotFoundException notFound) {
            throw new NoSuchElementException("No session data found for id " + id);
        }
    }

    @Override
    @Nullable
    public Object invalidate(@NotNull String id, @NotNull Continuation<? super Unit> $completion) {
        this.requireId(id);
        try {
            File file = this.fileOf(id);
            file.delete();
            File file2 = file.getParentFile();
            if (file2 != null) {
                DirectoryStorageKt.access$deleteParentsWhileEmpty(file2, this.dir);
            }
        }
        catch (FileNotFoundException notFound) {
            throw new NoSuchElementException("No session data found for id " + id);
        }
        return Unit.INSTANCE;
    }

    private final File fileOf(String id) {
        Sequence<String> sequence = this.split(id);
        String string = File.separator;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"separator");
        return new File(this.dir, SequencesKt.joinToString$default(sequence, (CharSequence)string, null, (CharSequence)".dat", (int)0, null, null, (int)58, null));
    }

    private final Sequence<String> split(String id) {
        return StringsKt.windowedSequence((CharSequence)id, (int)2, (int)2, (boolean)true);
    }

    private final void requireId(String id) {
        if (((CharSequence)id).length() == 0) {
            throw new IllegalArgumentException("Session id is empty");
        }
        Object[] objectArray = new String[]{"..", "/", "\\", "!", "?", ">", "<", "\u0000"};
        if (StringsKt.indexOfAny$default((CharSequence)id, (Collection)CollectionsKt.listOf((Object[])objectArray), (int)0, (boolean)false, (int)6, null) != -1) {
            throw new IllegalArgumentException("Bad session id " + id);
        }
    }
}

