/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.sessions;

import io.ktor.http.Cookie;
import io.ktor.http.CookieEncoding;
import io.ktor.server.application.ApplicationCall;
import io.ktor.server.sessions.CookieConfiguration;
import io.ktor.server.sessions.SessionTransport;
import io.ktor.server.sessions.SessionTransportTransformer;
import io.ktor.server.sessions.SessionTransportTransformerKt;
import io.ktor.util.date.DateJvmKt;
import io.ktor.util.date.DateKt;
import io.ktor.util.date.GMTDate;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\r\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0003H\u0016J\b\u0010\u001a\u001a\u00020\u0003H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lio/ktor/server/sessions/SessionTransportCookie;", "Lio/ktor/server/sessions/SessionTransport;", "name", "", "configuration", "Lio/ktor/server/sessions/CookieConfiguration;", "transformers", "", "Lio/ktor/server/sessions/SessionTransportTransformer;", "(Ljava/lang/String;Lio/ktor/server/sessions/CookieConfiguration;Ljava/util/List;)V", "getConfiguration", "()Lio/ktor/server/sessions/CookieConfiguration;", "getName", "()Ljava/lang/String;", "getTransformers", "()Ljava/util/List;", "clear", "", "call", "Lio/ktor/server/application/ApplicationCall;", "clearCookie", "Lio/ktor/http/Cookie;", "clearCookie$ktor_server_sessions", "receive", "send", "value", "toString", "ktor-server-sessions"})
public final class SessionTransportCookie
implements SessionTransport {
    @NotNull
    private final String name;
    @NotNull
    private final CookieConfiguration configuration;
    @NotNull
    private final List<SessionTransportTransformer> transformers;

    public SessionTransportCookie(@NotNull String name, @NotNull CookieConfiguration configuration, @NotNull List<? extends SessionTransportTransformer> transformers) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter(transformers, (String)"transformers");
        this.name = name;
        this.configuration = configuration;
        this.transformers = transformers;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final CookieConfiguration getConfiguration() {
        return this.configuration;
    }

    @NotNull
    public final List<SessionTransportTransformer> getTransformers() {
        return this.transformers;
    }

    @Override
    @Nullable
    public String receive(@NotNull ApplicationCall call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        return SessionTransportTransformerKt.transformRead(this.transformers, call.getRequest().getCookies().get(this.name, this.configuration.getEncoding()));
    }

    @Override
    public void send(@NotNull ApplicationCall call, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        GMTDate now = DateJvmKt.GMTDate$default(null, (int)1, null);
        long maxAge = this.configuration.getMaxAgeInSeconds();
        GMTDate expires = maxAge == 0L ? null : DateKt.plus((GMTDate)now, (long)(maxAge * 1000L));
        Cookie cookie = new Cookie(this.name, SessionTransportTransformerKt.transformWrite(this.transformers, value), this.configuration.getEncoding(), (int)RangesKt.coerceAtMost((long)maxAge, (long)Integer.MAX_VALUE), expires, this.configuration.getDomain(), this.configuration.getPath(), this.configuration.getSecure(), this.configuration.getHttpOnly(), this.configuration.getExtensions());
        call.getResponse().getCookies().append(cookie);
    }

    @Override
    public void clear(@NotNull ApplicationCall call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        call.getResponse().getCookies().append(this.clearCookie$ktor_server_sessions());
    }

    @NotNull
    public final Cookie clearCookie$ktor_server_sessions() {
        String string = this.name;
        CookieEncoding cookieEncoding = this.configuration.getEncoding();
        String string2 = this.configuration.getDomain();
        String string3 = this.configuration.getPath();
        boolean bl = this.configuration.getSecure();
        boolean bl2 = this.configuration.getHttpOnly();
        Map<String, String> map = this.configuration.getExtensions();
        GMTDate gMTDate = GMTDate.Companion.getSTART();
        return new Cookie(string, "", cookieEncoding, 0, gMTDate, string2, string3, bl, bl2, map);
    }

    @NotNull
    public String toString() {
        return "SessionTransportCookie: " + this.name;
    }
}

