/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.sessions;

import io.ktor.sessions.CacheStorage;
import io.ktor.sessions.DirectoryStorage;
import io.ktor.sessions.SessionStorage;
import java.io.File;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u001a\u0015\u0010\u0006\u001a\u00020\u0007*\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003H\u0082\u0010\u001a\f\u0010\t\u001a\u00020\u0007*\u00020\u0003H\u0002\u00a8\u0006\n"}, d2={"directorySessionStorage", "Lio/ktor/sessions/SessionStorage;", "rootDir", "Ljava/io/File;", "cached", "", "deleteParentsWhileEmpty", "", "mostTop", "mkdirsOrFail", "ktor-server-sessions"})
public final class DirectoryStorageKt {
    @NotNull
    public static final SessionStorage directorySessionStorage(@NotNull File rootDir, boolean cached) {
        SessionStorage sessionStorage;
        Intrinsics.checkNotNullParameter((Object)rootDir, (String)"rootDir");
        boolean bl = cached;
        if (bl) {
            sessionStorage = new CacheStorage(new DirectoryStorage(rootDir), 60000L);
        } else if (!bl) {
            sessionStorage = new DirectoryStorage(rootDir);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return sessionStorage;
    }

    public static /* synthetic */ SessionStorage directorySessionStorage$default(File file, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return DirectoryStorageKt.directorySessionStorage(file, bl);
    }

    private static final void mkdirsOrFail(File $this$mkdirsOrFail) {
        if (!$this$mkdirsOrFail.mkdirs() && !$this$mkdirsOrFail.exists()) {
            throw new IOException(Intrinsics.stringPlus((String)"Couldn't create directory ", (Object)$this$mkdirsOrFail));
        }
        if (!$this$mkdirsOrFail.isDirectory()) {
            throw new IOException(Intrinsics.stringPlus((String)"Path is not a directory: ", (Object)$this$mkdirsOrFail));
        }
    }

    private static final void deleteParentsWhileEmpty(File $this$deleteParentsWhileEmpty, File mostTop) {
        Object object;
        File file;
        Object object2;
        Object object3 = $this$deleteParentsWhileEmpty;
        File file2 = mostTop;
        while (!Intrinsics.areEqual((Object)(object2 = object3), (Object)(file = file2)) && object2.isDirectory() && object2.exists() && ((object = object2.list()) == null || ((String[])object).length == 0)) {
            if (!object2.delete() && object2.exists()) {
                throw new IOException(Intrinsics.stringPlus((String)"Failed to delete dir ", (Object)object2));
            }
            object = object2.getParentFile();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parentFile");
            object3 = object;
            file2 = file;
        }
    }

    public static final /* synthetic */ void access$mkdirsOrFail(File $receiver) {
        DirectoryStorageKt.mkdirsOrFail($receiver);
    }

    public static final /* synthetic */ void access$deleteParentsWhileEmpty(File $receiver, File mostTop) {
        DirectoryStorageKt.deleteParentsWhileEmpty($receiver, mostTop);
    }
}

