/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.testing;

import io.ktor.server.testing.FreePorts;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010!\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004H\u0002J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u000e\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0004J\u0006\u0010\u0017\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R2\u0010\u0006\u001a&\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00040\u0004 \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00040\u0004\u0018\u00010\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\n\u001a&\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00040\u0004 \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00040\u0004\u0018\u00010\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/ktor/server/testing/FreePorts;", "", "()V", "CAPACITY", "", "CAPACITY_LOW", "found", "", "kotlin.jvm.PlatformType", "", "free", "", "", "allocate", "", "count", "checkFreePort", "", "port", "log", "message", "", "recycle", "select", "ktor-server-test-host"})
public final class FreePorts {
    @NotNull
    public static final FreePorts INSTANCE = new FreePorts();
    private static final int CAPACITY = 20;
    private static final int CAPACITY_LOW = 10;
    private static final Set<Integer> found = Collections.synchronizedSet(new HashSet());
    private static final List<Integer> free = Collections.synchronizedList(new LinkedList());

    private FreePorts() {
    }

    public final int select() {
        if (free.size() < CAPACITY_LOW) {
            ThreadsKt.thread$default((boolean)false, (boolean)false, null, (String)"free-port-population", (int)0, (Function0)select.1.INSTANCE, (int)23, null);
        }
        while (true) {
            try {
                Integer n = free.remove(0);
                Intrinsics.checkNotNullExpressionValue((Object)n, (String)"free.removeAt(0)");
                return ((Number)n).intValue();
            }
            catch (IndexOutOfBoundsException expected) {
                this.allocate(CAPACITY);
                continue;
            }
            break;
        }
    }

    public final void recycle(int port) {
        if (found.contains(port) && this.checkFreePort(port)) {
            free.add(port);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void allocate(int count) {
        block9: {
            if (count <= 0) {
                return;
            }
            ArrayList<ServerSocket> sockets = new ArrayList<ServerSocket>();
            try {
                int repeat = 1;
                if (repeat > count) break block9;
                while (true) {
                    try {
                        ServerSocket socket = new ServerSocket(0, 1);
                        sockets.add(socket);
                    }
                    catch (Throwable ignore) {
                        this.log("Waiting for free ports");
                        Thread.sleep(1000L);
                    }
                    if (repeat != count) {
                        ++repeat;
                        continue;
                    }
                    break;
                }
            }
            finally {
                CollectionsKt.removeAll((List)sockets, (Function1)allocate.1.INSTANCE);
                this.log("Waiting for ports cleanup");
                Thread.sleep(1000L);
                Iterable $this$forEach$iv = sockets;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ServerSocket it = (ServerSocket)element$iv;
                    boolean bl = false;
                    free.add(it.getLocalPort());
                }
            }
        }
    }

    private final boolean checkFreePort(int port) {
        try {
            new ServerSocket(port).close();
            return true;
        }
        catch (Throwable unableToBind) {
            return false;
        }
    }

    private final void log(String message) {
        LoggerFactory.getLogger(FreePorts.class).info(message);
    }

    public static final /* synthetic */ void access$allocate(FreePorts $this, int count) {
        $this.allocate(count);
    }

    public static final /* synthetic */ int access$getCAPACITY$p() {
        return CAPACITY;
    }

    public static final /* synthetic */ List access$getFree$p() {
        return free;
    }

    public static final /* synthetic */ Set access$getFound$p() {
        return found;
    }

    static {
        INSTANCE.allocate(CAPACITY);
    }
}

