/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.testing;

import io.ktor.http.HttpHeaders;
import io.ktor.http.HttpMethod;
import io.ktor.http.cio.RequestResponseBuilder;
import io.ktor.utils.io.core.ByteBuffersKt;
import io.ktor.utils.io.core.ByteReadPacket;
import java.io.Closeable;
import java.net.InetSocketAddress;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.concurrent.ThreadsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 .2\u00020\u0001:\u0003-./B7\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bBF\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\f\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0017\u0010\r\u001a\u0013\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e\u00a2\u0006\u0002\b\u0011\u00a2\u0006\u0002\u0010\u0012J\u0006\u0010*\u001a\u00020\u0010J\u0006\u0010(\u001a\u00020\u0010J\b\u0010+\u001a\u00020\u0003H\u0002J\u0006\u0010,\u001a\u00020\u0010R\u000e\u0010\u0013\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\f\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001fR\u000e\u0010!\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lio/ktor/server/testing/HighLoadHttpGenerator;", "", "url", "", "host", "port", "", "numberConnections", "queueSize", "highPressure", "", "(Ljava/lang/String;Ljava/lang/String;IIIZ)V", "numberOfConnections", "builder", "Lkotlin/Function1;", "Lio/ktor/http/cio/RequestResponseBuilder;", "", "Lkotlin/ExtensionFunctionType;", "(Ljava/lang/String;IIIZLkotlin/jvm/functions/Function1;)V", "cancelled", "codeCounts", "", "Ljava/util/concurrent/atomic/AtomicLong;", "[Ljava/util/concurrent/atomic/AtomicLong;", "connectErrors", "count", "getHighPressure", "()Z", "getHost", "()Ljava/lang/String;", "getNumberOfConnections", "()I", "getQueueSize", "readErrors", "remote", "Ljava/net/InetSocketAddress;", "request", "Lio/ktor/utils/io/core/ByteReadPacket;", "requestByteBuffer", "Ljava/nio/ByteBuffer;", "shutdown", "writeErrors", "mainLoop", "stat", "stop", "ClientState", "Companion", "ParseState", "ktor-server-test-host"})
@SourceDebugExtension(value={"SMAP\nHighLoadHttpGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HighLoadHttpGenerator.kt\nio/ktor/server/testing/HighLoadHttpGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,751:1\n1855#2,2:752\n12474#3,2:754\n13374#3,3:756\n*S KotlinDebug\n*F\n+ 1 HighLoadHttpGenerator.kt\nio/ktor/server/testing/HighLoadHttpGenerator\n*L\n574#1:752,2\n587#1:754,2\n589#1:756,3\n*E\n"})
public final class HighLoadHttpGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String host;
    private final int numberOfConnections;
    private final int queueSize;
    private final boolean highPressure;
    @NotNull
    private final InetSocketAddress remote;
    @NotNull
    private final ByteReadPacket request;
    @NotNull
    private final ByteBuffer requestByteBuffer;
    @NotNull
    private final AtomicLong count;
    @NotNull
    private final AtomicLong[] codeCounts;
    @NotNull
    private final AtomicLong readErrors;
    @NotNull
    private final AtomicLong writeErrors;
    @NotNull
    private final AtomicLong connectErrors;
    private volatile boolean cancelled;
    private volatile boolean shutdown;
    @NotNull
    private static final byte[] HTTP11;
    private static final long HTTP11Long = 5211883372140375601L;
    private static final int HTTP1_length = 8;
    private static final int HTTP_200_SPACE_Int = 0x32303020;
    private static final int HTTP_200_R_Int = 842018829;
    private static final byte N = 10;
    private static final byte S = 32;

    /*
     * WARNING - void declaration
     */
    public HighLoadHttpGenerator(@NotNull String host, int port, int numberOfConnections, int queueSize, boolean highPressure, @NotNull Function1<? super RequestResponseBuilder, Unit> builder2) {
        void $this$requestByteBuffer_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter(builder2, (String)"builder");
        this.host = host;
        this.numberOfConnections = numberOfConnections;
        this.queueSize = queueSize;
        this.highPressure = highPressure;
        this.remote = new InetSocketAddress(this.host, port);
        Object object = new RequestResponseBuilder();
        builder2.invoke(object);
        this.request = object.build();
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect((int)this.request.getRemaining());
        Intrinsics.checkNotNull((Object)byteBuffer);
        object = byteBuffer;
        AtomicLong[] atomicLongArray = object;
        HighLoadHttpGenerator highLoadHttpGenerator = this;
        boolean bl = false;
        ByteBuffersKt.readFully((ByteReadPacket)this.request.copy(), (ByteBuffer)$this$requestByteBuffer_u24lambda_u240);
        $this$requestByteBuffer_u24lambda_u240.clear();
        highLoadHttpGenerator.requestByteBuffer = object;
        this.count = new AtomicLong(0L);
        int n = 0;
        atomicLongArray = new AtomicLong[1000];
        highLoadHttpGenerator = this;
        while (n < 1000) {
            int n2 = n++;
            atomicLongArray[n2] = new AtomicLong(0L);
        }
        highLoadHttpGenerator.codeCounts = atomicLongArray;
        this.readErrors = new AtomicLong();
        this.writeErrors = new AtomicLong();
        this.connectErrors = new AtomicLong();
    }

    @NotNull
    public final String getHost() {
        return this.host;
    }

    public final int getNumberOfConnections() {
        return this.numberOfConnections;
    }

    public final int getQueueSize() {
        return this.queueSize;
    }

    public final boolean getHighPressure() {
        return this.highPressure;
    }

    public HighLoadHttpGenerator(final @NotNull String url, final @NotNull String host, final int port, int numberConnections, int queueSize, boolean highPressure) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this(host, port, numberConnections, queueSize, highPressure, (Function1<? super RequestResponseBuilder, Unit>)((Function1)new Function1<RequestResponseBuilder, Unit>(){

            public final void invoke(@NotNull RequestResponseBuilder $this$null) {
                Intrinsics.checkNotNullParameter((Object)$this$null, (String)"$this$null");
                $this$null.requestLine(HttpMethod.Companion.getGet(), (CharSequence)url, (CharSequence)"HTTP/1.1");
                $this$null.headerLine((CharSequence)HttpHeaders.INSTANCE.getHost(), (CharSequence)(host + ':' + port));
                $this$null.headerLine((CharSequence)HttpHeaders.INSTANCE.getAccept(), (CharSequence)"*/*");
                $this$null.emptyLine();
            }
        }));
    }

    public final void shutdown() {
        this.shutdown = true;
    }

    public final void stop() {
        this.cancelled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void mainLoop() {
        SelectorProvider selectorProvider = SelectorProvider.provider();
        Intrinsics.checkNotNull((Object)selectorProvider);
        SelectorProvider provider = selectorProvider;
        AbstractSelector abstractSelector = provider.openSelector();
        Intrinsics.checkNotNull((Object)abstractSelector);
        AbstractSelector selector = abstractSelector;
        Closeable closeable = selector;
        Throwable throwable = null;
        try {
            AbstractSelector it = (AbstractSelector)closeable;
            boolean bl = false;
            int connectionsCount = 0;
            ArrayList<ClientState> writeReady = new ArrayList<ClientState>(this.numberOfConnections);
            ArrayList<ClientState> writeReadyTmp = new ArrayList<ClientState>(this.numberOfConnections);
            ArrayList<ClientState> readReady = new ArrayList<ClientState>(this.numberOfConnections);
            ArrayList<ClientState> pending = new ArrayList<ClientState>(this.numberOfConnections * 2);
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(65536);
            Intrinsics.checkNotNull((Object)byteBuffer);
            ByteBuffer bb = byteBuffer;
            bb.order(ByteOrder.BIG_ENDIAN);
            int connectFailureInRowCount = 0;
            while (!this.cancelled && connectFailureInRowCount < 100) {
                ClientState c;
                int idx;
                if (connectionsCount < this.numberOfConnections) {
                    SocketChannel ch;
                    Intrinsics.checkNotNull((Object)provider.openSocketChannel());
                    ch.configureBlocking(false);
                    try {
                        ClientState client2 = new ClientState(ch);
                        client2.send(this.queueSize);
                        if (ch.connect(this.remote)) {
                            writeReady.add(client2);
                        } else {
                            client2.setKey(ch.register(selector, 8, client2));
                            client2.setCurrentOps(8);
                        }
                        ++connectionsCount;
                        connectFailureInRowCount = 0;
                    }
                    catch (Throwable t) {
                        ch.close();
                        this.connectErrors.incrementAndGet();
                        ++connectFailureInRowCount;
                    }
                }
                int t = writeReady.size();
                for (int idx2 = 0; idx2 < t && !this.cancelled; ++idx2) {
                    Object e = writeReady.get(idx2);
                    Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
                    ClientState c2 = (ClientState)e;
                    if (!c2.getChannel().isConnected()) continue;
                    try {
                        if (!c2.doWrite$ktor_server_test_host()) {
                            c2.setWritePending(true);
                            readReady.add(c2);
                            pending.add(c2);
                            continue;
                        }
                        readReady.add(c2);
                        if (c2.getWritePending()) {
                            c2.setWritePending(false);
                            pending.add(c2);
                        }
                        if (c2.getRemaining() <= 0) continue;
                        writeReadyTmp.add(c2);
                        continue;
                    }
                    catch (Throwable t2) {
                        this.writeErrors.incrementAndGet();
                        c2.close();
                        --connectionsCount;
                    }
                }
                writeReady.clear();
                ArrayList<ClientState> tmp = writeReadyTmp;
                writeReadyTmp = writeReady;
                writeReady = tmp;
                int c2 = readReady.size();
                for (idx = 0; idx < c2 && !this.cancelled; ++idx) {
                    Object e = readReady.get(idx);
                    Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
                    c = (ClientState)e;
                    if (!c.getChannel().isConnected()) continue;
                    try {
                        int rc;
                        while ((rc = c.doRead$ktor_server_test_host(bb)) > 0) {
                        }
                        if (rc == -1) {
                            --connectionsCount;
                            c.close();
                            continue;
                        }
                        c.setReadPending(true);
                        pending.add(c);
                        if (c.getRemaining() <= 0) continue;
                        writeReady.add(c);
                        continue;
                    }
                    catch (Throwable t3) {
                        this.readErrors.incrementAndGet();
                        c.close();
                        --connectionsCount;
                    }
                }
                readReady.clear();
                c2 = pending.size();
                for (idx = 0; idx < c2 && !this.cancelled; ++idx) {
                    Object e = pending.get(idx);
                    Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
                    c = (ClientState)e;
                    c.interest(selector);
                }
                pending.clear();
                Set<SelectionKey> set = selector.keys();
                Intrinsics.checkNotNullExpressionValue(set, (String)"keys(...)");
                boolean hasKeys = !((Collection)set).isEmpty();
                int selectedCount = this.cancelled ? 0 : (!hasKeys ? 0 : (connectionsCount < this.numberOfConnections ? selector.selectNow() : (!((Collection)writeReady).isEmpty() ? selector.selectNow() : (!((Collection)readReady).isEmpty() ? selector.selectNow() : selector.select(500L)))));
                if (selectedCount <= 0) continue;
                Iterator<SelectionKey> iter = selector.selectedKeys().iterator();
                while (iter.hasNext()) {
                    SelectionKey key;
                    Intrinsics.checkNotNull((Object)iter.next());
                    Object object = key.attachment();
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type io.ktor.server.testing.HighLoadHttpGenerator.ClientState");
                    ClientState client3 = (ClientState)object;
                    if (!client3.getChannel().isOpen()) {
                        client3.close();
                    } else if (client3.getChannel().isConnectionPending()) {
                        try {
                            if (!client3.getChannel().finishConnect()) {
                                String string = "Check failed.";
                                throw new IllegalStateException(string.toString());
                            }
                            writeReady.add(client3);
                        }
                        catch (Throwable t4) {
                            client3.close();
                            --connectionsCount;
                            this.connectErrors.incrementAndGet();
                        }
                    } else {
                        int readyOps = key.readyOps();
                        if ((readyOps & 1) != 0) {
                            client3.setReadPending(false);
                            readReady.add(client3);
                        }
                        if ((readyOps & 4) != 0) {
                            client3.setWritePending(false);
                            writeReady.add(client3);
                        }
                    }
                    iter.remove();
                    client3.interest(selector);
                }
            }
            Set<SelectionKey> set = selector.keys();
            Intrinsics.checkNotNullExpressionValue(set, (String)"keys(...)");
            Iterable $this$forEach$iv = set;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SelectionKey it2 = (SelectionKey)element$iv;
                boolean bl2 = false;
                it2.cancel();
                try {
                    it2.channel().close();
                }
                catch (Throwable throwable2) {
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String stat() {
        boolean bl;
        StringBuilder $this$stat_u24lambda_u245;
        StringBuilder stringBuilder;
        block3: {
            $this$stat_u24lambda_u245 = stringBuilder = new StringBuilder();
            boolean bl2 = false;
            StringBuilder stringBuilder2 = $this$stat_u24lambda_u245.append("count: " + this.count.get());
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
            StringBuilder stringBuilder3 = $this$stat_u24lambda_u245.append("errors: read " + this.readErrors.get() + ", write " + this.writeErrors.get() + ", connect: " + this.connectErrors.get());
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
            AtomicLong[] $this$any$iv = this.codeCounts;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                AtomicLong element$iv;
                AtomicLong it = element$iv = $this$any$iv[i];
                boolean bl3 = false;
                if (!(it.get() > 0L)) continue;
                bl = true;
                break block3;
            }
            bl = false;
        }
        if (bl) {
            StringBuilder stringBuilder4 = $this$stat_u24lambda_u245.append("statuses:");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append(...)");
            AtomicLong[] $this$forEachIndexed$iv = this.codeCounts;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (AtomicLong item$iv : $this$forEachIndexed$iv) {
                void a;
                int n = index$iv++;
                AtomicLong bl3 = item$iv;
                int idx = n;
                boolean bl4 = false;
                long cnt = a.get();
                if (cnt <= 0L) continue;
                StringBuilder stringBuilder5 = $this$stat_u24lambda_u245.append("  " + idx + "    " + cnt);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append(...)");
            }
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Companion.main(args);
    }

    static {
        String string = "HTTP/1.1";
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        HTTP11 = byArray;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010&\u001a\u00020\bH\u0002J\u0006\u0010'\u001a\u00020(J\u0015\u0010)\u001a\u00020\b2\u0006\u0010*\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b+J\u000e\u0010,\u001a\u00020\u001aH\u0080\u0010\u00a2\u0006\u0002\b-J\u0010\u0010.\u001a\u00020(2\u0006\u0010*\u001a\u00020\nH\u0002J\u0010\u0010/\u001a\u00020(2\u0006\u0010*\u001a\u00020\nH\u0002J \u00100\u001a\u00020(2\u0006\u0010*\u001a\u00020\n2\u0006\u00101\u001a\u00020\b2\u0006\u00102\u001a\u00020\bH\u0002J\u0010\u00103\u001a\u00020(2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u00104\u001a\u00020(2\u0006\u00105\u001a\u000206J\u0010\u00107\u001a\u00020(2\u0006\u0010*\u001a\u00020\nH\u0002J\u0010\u00108\u001a\u00020(2\u0006\u0010*\u001a\u00020\nH\u0002J\u0010\u00109\u001a\u00020(2\b\b\u0002\u0010:\u001a\u00020\bJ\u0010\u0010;\u001a\u00020(2\u0006\u0010*\u001a\u00020\nH\u0002J \u0010<\u001a\u00020(2\u0006\u0010*\u001a\u00020\n2\u0006\u00101\u001a\u00020\b2\u0006\u00102\u001a\u00020\bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001e\u0010 \u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u000eR\u000e\u0010\"\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010#\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u001c\"\u0004\b%\u0010\u001e\u00a8\u0006="}, d2={"Lio/ktor/server/testing/HighLoadHttpGenerator$ClientState;", "", "channel", "Ljava/nio/channels/SocketChannel;", "(Lio/ktor/server/testing/HighLoadHttpGenerator;Ljava/nio/channels/SocketChannel;)V", "getChannel", "()Ljava/nio/channels/SocketChannel;", "code", "", "current", "Ljava/nio/ByteBuffer;", "kotlin.jvm.PlatformType", "currentOps", "getCurrentOps", "()I", "setCurrentOps", "(I)V", "key", "Ljava/nio/channels/SelectionKey;", "getKey", "()Ljava/nio/channels/SelectionKey;", "setKey", "(Ljava/nio/channels/SelectionKey;)V", "parseState", "Lio/ktor/server/testing/HighLoadHttpGenerator$ParseState;", "readPending", "", "getReadPending", "()Z", "setReadPending", "(Z)V", "<set-?>", "remaining", "getRemaining", "tokenSize", "writePending", "getWritePending", "setWritePending", "calcOps", "close", "", "doRead", "bb", "doRead$ktor_server_test_host", "doWrite", "doWrite$ktor_server_test_host", "findEol", "findHttp", "findHttpSlow", "position", "limit", "gotStatus", "interest", "selector", "Ljava/nio/channels/Selector;", "parseCode", "parseLoop", "send", "qty", "skipSpaces", "skipSpacesSlow", "ktor-server-test-host"})
    private final class ClientState {
        @NotNull
        private final SocketChannel channel;
        private final ByteBuffer current;
        private int remaining;
        @NotNull
        private ParseState parseState;
        private int tokenSize;
        private int code;
        @Nullable
        private SelectionKey key;
        private boolean writePending;
        private boolean readPending;
        private int currentOps;

        public ClientState(SocketChannel channel) {
            Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
            this.channel = channel;
            this.current = HighLoadHttpGenerator.this.requestByteBuffer.duplicate();
            this.parseState = ParseState.HTTP;
        }

        @NotNull
        public final SocketChannel getChannel() {
            return this.channel;
        }

        public final int getRemaining() {
            return this.remaining;
        }

        @Nullable
        public final SelectionKey getKey() {
            return this.key;
        }

        public final void setKey(@Nullable SelectionKey selectionKey) {
            this.key = selectionKey;
        }

        public final boolean getWritePending() {
            return this.writePending;
        }

        public final void setWritePending(boolean bl) {
            this.writePending = bl;
        }

        public final boolean getReadPending() {
            return this.readPending;
        }

        public final void setReadPending(boolean bl) {
            this.readPending = bl;
        }

        public final int getCurrentOps() {
            return this.currentOps;
        }

        public final void setCurrentOps(int n) {
            this.currentOps = n;
        }

        private final int calcOps() {
            int ops = 0;
            if (this.writePending) {
                ops |= 4;
            }
            if (this.readPending) {
                ops |= 1;
            }
            return ops;
        }

        public final void interest(@NotNull Selector selector) {
            Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
            int ops = this.calcOps();
            SelectionKey key = this.key;
            try {
                if (key == null) {
                    this.key = this.channel.register(selector, ops, this);
                    this.currentOps = ops;
                } else if (this.currentOps != ops) {
                    key.interestOps(ops);
                    this.currentOps = ops;
                }
            }
            catch (Throwable t) {
                this.close();
            }
        }

        public final void send(int qty) {
            if (!(qty > 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (!HighLoadHttpGenerator.this.shutdown) {
                this.remaining += qty;
                if (!this.current.hasRemaining()) {
                    this.current.clear();
                }
            }
        }

        public static /* synthetic */ void send$default(ClientState clientState, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = 1;
            }
            clientState.send(n);
        }

        public final void close() {
            SelectionKey selectionKey;
            SelectionKey selectionKey2 = selectionKey = this.key;
            if (selectionKey2 != null) {
                selectionKey2.cancel();
            }
            this.key = null;
            this.readPending = false;
            this.writePending = false;
            try {
                this.channel.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public final boolean doWrite$ktor_server_test_host() {
            block4: {
                boolean bl;
                block5: {
                    while (true) {
                        if (this.remaining == 0) {
                            return true;
                        }
                        boolean hp = HighLoadHttpGenerator.this.getHighPressure();
                        this.channel.write(this.current);
                        if (this.current.hasRemaining()) break block4;
                        HighLoadHttpGenerator.this.count.incrementAndGet();
                        if (HighLoadHttpGenerator.this.shutdown) {
                            this.remaining = 0;
                            bl = true;
                            break block5;
                        }
                        if (hp) {
                            this.current.clear();
                            continue;
                        }
                        ClientState clientState = this;
                        clientState.remaining += -1;
                        if (clientState.remaining <= 0) break;
                        this.current.clear();
                    }
                    bl = true;
                }
                return bl;
            }
            return false;
        }

        public final int doRead$ktor_server_test_host(@NotNull ByteBuffer bb) {
            Intrinsics.checkNotNullParameter((Object)bb, (String)"bb");
            bb.clear();
            int rc = this.channel.read(bb);
            if (rc == -1) {
                this.close();
                return -1;
            }
            if (rc == 0) {
                return 0;
            }
            if (!HighLoadHttpGenerator.this.getHighPressure()) {
                bb.flip();
                this.parseLoop(bb);
            }
            return 1;
        }

        private final void parseLoop(ByteBuffer bb) {
            while (bb.hasRemaining()) {
                switch (WhenMappings.$EnumSwitchMapping$0[this.parseState.ordinal()]) {
                    case 1: {
                        this.findEol(bb);
                        break;
                    }
                    case 2: {
                        this.findHttp(bb);
                        break;
                    }
                    case 3: {
                        this.skipSpaces(bb);
                        break;
                    }
                    case 4: {
                        this.parseCode(bb);
                    }
                }
            }
        }

        private final void findEol(ByteBuffer bb) {
            int position = bb.position();
            int limit = bb.limit();
            for (int idx = position; idx < limit; ++idx) {
                if (bb.get(idx) != 10) continue;
                this.parseState = ParseState.HTTP;
                this.tokenSize = 0;
                bb.position(idx + 1);
                return;
            }
            bb.position(limit);
        }

        private final void findHttp(ByteBuffer bb) {
            int position = bb.position();
            int limit = bb.limit();
            if (this.tokenSize == 0 && limit - position >= 8) {
                if (bb.getLong(position) == 5211883372140375601L) {
                    this.parseState = ParseState.SPACE;
                    this.tokenSize = 0;
                    bb.position(position + 8);
                    return;
                }
                this.parseState = ParseState.EOL;
                return;
            }
            this.findHttpSlow(bb, position, limit);
        }

        private final void findHttpSlow(ByteBuffer bb, int position, int limit) {
            byte[] http = HTTP11;
            int offset = this.tokenSize - position;
            for (int idx = position; idx < limit; ++idx) {
                byte b = bb.get(idx);
                if (b == 32) {
                    this.parseState = ParseState.SPACE;
                    this.tokenSize = 0;
                    bb.position(idx + 1);
                    return;
                }
                if (b == http[idx + offset]) {
                    ++this.tokenSize;
                    if (this.tokenSize <= 8) continue;
                    this.parseState = ParseState.EOL;
                    bb.position(idx + 1);
                    return;
                }
                this.parseState = ParseState.EOL;
                bb.position(idx);
                return;
            }
            bb.position(limit);
        }

        private final void skipSpaces(ByteBuffer bb) {
            int position = bb.position();
            int limit = bb.limit();
            if (limit - position >= 4) {
                int i = bb.getInt(position);
                switch (i) {
                    case 842018829: 
                    case 0x32303020: {
                        this.gotStatus(200);
                        this.parseState = ParseState.EOL;
                        bb.position(position + 3);
                        return;
                    }
                }
            }
            this.skipSpacesSlow(bb, position, limit);
        }

        private final void skipSpacesSlow(ByteBuffer bb, int position, int limit) {
            for (int idx = position; idx < limit; ++idx) {
                int n;
                byte b = bb.get(idx);
                if (b == 10) {
                    this.parseState = ParseState.HTTP;
                    bb.position(idx + 1);
                    return;
                }
                if (b == 32) {
                    ++this.tokenSize;
                    if (this.tokenSize <= 10) continue;
                    this.parseState = ParseState.EOL;
                    bb.position(idx + 1);
                    return;
                }
                if (b == 50 && limit - idx >= 4) {
                    int i = bb.getInt(idx);
                    switch (i) {
                        case 842018829: 
                        case 0x32303020: {
                            this.gotStatus(200);
                            this.parseState = ParseState.EOL;
                            bb.position(idx + 3);
                            return;
                        }
                    }
                }
                boolean bl = 0 <= (n = b - 48) ? n < 10 : false;
                if (bl) {
                    this.parseState = ParseState.CODE;
                    this.code = n;
                    this.tokenSize = 1;
                    bb.position(idx + 1);
                    return;
                }
                this.parseState = ParseState.EOL;
                bb.position(idx + 1);
                return;
            }
            bb.position(limit);
        }

        private final void parseCode(ByteBuffer bb) {
            int code = this.code;
            while (bb.hasRemaining()) {
                byte b = bb.get();
                if (b == 32 || b == 10) {
                    boolean bl = 100 <= code ? code < 1000 : false;
                    if (bl) {
                        this.gotStatus(code);
                    }
                    this.parseState = ParseState.EOL;
                    return;
                }
                int n = b - 48;
                if (n < 0 || n > 9) {
                    this.parseState = ParseState.EOL;
                    return;
                }
                ++this.tokenSize;
                if (this.tokenSize > 3) {
                    this.parseState = ParseState.EOL;
                    return;
                }
                code = code * 10 + n;
            }
            this.code = code;
        }

        private final void gotStatus(int code) {
            HighLoadHttpGenerator.this.codeCounts[code].incrementAndGet();
            this.send(1);
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ParseState.values().length];
                try {
                    nArray[ParseState.EOL.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ParseState.HTTP.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ParseState.SPACE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ParseState.CODE.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0006H\u0002J_\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00062\u0017\u0010\u001c\u001a\u0013\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u000f0\u001d\u00a2\u0006\u0002\b\u001fJN\u0010\u000e\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0006J\u001b\u0010!\u001a\u00020\u000f2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00160#H\u0007\u00a2\u0006\u0002\u0010$R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lio/ktor/server/testing/HighLoadHttpGenerator$Companion;", "", "()V", "HTTP11", "", "HTTP11Long", "", "HTTP1_length", "", "HTTP_200_R_Int", "HTTP_200_SPACE_Int", "N", "", "S", "doRun", "", "loadGenerator", "Lio/ktor/server/testing/HighLoadHttpGenerator;", "numberOfThreads", "gracefulMillis", "timeMillis", "host", "", "port", "connectionsPerThread", "queueSize", "highPressure", "", "builder", "Lkotlin/Function1;", "Lio/ktor/http/cio/RequestResponseBuilder;", "Lkotlin/ExtensionFunctionType;", "url", "main", "args", "", "([Ljava/lang/String;)V", "ktor-server-test-host"})
    @SourceDebugExtension(value={"SMAP\nHighLoadHttpGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HighLoadHttpGenerator.kt\nio/ktor/server/testing/HighLoadHttpGenerator$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,751:1\n1549#2:752\n1620#2,3:753\n1855#2,2:756\n1549#2:758\n1620#2,3:759\n1855#2,2:762\n1855#2,2:764\n1747#2,3:766\n*S KotlinDebug\n*F\n+ 1 HighLoadHttpGenerator.kt\nio/ktor/server/testing/HighLoadHttpGenerator$Companion\n*L\n670#1:752\n670#1:753,3\n690#1:756,2\n724#1:758\n724#1:759,3\n730#1:762,2\n742#1:764,2\n743#1:766,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void doRun(@NotNull String url, @NotNull String host, int port, int numberOfThreads, int connectionsPerThread, int queueSize, boolean highPressure, long gracefulMillis, long timeMillis) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            HighLoadHttpGenerator generator = new HighLoadHttpGenerator(url, host, port, connectionsPerThread, queueSize, highPressure);
            this.doRun(generator, numberOfThreads, gracefulMillis, timeMillis);
        }

        public final void doRun(@NotNull String host, int port, int numberOfThreads, int connectionsPerThread, int queueSize, boolean highPressure, long gracefulMillis, long timeMillis, @NotNull Function1<? super RequestResponseBuilder, Unit> builder2) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            Intrinsics.checkNotNullParameter(builder2, (String)"builder");
            HighLoadHttpGenerator generator = new HighLoadHttpGenerator(host, port, connectionsPerThread, queueSize, highPressure, builder2);
            this.doRun(generator, numberOfThreads, gracefulMillis, timeMillis);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final void doRun(HighLoadHttpGenerator loadGenerator, int numberOfThreads, long gracefulMillis, long timeMillis) {
            void $this$mapTo$iv$iv;
            System.out.println((Object)"Running...");
            Iterable $this$map$iv = (Iterable)new IntRange(1, numberOfThreads);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(loadGenerator){
                    final /* synthetic */ HighLoadHttpGenerator $loadGenerator;
                    {
                        this.$loadGenerator = $loadGenerator;
                        super(0);
                    }

                    public final void invoke() {
                        this.$loadGenerator.mainLoop();
                    }
                }), (int)31, null));
            }
            List threads2 = (List)destination$iv$iv;
            Thread joiner2 = ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>((List<? extends Thread>)threads2, gracefulMillis){
                final /* synthetic */ List<Thread> $threads;
                final /* synthetic */ long $gracefulMillis;
                {
                    this.$threads = $threads;
                    this.$gracefulMillis = $gracefulMillis;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    void $this$forEach$iv;
                    Iterable iterable = this.$threads;
                    long l = this.$gracefulMillis;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        Thread it = (Thread)element$iv;
                        boolean bl = false;
                        it.join(l);
                    }
                }
            }), (int)30, null);
            try {
                Thread.sleep(timeMillis);
                System.out.println((Object)"Shutting down...");
                loadGenerator.shutdown();
                joiner2.start();
                joiner2.join(gracefulMillis);
            }
            finally {
                System.out.println((Object)"Termination...");
                loadGenerator.stop();
                Iterable $this$forEach$iv = threads2;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Thread it = (Thread)element$iv;
                    boolean bl = false;
                    it.interrupt();
                }
                joiner2.join();
                System.out.println((Object)"Terminated.");
                System.out.println((Object)loadGenerator.stat());
            }
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final void main(@NotNull String[] args) {
            boolean bl;
            HighLoadHttpGenerator manager;
            block8: {
                void $this$mapTo$iv$iv;
                StringBuilder stringBuilder;
                Intrinsics.checkNotNullParameter((Object)args, (String)"args");
                boolean debug = false;
                URL url = new URL("http://localhost:8081/");
                int connections = 4000;
                int queue = 100;
                int time = 20;
                boolean highPressure = false;
                int numberCpu = Runtime.getRuntime().availableProcessors();
                StringBuilder $this$main_u24lambda_u242 = stringBuilder = new StringBuilder();
                boolean bl2 = false;
                $this$main_u24lambda_u242.append(url.getPath());
                CharSequence charSequence = url.getQuery();
                if (!(charSequence == null || charSequence.length() == 0)) {
                    $this$main_u24lambda_u242.append('?');
                    $this$main_u24lambda_u242.append(url.getQuery());
                }
                String string = stringBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                String pathAndQuery = string;
                String string2 = url.getHost();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getHost(...)");
                manager = new HighLoadHttpGenerator(pathAndQuery, string2, url.getPort() == -1 ? 80 : url.getPort(), connections / numberCpu, queue, highPressure);
                Iterable $this$map$iv = (Iterable)new IntRange(1, numberCpu);
                boolean $i$f$map = false;
                Iterator iterator = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator2 = $this$mapTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    int item$iv$iv;
                    int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(manager){
                        final /* synthetic */ HighLoadHttpGenerator $manager;
                        {
                            this.$manager = $manager;
                            super(0);
                        }

                        public final void invoke() {
                            this.$manager.mainLoop();
                        }
                    }), (int)30, null));
                }
                List threads2 = (List)destination$iv$iv;
                Iterable $this$forEach$iv = threads2;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Thread it = (Thread)element$iv;
                    boolean bl4 = false;
                    it.start();
                }
                TimeUnit.SECONDS.sleep(time);
                manager.shutdown();
                Thread.sleep(1000L);
                manager.stop();
                $this$forEach$iv = threads2;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Thread it = (Thread)element$iv;
                    boolean bl5 = false;
                    it.join(1000L);
                }
                Iterable $this$any$iv = threads2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Thread it = (Thread)element$iv;
                        boolean bl6 = false;
                        if (!it.isAlive()) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            }
            if (bl) {
                System.out.println((Object)"There are threads get stuck");
            }
            System.out.println((Object)manager.stat());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lio/ktor/server/testing/HighLoadHttpGenerator$ParseState;", "", "(Ljava/lang/String;I)V", "EOL", "HTTP", "SPACE", "CODE", "ktor-server-test-host"})
    private static final class ParseState
    extends Enum<ParseState> {
        public static final /* enum */ ParseState EOL = new ParseState();
        public static final /* enum */ ParseState HTTP = new ParseState();
        public static final /* enum */ ParseState SPACE = new ParseState();
        public static final /* enum */ ParseState CODE = new ParseState();
        private static final /* synthetic */ ParseState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ParseState[] values() {
            return (ParseState[])$VALUES.clone();
        }

        public static ParseState valueOf(String value) {
            return Enum.valueOf(ParseState.class, value);
        }

        @NotNull
        public static EnumEntries<ParseState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = parseStateArray = new ParseState[]{ParseState.EOL, ParseState.HTTP, ParseState.SPACE, ParseState.CODE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

