/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.websocket;

import io.ktor.http.Headers;
import io.ktor.serialization.ContentConverterKt;
import io.ktor.serialization.WebsocketContentConverter;
import io.ktor.serialization.WebsocketConverterNotFoundException;
import io.ktor.serialization.WebsocketDeserializeException;
import io.ktor.server.application.Application;
import io.ktor.server.application.ApplicationCall;
import io.ktor.server.application.ApplicationPluginKt;
import io.ktor.server.application.Plugin;
import io.ktor.server.websocket.DefaultWebSocketServerSession;
import io.ktor.server.websocket.DelegatedDefaultWebSocketServerSession;
import io.ktor.server.websocket.DelegatedWebSocketServerSession;
import io.ktor.server.websocket.WebSocketServerSession;
import io.ktor.server.websocket.WebSockets;
import io.ktor.util.pipeline.Pipeline;
import io.ktor.util.reflect.TypeInfo;
import io.ktor.util.reflect.TypeInfoJvmKt;
import io.ktor.websocket.DefaultWebSocketSession;
import io.ktor.websocket.Frame;
import io.ktor.websocket.WebSocketSession;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KType;
import kotlin.reflect.TypesJVMKt;
import kotlinx.coroutines.channels.ReceiveChannel;
import kotlinx.coroutines.channels.SendChannel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001d\u0010\t\u001a\u0002H\n\"\u0006\b\u0000\u0010\n\u0018\u0001*\u00020\u0002H\u0086H\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000b\u001a%\u0010\f\u001a\u00020\r\"\u0006\b\u0000\u0010\n\u0018\u0001*\u00020\u00022\u0006\u0010\u000e\u001a\u0002H\nH\u0086H\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000f\u001a\u0014\u0010\u0010\u001a\u00020\u0011*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u001a\u0014\u0010\u0010\u001a\u00020\u0002*\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0016"}, d2={"application", "Lio/ktor/server/application/Application;", "Lio/ktor/server/websocket/WebSocketServerSession;", "getApplication", "(Lio/ktor/server/websocket/WebSocketServerSession;)Lio/ktor/server/application/Application;", "converter", "Lio/ktor/serialization/WebsocketContentConverter;", "getConverter", "(Lio/ktor/server/websocket/WebSocketServerSession;)Lio/ktor/serialization/WebsocketContentConverter;", "receiveDeserialized", "T", "(Lio/ktor/server/websocket/WebSocketServerSession;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sendSerialized", "", "data", "(Lio/ktor/server/websocket/WebSocketServerSession;Ljava/lang/Object;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "toServerSession", "Lio/ktor/server/websocket/DefaultWebSocketServerSession;", "Lio/ktor/websocket/DefaultWebSocketSession;", "call", "Lio/ktor/server/application/ApplicationCall;", "Lio/ktor/websocket/WebSocketSession;", "ktor-server-websockets"})
public final class WebSocketServerSessionKt {
    @NotNull
    public static final Application getApplication(@NotNull WebSocketServerSession $this$application) {
        Intrinsics.checkNotNullParameter((Object)$this$application, (String)"<this>");
        return $this$application.getCall().getApplication();
    }

    @Nullable
    public static final WebsocketContentConverter getConverter(@NotNull WebSocketServerSession $this$converter) {
        Intrinsics.checkNotNullParameter((Object)$this$converter, (String)"<this>");
        return ((WebSockets)ApplicationPluginKt.plugin((Pipeline)((Pipeline)WebSocketServerSessionKt.getApplication($this$converter)), (Plugin)((Plugin)WebSockets.Plugin))).getContentConverter();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ <T> Object sendSerialized(WebSocketServerSession $this$sendSerialized, T data, Continuation<? super Unit> $completion) {
        void $this$sendSerializedBase$iv;
        void charset$iv;
        boolean $i$f$sendSerialized = false;
        WebsocketContentConverter websocketContentConverter = WebSocketServerSessionKt.getConverter($this$sendSerialized);
        if (websocketContentConverter == null) {
            throw new WebsocketConverterNotFoundException("No converter was found for websocket", null, 2, null);
        }
        WebsocketContentConverter converter = websocketContentConverter;
        websocketContentConverter = $this$sendSerialized;
        Charset charset = ContentConverterKt.suitableCharset$default((Headers)$this$sendSerialized.getCall().getRequest().getHeaders(), null, (int)1, null);
        boolean $i$f$sendSerializedBase = false;
        boolean $i$f$typeInfo = false;
        Intrinsics.reifiedOperationMarker((int)6, (String)"T");
        KType kType$iv$iv = null;
        Type reifiedType$iv$iv = TypesJVMKt.getJavaType(kType$iv$iv);
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        TypeInfo typeInfo = TypeInfoJvmKt.typeInfoImpl((Type)reifiedType$iv$iv, (KClass)Reflection.getOrCreateKotlinClass(Object.class), kType$iv$iv);
        InlineMarker.mark((int)0);
        Object object = converter.serializeNullable((Charset)charset$iv, typeInfo, data, $completion);
        InlineMarker.mark((int)1);
        Frame serializedData$iv = (Frame)object;
        SendChannel sendChannel = $this$sendSerializedBase$iv.getOutgoing();
        InlineMarker.mark((int)0);
        sendChannel.send((Object)serializedData$iv, $completion);
        InlineMarker.mark((int)1);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ <T> Object receiveDeserialized(WebSocketServerSession $this$receiveDeserialized, Continuation<? super T> $completion) {
        Object object;
        void charset$iv;
        void $this$receiveDeserializedBase$iv;
        boolean $i$f$receiveDeserialized = false;
        WebsocketContentConverter websocketContentConverter = WebSocketServerSessionKt.getConverter($this$receiveDeserialized);
        if (websocketContentConverter == null) {
            throw new WebsocketConverterNotFoundException("No converter was found for websocket", null, 2, null);
        }
        WebsocketContentConverter converter = websocketContentConverter;
        websocketContentConverter = $this$receiveDeserialized;
        Charset charset = ContentConverterKt.suitableCharset$default((Headers)$this$receiveDeserialized.getCall().getRequest().getHeaders(), null, (int)1, null);
        boolean $i$f$receiveDeserializedBase = false;
        ReceiveChannel receiveChannel = $this$receiveDeserializedBase$iv.getIncoming();
        InlineMarker.mark((int)0);
        Object object2 = receiveChannel.receive($completion);
        InlineMarker.mark((int)1);
        Frame frame$iv = (Frame)object2;
        if (!converter.isApplicable(frame$iv)) {
            throw new WebsocketDeserializeException("Converter doesn't support frame type " + frame$iv.getFrameType().name(), null, frame$iv, 2, null);
        }
        boolean $i$f$typeInfo = false;
        Intrinsics.reifiedOperationMarker((int)6, (String)"T");
        KType kType$iv$iv = null;
        Type reifiedType$iv$iv = TypesJVMKt.getJavaType(kType$iv$iv);
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        TypeInfo typeInfo$iv = TypeInfoJvmKt.typeInfoImpl((Type)reifiedType$iv$iv, (KClass)Reflection.getOrCreateKotlinClass(Object.class), kType$iv$iv);
        InlineMarker.mark((int)0);
        Object object3 = converter.deserialize((Charset)charset$iv, typeInfo$iv, frame$iv, $completion);
        InlineMarker.mark((int)1);
        Object result$iv = object3;
        Intrinsics.reifiedOperationMarker((int)3, (String)"T");
        if (result$iv instanceof Object) {
            object = result$iv;
        } else if (result$iv == null) {
            KType kType = typeInfo$iv.getKotlinType();
            boolean bl = kType != null ? kType.isMarkedNullable() : false;
            if (!bl) throw new WebsocketDeserializeException("Frame has null content", null, frame$iv, 2, null);
            object = null;
        } else {
            StringBuilder stringBuilder = new StringBuilder().append("Can't deserialize value : expected value of type ");
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            throw new WebsocketDeserializeException(stringBuilder.append(Reflection.getOrCreateKotlinClass(Object.class).getSimpleName()).append(", got ").append(Reflection.getOrCreateKotlinClass(result$iv.getClass()).getSimpleName()).toString(), null, frame$iv, 2, null);
        }
        Intrinsics.reifiedOperationMarker((int)1, (String)"T");
        return object;
    }

    @NotNull
    public static final WebSocketServerSession toServerSession(@NotNull WebSocketSession $this$toServerSession, @NotNull ApplicationCall call) {
        Intrinsics.checkNotNullParameter((Object)$this$toServerSession, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        return new DelegatedWebSocketServerSession(call, $this$toServerSession);
    }

    @NotNull
    public static final DefaultWebSocketServerSession toServerSession(@NotNull DefaultWebSocketSession $this$toServerSession, @NotNull ApplicationCall call) {
        Intrinsics.checkNotNullParameter((Object)$this$toServerSession, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        return new DelegatedDefaultWebSocketServerSession(call, $this$toServerSession);
    }
}

