/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.util;

import io.ktor.util.KtorExperimentalAPI;
import java.io.File;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0001H\u0002\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0007\u001a\f\u0010\u0005\u001a\u00020\u0001*\u00020\u0001H\u0002\u001a\f\u0010\u0006\u001a\u00020\u0001*\u00020\u0001H\u0007\u001a\f\u0010\u0007\u001a\u00020\u0001*\u00020\u0001H\u0002\u00a8\u0006\b"}, d2={"combineSafe", "Ljava/io/File;", "dir", "relativePath", "", "dropLeadingTopDirs", "normalizeAndRelativize", "notRooted", "ktor-utils"})
public final class PathKt {
    @KtorExperimentalAPI
    @NotNull
    public static final File combineSafe(@NotNull File $receiver, @NotNull String relativePath) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
        return PathKt.combineSafe($receiver, new File(relativePath));
    }

    @KtorExperimentalAPI
    @NotNull
    public static final File normalizeAndRelativize(@NotNull File $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return PathKt.dropLeadingTopDirs(PathKt.notRooted(FilesKt.normalize((File)$receiver)));
    }

    private static final File combineSafe(File dir, File relativePath) {
        boolean bl;
        File normalized = PathKt.normalizeAndRelativize(relativePath);
        if (FilesKt.startsWith((File)normalized, (String)"..")) {
            throw (Throwable)new IllegalArgumentException("Bad relative path " + relativePath);
        }
        boolean bl2 = bl = !normalized.isAbsolute();
        if (!bl) {
            String string = "Bad relative path " + relativePath;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return new File(dir, normalized.getPath());
    }

    /*
     * WARNING - void declaration
     */
    private static final File notRooted(@NotNull File $receiver) {
        String string;
        String string2;
        block5: {
            if (!FilesKt.isRooted((File)$receiver)) {
                return $receiver;
            }
            File current = $receiver;
            while (current.getParentFile() != null) {
                File parent;
                current = parent;
            }
            String string3 = $receiver.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"path");
            String $receiver$iv = StringsKt.drop((String)string3, (int)current.getName().length());
            int n = 0;
            int n2 = ((CharSequence)$receiver$iv).length();
            while (n < n2) {
                void index$iv;
                char it = $receiver$iv.charAt((int)index$iv);
                if (!(it == '\\' || it == '/')) {
                    String string4 = $receiver$iv;
                    String string5 = string4.substring((int)index$iv);
                    string2 = string5;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
                    break block5;
                }
                ++index$iv;
            }
            string2 = "";
        }
        String string6 = string = string2;
        return new File(string6);
    }

    private static final File dropLeadingTopDirs(@NotNull File $receiver) {
        String string;
        String string2;
        int startIndex = 0;
        String string3 = $receiver.getPath();
        if (string3 == null) {
            Intrinsics.throwNpe();
        }
        String path = string3;
        int lastIndex = path.length() - 1;
        while (startIndex < lastIndex && path.charAt(startIndex) == '.') {
            char second = path.charAt(startIndex + 1);
            if (second == '\\' || second == '/') {
                startIndex += 2;
                continue;
            }
            if (second != '.') break;
            if (startIndex + 2 == path.length()) {
                startIndex += 2;
                continue;
            }
            char c = path.charAt(startIndex + 2);
            char it = c;
            if (!(it == '/' || it == '\\')) continue;
            startIndex += 3;
        }
        if (startIndex == 0) {
            return $receiver;
        }
        if (startIndex >= path.length()) {
            return new File(".");
        }
        String string4 = string2 = path;
        if (string4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.substring(startIndex);
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
        String string6 = string = string5;
        return new File(string6);
    }
}

