/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.util.date;

import io.ktor.util.date.GMTDate;
import io.ktor.util.date.Month;
import io.ktor.util.date.WeekDay;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a6\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006\u001a\u0017\u0010\u0003\u001a\u00020\u00042\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000f\u001a\u001b\u0010\u0010\u001a\u00020\u0004*\u00020\u00112\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002\u00a2\u0006\u0002\u0010\u0012\u001a\n\u0010\u0013\u001a\u00020\u0014*\u00020\u0004\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"GMT_TIMEZONE", "Ljava/util/TimeZone;", "kotlin.jvm.PlatformType", "GMTDate", "Lio/ktor/util/date/GMTDate;", "seconds", "", "minutes", "hours", "dayOfMonth", "month", "Lio/ktor/util/date/Month;", "year", "timestamp", "", "(Ljava/lang/Long;)Lio/ktor/util/date/GMTDate;", "toDate", "Ljava/util/Calendar;", "(Ljava/util/Calendar;Ljava/lang/Long;)Lio/ktor/util/date/GMTDate;", "toJvmDate", "Ljava/util/Date;", "ktor-utils"})
public final class DateJvmKt {
    private static final TimeZone GMT_TIMEZONE = TimeZone.getTimeZone("GMT");

    @NotNull
    public static final GMTDate GMTDate(@Nullable Long timestamp) {
        Calendar calendar = Calendar.getInstance(GMT_TIMEZONE, Locale.ROOT);
        if (calendar == null) {
            Intrinsics.throwNpe();
        }
        return DateJvmKt.toDate(calendar, timestamp);
    }

    @NotNull
    public static /* synthetic */ GMTDate GMTDate$default(Long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = null;
        }
        return DateJvmKt.GMTDate(l);
    }

    @NotNull
    public static final GMTDate GMTDate(int seconds, int minutes, int hours, int dayOfMonth, @NotNull Month month, int year) {
        Calendar calendar;
        Intrinsics.checkParameterIsNotNull((Object)((Object)month), (String)"month");
        Calendar calendar2 = Calendar.getInstance(GMT_TIMEZONE, Locale.ROOT);
        if (calendar2 == null) {
            Intrinsics.throwNpe();
        }
        Calendar $receiver = calendar = calendar2;
        $receiver.set(1, year);
        $receiver.set(2, month.ordinal());
        $receiver.set(5, dayOfMonth);
        $receiver.set(11, hours);
        $receiver.set(12, minutes);
        $receiver.set(13, seconds);
        $receiver.set(14, 0);
        return DateJvmKt.toDate(calendar, null);
    }

    private static final GMTDate toDate(@NotNull Calendar $receiver, Long timestamp) {
        Long l = timestamp;
        if (l != null) {
            Long l2 = l;
            long it = ((Number)l2).longValue();
            $receiver.setTimeInMillis(it);
        }
        int seconds = $receiver.get(13);
        int minutes = $receiver.get(12);
        int hours = $receiver.get(11);
        int numberOfDay = ($receiver.get(7) + 7 - 2) % 7;
        WeekDay dayOfWeek = WeekDay.Companion.from(numberOfDay);
        int dayOfMonth = $receiver.get(5);
        int dayOfYear = $receiver.get(6);
        Month month = Month.Companion.from($receiver.get(2));
        int year = $receiver.get(1);
        return new GMTDate(seconds, minutes, hours, dayOfWeek, dayOfMonth, dayOfYear, month, year, $receiver.getTimeInMillis());
    }

    @NotNull
    public static final Date toJvmDate(@NotNull GMTDate $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Calendar calendar = Calendar.getInstance(GMT_TIMEZONE, Locale.ROOT);
        if (calendar == null) {
            Intrinsics.throwNpe();
        }
        Date date = calendar.getTime();
        if (date == null) {
            Intrinsics.throwNpe();
        }
        return date;
    }
}

