/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.util.date;

import io.ktor.util.InternalAPI;
import io.ktor.util.date.GMTDate;
import io.ktor.util.date.GMTDateBuilder;
import io.ktor.util.date.InvalidDateStringException;
import io.ktor.util.date.Month;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@InternalAPI
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0003\b\u0007\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0003J\u001c\u0010\b\u001a\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/ktor/util/date/GMTDateParser;", "", "pattern", "", "(Ljava/lang/String;)V", "parse", "Lio/ktor/util/date/GMTDate;", "dateString", "handleToken", "", "Lio/ktor/util/date/GMTDateBuilder;", "type", "", "chunk", "Companion", "ktor-utils"})
public final class GMTDateParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String pattern;
    public static final char SECONDS = 's';
    public static final char MINUTES = 'm';
    public static final char HOURS = 'h';
    public static final char DAY_OF_MONTH = 'd';
    public static final char MONTH = 'M';
    public static final char YEAR = 'Y';
    public static final char ZONE = 'z';
    public static final char ANY = '*';

    public GMTDateParser(@NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        this.pattern = pattern;
        CharSequence charSequence = this.pattern;
        boolean bl = false;
        boolean bl2 = charSequence.length() > 0;
        bl = false;
        boolean bl3 = false;
        if (!bl2) {
            boolean bl4 = false;
            String string = "Date parser pattern shouldn't be empty.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    @NotNull
    public final GMTDate parse(@NotNull String dateString) {
        Intrinsics.checkNotNullParameter((Object)dateString, (String)"dateString");
        GMTDateBuilder builder = new GMTDateBuilder();
        int start = 0;
        char current = this.pattern.charAt(start);
        int chunkStart = 0;
        int index = 1;
        try {
            int n;
            while (index < this.pattern.length()) {
                if (this.pattern.charAt(index) == current) {
                    int n2 = index;
                    index = n2 + 1;
                    continue;
                }
                int chunkEnd = chunkStart + index - start;
                String string = dateString;
                boolean bl = false;
                String string2 = string.substring(chunkStart, chunkEnd);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                this.handleToken(builder, current, string2);
                chunkStart = chunkEnd;
                start = index;
                current = this.pattern.charAt(index);
                n = index;
                index = n + 1;
            }
            if (chunkStart < dateString.length()) {
                String chunkEnd = dateString;
                n = 0;
                String string = chunkEnd.substring(chunkStart);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.String).substring(startIndex)");
                this.handleToken(builder, current, string);
            }
        }
        catch (Throwable _) {
            throw new InvalidDateStringException(dateString, chunkStart, this.pattern);
        }
        return builder.build();
    }

    private final void handleToken(GMTDateBuilder $this$handleToken, char type, String chunk) {
        char c = type;
        if (c == 's') {
            String string = chunk;
            boolean bl = false;
            $this$handleToken.setSeconds(Integer.parseInt(string));
        } else if (c == 'm') {
            String string = chunk;
            boolean bl = false;
            $this$handleToken.setMinutes(Integer.parseInt(string));
        } else if (c == 'h') {
            String string = chunk;
            boolean bl = false;
            $this$handleToken.setHours(Integer.parseInt(string));
        } else if (c == 'd') {
            String string = chunk;
            boolean bl = false;
            $this$handleToken.setDayOfMonth(Integer.parseInt(string));
        } else if (c == 'M') {
            $this$handleToken.setMonth(Month.Companion.from(chunk));
        } else if (c == 'Y') {
            String string = chunk;
            boolean bl = false;
            $this$handleToken.setYear(Integer.parseInt(string));
        } else if (c == 'z') {
            boolean bl = Intrinsics.areEqual((Object)chunk, (Object)"GMT");
            boolean bl2 = false;
            boolean bl3 = false;
            bl3 = false;
            boolean bl4 = false;
            if (!bl) {
                boolean bl5 = false;
                String string = "Check failed.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
        } else if (c != '*') {
            boolean bl;
            int n;
            block18: {
                CharSequence $this$all$iv = chunk;
                boolean $i$f$all = false;
                CharSequence charSequence = $this$all$iv;
                for (n = 0; n < charSequence.length(); ++n) {
                    char element$iv;
                    char it = element$iv = charSequence.charAt(n);
                    boolean bl6 = false;
                    if (it == type) continue;
                    bl = false;
                    break block18;
                }
                bl = true;
            }
            boolean bl7 = bl;
            boolean bl8 = false;
            boolean bl9 = false;
            bl9 = false;
            n = 0;
            if (!bl7) {
                boolean bl10 = false;
                String string = "Check failed.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/ktor/util/date/GMTDateParser$Companion;", "", "()V", "ANY", "", "DAY_OF_MONTH", "HOURS", "MINUTES", "MONTH", "SECONDS", "YEAR", "ZONE", "ktor-utils"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

